
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 24, 25, 26, 
	27, 28, 29, 31, 33, 44, 45, 46, 
	48, 50, 55, 60, 65, 70, 74, 78, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 90, 91, 92, 93, 94, 95, 
	100, 107, 112, 116, 122, 125, 127, 133, 
	144, 145, 146, 147, 148, 149, 150, 151, 
	152, 153, 154, 155, 156, 157, 158, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 171, 172, 173, 174, 175, 
	176, 177, 178, 179, 180, 181, 182, 183, 
	190, 192, 194, 196, 198, 200, 202, 204, 
	206, 208, 210, 212, 214, 216, 218, 220, 
	222, 224, 226, 228, 230, 241, 242, 243, 
	244, 245, 246, 247, 248, 249, 250, 251, 
	252, 253, 254, 255, 257, 258, 259, 260, 
	261, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 271, 272, 273, 274, 275, 276, 
	277, 278, 279, 280, 281, 282, 291, 299, 
	301, 304, 306, 308, 310, 312, 314, 316, 
	318, 320, 322, 324, 326, 328, 330, 332, 
	334, 336, 338, 340, 342, 344, 346, 348, 
	350, 352, 354, 356, 358, 360, 362, 364, 
	366, 368, 370, 372, 374, 376, 378, 380, 
	382, 384, 386, 388, 390, 392, 394, 396, 
	398, 400, 402, 404, 406, 408, 410, 412, 
	414, 416, 418, 420, 422, 424, 426, 428, 
	430, 432, 434, 436, 438, 440, 442, 444, 
	446, 448, 450, 452, 454, 456, 458, 460, 
	461, 462, 471, 480, 482, 485, 487, 489, 
	491, 493, 495, 497, 499, 501, 503, 505, 
	507, 509, 511, 513, 515, 517, 519, 521, 
	523, 525, 527, 529, 531, 533, 535, 537, 
	539, 541, 543, 545, 547, 549, 551, 553, 
	555, 557, 559, 561, 563, 565, 567, 570, 
	572, 574, 576, 578, 580, 582, 584, 586, 
	588, 590, 592, 594, 596, 598, 600, 602, 
	604, 606, 608, 610, 612, 614, 616, 618, 
	620, 622, 624, 626, 628, 630, 632, 634, 
	636, 638, 640, 642, 644, 646, 648, 650, 
	652, 654, 656, 658, 660, 662, 664, 666, 
	668, 670, 672, 674, 676, 678, 680, 682, 
	684, 686, 688, 690, 692, 694, 696, 698, 
	700, 702, 704, 705, 706, 707, 708, 709, 
	710, 711, 712, 713, 714, 715, 724, 732, 
	734, 737, 739, 741, 743, 745, 747, 749, 
	751, 753, 755, 757, 759, 761, 763, 765, 
	767, 769, 771, 773, 775, 777, 779, 781, 
	783, 785, 787, 789, 791, 793, 795, 797, 
	799, 801, 803, 805, 807, 809, 811, 813, 
	815, 817, 819, 822, 824, 826, 828, 830, 
	832, 834, 836, 838, 840, 842, 844, 846, 
	848, 850, 852, 854, 856, 858, 860, 862, 
	864, 866, 868, 870, 872, 874, 876, 878, 
	880, 882, 884, 886, 888, 890, 892, 894, 
	896, 898, 900, 902, 904, 906, 908, 910, 
	912, 914, 916, 918, 920, 922, 924, 926, 
	928, 930, 932, 934, 936, 938, 940, 941, 
	942, 943, 944, 945, 946, 947, 948, 949, 
	950, 951, 952, 953, 954, 955, 956, 957, 
	958, 959, 960, 961, 962, 963, 964, 965, 
	973, 978, 980, 982, 984, 986, 988, 990, 
	992, 994, 996, 998, 1000, 1002, 1004, 1006, 
	1008, 1010, 1012, 1014, 1016, 1018, 1020, 1022, 
	1024, 1026, 1028, 1030, 1032, 1034, 1036, 1039, 
	1041, 1043, 1045, 1047, 1049, 1051, 1053, 1055, 
	1057, 1059, 1061, 1063, 1065, 1067, 1069, 1071, 
	1073, 1075, 1077, 1079, 1081, 1083, 1085, 1087, 
	1089, 1091, 1093, 1095, 1097, 1099, 1101, 1103, 
	1105, 1107, 1109, 1111, 1113, 1115, 1117, 1119, 
	1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 
	1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 
	1153, 1155, 1157, 1159, 1161, 1163, 1164, 1165
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -111, -110, -101, 
	-100, -95, -94, -93, -92, -48, -77, -68, 
	-48, -80, -47, -128, 32, 10, 13, 10, 
	13, -48, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, 34, 34, 10, 13, 
	10, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	9, 13, 10, 32, 9, 13, 10, 13, 
	10, 95, 70, 69, 65, 84, 85, 82, 
	69, 95, 69, 78, 68, 95, 37, 13, 
	32, 64, 9, 10, 9, 10, 13, 32, 
	64, 11, 12, 10, 32, 64, 9, 13, 
	32, 124, 9, 13, 10, 32, 92, 124, 
	9, 13, 10, 92, 124, 10, 92, 10, 
	32, 92, 124, 9, 13, -48, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-48, -68, -48, -66, -48, -72, -47, -128, 
	-48, -66, -48, -70, -48, -80, -48, -75, 
	-48, -70, -48, -72, -48, -67, -48, -72, 
	-47, -127, -48, -66, -48, -69, -48, -69, 
	-48, -80, -47, -128, 58, 10, 10, -48, 
	10, 32, 35, 124, 9, 13, -92, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-48, 10, -72, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, 10, 58, -48, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -47, -122, -48, -75, -48, -67, -48, 
	-80, -47, -128, -48, -72, -48, -71, 32, 
	58, -47, -127, -47, -126, -47, -128, -47, 
	-125, -48, -70, -47, -126, -47, -125, -47, 
	-128, -48, -80, -47, -127, -48, -72, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -111, -110, -101, -95, 
	-93, -92, 10, -48, 10, -77, -68, 10, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	10, 32, -48, 10, -68, 10, -48, 10, 
	-66, 10, -48, 10, -72, 10, -47, 10, 
	-128, 10, -48, 10, -66, 10, -48, 10, 
	-70, 10, -48, 10, -80, 10, -48, 10, 
	-75, 10, -48, 10, -70, 10, -48, 10, 
	-72, 10, -48, 10, -67, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, 10, 58, -48, 10, -67, 10, 
	-48, 10, -76, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 10, -48, 10, 
	32, 35, 37, 42, 64, 9, 13, -112, 
	-111, -110, -101, -95, -94, -93, -92, 10, 
	-48, 10, -77, -68, 10, -48, 10, -80, 
	10, -47, 10, -128, 10, 10, 32, -48, 
	10, -68, 10, -48, 10, -66, 10, -48, 
	10, -72, 10, -47, 10, -128, 10, -48, 
	10, -66, 10, -48, 10, -70, 10, -48, 
	10, -80, 10, -48, 10, -75, 10, -48, 
	10, -70, 10, -48, 10, -72, 10, -48, 
	10, -67, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, 10, 
	32, 58, -47, 10, -127, 10, -47, 10, 
	-126, 10, -47, 10, -128, 10, -47, 10, 
	-125, 10, -48, 10, -70, 10, -47, 10, 
	-126, 10, -47, 10, -125, 10, -47, 10, 
	-128, 10, -48, 10, -80, 10, -47, 10, 
	-127, 10, -48, 10, -72, 10, 10, 58, 
	-48, 10, -80, 10, -47, 10, -128, 10, 
	-48, 10, -72, 10, -47, 10, -123, 10, 
	-48, 10, -67, 10, -48, 10, -76, 10, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-48, 10, -72, 10, -48, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-48, -80, -47, -128, -48, -72, -47, -123, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -112, -111, -110, -101, 
	-95, -93, -92, 10, -48, 10, -77, -68, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, 10, 32, -48, 10, -68, 10, -48, 
	10, -66, 10, -48, 10, -72, 10, -47, 
	10, -128, 10, -48, 10, -66, 10, -48, 
	10, -70, 10, -48, 10, -80, 10, -48, 
	10, -75, 10, -48, 10, -70, 10, -48, 
	10, -72, 10, -48, 10, -67, 10, -47, 
	10, -122, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -71, 10, 10, 32, 58, -47, 10, 
	-127, 10, -47, 10, -126, 10, -47, 10, 
	-128, 10, -47, 10, -125, 10, -48, 10, 
	-70, 10, -47, 10, -126, 10, -47, 10, 
	-125, 10, -47, 10, -128, 10, -48, 10, 
	-80, 10, -47, 10, -127, 10, -48, 10, 
	-72, 10, 10, 58, -48, 10, -67, 10, 
	-48, 10, -76, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -67, -48, -76, 
	-47, -125, -48, -67, -48, -70, -47, -122, 
	-48, -72, -48, -66, -48, -67, -48, -80, 
	-48, -69, 58, 10, 10, -48, 10, 32, 
	35, 37, 64, 9, 13, -100, -95, -94, 
	-92, 10, -48, 10, -72, 10, -47, 10, 
	-127, 10, -48, 10, -66, 10, -48, 10, 
	-69, 10, -48, 10, -69, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, 10, 58, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, 10, 32, 58, -47, 
	10, -127, 10, -47, 10, -126, 10, -47, 
	10, -128, 10, -47, 10, -125, 10, -48, 
	10, -70, 10, -47, 10, -126, 10, -47, 
	10, -125, 10, -47, 10, -128, 10, -48, 
	10, -80, 10, -47, 10, -127, 10, -48, 
	10, -72, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -48, 10, -72, 10, -47, 
	10, -123, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 2, 1, 1, 1, 
	1, 1, 2, 2, 9, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	5, 3, 2, 4, 3, 2, 4, 9, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 5, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 9, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 8, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 7, 9, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 8, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	5, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 27, 29, 31, 
	33, 35, 37, 40, 43, 54, 56, 58, 
	61, 64, 69, 74, 79, 84, 88, 92, 
	95, 97, 99, 101, 103, 105, 107, 109, 
	111, 113, 115, 117, 119, 121, 123, 125, 
	130, 137, 142, 146, 152, 156, 159, 165, 
	176, 178, 180, 182, 184, 186, 188, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 232, 234, 236, 238, 
	240, 242, 244, 246, 248, 250, 252, 254, 
	261, 264, 267, 270, 273, 276, 279, 282, 
	285, 288, 291, 294, 297, 300, 303, 306, 
	309, 312, 315, 318, 321, 332, 334, 336, 
	338, 340, 342, 344, 346, 348, 350, 352, 
	354, 356, 358, 360, 363, 365, 367, 369, 
	371, 373, 375, 377, 379, 381, 383, 385, 
	387, 389, 391, 393, 395, 397, 399, 401, 
	403, 405, 407, 409, 411, 413, 422, 431, 
	434, 438, 441, 444, 447, 450, 453, 456, 
	459, 462, 465, 468, 471, 474, 477, 480, 
	483, 486, 489, 492, 495, 498, 501, 504, 
	507, 510, 513, 516, 519, 522, 525, 528, 
	531, 534, 537, 540, 543, 546, 549, 552, 
	555, 558, 561, 564, 567, 570, 573, 576, 
	579, 582, 585, 588, 591, 594, 597, 600, 
	603, 606, 609, 612, 615, 618, 621, 624, 
	627, 630, 633, 636, 639, 642, 645, 648, 
	651, 654, 657, 660, 663, 666, 669, 672, 
	674, 676, 685, 695, 698, 702, 705, 708, 
	711, 714, 717, 720, 723, 726, 729, 732, 
	735, 738, 741, 744, 747, 750, 753, 756, 
	759, 762, 765, 768, 771, 774, 777, 780, 
	783, 786, 789, 792, 795, 798, 801, 804, 
	807, 810, 813, 816, 819, 822, 825, 829, 
	832, 835, 838, 841, 844, 847, 850, 853, 
	856, 859, 862, 865, 868, 871, 874, 877, 
	880, 883, 886, 889, 892, 895, 898, 901, 
	904, 907, 910, 913, 916, 919, 922, 925, 
	928, 931, 934, 937, 940, 943, 946, 949, 
	952, 955, 958, 961, 964, 967, 970, 973, 
	976, 979, 982, 985, 988, 991, 994, 997, 
	1000, 1003, 1006, 1009, 1012, 1015, 1018, 1021, 
	1024, 1027, 1030, 1032, 1034, 1036, 1038, 1040, 
	1042, 1044, 1046, 1048, 1050, 1052, 1061, 1070, 
	1073, 1077, 1080, 1083, 1086, 1089, 1092, 1095, 
	1098, 1101, 1104, 1107, 1110, 1113, 1116, 1119, 
	1122, 1125, 1128, 1131, 1134, 1137, 1140, 1143, 
	1146, 1149, 1152, 1155, 1158, 1161, 1164, 1167, 
	1170, 1173, 1176, 1179, 1182, 1185, 1188, 1191, 
	1194, 1197, 1200, 1204, 1207, 1210, 1213, 1216, 
	1219, 1222, 1225, 1228, 1231, 1234, 1237, 1240, 
	1243, 1246, 1249, 1252, 1255, 1258, 1261, 1264, 
	1267, 1270, 1273, 1276, 1279, 1282, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1306, 1309, 1312, 
	1315, 1318, 1321, 1324, 1327, 1330, 1333, 1336, 
	1339, 1342, 1345, 1348, 1351, 1354, 1357, 1360, 
	1363, 1366, 1369, 1372, 1375, 1378, 1381, 1383, 
	1385, 1387, 1389, 1391, 1393, 1395, 1397, 1399, 
	1401, 1403, 1405, 1407, 1409, 1411, 1413, 1415, 
	1417, 1419, 1421, 1423, 1425, 1427, 1429, 1431, 
	1439, 1445, 1448, 1451, 1454, 1457, 1460, 1463, 
	1466, 1469, 1472, 1475, 1478, 1481, 1484, 1487, 
	1490, 1493, 1496, 1499, 1502, 1505, 1508, 1511, 
	1514, 1517, 1520, 1523, 1526, 1529, 1532, 1536, 
	1539, 1542, 1545, 1548, 1551, 1554, 1557, 1560, 
	1563, 1566, 1569, 1572, 1575, 1578, 1581, 1584, 
	1587, 1590, 1593, 1596, 1599, 1602, 1605, 1608, 
	1611, 1614, 1617, 1620, 1623, 1626, 1629, 1632, 
	1635, 1638, 1641, 1644, 1647, 1650, 1653, 1656, 
	1659, 1662, 1665, 1668, 1671, 1674, 1677, 1680, 
	1683, 1686, 1689, 1692, 1695, 1698, 1701, 1704, 
	1707, 1710, 1713, 1716, 1719, 1722, 1724, 1726
};

static const short _lexer_trans_targs[] = {
	2, 581, 12, 12, 13, 23, 25, 9, 
	39, 42, 12, 0, 3, 52, 60, 62, 
	70, 109, 346, 462, 466, 0, 4, 0, 
	5, 48, 0, 6, 0, 7, 0, 8, 
	0, 9, 0, 10, 0, 12, 24, 11, 
	12, 24, 11, 2, 12, 12, 13, 23, 
	25, 9, 39, 42, 12, 0, 14, 0, 
	15, 0, 17, 16, 16, 17, 16, 16, 
	18, 18, 19, 18, 18, 18, 18, 19, 
	18, 18, 18, 18, 20, 18, 18, 18, 
	18, 21, 18, 18, 12, 22, 22, 0, 
	12, 22, 22, 0, 12, 24, 23, 12, 
	0, 26, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 32, 0, 33, 
	0, 34, 0, 35, 0, 36, 0, 37, 
	0, 38, 0, 583, 0, 0, 0, 0, 
	0, 40, 41, 12, 41, 41, 39, 40, 
	40, 12, 41, 39, 41, 0, 42, 43, 
	42, 0, 47, 46, 45, 43, 46, 44, 
	0, 45, 43, 44, 0, 45, 44, 47, 
	46, 45, 43, 46, 44, 2, 47, 47, 
	13, 23, 25, 9, 39, 42, 47, 0, 
	49, 0, 50, 0, 51, 0, 9, 0, 
	53, 0, 54, 0, 55, 0, 56, 0, 
	57, 0, 58, 0, 59, 0, 9, 0, 
	61, 0, 9, 0, 63, 0, 64, 0, 
	65, 0, 66, 0, 67, 0, 68, 0, 
	69, 0, 9, 0, 71, 0, 72, 0, 
	73, 0, 74, 0, 75, 0, 76, 0, 
	77, 0, 78, 0, 79, 0, 80, 0, 
	81, 0, 82, 0, 83, 0, 84, 0, 
	85, 0, 87, 86, 87, 86, 88, 87, 
	87, 12, 12, 87, 86, 89, 87, 86, 
	90, 87, 86, 91, 87, 86, 92, 87, 
	86, 93, 87, 86, 94, 87, 86, 95, 
	87, 86, 96, 87, 86, 97, 87, 86, 
	98, 87, 86, 99, 87, 86, 100, 87, 
	86, 101, 87, 86, 102, 87, 86, 103, 
	87, 86, 104, 87, 86, 105, 87, 86, 
	106, 87, 86, 107, 87, 86, 87, 108, 
	86, 2, 12, 12, 13, 23, 25, 9, 
	39, 42, 12, 0, 110, 0, 111, 0, 
	112, 0, 113, 0, 114, 0, 115, 0, 
	116, 0, 117, 0, 118, 0, 119, 0, 
	120, 0, 121, 0, 122, 0, 123, 0, 
	124, 231, 0, 125, 0, 126, 0, 127, 
	0, 128, 0, 129, 0, 130, 0, 131, 
	0, 132, 0, 133, 0, 134, 0, 135, 
	0, 136, 0, 137, 0, 138, 0, 139, 
	0, 140, 0, 141, 0, 142, 0, 143, 
	0, 144, 0, 145, 0, 146, 0, 147, 
	0, 149, 148, 149, 148, 150, 149, 149, 
	12, 217, 157, 12, 149, 148, 151, 162, 
	170, 172, 180, 195, 199, 149, 148, 152, 
	149, 148, 153, 158, 149, 148, 154, 149, 
	148, 155, 149, 148, 156, 149, 148, 157, 
	149, 148, 149, 108, 148, 159, 149, 148, 
	160, 149, 148, 161, 149, 148, 157, 149, 
	148, 163, 149, 148, 164, 149, 148, 165, 
	149, 148, 166, 149, 148, 167, 149, 148, 
	168, 149, 148, 169, 149, 148, 157, 149, 
	148, 171, 149, 148, 157, 149, 148, 173, 
	149, 148, 174, 149, 148, 175, 149, 148, 
	176, 149, 148, 177, 149, 148, 178, 149, 
	148, 179, 149, 148, 157, 149, 148, 181, 
	149, 148, 182, 149, 148, 183, 149, 148, 
	184, 149, 148, 185, 149, 148, 186, 149, 
	148, 187, 149, 148, 188, 149, 148, 189, 
	149, 148, 190, 149, 148, 191, 149, 148, 
	192, 149, 148, 193, 149, 148, 194, 149, 
	148, 149, 108, 148, 196, 149, 148, 197, 
	149, 148, 198, 149, 148, 170, 149, 148, 
	200, 149, 148, 201, 149, 148, 202, 149, 
	148, 203, 149, 148, 204, 149, 148, 205, 
	149, 148, 206, 149, 148, 207, 149, 148, 
	208, 149, 148, 209, 149, 148, 210, 149, 
	148, 211, 149, 148, 212, 149, 148, 213, 
	149, 148, 214, 149, 148, 215, 149, 148, 
	216, 149, 148, 194, 149, 148, 149, 218, 
	148, 149, 219, 148, 149, 220, 148, 149, 
	221, 148, 149, 222, 148, 149, 223, 148, 
	149, 224, 148, 149, 225, 148, 149, 226, 
	148, 149, 227, 148, 149, 228, 148, 149, 
	229, 148, 149, 230, 148, 149, 12, 148, 
	233, 232, 233, 232, 234, 233, 233, 12, 
	332, 241, 12, 233, 232, 235, 246, 254, 
	256, 264, 302, 310, 314, 233, 232, 236, 
	233, 232, 237, 242, 233, 232, 238, 233, 
	232, 239, 233, 232, 240, 233, 232, 241, 
	233, 232, 233, 108, 232, 243, 233, 232, 
	244, 233, 232, 245, 233, 232, 241, 233, 
	232, 247, 233, 232, 248, 233, 232, 249, 
	233, 232, 250, 233, 232, 251, 233, 232, 
	252, 233, 232, 253, 233, 232, 241, 233, 
	232, 255, 233, 232, 241, 233, 232, 257, 
	233, 232, 258, 233, 232, 259, 233, 232, 
	260, 233, 232, 261, 233, 232, 262, 233, 
	232, 263, 233, 232, 241, 233, 232, 265, 
	233, 232, 266, 233, 232, 267, 233, 232, 
	268, 233, 232, 269, 233, 232, 270, 233, 
	232, 271, 233, 232, 272, 233, 232, 273, 
	233, 232, 274, 233, 232, 275, 233, 232, 
	276, 233, 232, 277, 233, 232, 278, 233, 
	232, 233, 279, 108, 232, 280, 233, 232, 
	281, 233, 232, 282, 233, 232, 283, 233, 
	232, 284, 233, 232, 285, 233, 232, 286, 
	233, 232, 287, 233, 232, 288, 233, 232, 
	289, 233, 232, 290, 233, 232, 291, 233, 
	232, 292, 233, 232, 293, 233, 232, 294, 
	233, 232, 295, 233, 232, 296, 233, 232, 
	297, 233, 232, 298, 233, 232, 299, 233, 
	232, 300, 233, 232, 301, 233, 232, 233, 
	108, 232, 303, 233, 232, 304, 233, 232, 
	305, 233, 232, 306, 233, 232, 307, 233, 
	232, 308, 233, 232, 309, 233, 232, 301, 
	233, 232, 311, 233, 232, 312, 233, 232, 
	313, 233, 232, 254, 233, 232, 315, 233, 
	232, 316, 233, 232, 317, 233, 232, 318, 
	233, 232, 319, 233, 232, 320, 233, 232, 
	321, 233, 232, 322, 233, 232, 323, 233, 
	232, 324, 233, 232, 325, 233, 232, 326, 
	233, 232, 327, 233, 232, 328, 233, 232, 
	329, 233, 232, 330, 233, 232, 331, 233, 
	232, 301, 233, 232, 233, 333, 232, 233, 
	334, 232, 233, 335, 232, 233, 336, 232, 
	233, 337, 232, 233, 338, 232, 233, 339, 
	232, 233, 340, 232, 233, 341, 232, 233, 
	342, 232, 233, 343, 232, 233, 344, 232, 
	233, 345, 232, 233, 12, 232, 347, 0, 
	348, 0, 349, 0, 350, 0, 351, 0, 
	352, 0, 353, 0, 354, 0, 355, 0, 
	357, 356, 357, 356, 358, 357, 357, 12, 
	448, 365, 12, 357, 356, 359, 370, 378, 
	380, 388, 426, 430, 357, 356, 360, 357, 
	356, 361, 366, 357, 356, 362, 357, 356, 
	363, 357, 356, 364, 357, 356, 365, 357, 
	356, 357, 108, 356, 367, 357, 356, 368, 
	357, 356, 369, 357, 356, 365, 357, 356, 
	371, 357, 356, 372, 357, 356, 373, 357, 
	356, 374, 357, 356, 375, 357, 356, 376, 
	357, 356, 377, 357, 356, 365, 357, 356, 
	379, 357, 356, 365, 357, 356, 381, 357, 
	356, 382, 357, 356, 383, 357, 356, 384, 
	357, 356, 385, 357, 356, 386, 357, 356, 
	387, 357, 356, 365, 357, 356, 389, 357, 
	356, 390, 357, 356, 391, 357, 356, 392, 
	357, 356, 393, 357, 356, 394, 357, 356, 
	395, 357, 356, 396, 357, 356, 397, 357, 
	356, 398, 357, 356, 399, 357, 356, 400, 
	357, 356, 401, 357, 356, 402, 357, 356, 
	357, 403, 108, 356, 404, 357, 356, 405, 
	357, 356, 406, 357, 356, 407, 357, 356, 
	408, 357, 356, 409, 357, 356, 410, 357, 
	356, 411, 357, 356, 412, 357, 356, 413, 
	357, 356, 414, 357, 356, 415, 357, 356, 
	416, 357, 356, 417, 357, 356, 418, 357, 
	356, 419, 357, 356, 420, 357, 356, 421, 
	357, 356, 422, 357, 356, 423, 357, 356, 
	424, 357, 356, 425, 357, 356, 357, 108, 
	356, 427, 357, 356, 428, 357, 356, 429, 
	357, 356, 378, 357, 356, 431, 357, 356, 
	432, 357, 356, 433, 357, 356, 434, 357, 
	356, 435, 357, 356, 436, 357, 356, 437, 
	357, 356, 438, 357, 356, 439, 357, 356, 
	440, 357, 356, 441, 357, 356, 442, 357, 
	356, 443, 357, 356, 444, 357, 356, 445, 
	357, 356, 446, 357, 356, 447, 357, 356, 
	425, 357, 356, 357, 449, 356, 357, 450, 
	356, 357, 451, 356, 357, 452, 356, 357, 
	453, 356, 357, 454, 356, 357, 455, 356, 
	357, 456, 356, 357, 457, 356, 357, 458, 
	356, 357, 459, 356, 357, 460, 356, 357, 
	461, 356, 357, 12, 356, 463, 0, 464, 
	0, 465, 0, 60, 0, 467, 0, 468, 
	0, 469, 0, 470, 0, 471, 0, 472, 
	0, 473, 0, 474, 0, 475, 0, 476, 
	0, 477, 0, 478, 0, 479, 0, 480, 
	0, 481, 0, 482, 0, 483, 0, 484, 
	0, 485, 0, 487, 486, 487, 486, 488, 
	487, 487, 12, 567, 12, 487, 486, 489, 
	504, 541, 549, 487, 486, 490, 487, 486, 
	491, 487, 486, 492, 487, 486, 493, 487, 
	486, 494, 487, 486, 495, 487, 486, 496, 
	487, 486, 497, 487, 486, 498, 487, 486, 
	499, 487, 486, 500, 487, 486, 501, 487, 
	486, 502, 487, 486, 503, 487, 486, 487, 
	108, 486, 505, 487, 486, 506, 487, 486, 
	507, 487, 486, 508, 487, 486, 509, 487, 
	486, 510, 487, 486, 511, 487, 486, 512, 
	487, 486, 513, 487, 486, 514, 487, 486, 
	515, 487, 486, 516, 487, 486, 517, 487, 
	486, 518, 487, 486, 487, 519, 108, 486, 
	520, 487, 486, 521, 487, 486, 522, 487, 
	486, 523, 487, 486, 524, 487, 486, 525, 
	487, 486, 526, 487, 486, 527, 487, 486, 
	528, 487, 486, 529, 487, 486, 530, 487, 
	486, 531, 487, 486, 532, 487, 486, 533, 
	487, 486, 534, 487, 486, 535, 487, 486, 
	536, 487, 486, 537, 487, 486, 538, 487, 
	486, 539, 487, 486, 540, 487, 486, 503, 
	487, 486, 542, 487, 486, 543, 487, 486, 
	544, 487, 486, 545, 487, 486, 546, 487, 
	486, 547, 487, 486, 548, 487, 486, 503, 
	487, 486, 550, 487, 486, 551, 487, 486, 
	552, 487, 486, 553, 487, 486, 554, 487, 
	486, 555, 487, 486, 556, 487, 486, 557, 
	487, 486, 558, 487, 486, 559, 487, 486, 
	560, 487, 486, 561, 487, 486, 562, 487, 
	486, 563, 487, 486, 564, 487, 486, 565, 
	487, 486, 566, 487, 486, 503, 487, 486, 
	487, 568, 486, 487, 569, 486, 487, 570, 
	486, 487, 571, 486, 487, 572, 486, 487, 
	573, 486, 487, 574, 486, 487, 575, 486, 
	487, 576, 486, 487, 577, 486, 487, 578, 
	486, 487, 579, 486, 487, 580, 486, 487, 
	12, 486, 582, 0, 12, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 149, 126, 57, 
	110, 23, 0, 29, 54, 0, 5, 1, 
	0, 29, 1, 35, 0, 43, 0, 43, 
	0, 43, 139, 48, 9, 106, 11, 0, 
	134, 45, 45, 45, 3, 122, 33, 33, 
	33, 0, 122, 33, 33, 33, 0, 122, 
	33, 0, 33, 0, 102, 7, 7, 43, 
	54, 0, 0, 43, 114, 25, 0, 54, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 43, 43, 43, 
	43, 0, 27, 118, 27, 27, 51, 27, 
	0, 54, 0, 1, 0, 43, 0, 0, 
	0, 43, 54, 37, 37, 87, 37, 37, 
	43, 0, 39, 0, 43, 0, 0, 54, 
	0, 0, 39, 0, 0, 96, 54, 0, 
	93, 90, 41, 96, 90, 99, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 81, 81, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 21, 
	0, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	78, 33, 84, 78, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 19, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	144, 57, 54, 0, 84, 54, 0, 75, 
	33, 84, 75, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 17, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 72, 
	33, 84, 72, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 15, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 15, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 15, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 69, 33, 69, 0, 0, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	13, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 583;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1255 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
    
#line 1262 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1552 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1615 "ext/gherkin_lexer_uz/gherkin_lexer_uz.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/uz.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_uz()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Uz", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

