# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::SQL
  #
  # The Azure SQL Database management API provides a RESTful set of web
  # services that interact with Azure SQL Database services to manage your
  # databases. The API enables users to create, retrieve, update, and delete
  # Databases, Servers and related resources.
  #
  class SecurityAlertPolicy
    include Azure::ARM::SQL::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the SecurityAlertPolicy class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SqlManagementClient] reference to the SqlManagementClient
    attr_reader :client

    #
    # Creates or updates an Azure SQL Server security alert policy.
    #
    # @param parameters [ServerSecurityAlertPolicyCreateOrUpdateParameters] The
    # required parameters for creating or updating a Azure SQL Server security
    # alert policy.
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerSecurityAlertPolicy] operation results.
    #
    def create_or_update(parameters, resource_group_name, server_name, custom_headers = nil)
      response = create_or_update_async(parameters, resource_group_name, server_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param parameters [ServerSecurityAlertPolicyCreateOrUpdateParameters] The
    # required parameters for creating or updating a Azure SQL Server security
    # alert policy.
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(parameters, resource_group_name, server_name, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(parameters, resource_group_name, server_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = ServerSecurityAlertPolicy.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates or updates an Azure SQL Server security alert policy.
    #
    # @param parameters [ServerSecurityAlertPolicyCreateOrUpdateParameters] The
    # required parameters for creating or updating a Azure SQL Server security
    # alert policy.
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerSecurityAlertPolicy] operation results.
    #
    def begin_create_or_update(parameters, resource_group_name, server_name, custom_headers = nil)
      response = begin_create_or_update_async(parameters, resource_group_name, server_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates an Azure SQL Server security alert policy.
    #
    # @param parameters [ServerSecurityAlertPolicyCreateOrUpdateParameters] The
    # required parameters for creating or updating a Azure SQL Server security
    # alert policy.
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(parameters, resource_group_name, server_name, custom_headers = nil)
      begin_create_or_update_async(parameters, resource_group_name, server_name, custom_headers).value!
    end

    #
    # Creates or updates an Azure SQL Server security alert policy.
    #
    # @param parameters [ServerSecurityAlertPolicyCreateOrUpdateParameters] The
    # required parameters for creating or updating a Azure SQL Server security
    # alert policy.
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(parameters, resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ServerSecurityAlertPolicyCreateOrUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies/Default'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerSecurityAlertPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerSecurityAlertPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns an Azure SQL Server security alert policy.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerSecurityAlertPolicy] operation results.
    #
    def get(resource_group_name, server_name, custom_headers = nil)
      response = get_async(resource_group_name, server_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns an Azure SQL Server security alert policy.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, server_name, custom_headers = nil)
      get_async(resource_group_name, server_name, custom_headers).value!
    end

    #
    # Returns an Azure SQL Server security alert policy.
    #
    # @param resource_group_name [String] The name of the Resource Group to which
    # the server belongs.
    # @param server_name [String] The name of the Azure SQL Server.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies/Default'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerSecurityAlertPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
