# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::IotHub
  #
  # Use this API to manage the IoT hubs in your Azure subscription.
  #
  class IotHubResource
    include MsRestAzure

    #
    # Creates and initializes a new instance of the IotHubResource class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [IotHubClient] reference to the IotHubClient
    attr_reader :client

    #
    # Get the non-security related metadata of an IoT hub.
    #
    # Get the non-security related metadata of an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescription] operation results.
    #
    def get(resource_group_name, resource_name, custom_headers = nil)
      response = get_async(resource_group_name, resource_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the non-security related metadata of an IoT hub.
    #
    # Get the non-security related metadata of an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      get_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get the non-security related metadata of an IoT hub.
    #
    # Get the non-security related metadata of an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update the metadata of an IoT hub.
    #
    # Create or update the metadata of an Iot hub. The usual pattern to modify a
    # property is to retrieve the IoT hub metadata and security metadata, and then
    # combine them with the modified values in a new body to update the IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to create or update.
    # @param iot_hub_description [IotHubDescription] The IoT hub metadata and
    # security metadata.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescription] operation results.
    #
    def create_or_update(resource_group_name, resource_name, iot_hub_description, custom_headers = nil)
      response = create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to create or update.
    # @param iot_hub_description [IotHubDescription] The IoT hub metadata and
    # security metadata.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete an IoT hub.
    #
    # Delete an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete(resource_group_name, resource_name, custom_headers = nil)
      response = delete_async(resource_group_name, resource_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, resource_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, resource_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<IotHubDescription>] operation results.
    #
    def list_by_subscription(custom_headers = nil)
      first_page = list_by_subscription_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_subscription_with_http_info(custom_headers = nil)
      list_by_subscription_async(custom_headers).value!
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_subscription_async(custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hubs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<IotHubDescription>] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hubs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hubs.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the statistics from an IoT hub.
    #
    # Get the statistics from an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RegistryStatistics] operation results.
    #
    def get_stats(resource_group_name, resource_name, custom_headers = nil)
      response = get_stats_async(resource_group_name, resource_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the statistics from an IoT hub.
    #
    # Get the statistics from an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_stats_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      get_stats_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get the statistics from an IoT hub.
    #
    # Get the statistics from an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_stats_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::RegistryStatistics.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<IotHubSkuDescription>] operation results.
    #
    def get_valid_skus(resource_group_name, resource_name, custom_headers = nil)
      first_page = get_valid_skus_as_lazy(resource_group_name, resource_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_valid_skus_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      get_valid_skus_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_valid_skus_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubSkuDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<String>] operation results.
    #
    def list_event_hub_consumer_groups(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers = nil)
      first_page = list_event_hub_consumer_groups_as_lazy(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_event_hub_consumer_groups_with_http_info(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers = nil)
      list_event_hub_consumer_groups_async(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers).value!
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_event_hub_consumer_groups_async(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'event_hub_endpoint_name is nil' if event_hub_endpoint_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'eventHubEndpointName' => event_hub_endpoint_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::EventHubConsumerGroupsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubConsumerGroupInfo] operation results.
    #
    def get_event_hub_consumer_group(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      response = get_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_event_hub_consumer_group_with_http_info(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      get_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
    end

    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # Get a consumer group from the Event Hub-compatible device-to-cloud endpoint
    # for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to retrieve.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'event_hub_endpoint_name is nil' if event_hub_endpoint_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'eventHubEndpointName' => event_hub_endpoint_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::EventHubConsumerGroupInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to add.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubConsumerGroupInfo] operation results.
    #
    def create_event_hub_consumer_group(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      response = create_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to add.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_event_hub_consumer_group_with_http_info(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      create_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
    end

    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to add.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'event_hub_endpoint_name is nil' if event_hub_endpoint_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'eventHubEndpointName' => event_hub_endpoint_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::EventHubConsumerGroupInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_event_hub_consumer_group(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      response = delete_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
      nil
    end

    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_event_hub_consumer_group_with_http_info(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      delete_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers).value!
    end

    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint in the IoT hub.
    # @param name [String] The name of the consumer group to delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_event_hub_consumer_group_async(resource_group_name, resource_name, event_hub_endpoint_name, name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'event_hub_endpoint_name is nil' if event_hub_endpoint_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'eventHubEndpointName' => event_hub_endpoint_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<JobResponse>] operation results.
    #
    def list_jobs(resource_group_name, resource_name, custom_headers = nil)
      first_page = list_jobs_as_lazy(resource_group_name, resource_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_jobs_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      list_jobs_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_jobs_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::JobResponseListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param job_id [String] The job identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobResponse] operation results.
    #
    def get_job(resource_group_name, resource_name, job_id, custom_headers = nil)
      response = get_job_async(resource_group_name, resource_name, job_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param job_id [String] The job identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_job_with_http_info(resource_group_name, resource_name, job_id, custom_headers = nil)
      get_job_async(resource_group_name, resource_name, job_id, custom_headers).value!
    end

    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get the details of a job from an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param job_id [String] The job identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_job_async(resource_group_name, resource_name, job_id, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'job_id is nil' if job_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'jobId' => job_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::JobResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<IotHubQuotaMetricInfo>] operation results.
    #
    def get_quota_metrics(resource_group_name, resource_name, custom_headers = nil)
      first_page = get_quota_metrics_as_lazy(resource_group_name, resource_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_quota_metrics_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      get_quota_metrics_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_quota_metrics_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubQuotaMetricInfoListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Check if an IoT hub name is available.
    #
    # Check if an IoT hub name is available.
    #
    # @param operation_inputs [OperationInputs] Set the name parameter in the
    # OperationInputs structure to the name of the IoT hub to check.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubNameAvailabilityInfo] operation results.
    #
    def check_name_availability(operation_inputs, custom_headers = nil)
      response = check_name_availability_async(operation_inputs, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Check if an IoT hub name is available.
    #
    # Check if an IoT hub name is available.
    #
    # @param operation_inputs [OperationInputs] Set the name parameter in the
    # OperationInputs structure to the name of the IoT hub to check.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_name_availability_with_http_info(operation_inputs, custom_headers = nil)
      check_name_availability_async(operation_inputs, custom_headers).value!
    end

    #
    # Check if an IoT hub name is available.
    #
    # Check if an IoT hub name is available.
    #
    # @param operation_inputs [OperationInputs] Set the name parameter in the
    # OperationInputs structure to the name of the IoT hub to check.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_name_availability_async(operation_inputs, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'operation_inputs is nil' if operation_inputs.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::IotHub::Models::OperationInputs.mapper()
      request_content = @client.serialize(request_mapper,  operation_inputs)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubNameAvailabilityInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SharedAccessSignatureAuthorizationRule>] operation results.
    #
    def list_keys(resource_group_name, resource_name, custom_headers = nil)
      first_page = list_keys_as_lazy(resource_group_name, resource_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      list_keys_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::SharedAccessSignatureAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param key_name [String] The name of the shared access policy.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessSignatureAuthorizationRule] operation results.
    #
    def get_keys_for_key_name(resource_group_name, resource_name, key_name, custom_headers = nil)
      response = get_keys_for_key_name_async(resource_group_name, resource_name, key_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param key_name [String] The name of the shared access policy.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_keys_for_key_name_with_http_info(resource_group_name, resource_name, key_name, custom_headers = nil)
      get_keys_for_key_name_async(resource_group_name, resource_name, key_name, custom_headers).value!
    end

    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get a shared access policy by name from an IoT hub. For more information,
    # see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param key_name [String] The name of the shared access policy.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_keys_for_key_name_async(resource_group_name, resource_name, key_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'key_name is nil' if key_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name,'keyName' => key_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::SharedAccessSignatureAuthorizationRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param export_devices_parameters [ExportDevicesRequest] The parameters that
    # specify the export devices operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobResponse] operation results.
    #
    def export_devices(resource_group_name, resource_name, export_devices_parameters, custom_headers = nil)
      response = export_devices_async(resource_group_name, resource_name, export_devices_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param export_devices_parameters [ExportDevicesRequest] The parameters that
    # specify the export devices operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def export_devices_with_http_info(resource_group_name, resource_name, export_devices_parameters, custom_headers = nil)
      export_devices_async(resource_group_name, resource_name, export_devices_parameters, custom_headers).value!
    end

    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Exports all the device identities in the IoT hub identity registry to an
    # Azure Storage blob container. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param export_devices_parameters [ExportDevicesRequest] The parameters that
    # specify the export devices operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def export_devices_async(resource_group_name, resource_name, export_devices_parameters, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'export_devices_parameters is nil' if export_devices_parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::IotHub::Models::ExportDevicesRequest.mapper()
      request_content = @client.serialize(request_mapper,  export_devices_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::JobResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param import_devices_parameters [ImportDevicesRequest] The parameters that
    # specify the import devices operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobResponse] operation results.
    #
    def import_devices(resource_group_name, resource_name, import_devices_parameters, custom_headers = nil)
      response = import_devices_async(resource_group_name, resource_name, import_devices_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param import_devices_parameters [ImportDevicesRequest] The parameters that
    # specify the import devices operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def import_devices_with_http_info(resource_group_name, resource_name, import_devices_parameters, custom_headers = nil)
      import_devices_async(resource_group_name, resource_name, import_devices_parameters, custom_headers).value!
    end

    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # Import, update, or delete device identities in the IoT hub identity registry
    # from a blob. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param import_devices_parameters [ImportDevicesRequest] The parameters that
    # specify the import devices operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def import_devices_async(resource_group_name, resource_name, import_devices_parameters, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'import_devices_parameters is nil' if import_devices_parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::IotHub::Models::ImportDevicesRequest.mapper()
      request_content = @client.serialize(request_mapper,  import_devices_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::JobResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update the metadata of an IoT hub.
    #
    # Create or update the metadata of an Iot hub. The usual pattern to modify a
    # property is to retrieve the IoT hub metadata and security metadata, and then
    # combine them with the modified values in a new body to update the IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to create or update.
    # @param iot_hub_description [IotHubDescription] The IoT hub metadata and
    # security metadata.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescription] operation results.
    #
    def begin_create_or_update(resource_group_name, resource_name, iot_hub_description, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update the metadata of an IoT hub.
    #
    # Create or update the metadata of an Iot hub. The usual pattern to modify a
    # property is to retrieve the IoT hub metadata and security metadata, and then
    # combine them with the modified values in a new body to update the IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to create or update.
    # @param iot_hub_description [IotHubDescription] The IoT hub metadata and
    # security metadata.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, resource_name, iot_hub_description, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers).value!
    end

    #
    # Create or update the metadata of an IoT hub.
    #
    # Create or update the metadata of an Iot hub. The usual pattern to modify a
    # property is to retrieve the IoT hub metadata and security metadata, and then
    # combine them with the modified values in a new body to update the IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to create or update.
    # @param iot_hub_description [IotHubDescription] The IoT hub metadata and
    # security metadata.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, resource_name, iot_hub_description, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?
      fail ArgumentError, 'iot_hub_description is nil' if iot_hub_description.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
      request_content = @client.serialize(request_mapper,  iot_hub_description)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete an IoT hub.
    #
    # Delete an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_delete(resource_group_name, resource_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, resource_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete an IoT hub.
    #
    # Delete an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, resource_name, custom_headers = nil)
      begin_delete_async(resource_group_name, resource_name, custom_headers).value!
    end

    #
    # Delete an IoT hub.
    #
    # Delete an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub to delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, resource_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'resource_name is nil' if resource_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'resourceName' => resource_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200 || status_code == 204 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescription.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 404
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::ErrorDetails.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescriptionListResult] operation results.
    #
    def list_by_subscription_next(next_page_link, custom_headers = nil)
      response = list_by_subscription_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_subscription_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_subscription_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_subscription_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescriptionListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubSkuDescriptionListResult] operation results.
    #
    def get_valid_skus_next(next_page_link, custom_headers = nil)
      response = get_valid_skus_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_valid_skus_next_with_http_info(next_page_link, custom_headers = nil)
      get_valid_skus_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_valid_skus_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubSkuDescriptionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubConsumerGroupsListResult] operation results.
    #
    def list_event_hub_consumer_groups_next(next_page_link, custom_headers = nil)
      response = list_event_hub_consumer_groups_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_event_hub_consumer_groups_next_with_http_info(next_page_link, custom_headers = nil)
      list_event_hub_consumer_groups_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_event_hub_consumer_groups_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::EventHubConsumerGroupsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobResponseListResult] operation results.
    #
    def list_jobs_next(next_page_link, custom_headers = nil)
      response = list_jobs_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_jobs_next_with_http_info(next_page_link, custom_headers = nil)
      list_jobs_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_jobs_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::JobResponseListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubQuotaMetricInfoListResult] operation results.
    #
    def get_quota_metrics_next(next_page_link, custom_headers = nil)
      response = get_quota_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_quota_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_quota_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_quota_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::IotHubQuotaMetricInfoListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessSignatureAuthorizationRuleListResult] operation results.
    #
    def list_keys_next(next_page_link, custom_headers = nil)
      response = list_keys_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_next_with_http_info(next_page_link, custom_headers = nil)
      list_keys_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::IotHub::Models::SharedAccessSignatureAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the IoT hubs in a subscription.
    #
    # Get all the IoT hubs in a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescriptionListResult] which provide lazy access to pages of
    # the response.
    #
    def list_by_subscription_as_lazy(custom_headers = nil)
      response = list_by_subscription_async(custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_subscription_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all the IoT hubs in a resource group.
    #
    # Get all the IoT hubs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hubs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubDescriptionListResult] which provide lazy access to pages of
    # the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # Get the list of valid SKUs for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubSkuDescriptionListResult] which provide lazy access to pages
    # of the response.
    #
    def get_valid_skus_as_lazy(resource_group_name, resource_name, custom_headers = nil)
      response = get_valid_skus_async(resource_group_name, resource_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_valid_skus_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # Get a list of the consumer groups in the Event Hub-compatible device-to-cloud
    # endpoint in an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param event_hub_endpoint_name [String] The name of the Event Hub-compatible
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EventHubConsumerGroupsListResult] which provide lazy access to pages
    # of the response.
    #
    def list_event_hub_consumer_groups_as_lazy(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers = nil)
      response = list_event_hub_consumer_groups_async(resource_group_name, resource_name, event_hub_endpoint_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_event_hub_consumer_groups_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # Get a list of all the jobs in an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobResponseListResult] which provide lazy access to pages of the
    # response.
    #
    def list_jobs_as_lazy(resource_group_name, resource_name, custom_headers = nil)
      response = list_jobs_async(resource_group_name, resource_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_jobs_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the quota metrics for an IoT hub.
    #
    # Get the quota metrics for an IoT hub.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotHubQuotaMetricInfoListResult] which provide lazy access to pages
    # of the response.
    #
    def get_quota_metrics_as_lazy(resource_group_name, resource_name, custom_headers = nil)
      response = get_quota_metrics_async(resource_group_name, resource_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_quota_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # Get the security metadata for an IoT hub. For more information, see:
    # https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the IoT hub.
    # @param resource_name [String] The name of the IoT hub.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessSignatureAuthorizationRuleListResult] which provide lazy
    # access to pages of the response.
    #
    def list_keys_as_lazy(resource_group_name, resource_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, resource_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_keys_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
