/* 
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 2 of the License, or 
*  (at your option) any later version. 
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _DATA_VIEW_H__
#define _DATA_VIEW_H__


#include <gtk/gtk.h>

#include "libral.h"

G_BEGIN_DECLS


#define RUBRICA_DATA_VIEW_TYPE           (rubrica_data_view_get_type())

#define RUBRICA_DATA_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                          RUBRICA_DATA_VIEW_TYPE,           \
                                          RubricaDataView))

#define RUBRICA_DATA_VIEW_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),    \
                                          RUBRICA_DATA_VIEW_TYPE,           \
                                          RubricaDataViewClass))

#define IS_RUBRICA_DATA_VIEW(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                          RUBRICA_DATA_VIEW_TYPE))

#define IS_RUBRICA_DATA_VIEW_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                          RUBRICA_DATA_VIEW_TYPE))

#define RUBRICA_DATA_VIEW_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),   \
                                          RUBRICA_DATA_VIEW_TYPE,           \
                                          RubricaDataViewClass)


typedef struct _RubricaDataView        RubricaDataView;
typedef struct _RubricaDataViewClass   RubricaDataViewClass;
typedef struct _RubricaDataViewPrivate RubricaDataViewPrivate;


struct _RubricaDataView 
{
  GtkVBox parent;
  
  RubricaDataViewPrivate* priv;
};


struct _RubricaDataViewClass
{
  GtkVBoxClass parent_class;  

  /* signals */
  void (*launch) (RubricaDataView*, gpointer);
};


GType      rubrica_data_view_get_type  (void);


GtkWidget* rubrica_data_view_new       (void);

void       rubrica_data_view_show_card (RubricaDataView* view, RCard* card);


G_END_DECLS

#endif
