#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  rsbac_jail_ip_t ip;
  rsbac_jail_flags_t jail_flags = 0;
  char * progname;
  int verbose = 0;

  locale_init();

  progname = argv[0];

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'i':
                jail_flags |= JAIL_allow_external_ipc;
                break;
              case 'n':
                jail_flags |= JAIL_allow_all_net_family;
                break;
              case 'l':
                jail_flags |= JAIL_allow_rlimit;
                break;
              case 'r':
                jail_flags |= JAIL_allow_inet_raw;
                break;
              case 'a':
                jail_flags |= JAIL_auto_adjust_inet_any;
                break;
              case 'o':
                jail_flags |= JAIL_allow_inet_localhost;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc > 3)
    {
      struct in_addr addr;
      rsbac_jail_ip_t ip;
      int err;

      err = inet_aton(argv[2], &addr);
      error_exit(err);
      ip = addr.s_addr;
      if(verbose)
        printf(gettext("%s: executing %s in jail at %s with IP %s, flags %u\n"),
               progname,
               argv[3],
               argv[1],
               inet_ntoa(addr),
               jail_flags);
      res = rsbac_jail(RSBAC_JAIL_VERSION, argv[1], ip, jail_flags);
      error_exit(res);
      /* Already done in syscall rsbac_jail, but better repeat */
      res = chdir("/");
      error_exit(res);
      res = execvp(argv[3],&argv[3]);
      error_exit(res);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s [flags] path IP prog args\n"), progname);
      printf(gettext("This program will put the process into a jail with chroot to path,\n"));
      printf(gettext("ip address IP and then execute prog with args\n"));
      printf(gettext("-v = verbose, -i = allow access to IPC outside this jail,\n"));
      printf(gettext("-l = allow jailed processes to change their rlimits,\n"));
      printf(gettext("-n = allow all network families, not only UNIX and INET (IPv4),\n"));
      printf(gettext("-r = allow INET (IPv4) raw sockets (e.g. for ping),\n"));
      printf(gettext("-a = auto-adjust INET any address 0.0.0.0 to jail address, if set,\n"));
      printf(gettext("-o = additionally allow to/from remote INET (IPv4) address 127.0.0.1\n"));
    }
  return (res);
}

