#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include <rsbac/aci_data_structures.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

const char   set_prog[] = "auth_set_cap";
int recurse = 0;
int verbose = 0;
/* default max number of cap entries per file */
#define MAXNUM 200
int maxnum = MAXNUM;
char * filename = NULL;
struct rsbac_auth_cap_range_t * caplist;
rsbac_time_t * ttllist;

int process(char * name, FILE * tfile)
  {
    int res = 0;
    char tmp1[RSBAC_MAXNAMELEN];
    int i;
    struct stat buf;
    enum rsbac_auth_cap_type_t cap_type;

    if(verbose)
      printf(gettext("Processing FILE '%s'\n"), name);
    res = rsbac_auth_get_f_caplist(name, ACT_real, caplist, ttllist, maxnum);
    if(res<0)
      {
        get_error_name(tmp1,res);
        if(   verbose
           || (res != -RSBAC_EINVALIDTARGET)
          )
          fprintf(stderr, "%s: %s\n",
                  name,
                  tmp1);
        if(   !lstat(name,&buf)
           && S_ISDIR(buf.st_mode)
           && recurse)
          {
            DIR * dir_stream_p;
            struct dirent * dirent_p;
            char name2[PATH_MAX];

            if(S_ISLNK(buf.st_mode))
              return(0);
            if(!(dir_stream_p = opendir(name)))
              {
                fprintf(stderr, gettext("opendir for dir %s returned error: %s\n"),
                       name,
                       strerror(errno));
                return(-2);
              }
            while((dirent_p = readdir(dir_stream_p)))
              {
                if(   (strcmp(".",dirent_p->d_name))
                   && (strcmp("..",dirent_p->d_name)) )
                  {
                    strcpy(name2,name);
                    strcat(name2,"/");
                    strcat(name2,dirent_p->d_name);
                    process(name2, tfile);
                  }
              }
            closedir(dir_stream_p);
          }
      }
    else
      {
        if(verbose)
          printf("# %s: %i real caps\n", name, res);
        for(i=0;i<res;i++)
          if(ttllist[i])
            {
              rsbac_time_t now = time(NULL);

              if(caplist[i].first == caplist[i].last)
                fprintf(tfile,
                        "%s -T %u FILE add \"%s\" %u\n",
                        set_prog,
                        now + ttllist[i],
                        name,
                        caplist[i].first);
              else
                fprintf(tfile,
                        "%s -T %u FILE add \"%s\" %u %u\n",
                        set_prog,
                        now + ttllist[i],
                        name,
                        caplist[i].first,
                        caplist[i].last);
            }
          else
            {
              if(caplist[i].first == caplist[i].last)
                fprintf(tfile,
                        "%s FILE add \"%s\" %u\n",
                        set_prog,
                        name,
                        caplist[i].first);
              else
                fprintf(tfile,
                        "%s FILE add \"%s\" %u %u\n",
                        set_prog,
                        name,
                        caplist[i].first,
                        caplist[i].last);
            }
      }
    res = rsbac_auth_get_f_caplist(name, ACT_eff, caplist, ttllist, maxnum);
    if(res>0)
      {
        if(verbose)
          printf("# %s: %i eff caps\n", name, res);
        if(ttllist[i])
          {
            rsbac_time_t now = time(NULL);

            for(i=0;i<res;i++)
              {
                if(caplist[i].first == caplist[i].last)
                  fprintf(tfile,
                          "%s -e -T %u FILE add \"%s\" %u\n",
                          set_prog,
                          now + ttllist[i],
                          name,
                          caplist[i].first);
                else
                  fprintf(tfile,
                          "%s -e -T %u FILE add \"%s\" %u %u\n",
                          set_prog,
                          now + ttllist[i],
                          name,
                          caplist[i].first,
                          caplist[i].last);
              }
          }
        else
          {
            for(i=0;i<res;i++)
              {
                if(caplist[i].first == caplist[i].last)
                  fprintf(tfile,
                          "%s -e FILE add \"%s\" %u\n",
                          set_prog,
                          name,
                          caplist[i].first);
                else
                  fprintf(tfile,
                          "%s -e FILE add \"%s\" %u %u\n",
                          set_prog,
                          name,
                          caplist[i].first,
                          caplist[i].last);
              }
          }
      }
    res = rsbac_auth_get_f_caplist(name, ACT_fs, caplist, ttllist, maxnum);
    if(res>0)
      {
        if(verbose)
          printf("# %s: %i fs caps\n", name, res);
        if(ttllist[i])
          {
            rsbac_time_t now = time(NULL);

            for(i=0;i<res;i++)
              {
                if(caplist[i].first == caplist[i].last)
                  fprintf(tfile,
                          "%s -f -T %u FILE add \"%s\" %u\n",
                          set_prog,
                          now + ttllist[i],
                          name,
                          caplist[i].first);
                else
                  fprintf(tfile,
                          "%s -f -T %u FILE add \"%s\" %u %u\n",
                          set_prog,
                          now + ttllist[i],
                          name,
                          caplist[i].first,
                          caplist[i].last);
              }
          }
        else
          {
            for(i=0;i<res;i++)
              {
                if(caplist[i].first == caplist[i].last)
                  fprintf(tfile,
                          "%s -f FILE add \"%s\" %u\n",
                          set_prog,
                          name,
                          caplist[i].first);
                else
                  fprintf(tfile,
                          "%s -f FILE add \"%s\" %u %u\n",
                          set_prog,
                          name,
                          caplist[i].first,
                          caplist[i].last);
              }
          }
      }
    return(0);
  }

int main(int argc, char ** argv)
{
  int res = 0;
  int i;
  FILE * tfile;
  char * progname;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'm':
                if(argc > 2)
                  {
                    maxnum = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  fprintf(stderr, gettext("%s: missing maxnum value for parameter %c\n"), progname, *pos);
                break;
              case 'r':
                recurse=1;
                break;
              case 'o':
                if(argc > 2)
                  {
                    filename = argv[2];
                    argv++;
                    argc--;
                  }
                else
                  fprintf(stderr, gettext("%s: missing filename for parameter o\n"), progname);
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc > 1)
    {
      if(!filename)
        tfile = stdout;
      else
        if (!(tfile=fopen(filename,"w")))
          {
            fprintf(stderr, gettext("opening target file returned error: %s\n"),
                    strerror(errno));
          }
      if(verbose)
        {
          printf(gettext("%s: %i targets"), progname, argc - 1);
          if(recurse)
            printf(gettext(" - recursing"));
          printf("\n");
        }
      caplist = malloc(sizeof(*caplist) * maxnum);
      ttllist = malloc(sizeof(*ttllist) * maxnum);
      if(!caplist || !ttllist)
        error_exit(-ENOMEM);
      for (i=1;i < argc;i++)
        {
          process(argv[i],tfile);
        }
      if(tfile != stdout)
        fclose(tfile);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s [-r] [-v] [-o target-file] file/dirname(s)\n"), progname);  
      printf(gettext("- should be called by root with all rsbac modules switched off,\n"));
      printf(gettext("- -r = recurse in subdirs, -v = verbose, no symlinks followed,\n"));
      printf(gettext("  -m = set maximum length of cap entry list per file, default is %u\n"), MAXNUM);
      printf(gettext("- -o target-file = write to file, not stdout\n"));
    }
  return (res);
}
