#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  int i;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  struct passwd * user_info_p;

  locale_init();
  
  if (argc > 1)
    {
      printf(gettext("%s: %i users\n\n"), argv[0], argc - 1);
      for (i=1;i < (argc);i++)
        {
          value.dummy = -1;
              if(   (!(user_info_p = getpwnam(argv[i])))
                 && (!(user_info_p = getpwuid(strtol(argv[i],0,10)))) )
                {
                  fprintf(stderr, gettext("Invalid user %s!\n\n"), argv[i]);
                  continue;
                }
              printf(gettext("Processing user %s (uid %i)\n"),
                     user_info_p->pw_name, user_info_p->pw_uid);
              tid.user = user_info_p->pw_uid;

          res = rsbac_remove_target(T_USER, &tid);
          error_exit(res);
          printf("Returned value: %i\n",value.dummy);
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s user(s)\n\n"), argv[0]);  
    }
    
  return (res);
}
