#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <ctype.h>
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>

/*RSBAC*/
#include <rsbac/types.h>
#include <rsbac/rc_types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
/*RSBAC*/


#define RSU_FAIL_DELAY     2000000    /* usec on authentication failure */

static pam_handle_t *pamh = NULL;
static struct pam_conv conv = {
misc_conv,
NULL
};

int verbose=0;

int run_shell(int role,char *command)
{
char	**args=NULL;
char	*begin=command,*end,*line;
int	i=0,retval,j;

    while(isspace(*begin)) ++begin; 
    
    end=begin;
    while(end!=NULL){
        end++;
	end=strchr(end,' ');
    	i++;
    }
    
    args=malloc(sizeof(char *)*(i+1));
        
    end=begin;i=0;
    while (end!=NULL){
        int length;
        end=strchr(begin,' ');
        if ((end!=NULL)) end++;
	
        length=(end!=NULL)?end-begin:strlen(begin);
        line=malloc(length+2);
        strncpy(line,begin,length);
        while (isspace(line[length-1])) length--;
        line[length]=0;
        begin=end;
        args[i++]=line;
    }
    
    args[i]=NULL;
    
    if (verbose)
        for (j=0;j<=i;j++) printf("arg[%i]=`%s`\n",j,args[j]);
    
    /*set new role*/
    if ( (retval = rsbac_rc_change_role(role))<0 ){
        fprintf(stderr,"cannot set role\n");
	exit(retval);
    }
    
    if (verbose)
	printf("setting result %i\n",retval);

    
    retval=execvp( args[0] ,(i==1)?NULL:args );
    perror("rsu:execute");
    
    for(j=0;j<i;j++) free(args[j]);
    free(args);
    
    exit(retval);
}

int find_role(char *role_name)
{
    /*RSBAC*/
    union rsbac_rc_target_id_t	tid;
    union rsbac_rc_item_value_t	value;
    /*RSBAC*/
    int				i,j,retval;

    for(i=0; i<RSBAC_RC_NR_ROLES; i++)
    {	
        tid.role = i;
	value.dummy = -1;
	retval = rsbac_rc_get_item(RT_ROLE, &tid, RI_name, &value);
	if(!retval)
	{
	    if(value.name[0] == 0){
		continue;
	    }else{
		for(j=0;j<strlen(value.name);j++)
            	    if(isspace(value.name[j])) value.name[j] = '_';
	    }
	    if (!(strcmp(role_name,value.name)))
		return (i);
	}
    }
    return (-1);
}

int main(int argc, char **argv)
{
struct passwd	*pwd;
pid_t		child;
int		ch,retval,status;

int		role_number=0;
char		*command=NULL;
char		*name=NULL;

    if (argc < 2){
	fprintf(stderr,"No option given\n");
	fprintf(stderr,"Usage: rsu -r num [-v] [-n name]\n");
	fprintf(stderr,"-r role_num - role number\n");
	fprintf(stderr,"-n role_name - role name\n");
	fprintf(stderr,"-v     - print debug messages\n");
	exit(1);
    }

    /*check options*/    
    while ((ch = getopt(argc, argv, "vr:c:n:")) != EOF)
    switch((char)ch)
    {
    case 'v':/*verbose*/
	    verbose=1;
	    break;
    case 'r':/*Role Num*/
	    role_number = strtol(optarg,0,0);
	    break;
    case 'n':/*Name*/
	    name = optarg;
	    break;
    case 'c':/*Command*/
	    command = optarg;
	    break;
    default:
	    fprintf(stderr,"Unknown option\n");
	    exit(1);
    }
    
    if (command==NULL) command = strdup("bash -i");
    if (name!=NULL) role_number=find_role(name);
    
    if (verbose){
	if (name) printf("Name: %s\n",name);
	printf("Command: %s\n",command);
	printf("Role Num: %i\n",role_number);
    }
    
    /*start PAM*/
    pwd=getpwuid(getuid());
    retval = pam_start("rsu", pwd->pw_name, &conv, &pamh);
    if (retval != PAM_SUCCESS) {
	fprintf(stderr, "rsu: pam_start failed with code %d\n", retval);
	exit(1);
    }
    
    retval = pam_fail_delay(pamh, RSU_FAIL_DELAY);
    if (retval != PAM_SUCCESS) {
	fprintf(stderr, "rsu: problem initializing failure delay\n");
	exit(1);
    }
    
    do{
        retval = pam_authenticate(pamh, 0);	   /* authenticate the user */
	if (retval != PAM_SUCCESS)  break;
	
	retval= pam_end(pamh, PAM_SUCCESS);
	if (retval != PAM_SUCCESS){
	    fprintf(stderr,"cannot release autentificator");
	    exit(1);
	}
	pamh=NULL;
	
	/*set new role here*/
        child = fork();
        if (child == -1) {
	    fprintf(stderr,"cannot fork");
    	    exit(1);
        }

        if (child == 0) {
            run_shell(role_number,command);
        }

	/* wait for child to terminate */
	retval=wait(&status);
	return  WEXITSTATUS(status);
    }while (0);                       /* abuse loop to avoid using goto... */

    if (retval != PAM_SUCCESS) {      /* PAM has failed */
	fprintf(stderr, "rsu: %s\n", pam_strerror(pamh, retval));
    }
    
    if (pamh != NULL) {                                                                             
        pam_end(pamh,PAM_SUCCESS);                                                           
	pamh = NULL;                                                                                
    }
     
    return 1;
}
