
/*viewer.h - main viewer definitions*/

/*
 * (c) Stanislav Ievlev inger@linux.ru.net
 */
#ifndef _VIEWER_H
#define _VIEWER_H

/*main definitions*/
#define LOG_FILE_NAME "/secoff/log/security-out"
#define MAX_NAME 50
#define MAX_LINE 5000
#define MAX_BUFFER 3000
#define MIN_USER_LIMIT 500

/*command keys*/
#define KEY_USER	'u'
#define KEY_REQUEST	'r'
#define KEY_PROGRAM	'p'
#define KEY_TARGET_TYPE	't'
#define KEY_TARGET_ID	'i'
#define KEY_ATTR	'a'
#define KEY_RESULT	'z'

#define KEY_DONE	'q'
#define KEY_DATA	'd'
#define KEY_ENT		13	/*Enter */
#define KEY_NXT		9	/*Tab */
#define KEY_EXT		27	/*Esc */

/*numbers*/
#define COUNT_DATA       9
#define COUNT_OPTIONS    13

typedef struct log_info
{
	char    time[MAX_NAME];	/* copy of original url */
	char    request[MAX_NAME];
	int     pid;
	char    progname[MAX_NAME];
	char    username[MAX_NAME];
	char    target_type[10];
	char    tid[MAX_NAME];
	char    attr[MAX_NAME];
	int     value;
	char    result[MAX_NAME];
	char    modules[MAX_NAME];
	/*my */
	int     res;
} log_info;

typedef struct usage
{
	char    key[5];
	char    description[30];
} usage;

typedef struct menu_item
{
	char    key[2];
	char    description[MAX_LINE];
} menu_item;

typedef struct top_menu_item
{
	void    (*menu_fun) (int xpos, int ypos);
	char    description[MAX_LINE];
} top_menu_item;

log_info log_buffer[MAX_BUFFER];

#endif /*_VIEWER_H*/
