#!/bin/sh

# RRDWeather
# Copyright (c) 2005 Sebastien Wains <seb@wains.be>
# Released under the GNU General Public License
# http://www.wains.be/projects/rrdweather/

PATH=/usr/bin:/bin

##########################################################################################
################ EDIT THE FOLLOWING LINES TO MATCH YOUR CONFIGURATION ####################
##########################################################################################

UNIT=m 				# it should be "m" for metric units or "e" for english units
TMPDIR=/tmp/rrdweather		# where the images will be stored. NO TRAILING SLASH
RRDDIR=/usr/local/rrdweather/db	# where the DB's will be stored . NO TRAILING SLASH
WWWUSER=apache			# the web server user

ZIP=BEXX0014            	# your ZIP
CITY=mons               	# your city (no spaces, use underscores) 

DEBUG=n				# enable debug mode (y/n). When debug mode is enable, the DB's are not updated

##########################################################################################
###### YOU SHOULD NOT EDIT ANYTHING BELOW THIS LINE ######################################
##########################################################################################

cd /

if [ -d "$TMPDIR" ]; 
	then 			
		cd $TMPDIR
	else
		mkdir $TMPDIR
		chown $WWWUSER:$WWWUSER $TMPDIR
		chmod 777 $TMPDIR
		cd $TMPDIR
fi

rm $CITY -f
wget -q "http://xoap.weather.com/weather/local/$ZIP?cc=*&unit=$UNIT"
sleep 5s
mv "$ZIP?cc=*&unit=$UNIT" $CITY

if [ $UNIT = "m" ]
	then
	REAL=`cat $CITY | grep "<tmp>" |  awk -F'>' '{print $2}' | awk -F'<' '{print$1}' | sed -re 's/(N|n|A|a|\/)//g'`
	FELT=`cat $CITY | grep "<flik>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
	DEW=`cat $CITY | grep "<dewp>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
	HUMIDITY=`cat $CITY | grep "<hmid>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
	WIND=`cat $CITY | grep "<s>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(C|c|L|l|M|m|N|n|A|a|\/)//g'` 
	PRESSURE=`cat $CITY | grep "<r>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g;s/\.[0-9]{1,2}//g'`
	UV=`cat $CITY | grep "<i>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`

	else
        REAL=`cat $CITY | grep "<tmp>" |  awk -F'>' '{print $2}' | awk -F'<' '{print$1}' | sed -re 's/(N|n|A|a|\/)//g'`
        FELT=`cat $CITY | grep "<flik>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
        DEW=`cat $CITY | grep "<dewp>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
        HUMIDITY=`cat $CITY | grep "<hmid>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
        WIND=`cat $CITY | grep "<s>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(C|c|L|l|M|m|N|n|A|a|\/)//g'`
        PRESSURE=`cat $CITY | grep "<r>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
        UV=`cat $CITY | grep "<i>" |  awk -F'>' '{print $2}' | awk -F'<' '{print $1}' | sed -re 's/(N|n|A|a|\/)//g'`
fi

if [ $DEBUG = "y" ]
	then
	echo "Debugging mode"
	echo "Real temperature . :" $REAL
	echo "Felt temperature . :" $FELT
	echo "Dew point ........ :" $DEW
	echo "Humidity ......... :" $HUMIDITY
	echo "Wind ............. :" $WIND
	echo "Pressure ......... :" $PRESSURE
	echo "UV index ......... :" $UV

	else
	rrdtool update $RRDDIR/real.rrd N:$REAL
	rrdtool update $RRDDIR/felt.rrd N:$FELT
	rrdtool update $RRDDIR/dew.rrd N:$DEW
	rrdtool update $RRDDIR/humidity.rrd N:$HUMIDITY
	rrdtool update $RRDDIR/wind.rrd N:$WIND
	rrdtool update $RRDDIR/pressure.rrd N:$PRESSURE
	rrdtool update $RRDDIR/uv.rrd N:$UV
fi
