#!/bin/sh

# RRDWeather
# Copyright (c) 2005 Sebastien Wains <seb@wains.be>
# Released under the GNU General Public License
# http://www.wains.be/projects/rrdweather/

#######################################################################################
### EDIT THE LINE BELOW TO MATCH YOUR CONFIGURATION ###################################
#######################################################################################

RRDPATH="/usr/local/rrdweather/db/"

#######################################################################################
### YOU SHOULD NOT HAVE TO EDIT ANYTHING BELOW THIS LINE ##############################
#######################################################################################

echo "RRDWeather : database builder"
echo "-----------------------------"
echo "Are you updating an existing version or RRDweather (y/n) ? "
read UPDATE
echo " "
echo "Will you use metric (m) or english (e) units ?"
read UNIT
echo " "
echo "Thanks !"
echo " "
echo "Now, are you sure you want to create the databases ?"
echo "IT WILL OVERWRITE EXISTING DATA (y/n)" 
read ANSWER
echo " "

if [ $UPDATE = "y" ]
	then
	echo "You should not run db_builder.sh when upgrading RRDweather !"
	exit 1
fi 

if [ $ANSWER = "n" ]
then
	echo " "
	echo "Okay then.."
	echo "Exiting..."
	echo " "
	exit 0

elif [ $ANSWER = "y" ]
then
	cd

	if [ ! -d $RRDPATH ]
	then
	mkdir $RRDPATH
	fi

	rrdtool create $RRDPATH/real.rrd \
	--start 1127253600 \
	DS:real:GAUGE:600:-50:150 \
	RRA:AVERAGE:0.5:1:600 \
	RRA:AVERAGE:0.5:6:700 \
	RRA:AVERAGE:0.5:24:775 \
	RRA:AVERAGE:0.5:288:797 \
	RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
	RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create $RRDPATH/felt.rrd \
        --start 1127253600 \
        DS:felt:GAUGE:600:-50:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create $RRDPATH/dew.rrd \
        --start 1127253600 \
        DS:dew:GAUGE:600:-50:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create $RRDPATH/humidity.rrd \
        --start 1127253600 \
        DS:humidity:GAUGE:600:0:100 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create $RRDPATH/wind.rrd \
        --start 1127253600 \
        DS:wind:GAUGE:600:0:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	if [ $UNIT = "m" ]
	then

	rrdtool create $RRDPATH/pressure.rrd \
        --start 1127253600 \
        DS:pressure:GAUGE:600:950:1050 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	else
	rrdtool create $RRDPATH/pressure.rrd \
        --start 1127253600 \
        DS:pressure:GAUGE:600:28:31 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	fi

	rrdtool create $RRDPATH/uv.rrd \
        --start 1127253600 \
        DS:uv:GAUGE:600:0:15 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797
	
	echo " "	
	echo "Databases successfully built..."
	echo " "
	echo "Listing DB files created under $RRDPATH :"
	ls -lh $RRDPATH
	echo " "

else
echo " "
echo "It said y or n !"
echo "Exiting.. You deserved it ! :p"
echo " "
exit 1
fi
