import os
import sys
import unittest
import random

def run(module):
    try:
        unittest.main(module)
    except SystemExit:
        pass

if __name__ == '__main__':
    modules = os.listdir('.')

    if '--random' in sys.argv:
        random.shuffle(modules)
        sys.argv.remove('--random')

    modules = filter( lambda x: not x.endswith('.pyc'), modules)
    modules = filter( lambda x: x.startswith('test_'), modules)
    
    for module in modules:
        print 'Testing:', module[5:-3]
        name = module[:-3]
        run(name)
