# Find the kde-config program
#
# Variables:
#       HAVE_KDECONFIG
#	KDECONFIG_EXECUTABLE
#	KDE3PREFIX
#       KDE3HTMLDIR

IF(KDECONFIG_EXECUTABLE)
    SET(HAVE_KDECONFIG TRUE)
ELSE(KDECONFIG_EXECUTABLE)
    FIND_PROGRAM(KDECONFIG_EXECUTABLE NAMES kde-config PATHS
	$ENV{KDEDIR}/bin
	/opt/kde3/bin
	/opt/kde/bin
	NO_DEFAULT_PATH
    )
    FIND_PROGRAM(KDECONFIG_EXECUTABLE kde-config)
ENDIF(KDECONFIG_EXECUTABLE)

IF(NOT KDE3PREFIX)
    EXECUTE_PROCESS(COMMAND ${KDECONFIG_EXECUTABLE} --version
		    OUTPUT_VARIABLE kde_config_version )
    STRING(REGEX MATCH "KDE: .\\." kde_version ${kde_config_version})
    IF (${kde_version} MATCHES "KDE: 3\\.")
	EXECUTE_PROCESS(COMMAND ${KDECONFIG_EXECUTABLE} --prefix
			OUTPUT_VARIABLE kdedir )
	STRING(REGEX REPLACE "\n" "" KDE3PREFIX "${kdedir}")
    ENDIF (${kde_version} MATCHES "KDE: 3\\.")
ENDIF(NOT KDE3PREFIX)

IF(NOT KDE3HTMLDIR)
    EXECUTE_PROCESS(COMMAND ${KDECONFIG_EXECUTABLE} --expandvars --install html
        OUTPUT_VARIABLE _htmlinstalldir)
    STRING(REGEX REPLACE "\n" "" _htmlinstalldir "${_htmlinstalldir}")
    STRING(REPLACE "${KDE3PREFIX}/" "" KDE3HTMLDIR "${_htmlinstalldir}")
    #MESSAGE(STATUS "KDE3HTMLDIR : ${KDE3HTMLDIR}")
ENDIF(NOT KDE3HTMLDIR)
