#include "stringentry.h"

static void entryChanged(GtkEditable* widget, StringEntry* data)
{
        data->changed();
}

StringEntry::StringEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        valueWidget = gtk_entry_new();
        gtk_signal_connect(GTK_OBJECT(valueWidget), "changed", GTK_SIGNAL_FUNC(entryChanged), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), valueWidget, false, false, 3);
        gtk_widget_show(valueWidget);
}

DataSet StringEntry::getValue()
{
        string newValue(gtk_entry_get_text(GTK_ENTRY(valueWidget)));
        DataSet tmp;
        tmp.addString(newValue);
        return tmp;
}

void StringEntry::setValue(const DataSet& value)
{
        if (value.count() > 0)
                gtk_entry_set_text(GTK_ENTRY(valueWidget), const_cast<gchar*> (value.toString().c_str()));
}
