#include "overridemenu.h"
#include "modulemodifier.h"

void overrideButtonClicked(GtkButton* button, OverrideMenu* data)
{
        data->overrideClicked();
}

OverrideMenu::OverrideMenu(const Path& mod_, ModuleModifier& parent_, const Path& targetModule_)
        : mod(mod_),
          targetModule(targetModule_),
          parent(parent_),
          hbox(0)
{
        try {
                const DataSetMap *m = ModuleTree::instance()->module_info(targetModule);
                assert(m);
                const DataSetMap& modInf = *m;

                const string& mod_name = ModuleTree::instance()->get_type(targetModule);
                const DataSet& supported_vars = modInf["supported_vars"];
                const DataSet& overridable = modInf["overridable"];

                int ocount = 0;
                for (int i = 0; i < supported_vars.count(); i++) {
                        if (overridable.getBool(i))
                                ocount++;
                }
        
                if (ocount > 0) {
                        hbox = gtk_hbox_new(false, 0);
                        GtkWidget* label = gtk_label_new(mod_name.c_str());
                        gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 3);
                        GtkWidget* overrideMenu = gtk_option_menu_new();
                        menu = gtk_menu_new();
                        for (int i = 0; i < supported_vars.count(); i++) {
                                if (overridable.getBool(i)) {
                                        string name = supported_vars.getString(i);
                                        GtkWidget* menuItem = gtk_menu_item_new_with_label(const_cast<gchar *> (name.c_str()));
                                        gtk_object_set_user_data(GTK_OBJECT(menuItem), reinterpret_cast<void *> (i));
                                        gtk_menu_append(GTK_MENU(menu), menuItem);
                                }
                        }
                        gtk_option_menu_set_menu(GTK_OPTION_MENU(overrideMenu), menu);
                        gtk_box_pack_start(GTK_BOX(hbox), overrideMenu, true, true, 3);

                        GtkWidget* overrideButton = gtk_button_new_with_label("Over-ride");
                        gtk_signal_connect(GTK_OBJECT(overrideButton), "clicked", GTK_SIGNAL_FUNC(overrideButtonClicked), this);
                        gtk_box_pack_start(GTK_BOX(hbox), overrideButton, true, false, 3);
                
                        gtk_widget_show_all(hbox);
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void OverrideMenu::overrideClicked()
{
        try {
                GtkWidget* menuItem = gtk_menu_get_active(GTK_MENU(menu));
                int n = int(gtk_object_get_user_data(GTK_OBJECT(menuItem)));

                const DataSetMap *m = ModuleTree::instance()->module_info(targetModule);
                assert(m);
                const DataSetMap &modInf = *m;
                const DataSet& supported_vars = modInf["supported_vars"];
                string name = supported_vars.getString(n);

                for (int i = 0; i < sticky.count(); i++) {
                        if (sticky.getString(i) == name)
                                return;
                }

                sticky.addString(name);

                parent.addOverride(targetModule, n);
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void OverrideMenu::loadOverrides()
{
        try {
                sticky.clear();
                const DataSet& all_sticky = ModuleTree::instance()->get_value(mod, "sticky");
                if (all_sticky.count() > 0) {
                        const DataSetMap *m = ModuleTree::instance()->module_info(targetModule);
                        assert(m);
                        const DataSetMap& mInf = *m;
                        const DataSet& supVar = mInf["supported_vars"];
                        for (int i = 0; i < all_sticky.count(); i++) {
                                for (int j = 0; j < supVar.count(); j++) {
                                        if (supVar.getString(j) == all_sticky.getString(i)) {
                                                parent.addOverride(targetModule, j);
                                                sticky.add(all_sticky[i]);
                                        }
                                }
                        }
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

// remove `name' from `sticky' -- if its in there
void OverrideMenu::removeSticky(const string& name)
{
        for (int i = 0; i < sticky.count(); i++) {
                if (sticky.getString(i) == name) {
                        sticky.removeEntry(i);
                        parent.setChanged(true);
                }
        }
}
