#ifndef COMMON_H
#define COMMON_H

#define INTERNAL_ERROR cerr << "Internal error: " __FILE__ ":" << __LINE__ << "(Version =" VERSION ")" << endl

class RootPortal;
extern RootPortal* rootPortal;

extern int verbose;

#include <string>

std::string getBaseDir();
std::string getHomeDir();

#define CONFIG_DIR ".root-portal"

#ifdef DEBUG
extern bool debug;
#define rpdbgmsg(x) if (debug) cout << "\033[0;32m" << x << "\033[0m" << endl << flush
#else
#define rpdbgmsg(x)
#endif

#ifdef DEBUG
#define rpfailure() cerr << "\033[1;31m" << "Failure at " << __FILE__ << ":" << __LINE__ << "\033[0m" << endl; abort()
#else
#define rpfailure() cerr << "\033[1;31m" << "Failure at " << __FILE__ << ":" << __LINE__ << "\033[0m" << endl
#endif

#define rpwarning(x) cerr << "\033[1;33m" << "Warning at " << __FILE__ << ":" << __LINE__ << ": " << x << "\033[0m" << endl

#endif
