/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Dressings.h - Dressings -- various things that are scattered about the place.
 * Created by Robert Heller on Tue Aug  4 13:03:52 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Dressings.h,v $
 * Revision 1.4  1999/07/13 00:48:28  heller
 * Additional spelling error
 *
 * Revision 1.3  1999/07/13 00:29:40  heller
 * Documentation updates (spelling, punctionation, spelling, caps/nocaps).
 *
 * Revision 1.2  1998/12/27 21:48:19  heller
 * Spelling errors fixed.
 *
 * Revision 1.1  1998/08/21 14:58:33  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _DRESSINGS_H_
#define _DRESSINGS_H_

#include <Record.h>

//@Man: Dressings
/*@Doc:
  \typeout{Generated by $Id: Dressings.h,v 1.4 1999/07/13 00:48:28 heller Rel1 $.}
  Various dressing classes.
 */

//@{

/*@ManDoc: Treasures are the things the characters are trying to get and the
 monsters are guarding. */

class Treasure {
private:
	//@ManDoc: What it is called.
	const char *name;
	//@ManDoc: Description.
	const char *descr;
        //@ManDoc: Graphic.
        const char *image;
	//@ManDoc: How heavy it is.
        int weight;
        //@ManDoc: Armor Class adjustment.
        int aCAdj;
        //@ManDoc: To hit adjustment.
        int toHitAdj;
        //@ManDoc: Damage adjustment.
        int damAdj;
	//@ManDoc: Magical Resistance adjustment.
        int magResAdj;
        //@ManDoc: Damage Protection adjustment.
        int damProtAdj;
        //@ManDoc: Strength adjustment.
        int sAdj;
        //@ManDoc: Intelligence adjustment.
        int iAdj;
        //@ManDoc: Wisdom adjustment.
        int wAdj;
	//@ManDoc: Dexterity adjustment.
        int dAdj;
	//@ManDoc: Constitution adjustment.
        int cAdj;
	//@ManDoc: Charisma adjustment.
        int chAdj;
	//@ManDoc: Ground movement adjustment.
	int gAdj;
	//@ManDoc: Flying movement adjustment.
	int fAdj;
	//@ManDoc: Swimming movement adjustment.
	int swAdj;
	//@ManDoc: Value.
        int value;
        //@ManDoc: Data record.
        Record rawData;
	//@ManDoc: Record to Treasure.
	void RecordToTreasure();
	//@ManDoc: Update record.
	void UpdateRecord();
public:
	//@ManDoc: Update Treasure from Record.
	void UpdateFromRecord (const Record &rec)
	{
		rawData = rec;
		RecordToTreasure ();
	}
	//@ManDoc: Constructor.
	Treasure(
		//@ManDoc: What it is called.
		const char *nm = "",
		//@ManDoc: Description.
		const char *d = "",
		//@ManDoc: Graphical image (GIF).
		const char *i = "",
		//@ManDoc: How heavy it is.
	        int w = 0,
	        //@ManDoc: Armor class adjustment.
	        int aCA = 0,
	        //@ManDoc: To hit adjustment.
	        int toHA = 0,
	        //@ManDoc: Damage adjustment.
	        int damA = 0,
		//@ManDoc: Magical resistance adjustment.
	        int magResA = 0,
	        //@ManDoc: Damage protection adjustment.
	        int damProtA = 0,
	        //@ManDoc: Strength adjustment.
	        int sA = 0,
	        //@ManDoc: Intelligence adjustment.
	        int iA = 0,
	        //@ManDoc: Wisdom adjustment.
	        int wA = 0,
		//@ManDoc: Dexterity adjustment.
	        int dA = 0,
		//@ManDoc: Constitution adjustment.
	        int cA = 0,
		//@ManDoc: Charisma adjustment.
	        int chA = 0,
		//@ManDoc: Ground movement adjustment.
		int gA = 0,
		//@ManDoc: Flying movement adjustment.
		int fA = 0,
		//@ManDoc: Swimming movement adjustment.
		int swA = 0,
		//@ManDoc: Value.
	        int v = 0
	) {
		name = nm;
		descr = d;
		image = i;
		weight = w;
		aCAdj = aCA;
		toHitAdj = toHA;
		damAdj = damA;
		magResAdj = magResA;
		damProtAdj = damProtA;
		sAdj = sA;
		iAdj = iA;
		wAdj = wA;
		dAdj = dA;
		cAdj = cA;
		chAdj = chA;
		gAdj = gA;
		fAdj = fA;
		swAdj = swA;
		value = v;
		UpdateRecord();
	}
	//@ManDoc: Copy constructor (from pointer).
	Treasure (const Treasure *that)
	{
		UpdateFromRecord((Record)(*that));
	}
	//@ManDoc: Copy constructor (from reference).
	Treasure (const Treasure &that)
	{
		UpdateFromRecord((Record)(that));
	}
	//@ManDoc: Type conversion constructor, from a Record.
	Treasure (const Record *rec)
	{
		UpdateFromRecord(*rec);
	}
	//@ManDoc: Destructor.
	~Treasure() {}
	//@ManDoc: Type conversion: convert to a Record.
	operator const Record  () const {return rawData;}
	//@ManDoc: Return name.
	const char *Name() const {return name;}
	//@ManDoc: Return Description.
	const char *Description() const {return descr;}
	//@ManDoc: Return image.
        const char *Image() const {return image;}
        //@ManDoc: Return weight.
	int Weight() const {return weight;}
        //@ManDoc: Return armor class Adjustment.
	int ArmorClassAdj() const {return aCAdj;}
        //@ManDoc: Return to hit adjustment.
	int ToHitAdj() const {return toHitAdj;}
        //@ManDoc: Return damage adjustment.
	int DamageAdj() const {return damAdj;}
        //@ManDoc: Return magical resistance adjustment.
	int MagicalResistanceAdj() const {return magResAdj;}
        //@ManDoc: Return damage protection adjustment.
	int DamageProtectionAdj() const {return damProtAdj;}
        //@ManDoc: Return strength adjustment.
	int StrengthAdj() const {return sAdj;}
        //@ManDoc: Return intelligence adjustment.
	int IntelligenceAdj() const {return iAdj;}
        //@ManDoc: Return wisdom adjustment.
	int WisdomAdj() const {return wAdj;}
        //@ManDoc: Return dexterity adjustment.
	int DexterityAdj() const {return dAdj;}
        //@ManDoc: Return constitution adjustment.
	int ConstitutionAdj() const {return cAdj;}
        //@ManDoc: Return charisma adjustment.
	int CharismaAdj() const {return chAdj;}
	//@ManDoc: Return ground movement adjustment.
	int GroundMovementAdj() const {return gAdj;}
	//@ManDoc: Return flying adjustment.
	int FlyingAdj() const {return fAdj;}
	//@ManDoc: Return swimming adjustment.
	int SwimmingAdj() const {return swAdj;}
        //@ManDoc: Return value.
	int Value() const {return value;}
};

/*@ManDoc: Tricks and Traps are used to protect treasure and to generally
  keep the players on their toes.*/
 
class TrickTrap {
private:
	//@ManDoc: Name of the trick or trap.
	const char *name;
	//@ManDoc: Type of trick or trap.
	const char *tttype;
	//@ManDoc: Description of the trick or trap.
	const char *descr;
	//@ManDoc: Graphic of the trick or trap.
	const char *image;
        //@ManDoc: Data record.
        Record rawData;
	//@ManDoc: Record to TrickTrap.
	void RecordToTrickTrap();
	//@ManDoc: Update record.
	void UpdateRecord();
public:
	//@ManDoc: Update TrickTrap from Record.
	void UpdateFromRecord (const Record &rec)
	{
		rawData = rec;
		RecordToTrickTrap ();
	}
	//@ManDoc: Constructor.
	TrickTrap(
		//@ManDoc: What it is called.
		const char *nm = "",
		//@ManDoc: What type of trick or trap.
		const char *tt = "",
		//@ManDoc: Description.
		const char *d = "",
		//@ManDoc: Graphical image (GIF).
		const char *i = ""
	) {
		name = nm;
		tttype = tt;
		descr = d;
		image = i;
		UpdateRecord();
	}
	//@ManDoc: Copy constructor (from pointer).
	TrickTrap (const TrickTrap *that)
	{
		UpdateFromRecord((Record)(*that));
	}
	//@ManDoc: Copy constructor (from reference).
	TrickTrap (const TrickTrap &that)
	{
		UpdateFromRecord((Record)(that));
	}
	//@ManDoc: Type conversion constructor, from a Record.
	TrickTrap (const Record *rec)
	{
		UpdateFromRecord(*rec);
	}
	//@ManDoc: Destructor.
	~TrickTrap() {}
	//@ManDoc: Type conversion: convert to a Record.
	operator const Record  () const {return rawData;}
	//@ManDoc: Return name.
	const char *Name() const {return name;}
	//@ManDoc: Return trick or trap type.
	const char *Type() const {return tttype;}
	//@ManDoc: Return description.
	const char *Description() const {return descr;}
	//@ManDoc: Return image.
        const char *Image() const {return image;}
};

/*@ManDoc: Random dungeon dressings -- random odds and ends.  Sometimes these
  things have value, but real treasures use the Treasure class.*/
 
class Dressing {
private:
	//@ManDoc: The name of the object.
	const char *name;
	//@ManDoc: The image of the object.
	const char *image;
	//@MacDoc: The description of the object.
	const char *descr;
	//@ManDoc: The value of the object.
	int value;
	//@ManDoc: Data record.
	Record rawData;
	//@ManDoc: Record to Dressing.
	void RecordToDressing();
	//@ManDoc: Update record.
	void UpdateRecord();
public:
	//@ManDoc: Update dressing from Record.
	void UpdateFromRecord (const Record &rec)
	{
		rawData = rec;
		RecordToDressing ();
	}
	//@ManDoc: Constructor.
	Dressing(
		//@ManDoc: What it is called.
		const char *nm = "",
		//@ManDoc: Description.
		const char *d = "",
		//@ManDoc: Graphical image (GIF).
		const char *i = "",
		//@ManDoc: Value.
		int v = 0
	) {
		name = nm;
		descr = d;
		image = i;
		value = v;
		UpdateRecord();
	}
	//@ManDoc: Copy constructor (from pointer).
	Dressing (const Dressing *that)
	{
		UpdateFromRecord((Record)(*that));
	}
	//@ManDoc: Copy constructor (from reference).
	Dressing (const Dressing &that)
	{
		UpdateFromRecord((Record)(that));
	}
	//@ManDoc: Type conversion constructor, from a Record.
	Dressing (const Record *rec)
	{
		UpdateFromRecord(*rec);
	}
	//@ManDoc: Destructor.
	~Dressing() {}
	//@ManDoc: Type conversion: convert to a Record.
	operator const Record  () const {return rawData;}
	//@ManDoc: Return name.
	const char *Name() const {return name;}
	//@ManDoc: Return description.
	const char *Description() const {return descr;}
	//@ManDoc: Return image.
        const char *Image() const {return image;}
        //@ManDoc: Return Value.
	int Value() const {return value;}
};
		
//@}


#endif // _DRESSINGS_H_

