//ff_pls.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

int ff_pls_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl) {
 struct rpld_playlist_entry * cur = rpld_pl_get_first(pl);
 size_t num = rpld_pl_num(pl);
 unsigned long counter = 1;

 (void)handle;

 roar_vio_printf(vio, "[playlist]\n");
 roar_vio_printf(vio, "NumberOfEntries=%lu\n", (unsigned long)num);

 while ( cur != NULL ) {
//  roar_vio_printf(vio, "#EXTINF:%i,%s - %s\n", cur->length, cur->meta.artist, cur->meta.title);

  roar_vio_printf(vio, "File%lu=%s\n", counter, cur->io.filename);

  if ( cur->meta.title[0] )
   roar_vio_printf(vio, "Title%lu=%s\n", counter, cur->meta.title);

  if ( cur->length )
   roar_vio_printf(vio, "Length%lu=%lu\n", counter, (unsigned long)cur->length);

  counter++;

  cur = cur->list.next;
 }

 roar_vio_printf(vio, "Version=2\n");

 return 0;
}

int ff_pls_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);

//ll
