//QT_Spec.cpp, Copyright (c) 2001, 2002, 2003, 2004, 2005 R.Lackner
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qnamespace.h>
#include <qfiledialog.h>
#include <qpaintdevicemetrics.h>
#include <qimage.h>
#include <qcursor.h>
#include <qcstring.h>
#include <qclipboard.h>
#include <qbuffer.h>
#include <qbitmap.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "QT_Spec.h"

extern tag_Units Units[];
extern GraphObj *CurrGO;			//Selected Graphic Objects
extern Graph *CurrGraph;
extern char *WWWbrowser;
extern char *LoadFile;				//command line argument
extern char TmpTxt[];
extern Default defs;
extern UndoObj Undo;

QApplication *QAppl;
QWidget *MainWidget =0L;
POINT CurrWidgetPos = {0,0};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Menu item identifiers: synchronize this table with rlplot.rc for
//    compatibility with windows
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define CM_OPEN        500
#define CM_SAVEDATAAS  501
#define CM_EXIT        502
#define CM_NEWGRAPH    503
#define CM_NEWPAGE     504
#define CM_DELGRAPH    505
#define CM_ADDPLOT     506
#define CM_ABOUT       507
#define CM_ADDROWCOL   508
#define CM_COPYGRAPH   509
#define CM_SAVEGRAPHAS 510
#define CM_REDRAW      511
#define CM_ZOOM25      512
#define CM_ZOOM50      513
#define CM_ZOOM100     514
#define CM_ZOOM200     515
#define CM_ZOOM400     516
#define CM_PRINT       517
#define CM_EXPORT      518
#define CM_DELOBJ      519
#define CM_DEFAULTS    520
#define CM_COPY        521
#define CM_PASTE       522
#define CM_UPDATE      523
#define CM_ADDAXIS     524
#define CM_UNDO        525
#define CM_ZOOMIN      526
#define CM_ZOOMOUT     527
#define CM_ZOOMFIT     528
#define CM_FILE1       529
#define CM_FILE2       530
#define CM_FILE3       531
#define CM_FILE4       532
#define CM_FILE5       533
#define CM_FILE6       534
#define CM_FILLRANGE   535
#define CM_CUT         536
#define CM_LEGEND      537
#define CM_LAYERS      538
#define CM_INSROW      539
#define CM_INSCOL      540
#define CM_DELROW      541
#define CM_DELCOL      542

#define CM_T_STANDARD  560
#define CM_T_DRAW      561
#define CM_T_POLYLINE  562
#define CM_T_POLYGON   563
#define CM_T_RECTANGLE 564
#define CM_T_ROUNDREC  565
#define CM_T_ELLIPSE   566
#define CM_T_ARROW     567
#define CM_T_TEXT      568

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Exute a file open dialog for the different situations
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
static char UserFileName[600];
// Get a new file name to store data in
char *SaveDataAsName(char *oldname)
{
	QString fileName = QFileDialog::getSaveFileName(oldname?oldname:defs.currPath,
		"RLPlot workbook (*.rlw)\ndata files (*.csv)\ntab separated (*.tsv)\nXML (*.xml)", QAppl->focusWidget());
	if(!fileName.isEmpty()){
		strcpy(UserFileName, fileName);
		defs.FileHistory(UserFileName);
		return UserFileName;
		}
	return 0L;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a new file name to store graph
char *SaveGraphAsName(char *oldname)
{
	QString fileName = QFileDialog::getSaveFileName(oldname?oldname:defs.currPath,
		"RLPlot files (*.rlp)", QAppl->focusWidget());
	if(!fileName.isEmpty()){
		strcpy(UserFileName, fileName);
		defs.FileHistory(UserFileName);
		return UserFileName;
		}
	return 0L;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get file name to read graph
char *OpenGraphName(char *oldname)
{
	QString fileName = QFileDialog::getOpenFileName(oldname?oldname:defs.currPath,
		"RLPlot files (*.rlp)", QAppl->focusWidget());
	if(!fileName.isEmpty()){
		strcpy(UserFileName, fileName);
		defs.FileHistory(UserFileName);
		return UserFileName;
		}
	return 0L;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a file name to load data
char *OpenDataName(char *oldname)
{
	QString fileName = QFileDialog::getOpenFileName(oldname?oldname:defs.currPath,
		"RLPlot workbook (*.rlw)\ndata files (*.csv)\ntab separated file (*.tsv)\n"
		"RLPlot files (*.rlp)\nall files (*.*)", QAppl->focusWidget());
	if(!fileName.isEmpty()){
		strcpy(UserFileName, fileName);
		defs.FileHistory(UserFileName);
		return UserFileName;
		}
	return 0L;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a file name to export graph
void OpenExportName(GraphObj *g, char *oldname)
{
	int i;
	PrintQT *out=0L;

	if (!g) return;
	QString fileName = QFileDialog::getSaveFileName(oldname?oldname:defs.currPath,
		"Scalable Vector Graphics (*.svg)\nEncapsulated Post Script (*.eps)\n"
		"MSWindows MetaFile (*.wmf)\nTag Image File Format(*.tif *.tiff)", 
		QAppl->focusWidget());
	if(!fileName.isEmpty()){
		strcpy(UserFileName, fileName);
		i = strlen(UserFileName);
		g->Command(CMD_BUSY, 0L, 0L);
		if(0==strcasecmp(".svg", UserFileName+i-4)) {
			DoExportSvg(g, UserFileName, 0L);
			}
		else if(0==strcasecmp(".wmf", UserFileName+i-4)) {
			DoExportWmf(g, UserFileName, 600.0f, 0L);
			}
		else if(0==strcasecmp(".eps", UserFileName+i-4)) {
			DoExportEps(g, UserFileName, 0L);
			}
		else if(0==strcasecmp(".tif", UserFileName+i-4)) {
			DoExportTif(g, UserFileName, 0L);
			}
		else if(0==strcasecmp(".tiff", UserFileName+i-5)) {
			DoExportTif(g, UserFileName, 0L);
			}
		else ErrorBox("Unknown file extension or format");
		g->Command(CMD_MOUSECURSOR, 0L, 0L);
		}
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Common alert boxes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void InfoBox(char *Msg)
{
	QMessageBox::information(QAppl->focusWidget(), "Info", Msg);
}

void ErrorBox(char *Msg)
{
	QMessageBox::critical(QAppl->focusWidget(), "ERROR", Msg);
}

bool YesNoBox(char *Msg)
{
	if(QMessageBox::information(QAppl->focusWidget(), "RLPlot", Msg,
		"&Yes", "&No", 0L, 0, -1)) return false;
	return true;
}

int YesNoCancelBox(char *Msg)
{
	int res;

	res = QMessageBox::information(QAppl->focusWidget(), "RLPlot", Msg,
		"&Yes", "&No", "&Cancel", 0, -1);
	switch(res) {
	case 0:		return 1;
	case 1:		return 0;
	default:	return 2;
		}
	return 0;
}

void Qt_Box()
{
	QMessageBox::aboutQt(QAppl->focusWidget(), "RLPlot uses Qt");
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Display blinking text cursor
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
anyOutput *oTxtCur = 0L;
RECT rTxtCur, rCopyMark;
bool bTxtCur = false;
DWORD coTxtCur = 0x0L;
TxtCurBlink *cTxtCur = 0L;
POINT ptTxtCurLine[2];

void HideTextCursor()
{
	if(oTxtCur) {
		bTxtCur = false;
		oTxtCur->UpdateRect(&rTxtCur, false);
		}
	oTxtCur = 0L;
}

void HideTextCursorObj(anyOutput *out)
{
	if(oTxtCur && oTxtCur == out) HideTextCursor();
}

void ShowTextCursor(anyOutput *out, RECT *disp, DWORD color)
{
	coTxtCur = color;
	HideTextCursor();
	oTxtCur = out;
	memcpy(&rTxtCur, disp, sizeof(RECT));
	ptTxtCurLine[0].x = rTxtCur.left;	ptTxtCurLine[0].y = rTxtCur.top;
	ptTxtCurLine[1].x = rTxtCur.right;	ptTxtCurLine[1].y = rTxtCur.bottom;
	rTxtCur.bottom++;		rTxtCur.right++;
	bTxtCur = true;
	if(cTxtCur) cTxtCur->Show();
}

void InitTextCursor(bool init)
{
	if(init && !cTxtCur) cTxtCur = new TxtCurBlink();
	else if(!init && cTxtCur) {
		delete cTxtCur;
		cTxtCur = 0L;
		}
}

void HideCopyMark()
{
	if(cTxtCur && cTxtCur->bmCopyMark && cTxtCur->oCopyMark) {
		cTxtCur->oCopyMark->UpdateRect(&rCopyMark, false);
		delete cTxtCur->bmCopyMark;
		}
	cTxtCur->bmCopyMark = 0L;	cTxtCur->oCopyMark = 0L;
}

void ShowCopyMark(anyOutput *out, RECT *mrk, int nRec)
{
	int i;

	if(!out || !mrk || !nRec || !cTxtCur) return;
	cTxtCur->oCopyMark = out;
	rCopyMark.left = mrk[0].left;	rCopyMark.right = mrk[0].right;
	rCopyMark.top = mrk[0].top;		rCopyMark.bottom = mrk[0].bottom;
	for(i = 1; i < nRec; i++) {
		UpdateMinMaxRect(&rCopyMark, mrk[i].left, mrk[i].top);
		UpdateMinMaxRect(&rCopyMark, mrk[i].right, mrk[i].bottom);
		}
	cTxtCur->bmCopyMark = new BitMapQT(rCopyMark.right - rCopyMark.left+1, 
		rCopyMark.bottom - rCopyMark.top+1, out->hres, out->vres);
}

LineDEF liCopyMark1 = {0.0f, 1.0f, 0x00ffffffL, 0L};
LineDEF liCopyMark2 = {0.0f, 6.0f, 0x0L, 0xf0f0f0f0L};

TxtCurBlink::TxtCurBlink():QObject(MainWidget, 0)
{
	isVis = false;
	oCopyMark = 0L;		bmCopyMark = 0L;
	count = cp_mark = 0;
	startTimer(60);
}

void
TxtCurBlink::Show()
{
	count = -4;
	isVis = true;
	if(bTxtCur && oTxtCur)oTxtCur->ShowLine(ptTxtCurLine, 2, coTxtCur);

}

void
TxtCurBlink::showCopyMark()
{
	if(bmCopyMark && oCopyMark) {
		bmCopyMark->CopyBitmap(0, 0, oCopyMark, rCopyMark.left, rCopyMark.top, 
			rCopyMark.right - rCopyMark.left, rCopyMark.bottom - rCopyMark.top, false);
		bmCopyMark->SetLine(&liCopyMark1);
		line[0].x = line[1].x = line[4].x = 0;
		line[0].y = line[3].y = line[4].y = 0;
		line[1].y = line[2].y = rCopyMark.bottom-rCopyMark.top-1;
		line[2].x = line[3].x = rCopyMark.right-rCopyMark.left-1;
		bmCopyMark->oPolyline(line, 5);
		bmCopyMark->SetLine(&liCopyMark2);
		bmCopyMark->RLP.finc = 1.0;		bmCopyMark->RLP.fp = (cp_mark & 0x7);
		bmCopyMark->oPolyline(line, 5);
		oCopyMark->ShowBitmap(rCopyMark.left, rCopyMark.top, bmCopyMark);
		cp_mark++;
		if(isVis && oTxtCur && ptTxtCurLine[0].y != ptTxtCurLine[1].y &&
			oTxtCur == oCopyMark && OverlapRect(&rCopyMark, &rTxtCur)){
			oTxtCur->ShowLine(ptTxtCurLine, 2, coTxtCur);
			}
		}
}

void
TxtCurBlink::timerEvent(QTimerEvent *ev)
{
	showCopyMark();
	if(!oTxtCur || (ptTxtCurLine[0].x == ptTxtCurLine[1].x &&
		ptTxtCurLine[0].y == ptTxtCurLine[1].y)) return;
	count++;
	if(count<0) oTxtCur->ShowLine(ptTxtCurLine, 2, coTxtCur);
	if(count < 8) return;
	count = 0;
	if(bTxtCur && oTxtCur) {
		if(isVis) {
			oTxtCur->UpdateRect(&rTxtCur, false);
			isVis = false;
			}
		else {
			oTxtCur->ShowLine(ptTxtCurLine, 2, coTxtCur);
			isVis = true;
			}
		}
}

#define MIME_KSPREAD "application/x-kspread-snippet"
#define MIME_RLPLOT "application/x-rlplot-snippet"
#define MIME_RLPGRAPH "application/x-rlplot-graph"
#define MIME_RLPOBJ "application/x-rlplot-object"
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Clipboard support
// based on KDEs KSpread source: kspread_table.cc
// copyright (C) 1998, 1999 Torben Weis
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
KSpreadTextDrag::KSpreadTextDrag(QWidget *dragSource, const char *name )
	:QTextDrag(dragSource, name)
{
	go = 0L;
}

KSpreadTextDrag::~KSpreadTextDrag()
{
}

bool
KSpreadTextDrag::provides(const char *mimeType)
{
	if(0 == strcmp(mimeType, "text/plain")) return true;
	if(0 == strcmp(mimeType, MIME_RLPLOT)) return true;
	if(0 == strcmp(mimeType, selectionMimeType())) return true;
	return false;
}

QByteArray
KSpreadTextDrag::encodedData(const char *mime) const
{
	static QByteArray b;
	char *ptr = 0L;
	long cb;

	if(!go || go->Id != GO_SPREADDATA) return 0L;
	if(0 == strcmp(mime, MIME_RLPLOT)) {
		go->Command(CMD_COPY_XML, &ptr, 0L);
		}
	else if(0 == strcmp(mime, "text/plain")) {
		go->Command(CMD_COPY_TSV, &ptr, 0L);
		}
	else if(0 == strcmp(mime, selectionMimeType())){
		go->Command(CMD_COPY_XML, &ptr, 0L);
		}
	else return 0L;
	if(!ptr) ptr = (char*)calloc(cb = 4, 1);
	else cb = strlen(ptr)+1;
	if(ptr && b.resize(cb)) {
		memcpy(b.data(), ptr, cb);
		free (ptr);
		return (b);
		}
	return 0L;
}

bool
KSpreadTextDrag::canDecode(QMimeSource *e)
{
	if(e->provides(selectionMimeType())) return true;
	return false;
}

const char *
KSpreadTextDrag::format(int i) const
{
	static const char *fmt;

	switch(i) {
	case 0:	case 1:
		fmt = "text/plain";
		return fmt;
	case 2:
	case 3:	case 4:
		return selectionMimeType();
	default:
		return 0L;
		}
}

const char *
KSpreadTextDrag::selectionMimeType()
{
	return(MIME_RLPLOT);
}

RLPGraphDrag::RLPGraphDrag(QWidget *dragSource, const char *name)
	:QTextDrag(dragSource, name)
{
	go1 = go2 = 0L;
}

RLPGraphDrag::~RLPGraphDrag()
{
}

bool
RLPGraphDrag::provides(const char *mimeType)
{
	if(go1 && 0 == strcmp(mimeType, MIME_RLPGRAPH)) return true;
	if(go2 && 0 == strcmp(mimeType, MIME_RLPOBJ)) return true;
	return false;
}

void
RLPGraphDrag::setGraphData(GraphObj *g)
{
	go1 = g;
	if(CurrGraph && CurrGraph != g) go2 = CurrGraph;
	else go2 = 0L;
}

QByteArray
RLPGraphDrag::encodedData(const char* mime) const
{
	static QByteArray b;
	char *ptr = 0L;
	long cb;

	if(0 == strcmp(mime, "text/plain")) return 0L;
	else if(go1 && 0 == strcmp(mime, MIME_RLPGRAPH)) ptr = GraphToMem(go1, &cb);
	else if(go2 && 0 == strcmp(mime, MIME_RLPOBJ)) ptr = GraphToMem(go2, &cb);
	else return 0L;
	if(ptr && b.resize(cb+1)) {
		memcpy(b.data(), ptr, cb+1);
		free (ptr);
		return (b);
		}
	return 0L;
}

const char*
RLPGraphDrag::format(int i) const
{
	switch(i) {
	case 0:		return("text/plain");
	case 1:		return MIME_RLPGRAPH;
	case 2:		return MIME_RLPOBJ;
	default:	return 0L;
		}
}

bool
RLPGraphDrag::canDecode(QMimeSource *e)
{
	if(e->provides(MIME_RLPGRAPH)) return true;
	if(e->provides(MIME_RLPOBJ)) return true;
	return false;
}

const char*
RLPGraphDrag::selectionMimeType()
{
	return(MIME_RLPGRAPH);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Process paste command: check for clipboard contents
void TestClipboard(GraphObj *g)
{

	QClipboard *cb;
	QDragObject *mime;

	if(!(cb = QAppl->clipboard()))return;
	if(!(mime = (QDragObject *)cb->data()))return;
	if(g->Id == GO_SPREADDATA) {
		if(mime->provides(MIME_RLPLOT)){
			QByteArray b = mime->encodedData(MIME_RLPLOT);
			if(b) g->Command(CMD_PASTE_XML, (void*)b.data(), 0L);
			return;
			}
		else if(mime->provides(MIME_KSPREAD)){
			QByteArray b = mime->encodedData(MIME_KSPREAD);
			if(b) g->Command(CMD_PASTE_XML, (void*)b.data(), 0L);
			return;
			}
		else if(QByteArray b = mime->encodedData(MIME_RLPOBJ)){
			OpenGraph(g, 0L, (unsigned char*)b.data());
			return;
			}
		else if(QByteArray b = mime->encodedData(MIME_RLPGRAPH)){
			OpenGraph(g, 0L, (unsigned char*)b.data());
			return;
			}
		else if(mime->provides("text/plain")){
			QString _text = cb->text();
			ProcMemData(g, (unsigned char*)_text.latin1(), true);
			return;
			}
		}
	else if(g->Id == GO_PAGE){
		if(QByteArray b = mime->encodedData(MIME_RLPOBJ)){
			OpenGraph(g, 0L, (unsigned char*)b.data());
			return;
			}
		else if(QByteArray b = mime->encodedData(MIME_RLPGRAPH)){
			OpenGraph(g, 0L, (unsigned char*)b.data());
			return;
			}
		}
	else if(g->Id == GO_GRAPH)TestClipboard(g->parent);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Copy spreadsheet or graph to clipboard
void CopyData(GraphObj *g)
{
	EmptyClip();
	KSpreadTextDrag *kd = new KSpreadTextDrag(0L);
	kd->setText(QString("RLPlot snippet"));
	kd->setSpreadData(g);
#ifdef Q_CHECK_PTR				//n.a. in Qt version 2
	if(QAppl->clipboard()->supportsSelection())
		QAppl->clipboard()->setSelectionMode(TRUE);
#endif
	QAppl->clipboard()->setData(kd);
}

void CopyGraph(GraphObj *g)
{
	EmptyClip();
	RLPGraphDrag *gd = new RLPGraphDrag(0L);
	gd->setText(QString("RLPlot graph"));
	gd->setGraphData(g);
	//no support for X11 clipboard possible
	QAppl->clipboard()->setData(gd);
}

void EmptyClip()
{
	HideCopyMark();
	QAppl->clipboard()->clear();
}

void CopyText(char *txt, int len)
{
	QClipboard *cb;
	char tmp_txt[90];

	if(!(cb = QAppl->clipboard()) || !txt || !txt[0])return;
	EmptyClip();
	if(!len) len = strlen(txt);
	memcpy(tmp_txt, txt, len);		tmp_txt[len] = 0;
#ifdef Q_CHECK_PTR				//n.a. in Qt version 2
	cb->setText(tmp_txt, QClipboard::Clipboard);
	cb->setText(tmp_txt, QClipboard::Selection);
#else
	cb->setText(tmp_txt);
#endif
}

unsigned char* PasteText()
{
	QClipboard *cb;
	QMimeSource *mime;
	unsigned char *tmp_txt = 0L;

	if(!(cb = QAppl->clipboard())) return 0L;
#ifdef Q_CHECK_PTR				//n.a. in Qt version 2
	QString qstr = cb->text(QClipboard::Clipboard);
#else
	QString qstr = cb->text();
#endif
	if(qstr.length()) tmp_txt = (unsigned char*) strdup(qstr);
	else {
#ifdef Q_CHECK_PTR				//n.a. in Qt version 2
		qstr = cb->text(QClipboard::Selection);
#else
		QString qstr = cb->text();
#endif
		if(qstr.length()) tmp_txt = (unsigned char*) strdup(qstr);
		}
	return tmp_txt;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get display (desktop) size
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void GetDesktopSize(int *width, int *height)
{
	QWidget *d = QApplication::desktop();
	*width = d->width();
	*height = d->height();
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Swap red and blue in RGB value
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DWORD SwapRB(DWORD col)
{
	DWORD nc = col & 0x0000ff00L;

	nc |= (col>>16)&0x000000ffL;
	nc |= (col<<16)&0x00ff0000L;
	return nc;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Common code for all QT output classes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bool com_TextOut(int x, int y, char *ctxt, TextDEF *TxtSet, QPainter *qP, anyOutput *o)
{
	int i, w, h, ix, iy;
	QBrush oldBrush;
	QPen oldPen, currPen;
	QWMatrix xf, dxf;
	QString txt(ctxt);

	if(!ctxt || !ctxt[0] || !TxtSet || !qP || !o) return false;
	if(TxtSet->Font==FONT_GREEK) {
		txt.truncate(0);
		for(i = 0; ctxt[i]; i++) {
			if((ctxt[i] >= 'A' && ctxt[i] <= 'Z')) txt.append(QChar(ctxt[i] - 'A' + 0x391));
			else if((ctxt[i] >= 'a' && ctxt[i] <= 'z')) txt.append(QChar(ctxt[i] - 'a' + 0x3B1));
			else txt.append(QChar(ctxt[i]));
			}
		}
	oldBrush = qP->brush();		dxf = qP->worldMatrix();
	oldPen = currPen = qP->pen();
	o->oGetTextExtent(ctxt, -1, &w, &h);
	if(TxtSet->Align & TXA_VCENTER) iy = y + iround(TxtSet->iSize *0.4);
	else if(TxtSet->Align & TXA_VBOTTOM) iy = y;
	else iy = y + TxtSet->iSize + 1;
	if(TxtSet->Align & TXA_HCENTER) ix = x - (w >> 1);
	else if(TxtSet->Align & TXA_HRIGHT) ix = x - w;
	else ix = x;
	currPen.setColor(SwapRB(TxtSet->ColTxt));
	qP->setPen(currPen);
	if(fabs(TxtSet->RotBL) >.01 || fabs(TxtSet->RotCHAR) >.01) {
		xf.translate(x, y);
		xf.rotate(-TxtSet->RotBL);
		qP->setWorldMatrix(xf, TRUE);
		if(TxtSet->Mode == TXM_OPAQUE){
			currPen.setColor(SwapRB(TxtSet->ColBg));
			qP->setPen(currPen);
			qP->setBrush(QColor(SwapRB(TxtSet->ColBg)));
			qP->drawRect(0, - iround(h*.8), w, h);
			currPen.setColor(SwapRB(TxtSet->ColTxt));
			qP->setPen(currPen);
			}
		if(TxtSet->Style & TXS_SUB) iy += o->un2iy(TxtSet->fSize*0.4);
		else if(TxtSet->Style & TXS_SUPER) iy -= o->un2iy(TxtSet->fSize*0.4);
		qP->drawText(ix-x, iy-y, txt, -1);
		}
	else {
		if(TxtSet->Mode == TXM_OPAQUE){
			currPen.setColor(SwapRB(TxtSet->ColBg));
			qP->setPen(currPen);
			qP->setBrush(QColor(SwapRB(TxtSet->ColBg)));
			qP->drawRect(ix, iy - iround(h*.8), w, h);
			currPen.setColor(SwapRB(TxtSet->ColTxt));
			qP->setPen(currPen);
			}
		if(TxtSet->Style & TXS_SUB) iy += o->un2iy(TxtSet->fSize*0.4);
		else if(TxtSet->Style & TXS_SUPER) iy -= o->un2iy(TxtSet->fSize*0.4);
		qP->drawText(ix, iy, txt, -1);
		}
	qP->setPen(oldPen);
	qP->setBrush(oldBrush);
	qP->setWorldMatrix(dxf, FALSE);
	return true;
}

bool com_SetTextSpec(TextDEF *set, TextDEF *TxtSet, anyOutput *o, QFont qF, QPainter *qP)
{
	bool IsModified, RetVal;

	if(!set->iSize && set->fSize > 0.0) set->iSize = o->un2iy(set->fSize);
	if(!set->iSize) return false;
	if(TxtSet->iSize != set->iSize || TxtSet->Style != set->Style ||
		TxtSet->RotBL != set->RotBL || TxtSet->RotCHAR != set->RotCHAR ||
		TxtSet->Font != set->Font || TxtSet->Mode != set->Mode)
		IsModified = true;
	else IsModified = false;
	RetVal = o->anyOutput::SetTextSpec(set);
	if(IsModified) {
		qF.setBold((TxtSet->Style & TXS_BOLD) ? true : false);
		qF.setItalic((TxtSet->Style & TXS_ITALIC) ? true : false);
		qF.setUnderline((TxtSet->Style &TXS_UNDERLINE) ? true : false);
		if((TxtSet->Style & TXS_SUPER) || (TxtSet->Style & TXS_SUB))
			 qF.setPointSize(o->un2iy(set->fSize*0.71));
		else qF.setPointSize((TxtSet->iSize > 8) ? TxtSet->iSize : 8);
		switch(TxtSet->Font){
		case FONT_HELVETICA:
		default:			qF.setFamily("Helvetica");			break;
		case FONT_GREEK:
		case FONT_TIMES:	qF.setFamily("Times");				break;
		case FONT_COURIER:	qF.setFamily("Courier");			break;
			}
		qP->setFont(qF);
		}
	return RetVal;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Icon definitions
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//this icon has been taken from trolltech's Qt: qmessagebox.cpp
static char *information_xpm[]={
"32 32 5 1",
". c None",
"c c #000000",
"* c #999999",
"a c #ffffff",
"b c #0000ff",
"...........********.............",
"........***aaaaaaaa***..........",
"......**aaaaaaaaaaaaaa**........",
".....*aaaaaaaaaaaaaaaaaa*.......",
"....*aaaaaaaabbbbaaaaaaaac......",
"...*aaaaaaaabbbbbbaaaaaaaac.....",
"..*aaaaaaaaabbbbbbaaaaaaaaac....",
".*aaaaaaaaaaabbbbaaaaaaaaaaac...",
".*aaaaaaaaaaaaaaaaaaaaaaaaaac*..",
"*aaaaaaaaaaaaaaaaaaaaaaaaaaaac*.",
"*aaaaaaaaaabbbbbbbaaaaaaaaaaac*.",
"*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
"*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
"*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
"*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
"*aaaaaaaaaaaabbbbbaaaaaaaaaaac**",
".*aaaaaaaaaaabbbbbaaaaaaaaaac***",
".*aaaaaaaaaaabbbbbaaaaaaaaaac***",
"..*aaaaaaaaaabbbbbaaaaaaaaac***.",
"...caaaaaaabbbbbbbbbaaaaaac****.",
"....caaaaaaaaaaaaaaaaaaaac****..",
".....caaaaaaaaaaaaaaaaaac****...",
"......ccaaaaaaaaaaaaaacc****....",
".......*cccaaaaaaaaccc*****.....",
"........***cccaaaac*******......",
"..........****caaac*****........",
".............*caaac**...........",
"...............caac**...........",
"................cac**...........",
".................cc**...........",
"..................***...........",
"...................**..........."};

//this icon has been taken from trolltech's Qt: qmessagebox.cpp
static char *critical_xpm[]={
"32 32 4 1",
". c None",
"a c #999999",
"* c #ff0000",
"b c #ffffff",
"...........********.............",
".........************...........",
".......****************.........",
"......******************........",
".....********************a......",
"....**********************a.....",
"...************************a....",
"..*******b**********b*******a...",
"..******bbb********bbb******a...",
".******bbbbb******bbbbb******a..",
".*******bbbbb****bbbbb*******a..",
"*********bbbbb**bbbbb*********a.",
"**********bbbbbbbbbb**********a.",
"***********bbbbbbbb***********aa",
"************bbbbbb************aa",
"************bbbbbb************aa",
"***********bbbbbbbb***********aa",
"**********bbbbbbbbbb**********aa",
"*********bbbbb**bbbbb*********aa",
".*******bbbbb****bbbbb*******aa.",
".******bbbbb******bbbbb******aa.",
"..******bbb********bbb******aaa.",
"..*******b**********b*******aa..",
"...************************aaa..",
"....**********************aaa...",
"....a********************aaa....",
".....a******************aaa.....",
"......a****************aaa......",
".......aa************aaaa.......",
".........aa********aaaaa........",
"...........aaaaaaaaaaa..........",
".............aaaaaaa............"};

//thanks to Markus Bongard for the following icon
static char *RLPlot_xpm[]={
/* width height ncolors chars_per_pixel */
"32 32 169 2",
/* colors */
"AA c #FFFFFFFFFFFF",
"BA c #FFFFF7F79494",
"CA c #FFFFF7F78484",
"DA c #FFFFF7F77373",
"EA c #FFFFF7F75252",
"FA c #FFFFF7F74242",
"GA c #FFFFF7F73939",
"HA c #FFFFEFEF8C8C",
"IA c #FFFFEFEF4A4A",
"JA c #FFFFEFEF2929",
"KA c #F7F7E7E77B7B",
"LA c #F7F7C6C6ADAD",
"MA c #F7F7B5B59C9C",
"NA c #F7F7ADAD9494",
"OA c #EFEFF7F7F7F7",
"PA c #EFEFF7F7EFEF",
"AB c #EFEFEFEFEFEF",
"BB c #EFEFEFEFDEDE",
"CB c #EFEFE7E7A5A5",
"DB c #EFEFDEDE7373",
"EB c #EFEFDEDE3939",
"FB c #EFEFDEDE2929",
"GB c #EFEFD6D64242",
"HB c #EFEFA5A58C8C",
"IB c #EFEF94947B7B",
"JB c #EFEF84847373",
"KB c #EFEF84846363",
"LB c #EFEF7B7B7373",
"MB c #E7E7E7E7CECE",
"NB c #E7E7E7E79494",
"OB c #E7E7DEDE6B6B",
"PB c #E7E7DEDE5252",
"AC c #E7E7CECE5252",
"BC c #E7E77B7B6363",
"CC c #E7E773735A5A",
"DC c #E7E76B6B5252",
"EC c #E7E75A5A4A4A",
"FC c #DEDEE7E7F7F7",
"GC c #DEDEE7E7EFEF",
"HC c #DEDEDEDEDEDE",
"IC c #DEDEDEDEBDBD",
"JC c #DEDECECE4A4A",
"KC c #DEDE4A4A3939",
"LC c #D6D6EFEFCECE",
"MC c #D6D6DEDEEFEF",
"NC c #D6D6DEDECECE",
"OC c #CECEDEDEDEDE",
"PC c #CECED6D6CECE",
"AD c #CECECECEB5B5",
"BD c #CECECECE5A5A",
"CD c #C6C6E7E7C6C6",
"DD c #C6C6DEDEEFEF",
"ED c #C6C6D6D67373",
"FD c #C6C6CECE4A4A",
"GD c #BDBDDEDEB5B5",
"HD c #BDBDCECEE7E7",
"ID c #BDBDCECECECE",
"JD c #BDBDC6C6D6D6",
"KD c #BDBD39394242",
"LD c #B5B5DEDEADAD",
"MD c #B5B5BDBDCECE",
"ND c #B5B5BDBD4242",
"OD c #B5B5B5B59C9C",
"PD c #ADADD6D6ADAD",
"AE c #ADADCECEDEDE",
"BE c #ADADBDBDB5B5",
"CE c #ADADB5B54242",
"DE c #ADAD4A4A5252",
"EE c #A5A5BDBDDEDE",
"FE c #A5A5BDBDCECE",
"GE c #A5A5ADADB5B5",
"HE c #A5A5ADAD4242",
"IE c #A5A563637B7B",
"JE c #9C9CD6D6A5A5",
"KE c #9C9CBDBDD6D6",
"LE c #9C9CBDBDBDBD",
"ME c #9C9CADADCECE",
"NE c #9C9CADADA5A5",
"OE c #9C9C52525252",
"PE c #9C9C4A4A5252",
"AF c #9494CECE9C9C",
"BF c #9494B5B5CECE",
"CF c #9494ADAD5A5A",
"DF c #9494ADAD3939",
"EF c #8C8CCECE9494",
"FF c #8C8CCECE8C8C",
"GF c #8C8CB5B5B5B5",
"HF c #8C8CADADD6D6",
"IF c #8C8CADADCECE",
"JF c #8C8CADADB5B5",
"KF c #8C8CADADA5A5",
"LF c #8C8C9C9CB5B5",
"MF c #8C8C9C9CADAD",
"NF c #8C8C8C8CA5A5",
"OF c #8C8C52526363",
"PF c #8C8C42425252",
"AG c #8484B5B5CECE",
"BG c #7B7BCECE9494",
"CG c #7B7BC6C68484",
"DG c #7B7BC6C67B7B",
"EG c #7B7BADADC6C6",
"FG c #7B7BADADADAD",
"GG c #7B7B9C9CC6C6",
"HG c #7B7B9C9CB5B5",
"IG c #7B7B9C9CADAD",
"JG c #7B7B84849C9C",
"KG c #7B7B42425252",
"LG c #737384848C8C",
"MG c #737373738484",
"NG c #737339395252",
"OG c #6B6BC6C68484",
"PG c #6B6BBDBD7B7B",
"AH c #6B6BA5A5CECE",
"BH c #6B6B9C9CBDBD",
"CH c #6B6B9C9CA5A5",
"DH c #6B6B94949C9C",
"EH c #6B6B8C8CA5A5",
"FH c #6B6B8C8C9C9C",
"GH c #6B6B6B6B7B7B",
"HH c #6B6B42425252",
"IH c #6363BDBD6B6B",
"JH c #6363B5B58C8C",
"KH c #6363A5A58C8C",
"LH c #63639C9CC6C6",
"MH c #5A5AB5B56363",
"NH c #5A5A9C9CBDBD",
"OH c #5A5A8C8C9C9C",
"PH c #5A5A7B7B8C8C",
"AI c #5A5A6B6B8484",
"BI c #5A5A63637B7B",
"CI c #5252BDBD7373",
"DI c #5252ADAD8484",
"EI c #5252A5A57B7B",
"FI c #4A4AB5B55A5A",
"GI c #4A4A8C8CBDBD",
"HI c #4A4A8C8CADAD",
"II c #4A4A7B7B9C9C",
"JI c #4A4A7B7B8484",
"KI c #4A4A6B6B7B7B",
"LI c #42429C9C7373",
"MI c #42428C8C7B7B",
"NI c #42425A5A7373",
"OI c #42424A4A6B6B",
"PI c #3939ADAD6B6B",
"AJ c #3939ADAD5A5A",
"BJ c #39399C9C6B6B",
"CJ c #39398484BDBD",
"DJ c #39397B7BADAD",
"EJ c #39397B7B8C8C",
"FJ c #393973737B7B",
"GJ c #313163637B7B",
"HJ c #31315A5A7B7B",
"IJ c #292984846B6B",
"JJ c #29296B6B7B7B",
"KJ c #21217B7BB5B5",
"LJ c #21217373A5A5",
"MJ c #212173739C9C",
"NJ c #21216B6B8C8C",
"OJ c #212152527373",
"PJ c #181884846363",
"AK c #18186B6B7B7B",
"BK c #18185A5A7373",
"CK c #10106B6B9C9C",
"DK c #10105A5A8484",
"EK c #08087B7B6363",
"FK c #08085A5A7B7B",
"GK c #00006B6B9C9C",
"HK c #000063637B7B",
"IK c #00005A5A8C8C",
/* pixels */
"CJAHAHAHAHHILHLHBHLHLJNHNHNHGINHGINHGINHGINHGINHGINHGINHGINHGIKJ",
"AHAAAAAAAGHDABBBGCBFBFHCPCOCEEHDJDEEJDEEHDJDEEHDJDEEJDEEHDEEJDNH",
"AHAAAGAAABABABKEOCHCHCPCFEFEABAEHDFCDDJDDDMCJDHDFCHDHDGCDDJDDDLH",
"EGAEDDABOAABOCEGHCHCPCHCBHJDJDEEJDEEJDEEJDAEJDEEAEJDEEJDEEJDEELH",
"AHAAAAAAMCJDGCABHCHCBFOCPCJDEEJDEEJDEEAEEEEEAEJDEEFEFEFEEEEEJDGI",
"AHAAAAPAAGGCABBBMCEGJDNCPCPCEEEEEEEEEEEEEEJDEEEEFEDIPIGFFEFEEENH",
"EGOAKEAAABPAABKEHCHCHCHCMEBFABJDAEMCOCEEMCMCFEOCDDLEKHIDIDEEDDLH",
"LHAEMCAAABABAEIFHCHCHCPCBHOCKEKEEEFEEEFEEEFEEEKEBFGEDIKFMEFEEEGI",
"AHAAAAABGCJDABGCBBOCHGHCPCMDEEFEKEEEFEKEFEKEEEMEBFJFDIGEIFBFFEGI",
"AHAAAAPAAHGCABBBMCJFMDOCPCJDMEKEKEMEKEKEKEKEMEIFGEFGEIIGJFGEMEGI",
"AHAAAEAAABABGCNBDBOCNCNCMDEEMCEEEEMCJDKEDDDDLFCIDIEIPICIDIDIJDNH",
"AHKEDDAAPAABOCKFPBICNCPCHGFEMEMEMEMEHFMEMEIFJFJELCCDCGBBCDLIIGHI",
"EGAAAAABABJDMBNCPBADGENCMDMDMEHFIFHFMEHFIFMECHJEPCLDBGGDGDLIIGDJ",
"AHAAAAAAAHEDKAOBEBBDCEODICMDIFIFMEIFIFIFIFIFCHEFLDPDOGGDPDMIFHHI",
"AHAAOCABMBEABABAFABABAGBNELEHDKEHFDDEEIFJDEEFGCGLDPDPGPDPDAJMFHI",
"AHDDEGABBBEABACAFABACBGBFHGEIFGGIFGGIFIFGGIFDHCGJEMHFIAFAFBJDHII",
"AHAAAAABMBEAHAEAEADACABDODBEHGIFGGIFHGGGIFHGCHJHAFAFEFAFFFFJDHMJ",
"AHAAAAAABEIADADAKACADAGBODNEGGHGIEIENFGGHGGGOHDGFFFFFFFFFFAJOHHI",
"AHAAABABPCGAKADADAKADAFDODMFHIHIAIPFIIIIHIHIEJCIFFDGFFDGDGJJFJCK",
"AHAAAHHCMBGAEAEAEAFAFAJCLGFKPEPEPEKDPEPEOIIKHKLIDGDGPGDGIHEKIKGK",
"EGFCDDAANCJAIAIAIAIAIANDBKOJJBLALALBLAMANGFKHKFIMHPGMHFILIEKFKGK",
"LHAAAABBNCFBJAJAJAEBGBDFBKOJBCNADCDCIBHBNGBKAKFIMHMHMHMHMHEKHKGK",
"AHAAAAABADEBJCEBGBACACHEBKNIBCJBJBHBJBJBHHOJJJPIIHPGIHIHIHPJDKGK",
"AHAAOCJDNCEBOBACOBOBOBHEEJNIKCLBKBBCKBCCKGHJJJMHDGIHPGDGIHEKEJCK",
"AHAAKEABMBEBDBDBOBOBOBHENIAIKCDCDCDCDCECKGKIGJCIDGFFLGDGDGPJNJMJ",
"CJAAOAABBBIADBHADBHAKAHEAIBIDCDCBCCCDCCCPFKIJIPGBGCFDGFFDGIJIIMJ",
"AHAAAAABMBIABADBBAHAHAHEAIGHKCJBBCKBKBBCKGPHJIPGFFGFFFFFFFIJJILJ",
"AHAAAAABMDFDFDBDFDNDBDHEFHJGDEDEDEDEOEDEOFPHMGBJBJAJBJBJBJMIOHDJ",
"EGAAAAJDHGNFFHMGFHJGMGEHJGNFNFMGMGMGMGMGLGJGCHEHFHPHMGOHPHFHIGDJ",
"LHAAOCIFIFIFLFLFMFMFJFLFIFJFHGIGMFIGNFMFMFLFIFLFHGIGFGIGIGHGJFCJ",
"EGDDKEKEMEBFBFBFBFMEBFBFFEKEMEMEMEGEBFMEBFBFBFKEMEBFMEBFBFKEKEGI",
"KJLHGINHGINHNHNHNHGINHNHGINHGINHNHGIGINHGINHNHGINHNHGIGINHNHGICJ"};

//this icon has been taken from trolltech's Qt: qmessagebox.cpp
static char *qtlogo_xpm[] = {
/* width height ncolors chars_per_pixel */
"50 50 17 1",
/* colors */
"  c #000000",
". c #495808",
"X c #2A3304",
"o c #242B04",
"O c #030401",
"+ c #9EC011",
"@ c #93B310",
"# c #748E0C",
"$ c #A2C511",
"% c #8BA90E",
"& c #99BA10",
"* c #060701",
"= c #181D02",
"- c #212804",
"; c #61770A",
": c #0B0D01",
"/ c None",
/* pixels */
"/$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$/",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$+++$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$@;.o=::=o.;@$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$+#X*         **X#+$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$#oO*         O  **o#+$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$&.* OO              O*.&$$$$$$$$$$$$$",
"$$$$$$$$$$$$@XOO            * OO    X&$$$$$$$$$$$$",
"$$$$$$$$$$$@XO OO  O  **:::OOO OOO   X@$$$$$$$$$$$",
"$$$$$$$$$$&XO      O-;#@++@%.oOO      X&$$$$$$$$$$",
"$$$$$$$$$$.O  :  *-#+$$$$$$$$+#- : O O*.$$$$$$$$$$",
"$$$$$$$$$#*OO  O*.&$$$$$$$$$$$$+.OOOO **#$$$$$$$$$",
"$$$$$$$$+-OO O *;$$$$$$$$$$$&$$$$;*     o+$$$$$$$$",
"$$$$$$$$#O*  O .+$$$$$$$$$$@X;$$$+.O    *#$$$$$$$$",
"$$$$$$$$X*    -&$$$$$$$$$$@- :;$$$&-    OX$$$$$$$$",
"$$$$$$$@*O  *O#$$$$$$$$$$@oOO**;$$$#    O*%$$$$$$$",
"$$$$$$$;     -+$$$$$$$$$@o O OO ;+$$-O   *;$$$$$$$",
"$$$$$$$.     ;$$$$$$$$$@-OO OO  X&$$;O    .$$$$$$$",
"$$$$$$$o    *#$$$$$$$$@o  O O O-@$$$#O   *o$$$$$$$",
"$$$$$$+=    *@$$$$$$$@o* OO   -@$$$$&:    =$$$$$$$",
"$$$$$$+:    :+$$$$$$@-      *-@$$$$$$:    :+$$$$$$",
"$$$$$$+:    :+$$$$$@o* O    *-@$$$$$$:    :+$$$$$$",
"$$$$$$$=    :@$$$$@o*OOO      -@$$$$@:    =+$$$$$$",
"$$$$$$$-    O%$$$@o* O O    O O-@$$$#*   OX$$$$$$$",
"$$$$$$$. O *O;$$&o O*O* *O      -@$$;    O.$$$$$$$",
"$$$$$$$;*   Oo+$$;O*O:OO--      Oo@+=    *;$$$$$$$",
"$$$$$$$@*  O O#$$$;*OOOo@@-O     Oo;O*  **@$$$$$$$",
"$$$$$$$$X* OOO-+$$$;O o@$$@-    O O     OX$$$$$$$$",
"$$$$$$$$#*  * O.$$$$;X@$$$$@-O O        O#$$$$$$$$",
"$$$$$$$$+oO O OO.+$$+&$$$$$$@-O         o+$$$$$$$$",
"$$$$$$$$$#*    **.&$$$$$$$$$$@o      OO:#$$$$$$$$$",
"$$$$$$$$$+.   O* O-#+$$$$$$$$+;O    OOO:@$$$$$$$$$",
"$$$$$$$$$$&X  *O    -;#@++@#;=O    O    -@$$$$$$$$",
"$$$$$$$$$$$&X O     O*O::::O      OO    Oo@$$$$$$$",
"$$$$$$$$$$$$@XOO                  OO    O*X+$$$$$$",
"$$$$$$$$$$$$$&.*       **  O      ::    *:#$$$$$$$",
"$$$$$$$$$$$$$$$#o*OO       O    Oo#@-OOO=#$$$$$$$$",
"$$$$$$$$$$$$$$$$+#X:* *     O**X#+$$@-*:#$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$%;.o=::=o.#@$$$$$$@X#$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$+++$$$$$$$$$$$+$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$",
"/$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$/"};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Bitmap class for display export etc.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BitMapQT::BitMapQT(GraphObj *g, QWidget *wi, int vr, int hr):anyOutput()
{
	int w, h;

	hres = (double)hr;		vres = (double)vr;
	image = 0L;				hgo = 0L;
	if(wi) {
		w = wi->width();		h = wi->height();
		}
	else {
		GetDesktopSize(&w, &h);
		}
	Box1.Xmin = Box1.Ymin = 0.0;
	Box1.Xmax = w;					Box1.Ymax = h;
	DeskRect.left = DeskRect.top = 0;
	GetDesktopSize(&w, &h);
	DeskRect.right = w;				DeskRect.bottom = h;
	mempic = new QPixmap(w, h);
	mempic->fill(0x00ffffffL);
	qPainter.begin(mempic);
	qPen.setCapStyle(Qt::RoundCap);
	qPainter.setPen(qPen);
	qFont = qPainter.font();
}

BitMapQT::BitMapQT(int w, int h, double hr, double vr):anyOutput()
{
	hres = hr;		vres = vr;
	image = 0L;		hgo = 0L;
	w = abs(w);		h = abs(h);
	Box1.Xmin = Box1.Ymin = 0.0;
	Box1.Xmax = w;					Box1.Ymax = h;
	DeskRect.right = w;				DeskRect.bottom = h;
	DeskRect.left = DeskRect.top = 0;
	mempic = new QPixmap(w, h);
	mempic->fill(0x00ffffffL);
	qPainter.begin(mempic);
	qPen.setCapStyle(Qt::RoundCap);
	qPainter.setPen(qPen);
	qFont = qPainter.font();
}

BitMapQT::~BitMapQT()
{
	Undo.KillDisp(this);
	if(qPainter.isActive()) qPainter.end();
	HideTextCursorObj(this);
	if(mempic) delete mempic;
	if(hgo) delete hgo;
	if(image) delete image;
	mempic = 0L;	hgo = 0L;	image = 0L;
}

bool
BitMapQT::SetLine(LineDEF *lDef)
{
	int iw;

	if(lDef->width != LineWidth || lDef->width != LineWidth ||
		lDef->pattern != dPattern || lDef->color != dLineCol) {
		LineWidth = lDef->width;
		iw = iround(un2ix(lDef->width));
		dPattern = lDef->pattern;
		RLP.finc = 256.0/un2fix(lDef->patlength*8.0);
		RLP.fp = 0.0;
		if(iLine == iw && dLineCol == lDef->color) return true;
		iLine = iw;
		dLineCol = lDef->color;
		qPen.setColor(SwapRB(dLineCol));
		qPen.setWidth(iw);
		qPen.setStyle(Qt::SolidLine);
		qPen.setCapStyle(Qt::RoundCap);
		qPen.setJoinStyle(Qt::RoundJoin);
		qPainter.setPen(qPen);
		}
	return true;
}

bool
BitMapQT::SetFill(FillDEF *fill)
{
	if(!fill) return false;
	if((fill->type & 0xff) != FILL_NONE) {
		if(!hgo) hgo = new HatchOut(this);
		if(hgo) hgo->SetFill(fill);
		}
	else {
		if(hgo) delete hgo;
		hgo = 0L;
		}
	qPainter.setBrush(QColor(SwapRB(fill->color)));
	dFillCol = fill->color;
	dFillCol2 = fill->color2;
	return true;
}

bool
BitMapQT::SetTextSpec(TextDEF *set)
{
	return com_SetTextSpec(set, &TxtSet, this, qFont, &qPainter);
}

bool
BitMapQT::Erase(DWORD color)
{
	if(!mempic) return false;
	mempic->fill(color);
	if(image) delete image;
	image = 0L;
	return true;
}

bool
BitMapQT::CopyBitmap(int x, int y, anyOutput* sr, int sx, int sy,
	int sw, int sh, bool invert)
{
	BitMapQT *src = (BitMapQT*)sr;

	if(!mempic) return false;
	bitBlt(mempic, x, y, src->mempic, sx, sy, sw, sh,
		invert ? Qt::NotCopyROP : Qt::CopyROP);
	return true;


}

bool
BitMapQT::oGetTextExtent(char *text, int cb, int *width, int *height)
{
	if(!text) return false;
	QRect rc = qPainter.boundingRect(0, 0, 10000, 1000, Qt::AlignLeft | Qt::AlignTop,
		text, cb > 0 ? cb : strlen(text));
	*width = rc.rRight() - rc.rLeft();		*height = TxtSet.iSize +2;
	return true;
}

bool
BitMapQT::oGetPix(int x, int y, DWORD *col)
{
	DWORD pix;

	if(!image && !(image = new QImage(mempic->convertToImage())))return false;
	if(x >= DeskRect.left && x < DeskRect.right &&
		y >= DeskRect.top && y < DeskRect.bottom){
		pix = SwapRB(image->pixel(x, y));
		*col = pix;
		return true;
		}
	return false;
}

bool
BitMapQT::oDrawIcon(int type, int x, int y)
{
	char** xpm_data;
	QPixmap pm;

	switch (type) {
	case ICO_INFO:
		xpm_data = information_xpm;
		break;
	case ICO_ERROR:
		xpm_data = critical_xpm;
		break;
	case ICO_RLPLOT:
		xpm_data = RLPlot_xpm;
		break;
	case ICO_QT:
		xpm_data = qtlogo_xpm;
		break;
	default:
		return false;
		}
	if (xpm_data) {
		QImage image((const char **)xpm_data);
		pm.convertFromImage(image);
		bitBlt(mempic, x, y, &pm, 0, 0,	-1, -1, Qt::CopyROP);
		return true;
		}
	return false;
}

bool
BitMapQT::oCircle(int x1, int y1, int x2, int y2, char* nam)
{
	qPainter.drawEllipse(x1, y1, x2-x1, y2-y1);
	if(hgo) return hgo->oCircle(x1, y1, x2, y2);
	return true;
}

bool
BitMapQT::oPolyline(POINT * pts, int cp, char *nam)
{
	int i;

	if(cp < 1) return false;
	if (dPattern) {
		for (i = 1; i < cp; i++) PatLine(pts[i-1], pts[i]);
		}
	else {
		qPainter.moveTo(pts[0].x, pts[0].y);
		for (i = 1; i < cp; i++) qPainter.lineTo(pts[i].x, pts[i].y);
		}
	return true;
}

bool
BitMapQT::oRectangle(int x1, int y1, int x2, int y2, char *nam)
{
	qPainter.drawRect(x1, y1, x2-x1, y2-y1);
	if(hgo) hgo->oRectangle(x1, y1, x2, y2, 0L);
	return true;
}

bool
BitMapQT::oSolidLine(POINT *p)
{
	qPainter.drawLine(p[0].x, p[0].y, p[1].x, p[1].y);
	return true;
}

bool
BitMapQT::oTextOut(int x, int y, char *txt, int cb)
{
	return com_TextOut(x, y, txt, &TxtSet, &qPainter, this);
}

bool
BitMapQT::oPolygon(POINT *pts, int cp, char *nam)
{
	int i;

	QPointArray *a;

	if(!pts || cp <2) return false;
	a = new QPointArray(cp);
	if (a) {
		for(i = 0; i < cp; i++) a->setPoint(i, pts[i].x, pts[i].y);
		qPainter.drawPolygon(*a);
		delete a;
		}
	if(hgo) hgo->oPolygon(pts, cp);
}

bool
BitMapQT::oArc(int x1, int y1, int x2, int y2, int quads)
{
	int i, j;

	if(x1 > x2) Swap(x1, x2);	if(y1 > y2) Swap(y1, y2);
	switch(quads) {
	case 1:	i = 270*16;		j = 90*16;	break;
	case 2:	i = 180*16;		j = 180*16;	break;
	case 3:	i = 90*16;		j = 270*16;	break;
	case 4:	i = 0;			j = 360*16;	break;
	default: return false;
		}
	qPainter.drawArc(x1, y1, x2-x1, y2-y1, i, j);
	return true;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The display output class
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OutputQT::OutputQT(GraphObj *g):BitMapQT(g, 0L)
{
	int w, h;
	RLPwidget *rw;

	HScroll = VScroll = 0L;
	CreateNewWindow(BaseObj = g);
	if(rw = (RLPwidget*)widget) {
		rw->move(CurrWidgetPos.x+50, CurrWidgetPos.y+50);
		rw->show();
		rw->mempic = mempic;
		rw->setBackgroundMode(QWidget::NoBackground);
		}
}

OutputQT::OutputQT(DlgWidget *wi):BitMapQT(0L, wi)
{
	//assume fixed size (dialog) widget
	widget = wi;
	HScroll = VScroll = 0L;
	BaseObj = 0L;
	wi->OutputClass = this;
	wi->mempic = mempic;
	wi->setBackgroundMode(QWidget::NoBackground);
	xAxis.flags = 0L;
	yAxis.flags = AXIS_INVERT;	//drawing origin upper left corner
}

OutputQT::~OutputQT()
{
	if(BaseObj) {
		BaseObj->Command(CMD_CAN_DELETE, 0L, 0L);
		}
	if(qPainter.isActive()) qPainter.end();
	if(widget)	delete widget;	widget = 0L;
	HideTextCursorObj(this);
	if(mempic) delete mempic;	mempic = 0L;
	if(hgo) delete hgo;			hgo = 0L;
	if(image) delete image;		image = 0L;
}

bool
OutputQT::ActualSize(RECT *rc)
{
	if(rc) {
		rc->left = rc->top = 0;
		rc->bottom = widget->height() - MenuHeight-6;
		rc->right = widget->width();
		return true;
		}
	return false;
}

void
OutputQT::Caption(char *txt)
{
	QString cap(txt);
	widget->setCaption(cap);
}

unsigned char hand_bits[] =	{	//hand cursor bitmap
	0x80, 0x01, 0x58, 0x0e, 0x64, 0x12, 0x64, 0x52,
	0x48, 0xb2, 0x48, 0x92, 0x16, 0x90, 0x19, 0x80,
	0x11, 0x40, 0x02, 0x40, 0x02, 0x40, 0x04, 0x20,
	0x08, 0x20, 0x10, 0x10, 0x20, 0x10, 0x20, 0x10};

unsigned char hand_mask[] =	{	//hand cursor mask
	0x80, 0x01, 0xd8, 0x0f, 0xfc, 0x1f, 0xfc, 0x5f,
	0xf8, 0xbf, 0xf8, 0xff, 0xfe, 0xff, 0xff, 0xff,
	0xff, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f,
	0xf8, 0x3f, 0xf0, 0x1f, 0xe0, 0x1f, 0xe0, 0x1f};

unsigned char zoom_bits[] =	{	//zoom cursor bitmap
	0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x60, 0x0a,
	0x10, 0x10, 0x08, 0x21, 0x08, 0x21, 0x04, 0x40,
	0x64, 0x4c, 0x04, 0x40, 0x08, 0x21, 0x08, 0x21,
	0x10, 0x10, 0x60, 0x0a, 0x80, 0x03, 0x00, 0x00};

unsigned char zoom_mask[] =	{	//zoom cursor mask
	0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0xe0, 0x0f,
	0xf0, 0x1f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf4, 0x7e,
	0x7c, 0x7c, 0xfc, 0x7e, 0xf8, 0x3f, 0xf8, 0x3f,
	0xf0, 0x1f, 0xe0, 0x0f, 0x80, 0x03, 0x00, 0x00};

void
OutputQT::MouseCursor(int cid, bool force)
{
	if(cid == cCursor && !force) return;
	if(cid == MC_LAST) cid = cCursor;
	QBitmap cb(16, 16, hand_bits, TRUE);	QBitmap cm(16, 16, hand_mask, TRUE);
	QBitmap zb(16, 16, zoom_bits, TRUE);	QBitmap zm(16, 16, zoom_mask, TRUE);
	switch(cid) {
#ifdef Q_CHECK_PTR				//Qt version 3
	case MC_ARROW:	widget->setCursor(QCursor(Qt::ArrowCursor));	break;
	case MC_CROSS:	widget->setCursor(QCursor(Qt::CrossCursor));	break;
	case MC_WAIT:	widget->setCursor(QCursor(Qt::WaitCursor));		break;
	case MC_TEXT:	widget->setCursor(QCursor(Qt::IbeamCursor));	break;
	case MC_NORTH:	widget->setCursor(QCursor(Qt::SizeVerCursor));	break;
	case MC_NE:		widget->setCursor(QCursor(Qt::SizeBDiagCursor));break;
	case MC_EAST:	widget->setCursor(QCursor(Qt::SizeHorCursor));	break;
	case MC_SE:		widget->setCursor(QCursor(Qt::SizeFDiagCursor));break;
	case MC_SALL:	widget->setCursor(QCursor(Qt::SizeAllCursor));	break;
#else							//Qt version 2
	case MC_ARROW:	widget->setCursor(QCursor(ArrowCursor));	break;
	case MC_CROSS:	widget->setCursor(QCursor(CrossCursor));	break;
	case MC_WAIT:	widget->setCursor(QCursor(WaitCursor));		break;
	case MC_TEXT:	widget->setCursor(QCursor(IbeamCursor));	break;
	case MC_NORTH:	widget->setCursor(QCursor(SizeVerCursor));	break;
	case MC_NE:		widget->setCursor(QCursor(SizeBDiagCursor));break;
	case MC_EAST:	widget->setCursor(QCursor(SizeHorCursor));	break;
	case MC_SE:		widget->setCursor(QCursor(SizeFDiagCursor));break;
	case MC_SALL:	widget->setCursor(QCursor(SizeAllCursor));	break;
#endif
	case MC_MOVE:
		widget->setCursor(QCursor(cb, cm));
		break;
	case MC_ZOOM:
		widget->setCursor(QCursor(zb, zm));
		break;
	default:	return;
		}
	cCursor = cid;
}

bool
OutputQT::SetScroll(bool isVert, int iMin, int iMax, int iPSize, int iPos)
{
	QScrollBar *sb;

	if(isVert) {
		if(!(sb = VScroll))return false;
		}
	else if(!(sb = HScroll)) return false;
	if(iPos < sb->minValue()) return false;
	sb->setRange(iMin, iMax);
	sb->setPageStep(iPSize);
	if(BaseObj && BaseObj->Id == GO_GRAPH) sb->setLineStep(8);
	else sb->setLineStep(1);
	sb->setValue(iPos);
	return true;
}

bool
OutputQT::EndPage()
{
	if(widget)widget->repaint();
	return true;
}

bool
OutputQT::UpdateRect(RECT *rc, bool invert)
{
	int x1, x2, y1, y2;

	if(!widget || !mempic)return false;
	if(rc->right > rc->left) {
		x1 = rc->left;		x2 = rc->right;
		}
	else {
		x1 = rc->right;		x2 = rc->left;
		}
	if(rc->bottom > rc->top) {
		y1 = rc->top;		y2 = rc->bottom;
		}
	else {
		y1 = rc->bottom;	y2 = rc->top;
		}
	if(x2 > DeskRect.right) x2 = DeskRect.right;
	if(y2 > DeskRect.bottom) y2 = DeskRect.right;
	bitBlt(widget, x1, y1, mempic, x1, y1,
		x2 - x1, y2 - y1, invert ? Qt::NotCopyROP : Qt::CopyROP);
	return true;
}

void
OutputQT::ShowBitmap(int x, int y, anyOutput* src)
{
	BitMapQT *sr;
	RECT *rc;

	if(!widget || !mempic || !src)return;
	sr = (BitMapQT*) src;		rc = &sr->DeskRect;
	bitBlt(widget, x, y, sr->mempic, 0, 0, abs(rc->right-rc->left), 
		abs(rc->bottom-rc->top), Qt::CopyROP);
}

void
OutputQT::ShowLine(POINT * pts, int cp, DWORD color)
{
	int i;
	QPen qp;
	QPainter paint(widget);

	qp.setColor(SwapRB(color));
	qp.setWidth(1);
	qp.setStyle(Qt::SolidLine);
	paint.setPen(qp);
	paint.moveTo(pts[0].x, pts[0].y);
	for (i = 1; i < cp; i++) paint.lineTo(pts[i].x, pts[i].y);
	paint.flush();
}

void
OutputQT::ShowEllipse(POINT p1, POINT p2, DWORD color)
{
	int i;
	QPen qp;
	QPainter paint(widget);

	qp.setColor(SwapRB(color));
	qp.setWidth(1);
	qp.setStyle(Qt::SolidLine);
	paint.setPen(qp);
	paint.drawArc(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y, 0, 5760);
	paint.flush();
}

bool
OutputQT::SetMenu(int type)
{
	if(type == MENU_SPREAD){
		QPopupMenu *file = new QPopupMenu(widget);
		file->insertItem("&Open", widget, SLOT(cmOpen()));
		file->insertItem("Save &as", widget, SLOT(cmSaveDataAs()));
		file->insertSeparator();
		file->insertItem("&Print", widget, SLOT(cmPrint()));
		file->insertSeparator();
		file->insertItem("E&xit", widget, SLOT(cmExit()));
		file->insertSeparator();
		file->insertItem("n.a.", widget, SLOT(cmFile1()), 0, CM_FILE1);
		file->insertItem("n.a.", widget, SLOT(cmFile2()), 0, CM_FILE2);
		file->insertItem("n.a.", widget, SLOT(cmFile3()), 0, CM_FILE3);
		file->insertItem("n.a.", widget, SLOT(cmFile4()), 0, CM_FILE4);
		file->insertItem("n.a.", widget, SLOT(cmFile5()), 0, CM_FILE5);
		file->insertItem("n.a.", widget, SLOT(cmFile6()), 0, CM_FILE6);

		QPopupMenu *insert = new QPopupMenu(widget);
		insert->insertItem("&Rows", widget, SLOT(cmInsRow()));
		insert->insertItem("&Columns", widget, SLOT(cmInsCol()));

		QPopupMenu *Delete = new QPopupMenu(widget);
		Delete->insertItem("&Rows", widget, SLOT(cmDelRow()));
		Delete->insertItem("&Columns", widget, SLOT(cmDelCol()));

		QPopupMenu *edit = new QPopupMenu(widget);
		edit->insertItem("&Undo", widget, SLOT(cmUndo()), Qt::CTRL + Qt::Key_Z);
		edit->insertSeparator();
		edit->insertItem("&Rows/Cols", widget, SLOT(cmAddRowCol()));
		edit->insertItem("&Insert", insert);
		edit->insertItem("&Delete", Delete);
		edit->insertSeparator();
		edit->insertItem("&Copy", widget, SLOT(cmCopy()), Qt::CTRL + Qt::Key_C);
		edit->insertItem("C&ut", widget, SLOT(cmCut()), Qt::CTRL + Qt::Key_X);
		edit->insertItem("&Paste", widget, SLOT(cmPaste()), Qt::CTRL + Qt::Key_V);
		edit->insertSeparator();
		edit->insertItem("&Fill Range", widget, SLOT(cmFillRange()));

		QPopupMenu *graph = new QPopupMenu(widget);
		graph->insertItem("Create &Graph", widget, SLOT(cmNewGraph()));
		graph->insertItem("Create &Page", widget, SLOT(cmNewPage()));
		graph->insertItem("&Flush Graph(s)", widget, SLOT(cmDelGraph()));
		graph->insertSeparator();
		graph->insertItem("&Settings", widget, SLOT(cmDefaults()));

		QPopupMenu *about = new QPopupMenu(widget);
		about->insertItem("&About ...", widget, SLOT(cmAbout()));

		menu = new QMenuBar(widget);
		menu->insertItem("&File", file);			menu->insertItem("&Edit", edit);
		menu->insertItem("&Graph", graph);			menu->insertItem("&?", about);
#ifdef Q_CHECK_PTR				//Qt version 3, n.a. in version 2
		menu->setItemVisible(CM_FILE1, false);		menu->setItemVisible(CM_FILE2, false);
		menu->setItemVisible(CM_FILE3, false);		menu->setItemVisible(CM_FILE4, false);
		menu->setItemVisible(CM_FILE5, false);		menu->setItemVisible(CM_FILE6, false);
#endif
		}
	else if(type == MENU_GRAPH) {
		QPopupMenu *file = new QPopupMenu(widget);
		file->insertItem("&Open", widget, SLOT(cmOpen()));
		file->insertItem("Save &as", widget, SLOT(cmSaveGraphAs()));
		file->insertItem("&Copy", widget, SLOT(cmCopyGraph()));
		file->insertSeparator();
		file->insertItem("&Print", widget, SLOT(cmPrint()));
		file->insertItem("&Export", widget, SLOT(cmExport()));
		file->insertSeparator();
		file->insertItem(widget == MainWidget ? "E&xit" : "&Close", widget, SLOT(cmExit()));

		QPopupMenu *edit = new QPopupMenu(widget);
		edit->insertItem("&Undo", widget, SLOT(cmUndo()), Qt::CTRL + Qt::Key_Z);
		edit->insertSeparator();
		edit->insertItem("&Copy", widget, SLOT(cmCopyGraph()), Qt::CTRL + Qt::Key_C);
		edit->insertItem("&Paste", widget, SLOT(cmPaste()), Qt::CTRL + Qt::Key_V);
		edit->insertSeparator();
		edit->insertItem("&UpdateValues", widget, SLOT(cmUpdate()));
		edit->insertSeparator();
		edit->insertItem("&Delete Object", widget, SLOT(cmDelObj()));

		QPopupMenu *zoom = new QPopupMenu(widget);
		zoom->insertTearOffHandle();
		zoom->insertItem("zoom &in", widget, SLOT(cmZoomIn()), Qt::CTRL + Qt::Key_Plus);
		zoom->insertItem("zoom &out", widget, SLOT(cmZoomOut()), Qt::CTRL + Qt::Key_Minus);
		zoom->insertItem("&fit to widget", widget, SLOT(cmZoomFit()), Qt::CTRL + Qt::Key_F);
		zoom->insertSeparator();
		zoom->insertItem("25%", widget, SLOT(cmZoom25()));
		zoom->insertItem("50%", widget, SLOT(cmZoom50()));
		zoom->insertItem("100%", widget, SLOT(cmZoom100()));
		zoom->insertItem("200%", widget, SLOT(cmZoom200()));
		zoom->insertItem("400%", widget, SLOT(cmZoom400()));

		QPopupMenu *displ = new QPopupMenu(widget);
		displ->insertItem("&Redraw", widget, SLOT(cmRedraw()));
		displ->insertItem("&Zoom", zoom);
		displ->insertItem("&Layers", widget, SLOT(cmLayers()));

		QPopupMenu *tools = new QPopupMenu(widget);
		tools->insertTearOffHandle();
		tools->insertItem("&Standard", widget, SLOT(cmtStandard()), Qt::Key_Escape, CM_T_STANDARD);
		tools->insertSeparator();
		tools->insertItem("&Draw", widget, SLOT(cmtDraw()), 0, CM_T_DRAW);
		tools->insertItem("Poly&line", widget, SLOT(cmtPolyline()), 0, CM_T_POLYLINE);
		tools->insertItem("Poly&gon", widget, SLOT(cmtPolygon()), 0, CM_T_POLYGON);
		tools->insertItem("&Rectangle", widget, SLOT(cmtRectangle()), 0, CM_T_RECTANGLE);
		tools->insertItem("&r&ound Rect.", widget, SLOT(cmtRoundrect()), 0, CM_T_ROUNDREC);
		tools->insertItem("&Ellipse", widget, SLOT(cmtEllipse()), 0, CM_T_ELLIPSE);
		tools->insertItem("&Arrow", widget, SLOT(cmtArrow()), 0, CM_T_ARROW);
		tools->insertItem("&Text", widget, SLOT(cmtText()), 0, CM_T_TEXT);
		tools->setCheckable(true);

		QPopupMenu *plots = new QPopupMenu(widget);
		plots->insertItem("Add &Plot", widget, SLOT(cmAddPlot()));
		plots->insertItem("Add &Axis", widget, SLOT(cmAddAxis()));
		plots->insertItem("Add &Legend", widget, SLOT(cmAddLegend()));
		plots->insertSeparator();
		plots->insertItem("&Configure", widget, SLOT(cmDefaults()));

		QPopupMenu *about = new QPopupMenu(widget);
		about->insertItem("&About ...", widget, SLOT(cmAbout()));

		menu = new QMenuBar(widget);
		menu->insertItem("&File", file);
		menu->insertItem("&Edit", edit);
		menu->insertItem("&Display", displ);
		menu->insertItem("&Tools", tools);
		menu->insertItem("&Plots", plots);
		menu->insertItem("&?", about);
		}
	else if(type == MENU_PAGE) {
		QPopupMenu *file = new QPopupMenu(widget);
		file->insertItem("&Open", widget, SLOT(cmOpen()));
		file->insertItem("Save &as", widget, SLOT(cmSaveGraphAs()));
		file->insertSeparator();
		file->insertItem("&Print", widget, SLOT(cmPrint()));
		file->insertItem("&Export", widget, SLOT(cmExport()));
		file->insertSeparator();
		file->insertItem(widget == MainWidget ? "E&xit" : "&Close", widget, SLOT(cmExit()));

		QPopupMenu *edit = new QPopupMenu(widget);
		edit->insertItem("&Undo", widget, SLOT(cmUndo()), Qt::CTRL + Qt::Key_Z);
		edit->insertSeparator();
		edit->insertItem("&Copy", widget, SLOT(cmCopyGraph()), Qt::CTRL + Qt::Key_C);
		edit->insertItem("&Paste", widget, SLOT(cmPaste()), Qt::CTRL + Qt::Key_V);
		edit->insertSeparator();
		edit->insertItem("&UpdateValues", widget, SLOT(cmUpdate()));
		edit->insertSeparator();
		edit->insertItem("&Delete Object", widget, SLOT(cmDelObj()));

		QPopupMenu *zoom = new QPopupMenu(widget);
		zoom->insertTearOffHandle();
		zoom->insertItem("zoom &in", widget, SLOT(cmZoomIn()), Qt::CTRL + Qt::Key_Plus);
		zoom->insertItem("zoom &out", widget, SLOT(cmZoomOut()), Qt::CTRL + Qt::Key_Minus);
		zoom->insertItem("&fit to widget", widget, SLOT(cmZoomFit()), Qt::CTRL + Qt::Key_F);
		zoom->insertSeparator();
		zoom->insertItem("25%", widget, SLOT(cmZoom25()));
		zoom->insertItem("50%", widget, SLOT(cmZoom50()));
		zoom->insertItem("100%", widget, SLOT(cmZoom100()));
		zoom->insertItem("200%", widget, SLOT(cmZoom200()));
		zoom->insertItem("400%", widget, SLOT(cmZoom400()));

		QPopupMenu *displ = new QPopupMenu(widget);
		displ->insertItem("&Redraw", widget, SLOT(cmRedraw()));
		displ->insertItem("&Zoom", zoom);
		displ->insertItem("&Layers", widget, SLOT(cmLayers()));

		QPopupMenu *tools = new QPopupMenu(widget);
		tools->insertTearOffHandle();
		tools->insertItem("&Standard", widget, SLOT(cmtStandard()), Qt::Key_Escape, CM_T_STANDARD);
		tools->insertSeparator();
		tools->insertItem("&Draw", widget, SLOT(cmtDraw()), 0, CM_T_DRAW);
		tools->insertItem("Poly&line", widget, SLOT(cmtPolyline()), 0, CM_T_POLYLINE);
		tools->insertItem("Poly&gon", widget, SLOT(cmtPolygon()), 0, CM_T_POLYGON);
		tools->insertItem("&Rectangle", widget, SLOT(cmtRectangle()), 0, CM_T_RECTANGLE);
		tools->insertItem("&r&ound Rect.", widget, SLOT(cmtRoundrect()), 0, CM_T_ROUNDREC);
		tools->insertItem("&Ellipse", widget, SLOT(cmtEllipse()), 0, CM_T_ELLIPSE);
		tools->insertItem("&Arrow", widget, SLOT(cmtArrow()), 0, CM_T_ARROW);
		tools->insertItem("&Text", widget, SLOT(cmtText()), 0, CM_T_TEXT);
		tools->setCheckable(true);

		QPopupMenu *plots = new QPopupMenu(widget);
		plots->insertItem("Add &Graph", widget, SLOT(cmNewGraph()));
		plots->insertItem("Add &Plot", widget, SLOT(cmAddPlot()));
		plots->insertItem("Add &Axis", widget, SLOT(cmAddAxis()));
		plots->insertItem("Add &Legend", widget, SLOT(cmAddLegend()));
		plots->insertSeparator();
		plots->insertItem("Page &Settings", widget, SLOT(cmDefaults()));

		QPopupMenu *about = new QPopupMenu(widget);
		about->insertItem("&About ...", widget, SLOT(cmAbout()));

		menu = new QMenuBar(widget);
		menu->insertItem("&File", file);
		menu->insertItem("&Edit", edit);
		menu->insertItem("&Display", displ);
		menu->insertItem("&Tools", tools);
		menu->insertItem("&Plots", plots);
		menu->insertItem("&?", about);
		}
	else return false;
	menu->show();
	MenuHeight = menu->height();
	widget->resize(widget->width()+8, widget->height()+8);
	return true;
}

void
OutputQT::CheckMenu(int mid, bool check)
{
	if(mid < CM_T_STANDARD) switch(mid){					//tool mode identifier
	case TM_STANDARD:	mid = CM_T_STANDARD;	break;
	case TM_DRAW:		mid = CM_T_DRAW;		break;
	case TM_POLYLINE:	mid = CM_T_POLYLINE;	break;
	case TM_POLYGON:	mid = CM_T_POLYGON;		break;
	case TM_RECTANGLE:	mid = CM_T_RECTANGLE;	break;
	case TM_ROUNDREC:	mid = CM_T_ROUNDREC;	break;
	case TM_ELLIPSE:	mid = CM_T_ELLIPSE;		break;
	case TM_ARROW:		mid = CM_T_ARROW;		break;
	case TM_TEXT:		mid = CM_T_TEXT;		break;
	default:	return;
		}
	if(menu) menu->setItemChecked(mid, check);
}

void
OutputQT::FileHistory()
{
	char **history[] = {&defs.File1, &defs.File2, &defs.File3, &defs.File4, &defs.File5, &defs.File6};
	int i, j, k;

	if(!hasHistMenu || !defs.File1 || !menu) return;
    for(i = 0; i < 6 && *history[i]; i++) {
		k = strlen(*history[i]);
		for (j = 0; j < k && defs.currPath[j] == (*history[i])[j]; j++);
		if((*history[i])[j] == '\\' || (*history[i])[j] == '/') j++;
		menu->changeItem(CM_FILE1+i, *history[i]+j);
#ifdef Q_CHECK_PTR				//Qt version 3, n.a. in version 2
		menu->setItemVisible(CM_FILE1+i, true);
#endif
		}
	HistMenuSize = i;
}

void
OutputQT::CreateNewWindow(GraphObj *g)
{
	int w, h;

	GetDesktopSize(&w, &h);
	if(widget = new RLPwidget(0, 0, this, g)) {
		widget->setCaption("OutputQT::CreateNewWindow");
		widget->setGeometry(0, 0, (int)(w*.7f), (int)(h*.7f));
		HScroll = ((RLPwidget*)widget)->HScroll;
		VScroll = ((RLPwidget*)widget)->VScroll;
		}
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Common widget support
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RLPwidget::RLPwidget(QWidget *par, const char *name, anyOutput *o, GraphObj *g)
	: QWidget(par, name)
{
	int w, h;

	GetDesktopSize(&w, &h);
	mempic = new QPixmap(w, h);
	parent = par;
	OutputClass = o;
	BaseObj = g;
	setMinimumSize(100, 80);
	setBackgroundMode(NoBackground);
	HScroll = new QScrollBar(QScrollBar::Horizontal, this, 0);
	HScroll->setRange(0, 1000);
	HScroll->setSteps(1, 16);
	connect(HScroll, SIGNAL(valueChanged(int)), SLOT(hScrollEvent(int)));
	VScroll = new QScrollBar(QScrollBar::Vertical, this, 0);
	VScroll->setRange(0, 1000);
	VScroll->setSteps(1, 16);
	connect(VScroll, SIGNAL(valueChanged(int)), SLOT(vScrollEvent(int)));
	if(!MainWidget) QAppl->setMainWidget(MainWidget = this);
	setMouseTracking(true);
	setFocusPolicy(StrongFocus);
}

RLPwidget::~RLPwidget()
{
	if(OutputClass)((OutputQT*)OutputClass)->widget = 0L;
	OutputClass = 0L;
	if(BaseObj){
		BaseObj->Command(CMD_CAN_DELETE, 0L, 0L);
		BaseObj = 0L;
		}
}

//public slots: menu items, events
void
RLPwidget::hScrollEvent(int pos)
{
	if(BaseObj){
		BaseObj->Command(CMD_SETHPOS, (void*)(&pos), OutputClass);
		repaint();
		}
}

void
RLPwidget::vScrollEvent(int pos)
{
	if(BaseObj){
		BaseObj->Command(CMD_SETVPOS, (void*)(&pos), OutputClass);
		repaint();
		}
}


void
RLPwidget::cmOpen()
{
	if(BaseObj)BaseObj->Command(CMD_OPEN, (void *)NULL, OutputClass);
}

void
RLPwidget::cmSaveDataAs()
{
	if(BaseObj)BaseObj->Command(CMD_SAVEDATAAS, (void *)NULL, OutputClass);
}

void
RLPwidget::cmExit()
{
	if(BaseObj) {
		if(BaseObj->Command(CMD_CAN_CLOSE, 0L, 0L)){
			BaseObj = 0L;
			delete this;
			}
		}
	else delete(this);
}

void
RLPwidget::cmNewGraph()
{
	if(BaseObj)BaseObj->Command(CMD_NEWGRAPH, (void *)NULL, OutputClass);
}

void
RLPwidget::cmNewPage()
{
	if(BaseObj)BaseObj->Command(CMD_NEWPAGE, (void *)NULL, OutputClass);
}

void
RLPwidget::cmDelGraph()
{
	if(BaseObj)BaseObj->Command(CMD_DELGRAPH, (void *)NULL, OutputClass);
}

void
RLPwidget::cmAddPlot()
{
	if(BaseObj)BaseObj->Command(CMD_ADDPLOT, (void *)NULL, OutputClass);
}

void
RLPwidget::cmAddLegend()
{
	if(BaseObj)BaseObj->Command(CMD_LEGEND, (void *)NULL, OutputClass);
}

void
RLPwidget::cmLayers()
{
	if(BaseObj)BaseObj->Command(CMD_LAYERS, (void *)NULL, OutputClass);
}

void
RLPwidget::cmAbout()
{
	RLPlotInfo();
}

void
RLPwidget::cmAddRowCol()
{
	if(BaseObj)BaseObj->Command(CMD_ADDROWCOL, (void *)NULL, OutputClass);
}

void
RLPwidget::cmCopy()
{
	if(BaseObj && BaseObj->Id == GO_SPREADDATA) {
		if(BaseObj->Command(CMD_QUERY_COPY, 0L, OutputClass))
			CopyData(BaseObj);
		}
}

void
RLPwidget::cmCut()
{
	if(BaseObj && BaseObj->Id == GO_SPREADDATA) {
		BaseObj->Command(CMD_CUT, 0L, OutputClass);
		CopyData(BaseObj);
		}
}

void
RLPwidget::cmPaste()
{
	if(BaseObj) {
		OutputClass->MouseCursor(MC_WAIT, true);
		TestClipboard(BaseObj);
		OutputClass->MouseCursor(MC_ARROW, true);
		}
}

void
RLPwidget::cmCopyGraph()
{
	if(BaseObj) CopyGraph(BaseObj);
}

void
RLPwidget::cmSaveGraphAs()
{
	SaveGraphAs(BaseObj);
}

void
RLPwidget::cmRedraw()
{
	if(OutputClass && BaseObj && OutputClass->Erase(defs.Color(COL_BG))) {
		BaseObj->Command(CMD_SETSCROLL, 0L, OutputClass);
		repaint();
		}
}

void
RLPwidget::cmZoom25()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"25"), OutputClass);
}

void
RLPwidget::cmZoom50()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"50"), OutputClass);
}

void
RLPwidget::cmZoom100()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"100"), OutputClass);
}

void
RLPwidget::cmZoom200()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"200"), OutputClass);
}

void
RLPwidget::cmZoom400()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"400"), OutputClass);
}

void
RLPwidget::cmZoomIn()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"+"), OutputClass);
}

void
RLPwidget::cmZoomOut()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"-"), OutputClass);
}

void
RLPwidget::cmZoomFit()
{
	BaseObj->Command(CMD_ZOOM, (void*)(&"fit"), OutputClass);
}

void
RLPwidget::cmPrint()
{
	int m;
	PrintQT out(0L, 0L);

	if(!BaseObj) return;
	if(BaseObj->Id == GO_SPREADDATA) {
		m = iround(out.hres/60.0);
#ifdef Q_CHECK_PTR				//Qt version 3, n.a. in version 2
		out.printer->setMargins(m, m, m, m);
#endif
		BaseObj->Command(CMD_PRINT, 0L, &out);
		}
	else if(out.StartPage()){
		BaseObj->DoPlot(&out);
		out.EndPage();
		}
	BaseObj->DoPlot(OutputClass);
}

void
RLPwidget::cmExport()
{
	OpenExportName(BaseObj, "hello.svg");
	BaseObj->DoPlot(0L);
}

void
RLPwidget::cmDelObj()
{
	if(CurrGO && CurrGO->parent && CurrGO->parent->
		Command(CMD_DELOBJ, (void*)CurrGO, OutputClass)) {
		CurrGO = 0L;
		OutputClass->Erase(defs.Color(COL_BG));
		BaseObj->DoPlot(OutputClass);
		}
	else if(!CurrGO) InfoBox("No object selected!");
}

void
RLPwidget::cmUpdate()
{
	if(BaseObj) BaseObj->Command(CMD_UPDATE, 0L, OutputClass);
}

void
RLPwidget::cmDefaults()
{
	BaseObj->Command(CMD_CONFIG, 0L, OutputClass);
}

void
RLPwidget::cmAddAxis()
{
	BaseObj->Command(CMD_ADDAXIS, 0L, OutputClass);
}

void
RLPwidget::cmUndo()
{
	BaseObj->Command(CMD_UNDO, 0L, OutputClass);
}

void
RLPwidget::cmFillRange()
{
	BaseObj->Command(CMD_FILLRANGE, 0L, OutputClass);
}

void
RLPwidget::cmInsRow()
{
	BaseObj->Command(CMD_INSROW, 0L, OutputClass);
}

void
RLPwidget::cmInsCol()
{
	BaseObj->Command(CMD_INSCOL, 0L, OutputClass);
}

void
RLPwidget::cmDelRow()
{
	BaseObj->Command(CMD_DELROW, 0L, OutputClass);
}

void
RLPwidget::cmDelCol()
{
	BaseObj->Command(CMD_DELCOL, 0L, OutputClass);
}

void ToolMenu(GraphObj *b, anyOutput *o, int tm)
{
	if(b && o) b->Command(CMD_TOOLMODE, (void*)(& tm), o);
}

void
RLPwidget::cmtStandard()
{
	ToolMenu(BaseObj, OutputClass, TM_STANDARD);
}

void
RLPwidget::cmtDraw()
{
	ToolMenu(BaseObj, OutputClass, TM_DRAW);
}

void
RLPwidget::cmtPolyline()
{
	ToolMenu(BaseObj, OutputClass, TM_POLYLINE);
}

void
RLPwidget::cmtPolygon()
{
	ToolMenu(BaseObj, OutputClass, TM_POLYGON);
}

void
RLPwidget::cmtRectangle()
{
	ToolMenu(BaseObj, OutputClass, TM_RECTANGLE);
}

void
RLPwidget::cmtRoundrect()
{
	ToolMenu(BaseObj, OutputClass, TM_ROUNDREC);
}

void
RLPwidget::cmtEllipse()
{
	ToolMenu(BaseObj, OutputClass, TM_ELLIPSE);
}

void
RLPwidget::cmtArrow()
{
	ToolMenu(BaseObj, OutputClass, TM_ARROW);
}

void
RLPwidget::cmtText()
{
	ToolMenu(BaseObj, OutputClass, TM_TEXT);
}

//protected: widget events
void
RLPwidget::paintEvent(QPaintEvent *range)
{
	QRect rc;

	rc = range->rect();
	bitBlt(this, rc.left(), rc.top(), this->mempic, rc.left(), rc.top(),
		1+rc.right()-rc.left(), 1+rc.bottom()-rc.top());
}

void
RLPwidget::resizeEvent(QResizeEvent *)
{
	HScroll->resize(width() -16, 16);
	HScroll->move(0, height()-16);
	VScroll->resize(16, height()-OutputClass->MenuHeight-16);
	VScroll->move(width()-16, OutputClass->MenuHeight);
	if(BaseObj) BaseObj->Command(CMD_SETSCROLL, 0L, OutputClass);
}

void
RLPwidget::closeEvent(QCloseEvent *e)
{
	if(BaseObj){
		if(BaseObj->Command(CMD_CAN_CLOSE, 0L, 0L)) {
			if(OutputClass)((OutputQT*)OutputClass)->widget = 0L;
			OutputClass = 0L;
			BaseObj = 0L;
			e->accept();
			}
		}
	else e->accept();
}

void
RLPwidget::mouseDoubleClickEvent(QMouseEvent *e)
{
	MouseEvent mev = {1, e->button() == Qt::LeftButton?MOUSE_LBDOUBLECLICK:-1,e->x(),e->y()};

	if (BaseObj)BaseObj->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
RLPwidget::mousePressEvent(QMouseEvent *e)
{
	int i;
	MouseEvent mev = {1, e->button() == Qt::LeftButton ? MOUSE_LBDOWN : -1, e->x(), e->y()};

	HideTextCursor();
	i = e->state();
	if(i & Qt::ShiftButton) mev.StateFlags |= 0x08;
	if(i & Qt::ControlButton) mev.StateFlags |= 0x10;
	if (BaseObj)BaseObj->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
RLPwidget::mouseReleaseEvent(QMouseEvent *e)
{
	int i;
	MouseEvent mev = {0, e->button() == Qt::LeftButton ? MOUSE_LBUP :
		e->button() == Qt::RightButton ? MOUSE_RBUP : -1, e->x(), e->y()};

	i = e->state();
	if(i & Qt::ShiftButton) mev.StateFlags |= 0x08;
	if(i & Qt::ControlButton) mev.StateFlags |= 0x10;
	if (BaseObj) BaseObj->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
RLPwidget::mouseMoveEvent(QMouseEvent *e)
{
	int i;
	MouseEvent mev = {0, MOUSE_MOVE, e->x(), e->y()};

	i = e->state();
	if(i & Qt::LeftButton) mev.StateFlags |= 0x01;
	if(i & Qt::ShiftButton) mev.StateFlags |= 0x08;
	if(i & Qt::ControlButton) mev.StateFlags |= 0x10;
	if (BaseObj) BaseObj->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
RLPwidget::keyPressEvent(QKeyEvent *e)
{
	int i, c;

	if(BaseObj) switch(c = e->key()) {
		case Key_Prior:
			i = e->state();
			if(i & Qt::ShiftButton) BaseObj->Command(CMD_SHPGUP, 0L, OutputClass);
			else BaseObj->Command(CMD_PAGEUP, 0L, OutputClass);
			break;
		case Key_Next:
			i = e->state();
			if(i & Qt::ShiftButton) BaseObj->Command(CMD_SHPGDOWN, 0L, OutputClass);
			else BaseObj->Command(CMD_PAGEDOWN, 0L, OutputClass);
			break;
		case Key_Left:
			if(e->state() & ShiftButton) BaseObj->Command(CMD_SHIFTLEFT, 0L, OutputClass);
			else BaseObj->Command(CMD_CURRLEFT, 0L, OutputClass);
			break;
		case Key_Right:
			if(e->state() & ShiftButton) BaseObj->Command(CMD_SHIFTRIGHT, 0L, OutputClass);
			else BaseObj->Command(CMD_CURRIGHT, 0L, OutputClass);
			break;
		case Key_Up:
			if(e->state() & ShiftButton) BaseObj->Command(CMD_SHIFTUP, 0L, OutputClass);
			else BaseObj->Command(CMD_CURRUP, 0L, OutputClass);
			break;
		case Key_Down:
			if(e->state() & ShiftButton) BaseObj->Command(CMD_SHIFTDOWN, 0L, OutputClass);
			else BaseObj->Command(CMD_CURRDOWN, 0L, OutputClass);
			break;
		case Key_Delete:
			BaseObj->Command(CMD_DELETE, 0L, OutputClass);
			break;
		case Key_Tab:
			BaseObj->Command(CMD_TAB, 0L, OutputClass);
			break;
		case Key_Backtab:
			BaseObj->Command(CMD_SHTAB, 0L, OutputClass);
			break;
		case Key_Home:
			BaseObj->Command(CMD_POS_FIRST, 0L, OutputClass);
			break;
		case Key_End:
			BaseObj->Command(CMD_POS_LAST, 0L, OutputClass);
			break;
		default:
			c = e->ascii();
			if(c == 3) cmCopy();
			else if(c == 22) cmPaste();
			else if(c == 26) cmUndo();
			else if(c >1 && c < 256)
				BaseObj->Command(CMD_ADDCHAR, (void *)(& c), OutputClass);
			break;
		}
	e->accept();
}

void
RLPwidget::focusInEvent(QFocusEvent *e)
{
	CurrWidgetPos.x = x();			CurrWidgetPos.y = y();
	if(BaseObj) {
		if(BaseObj->Id == GO_GRAPH) CurrGraph = (Graph*)BaseObj;
		}
}

//private functions
void
RLPwidget::openHistoryFile(int idx)
{
	char *name = 0L;

	switch (idx) {
	case 0:			name = defs.File1;			break;
	case 1:			name = defs.File2;			break;
	case 2:			name = defs.File3;			break;
	case 3:			name = defs.File4;			break;
	case 4:			name = defs.File5;			break;
	case 5:			name = defs.File6;			break;
		}
	if(name && FileExist(name)) {
		BaseObj->Command(CMD_DROPFILE, name, OutputClass);
		defs.FileHistory(name);
		OutputClass->FileHistory();
		}
}


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Print and output EPS to file
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class FileEPS:public QPrinter {
public:
	FileEPS(GraphObj *g, anyOutput *o);

protected:
	int metric(int) const;

private:
	GraphObj *go;
	anyOutput *out;
};

FileEPS::FileEPS(GraphObj *g, anyOutput *o)
{
	go = g;
	out = o;
}

int
FileEPS::metric(int m) const
{
	if(go && out)switch (m) {
	case QPaintDeviceMetrics::PdmWidth:
		return out->un2ix(go->GetSize(SIZE_GRECT_RIGHT) - go->GetSize(SIZE_GRECT_LEFT))/10;
	case QPaintDeviceMetrics::PdmHeight:
		return out->un2ix(go->GetSize(SIZE_GRECT_BOTTOM) - go->GetSize(SIZE_GRECT_TOP))/10;
	case QPaintDeviceMetrics::PdmWidthMM:
		return iround((go->GetSize(SIZE_GRECT_RIGHT) - go->GetSize(SIZE_GRECT_LEFT)) *
			Units[defs.cUnits].convert);
	case QPaintDeviceMetrics::PdmHeightMM:
		return iround((go->GetSize(SIZE_GRECT_BOTTOM) - go->GetSize(SIZE_GRECT_TOP)) *
			Units[defs.cUnits].convert);
		}
	return QPrinter::metric(m);
}

PrintQT::PrintQT(GraphObj *g, char *file)
{
	hres = vres = 720.0;
	units = defs.cUnits;
	Box1.Xmin = Box1.Ymin = 0.0;
	Box1.Xmax = Box1.Ymax = 6000;
	DeskRect.left = DeskRect.top = 0;
	DeskRect.right = (long)(hres*6.0);
	DeskRect.bottom = (long)(vres*8.0);
	dxf.setMatrix(0.1, 0.0, 0.0, 0.1, 0.0, 0.0);
	hgo = 0L;
	if(file) fileName = strdup(file);
	else fileName = 0L;
	go = g;
	if(fileName && go) printer = new FileEPS(g, this);
	else printer = new QPrinter;
	bPrinting = false;
}

PrintQT::~PrintQT()
{
	if(printer) delete(printer);
	if(hgo) delete(hgo);
	if(fileName) free(fileName);
}

bool 
PrintQT::ActualSize(RECT *rc)
{
	if(printer) {
		QPaintDeviceMetrics dm(printer);	rc->top = rc->left = 0;
		rc->bottom = dm.height() *10;		rc->right = dm.width() *10;
		return true;
		}
	return false;
}

bool
PrintQT::SetLine(LineDEF *lDef)
{
	int iw;

	if(lDef->width != LineWidth || lDef->width != LineWidth ||
		lDef->pattern != dPattern || lDef->color != dLineCol) {
		LineWidth = lDef->width;
		iw = iround(un2fix(lDef->width));
		dPattern = lDef->pattern;
		RLP.finc = 256.0/un2fix(lDef->patlength*8.0);
		RLP.fp = 0.0;
		if(iLine == iw && dLineCol == lDef->color) return true;
		iLine = iw;
		dLineCol = lDef->color;
		qPen.setColor(SwapRB(dLineCol));
		qPen.setWidth(iw);
		qPen.setStyle(Qt::SolidLine);
		qPen.setCapStyle(Qt::RoundCap);
		qPen.setJoinStyle(Qt::RoundJoin);
		qPainter.setPen(qPen);
		}
	return true;
}

bool
PrintQT::SetFill(FillDEF *fill)
{
	if(!fill) return false;
	if((fill->type & 0xff) != FILL_NONE) {
		if(!hgo) hgo = new HatchOut(this);
		if(hgo) hgo->SetFill(fill);
		}
	else {
		if(hgo) delete hgo;
		hgo = 0L;
		}
	qPainter.setBrush(QColor(SwapRB(fill->color)));
	dFillCol = fill->color;
	dFillCol2 = fill->color2;
	return true;
}

bool
PrintQT::SetTextSpec(TextDEF *set)
{
	return com_SetTextSpec(set, &TxtSet, this, qFont, &qPainter);
}

bool
PrintQT::StartPage()
{
	if(!printer || bPrinting) return false;
	if(fileName) {
		VPorg.fy = -co2fiy(go->GetSize(SIZE_GRECT_TOP));
		VPorg.fx = -co2fix(go->GetSize(SIZE_GRECT_LEFT));
		printer->setOutputFileName(fileName);
		printer->setFullPage(true);
		qPainter.begin(printer);
		qPainter.setWorldMatrix(dxf, FALSE);
		return bPrinting = true;
		}

	if(printer->setup(0)){
		qPainter.begin(printer);
		qPainter.setWorldMatrix(dxf, FALSE);
		return bPrinting = true;
		}
	else return false;
}

bool
PrintQT::EndPage()
{
	qPainter.flush();	qPainter.end();	bPrinting = false;
	return true;
}

bool
PrintQT::Eject()
{
	if(!bPrinting) return false;
	qPainter.flush();	qPainter.end();		qPainter.begin(printer);
	qPainter.setWorldMatrix(dxf, FALSE);
	return true;
}

bool
PrintQT::oGetTextExtent(char *text, int cb, int *width, int *height)
{
	QRect rc = qPainter.boundingRect(0, 0, 10000, 1000, Qt::AlignLeft | Qt::AlignTop,
		text, cb > 0 ? cb : strlen(text));
	*width = rc.rRight() - rc.rLeft();		*height = rc.rBottom() - rc.rTop();
	return true;
}

bool
PrintQT::oCircle(int x1, int y1, int x2, int y2, char* nam)
{
	qPainter.drawEllipse(x1, y1, x2-x1, y2-y1);
	if(hgo) return hgo->oCircle(x1, y1, x2, y2);
	return true;
}

bool
PrintQT::oPolyline(POINT * pts, int cp, char *nam)
{
	int i;

	if(cp < 1) return false;
	if (dPattern) {
		for (i = 1; i < cp; i++) PatLine(pts[i-1], pts[i]);
		}
	else {
		qPainter.moveTo(pts[0].x, pts[0].y);
		for (i = 1; i < cp; i++) qPainter.lineTo(pts[i].x, pts[i].y);
		}
	return true;
}

bool
PrintQT::oRectangle(int x1, int y1, int x2, int y2, char *nam)
{
	qPainter.drawRect(x1, y1, x2-x1-1, y2-y1-1);
	if(hgo) hgo->oRectangle(x1, y1, x2, y2, 0L);
	return true;
}

bool
PrintQT::oSolidLine(POINT *p)
{
	qPainter.drawLine(p[0].x, p[0].y, p[1].x, p[1].y);
	return true;
}

bool
PrintQT::oTextOut(int x, int y, char *txt, int cb)
{
	return com_TextOut(x, y, txt, &TxtSet, &qPainter, this);
}

bool
PrintQT::oPolygon(POINT *pts, int cp, char *nam)
{
	int i;

	QPointArray *a;

	if(!pts || cp <2) return false;
	a = new QPointArray(cp);
	if (a) {
		for(i = 0; i < cp; i++) a->setPoint(i, pts[i].x, pts[i].y);
		qPainter.drawPolygon(*a);
		delete a;
		}
	if(hgo) hgo->oPolygon(pts, cp);
	return true;
}

bool
PrintQT::oArc(int x1, int y1, int x2, int y2, int quads)
{
	return false;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Find a suitable www browser
void FindBrowser()
{
	//find a suitable browser
	if(FileExist("/usr/bin/mozilla")) WWWbrowser = strdup("mozilla");
	else if(FileExist("/usr/bin/netscape")) WWWbrowser = strdup("netscape");
	else if(FileExist("/usr/bin/konqueror")) WWWbrowser = strdup("konqueror");
	else if(FileExist("/opt/kde3/bin/konqueror")) WWWbrowser = strdup("konqueror");
	//use home as startup directory
	sprintf(TmpTxt, "%s", getenv("HOME"));
	defs.currPath = strdup(TmpTxt);	strcat(TmpTxt, "/.RLPlot");
	defs.IniFile = strdup(TmpTxt);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// The MAIN antry point
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
int main (int argc, char **argv)
{
	QApplication a(argc, argv);
	DefsRW *drw;

	if(argc > 1 && argv[1]  && argv[1][0] && FileExist(argv[1]))
		LoadFile = strdup(argv[1]);
	QAppl = &a;
	InitTextCursor(true);
	ShowBanner(true);
	a.exec();
	if(defs.IniFile) {
		if(drw = new DefsRW()){
			drw->FileIO(FILE_WRITE);		delete drw;
			}
		}
	SpreadMain(false);
	InitTextCursor(false);
	if(WWWbrowser) free(WWWbrowser);
	if(LoadFile) free(LoadFile);
	return 0;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Dialog box support
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
DlgWidget::DlgWidget(QWidget *par, const char *name, tag_DlgObj *d)
#ifdef Q_CHECK_PTR				//n.a. in Qt version 2
: QWidget(par, name, Qt::WType_Dialog)
#else
: QWidget(par, name, 0x0000002)
#endif
{
	parent = par;
	dlg = d;
	setFocusPolicy(StrongFocus);
}

DlgWidget::~DlgWidget()
{
	if(OutputClass){
		((OutputQT*)OutputClass)->widget=0L;
		delete ((OutputQT*)OutputClass);
		}
}

void
DlgWidget::paintEvent(QPaintEvent *range)
{
	QRect rc;

	rc = range->rect();
	bitBlt(this, rc.left(), rc.top(), this->mempic, rc.left(), rc.top(),
		1+rc.right()-rc.left(), 1+rc.bottom()-rc.top());
}

void
DlgWidget::mouseDoubleClickEvent(QMouseEvent *e)
{
	MouseEvent mev = {1, e->button() == Qt::LeftButton?MOUSE_LBDOUBLECLICK:-1,e->x(),e->y()};

	if (dlg) dlg->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
DlgWidget::mousePressEvent(QMouseEvent *e)
{
	MouseEvent mev = {1, e->button() == Qt::LeftButton ? MOUSE_LBDOWN : -1, e->x(), e->y()};

	HideTextCursor();
	if (dlg) dlg->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
DlgWidget::mouseReleaseEvent(QMouseEvent *e)
{
	MouseEvent mev = {0, e->button() == Qt::LeftButton ? MOUSE_LBUP : -1, e->x(), e->y()};

	if (dlg) dlg->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
DlgWidget::mouseMoveEvent(QMouseEvent *e)
{
	MouseEvent mev = {1, e->state() == Qt::LeftButton ? MOUSE_MOVE : -1, e->x(), e->y()};

	if (dlg) dlg->Command(CMD_MOUSE_EVENT, (void *)&mev, OutputClass);
}

void
DlgWidget::keyPressEvent(QKeyEvent *e)
{
	int c;

	if(dlg) switch(c = e->key()) {
		case Key_Left:
			if(e->state() & ShiftButton) dlg->Command(CMD_SHIFTLEFT, 0L, OutputClass);
			else dlg->Command(CMD_CURRLEFT, 0L, OutputClass);
			break;
		case Key_Right:
			if(e->state() & ShiftButton) dlg->Command(CMD_SHIFTRIGHT, 0L, OutputClass);
			else dlg->Command(CMD_CURRIGHT, 0L, OutputClass);
			break;
		case Key_Up:
			if(e->state() & ShiftButton) dlg->Command(CMD_SHIFTUP, 0L, OutputClass);
			else dlg->Command(CMD_CURRUP, 0L, OutputClass);
			break;
		case Key_Down:
			if(e->state() & ShiftButton) dlg->Command(CMD_SHIFTDOWN, 0L, OutputClass);
			else dlg->Command(CMD_CURRDOWN, 0L, OutputClass);
			break;
		case Key_Delete:
			dlg->Command(CMD_DELETE, 0L, OutputClass);
			break;
		case Key_Tab:
			dlg->Command(CMD_TAB, 0L, OutputClass);
			break;
		case Key_Backtab:
			dlg->Command(CMD_SHTAB, 0L, OutputClass);
			break;
		case Key_Home:
			dlg->Command(CMD_POS_FIRST, 0L, OutputClass);
			break;
		case Key_End:
			dlg->Command(CMD_POS_LAST, 0L, OutputClass);
			break;
		default:
			c = e->ascii();
			if(c >1 && c < 256)
				if(c == 26) dlg->Command(CMD_UNDO, 0L, OutputClass);
				else if(c == 0x03) dlg->Command(CMD_COPY, 0L, OutputClass);
				else if(c == 0x16) dlg->Command(CMD_PASTE, 0L, OutputClass);
				else dlg->Command(CMD_ADDCHAR, (void *)(& c), OutputClass);
			break;
		}
	e->accept();
}

void
DlgWidget::focusInEvent(QFocusEvent *e)
{
	CurrWidgetPos.x = x();		CurrWidgetPos.y = y();
}

void
DlgWidget::focusOutEvent(QFocusEvent *e)
{
	HideTextCursorObj(OutputClass);
	if(dlg) dlg->Command(CMD_ENDDIALOG, 0L, OutputClass);
}

void
DlgWidget::closeEvent(QCloseEvent *e)
{
	HideTextCursorObj(OutputClass);
	e->ignore();
	if(dlg){
		dlg->Command(CMD_UNLOCK, 0L, OutputClass);
		dlg->Command(CMD_ENDDIALOG, 0L, OutputClass);
		}
}

void
DlgWidget::timerEvent(QTimerEvent *)
{
	if(dlg) dlg->Command(CMD_ENDDIALOG, dlg, OutputClass);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void *CreateDlgWnd(char *title, int x, int y, int width, int height, tag_DlgObj *d, DWORD flags)
{
	DlgWidget *w;
	OutputQT *o;
	int dw, dh;

	w = new DlgWidget(QAppl->focusWidget(), 0, d);
	w->setCaption(title);
	if(flags & 0x2) w->setFixedSize(width, height);
	else w->setFixedSize(width-6, height-16);
	if(flags & 0x1) {
		GetDesktopSize(&dw, &dh);
		w->move((dw>>1) - ((w->width())>>1), (dh>>1) - ((w->height())>>1));
		}
	else w->move(CurrWidgetPos.x+x, CurrWidgetPos.y+y);
	o = new OutputQT(w);
	o->units = defs.cUnits;
	o->Erase(0x00e0e0e0L);
	if(flags & 0x04) {
		w->startTimer(100);
		}
	d->DoPlot(o);
	w->show();
	return w;
}

void LoopDlgWnd() 	//keep message processing running
{
	QAppl->processOneEvent();
}

void CloseDlgWnd(void *hDlg)
{
	HideCopyMark();
	if(hDlg) {
		delete((DlgWidget*) hDlg);
		}
}

void ShowDlgWnd(void *hDlg)
{
	if(hDlg){
		((DlgWidget*)hDlg)->show();
		((DlgWidget*)hDlg)->setActiveWindow();
		((DlgWidget*)hDlg)->raise();
		}
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// OS independent interface to Qt specific classes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
anyOutput *NewDispClass(GraphObj *g)
{
	return new OutputQT(g);
}

bool DelDispClass(anyOutput *w)
{
	if(w) delete (OutputQT*) w;
	return true;
}

anyOutput *NewBitmapClass(int w, int h, double hr, double vr)
{
	return new BitMapQT(w, h, hr, vr);
}

bool DelBitmapClass(anyOutput *w)
{
	if (w) delete (BitMapQT*) w;
	return true;
}

