
/*  A Bison parser, made from ../../rlplot/mfcalc.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUM	257
#define	ARR	258
#define	PI	259
#define	E	260
#define	VAR	261
#define	FNCT	262
#define	AND	263
#define	OR	264
#define	EQ	265
#define	NE	266
#define	GT	267
#define	GE	268
#define	LT	269
#define	LE	270
#define	NEG	271


/*
 mfcalc.y, mfcalc.cpp, Copyright (c) 2004 R.Lackner
 parse string and simple math: based on the bison 'mfcalc' example

    This file is part of RLPlot.

    RLPlot is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RLPlot is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RLPlot; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <math.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include "rlplot.h"

struct symrec {
	char *name;
	int type, row, col;
	struct {
		double var;
		double (*fnctptr)(...);
		} value;
	int arg_type;
	struct symrec *next;
};

typedef struct{
	double  val;
	int type;
	symrec  *tptr;
	double *a_data;
	int a_count;

}YYSTYPE;

symrec *putsym (char *sym_name, int sym_type, int arg_type);
symrec *getsym (char *sym_name);
int push(YYSTYPE *res, YYSTYPE *val);
int get_range(YYSTYPE *res, char *first, char *last);
void yyerror(char *s);
int yylex(void);

static double line_result;
static DataObj *curr_data;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		56
#define	YYFLAG		-32768
#define	YYNTBASE	30

#define YYTRANSLATE(x) ((unsigned)(x) <= 271 ? yytranslate[x] : 33)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    26,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    28,
    29,    22,    21,    10,    20,     2,    23,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    11,    27,     2,
     9,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    25,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,    12,    13,    14,    15,    16,    17,    18,    19,
    24
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     7,    10,    13,    16,    18,    20,    22,
    24,    28,    33,    37,    41,    45,    49,    53,    57,    61,
    65,    69,    73,    77,    81,    85,    89,    92,    96
};

static const short yyrhs[] = {    -1,
    30,    31,     0,    26,    27,     0,    32,    26,     0,    32,
    27,     0,     1,    26,     0,     3,     0,     5,     0,     6,
     0,     7,     0,     7,     9,    32,     0,     8,    28,    32,
    29,     0,    32,    12,    32,     0,    32,    13,    32,     0,
    32,    14,    32,     0,    32,    15,    32,     0,    32,    16,
    32,     0,    32,    17,    32,     0,    32,    18,    32,     0,
    32,    19,    32,     0,    32,    21,    32,     0,    32,    20,
    32,     0,    32,    22,    32,     0,    32,    23,    32,     0,
    32,    10,    32,     0,     7,    11,     7,     0,    20,    32,
     0,    32,    25,    32,     0,    28,    32,    29,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    76,    77,    80,    81,    82,    83,    86,    87,    88,    89,
    90,    92,    94,    95,    96,    97,    98,    99,   100,   101,
   102,   103,   104,   105,   107,   108,   109,   110,   111
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUM","ARR",
"PI","E","VAR","FNCT","'='","','","':'","AND","OR","EQ","NE","GT","GE","LT",
"LE","'-'","'+'","'*'","'/'","NEG","'^'","'\\n'","';'","'('","')'","input","line",
"exp", NULL
};
#endif

static const short yyr1[] = {     0,
    30,    30,    31,    31,    31,    31,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32
};

static const short yyr2[] = {     0,
     0,     2,     2,     2,     2,     2,     1,     1,     1,     1,
     3,     4,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     2,     3,     3
};

static const short yydefact[] = {     1,
     0,     0,     7,     8,     9,    10,     0,     0,     0,     0,
     2,     0,     6,     0,     0,     0,    27,     3,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     4,     5,    11,    26,     0,    29,    25,
    13,    14,    15,    16,    17,    18,    19,    20,    22,    21,
    23,    24,    28,    12,     0,     0
};

static const short yydefgoto[] = {     1,
    11,    12
};

static const short yypact[] = {-32768,
     0,   -24,-32768,-32768,-32768,    13,   -15,    40,   -23,    40,
-32768,    93,-32768,    40,    14,    40,     2,-32768,    57,    40,
    40,    40,    40,    40,    40,    40,    40,    40,    40,    40,
    40,    40,    40,-32768,-32768,   111,-32768,    75,-32768,   125,
    36,    36,   -11,   -11,   -11,   -11,   -11,   -11,    -7,    -7,
     2,     2,     2,-32768,    44,-32768
};

static const short yypgoto[] = {-32768,
-32768,     9
};


#define	YYLAST		150


static const short yytable[] = {    55,
     2,    13,     3,    18,     4,     5,     6,     7,    29,    30,
    31,    32,    16,    33,    31,    32,    17,    33,    19,     8,
    37,    14,    36,    15,    38,     9,    33,    10,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,     3,    56,     4,     5,     6,     7,     0,    23,
    24,    25,    26,    27,    28,    29,    30,    31,    32,     8,
    33,     0,     0,     0,     0,     0,    20,    10,    21,    22,
    23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
     0,    33,     0,     0,    20,    39,    21,    22,    23,    24,
    25,    26,    27,    28,    29,    30,    31,    32,     0,    33,
     0,     0,    20,    54,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,     0,    33,    34,    35,
    20,     0,    21,    22,    23,    24,    25,    26,    27,    28,
    29,    30,    31,    32,     0,    33,    21,    22,    23,    24,
    25,    26,    27,    28,    29,    30,    31,    32,     0,    33
};

static const short yycheck[] = {     0,
     1,    26,     3,    27,     5,     6,     7,     8,    20,    21,
    22,    23,    28,    25,    22,    23,     8,    25,    10,    20,
     7,     9,    14,    11,    16,    26,    25,    28,    20,    21,
    22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
    32,    33,     3,     0,     5,     6,     7,     8,    -1,    14,
    15,    16,    17,    18,    19,    20,    21,    22,    23,    20,
    25,    -1,    -1,    -1,    -1,    -1,    10,    28,    12,    13,
    14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
    -1,    25,    -1,    -1,    10,    29,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    -1,    25,
    -1,    -1,    10,    29,    12,    13,    14,    15,    16,    17,
    18,    19,    20,    21,    22,    23,    -1,    25,    26,    27,
    10,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    21,    22,    23,    -1,    25,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    -1,    25
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */

/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 4:
{line_result = yyvsp[-1].val; return 0;;
    break;}
case 5:
{line_result = yyvsp[-1].val; return 0;;
    break;}
case 6:
{yyerrok;;
    break;}
case 7:
{yyval.val = yyvsp[0].val;;
    break;}
case 8:
{yyval.val = 3.14159265358979;;
    break;}
case 9:
{yyval.val = 2.71828182845905;;
    break;}
case 10:
{yyval.val = yyvsp[0].tptr->value.var;;
    break;}
case 11:
{yyval.val = yyvsp[-2].tptr->value.var = yyvsp[0].val;
					if(yyvsp[-2].tptr->row >=0 && yyvsp[-2].tptr->col >= 0 && curr_data) curr_data->SetValue(yyvsp[-2].tptr->row, yyvsp[-2].tptr->col, yyvsp[0].val);;
    break;}
case 12:
{yyval.val = (yyvsp[-3].tptr->arg_type == ARR) ? ((*yyvsp[-3].tptr->value.fnctptr)(&yyvsp[-1])) : 
					(*(yyvsp[-3].tptr->value.fnctptr))(yyvsp[-1].val);;
    break;}
case 13:
{yyval.val = ((yyvsp[-2].val != 0) && (yyvsp[0].val != 0))? 1 : 0;;
    break;}
case 14:
{yyval.val = ((yyvsp[-2].val != 0) || (yyvsp[0].val != 0))? 1 : 0;;
    break;}
case 15:
{yyval.val = (yyvsp[-2].val == yyvsp[0].val) ? 1 : 0;;
    break;}
case 16:
{yyval.val = (yyvsp[-2].val != yyvsp[0].val) ? 1 : 0;;
    break;}
case 17:
{yyval.val = (yyvsp[-2].val > yyvsp[0].val) ? 1 : 0;;
    break;}
case 18:
{yyval.val = (yyvsp[-2].val >= yyvsp[0].val) ? 1 : 0;;
    break;}
case 19:
{yyval.val = (yyvsp[-2].val < yyvsp[0].val) ? 1 : 0;;
    break;}
case 20:
{yyval.val = (yyvsp[-2].val <= yyvsp[0].val) ? 1 : 0;;
    break;}
case 21:
{yyval.val = yyvsp[-2].val + yyvsp[0].val;;
    break;}
case 22:
{yyval.val = yyvsp[-2].val - yyvsp[0].val;;
    break;}
case 23:
{yyval.val = yyvsp[-2].val * yyvsp[0].val;;
    break;}
case 24:
{if(yyvsp[0].val != 0.0) yyval.val = yyvsp[-2].val / yyvsp[0].val;
					else yyval.val = (getsym("zdiv"))->value.var; ;
    break;}
case 25:
{push(&yyval, &yyvsp[0]);;
    break;}
case 26:
{get_range(&yyval, yyvsp[-2].tptr->name, yyvsp[0].tptr->name);;
    break;}
case 27:
{yyval.val = -yyvsp[0].val;;
    break;}
case 28:
{yyval.val = pow(yyvsp[-2].val, yyvsp[0].val);;
    break;}
case 29:
{yyval.val = yyvsp[-1].val;;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */


  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}


void yyerror(char *s)
{  
	//Called by yyparse on error
	if(curr_data) curr_data->Command(CMD_ERROR, s, 0L);
	else printf("%s\n", s);
}

/* more functions */
double sign(double v)
{
	if(v > 0.0) return 1.0;
	if(v < 0.0) return -1.0;
	return 0.0;
}

#undef min
double min(YYSTYPE *sr) 
{
	int i;

	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		for(i = 1, sr->val = sr->a_data[0]; i < sr->a_count; i++) 
			if(sr->a_data[i] < sr->val) sr->val = sr->a_data[i];
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

#undef max
double max(YYSTYPE *sr) 
{
	int i;

	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		for(i = 1, sr->val = sr->a_data[0]; i < sr->a_count; i++) 
			if(sr->a_data[i] > sr->val) sr->val = sr->a_data[i];
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

double count(YYSTYPE *sr)
{
	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		sr->val = (double)sr->a_count;
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	else sr->val = 1.0;
	return sr->val;
}

double sum(YYSTYPE *sr) 
{
	int i;

	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		for(i = 1, sr->val = sr->a_data[0]; i < sr->a_count; i++) sr->val += sr->a_data[i];
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

double calc_mean(double *values, int n)
{
	int i;
	double sum;

	for(i = 1, sum = values[0]; i < n; i++) sum += values[i];
	return (sum/n);
}

double calc_variance(double *values, int n)
{
	int i;
	double ss, d, mean = calc_mean(values, n);

	for(i=0, ss=0.0; i < n; i++) ss += ((d=values[i]-mean)*d);
	return (ss/(n-1));
}

double mean(YYSTYPE *sr) 
{
	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		sr->val = calc_mean(sr->a_data, sr->a_count);
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

double variance(YYSTYPE *sr)
{
	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		sr->val = calc_variance(sr->a_data, sr->a_count);
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

double stdev(YYSTYPE *sr)
{
	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		sr->val = sqrt(calc_variance(sr->a_data, sr->a_count));
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

double sterr(YYSTYPE *sr)
{
	if(!sr) return 0.0;
	if(sr->type == ARR && sr->a_data && sr->a_count){
		sr->val = sqrt(calc_variance(sr->a_data, sr->a_count))/sqrt(sr->a_count);
		free(sr->a_data);
		sr->a_data = 0L;
		sr->a_count = 0;
		sr->type = NUM;
		}
	return sr->val;
}

struct init
{
	char *fname;
	double (*fnct)(double);
	int arg_type;
};

struct init arith_fncts[] = {
	{"variance", (double(*)(double))&variance, ARR},
	{"stdev", (double(*)(double))&stdev, ARR},
	{"sterr", (double(*)(double))&sterr, ARR},
	{"min", (double(*)(double))&min, ARR},
	{"max", (double(*)(double))&max, ARR},
	{"count", (double(*)(double))&count, ARR},
	{"sum", (double(*)(double))&sum, ARR},
	{"mean", (double(*)(double))&mean, ARR},
	{"sign", sign, VAR},
	{"abs", fabs, VAR},
	{"asin", asin, VAR},
	{"acos", acos, VAR},
	{"atan", atan, VAR},
	{"sinh", sinh, VAR},
	{"cosh", cosh, VAR},
	{"tanh", tanh, VAR},
	{"sin",  sin, VAR},
	{"cos",  cos, VAR},
	{"atan", atan, VAR},
	{"log10", log10, VAR},
	{"ln",   log, VAR},
	{"exp",  exp, VAR},
	{"sqrt", sqrt, VAR},
	{0, 0, 0}};

//The symbol table: a chain of `struct symrec'
static symrec *sym_table = (symrec *) 0;

// Put arithmetic functions and predifened variables in table
void init_table (void)
{
	int i;
	symrec *ptr;

	for (i = 0; arith_fncts[i].fname != 0; i++) {
		ptr = putsym (arith_fncts[i].fname, FNCT, arith_fncts[i].arg_type);
		ptr->value.fnctptr = (double (*)(...))arith_fncts[i].fnct;
		}
	ptr = putsym("zdiv", VAR, 0);	ptr->value.var = 1.0;
}

void clear_table()
{
	symrec *ptr, *next;

	for (ptr = sym_table; ptr != (symrec *) 0;){
		if(ptr) {
			next = (symrec*)ptr->next;
			free(ptr);
			}
		ptr = next;
		}
	sym_table = (symrec *) 0;
}

symrec *
putsym (char *sym_name, int sym_type, int arg_type)
{
	symrec *ptr;

	ptr = (symrec *) malloc (sizeof (symrec));
	ptr->name = (char *) malloc (strlen (sym_name) + 1);
	strcpy (ptr->name,sym_name);
	ptr->type = sym_type;
	ptr->value.var = 0; /* set value to 0 even if fctn.  */
	ptr->arg_type = arg_type;
	ptr->col = ptr->row = -1;
	ptr->next = (struct symrec *)sym_table;
	sym_table = ptr;
	return ptr;
}

symrec *
getsym (char *sym_name)
{
	symrec *ptr;
	int row, col;
	double value;
	AccRange *ar;

	if(!sym_name || !sym_name[0]) return 0;
	for (ptr = sym_table; ptr != (symrec *) 0; ptr = (symrec *)ptr->next)
		if (!(strcmp(ptr->name,sym_name))) return ptr;
        if((curr_data) && (isalpha(sym_name[0]) || sym_name[0] == '$') && isdigit(sym_name[strlen(sym_name)-1])) {
		if((ar = new AccRange(sym_name)) && ar->GetFirst(&col, &row) && 
			(ptr = putsym(sym_name, VAR, 0))) {
			if(curr_data->GetValue(row, col, &value)) ptr->value.var = value;
			else ptr->value.var = 0.0;
			ptr->row = row;	ptr->col = col;
			delete(ar);
			return ptr;
			}
		}
	return 0;
}

int
push(YYSTYPE *res, YYSTYPE *val)
{
	if(val->type == ARR) {
		if(res->type == NUM) {
			if(!(val->a_data=(double*)realloc(val->a_data, (val->a_count+2)*sizeof(double))))return 0;
			val->a_data[val->a_count++] = res->val;
			res->a_data = val->a_data;		res->a_count = val->a_count;
			res->type = ARR;			val->a_data = 0L;
			val->a_count = 0;			val->type = NUM;
			val->val = res->val;			return 1;
			}
		if(res->type == ARR) {
			if(!(res->a_data=(double*)realloc(res->a_data, (val->a_count+res->a_count)*sizeof(double))))return 0;
			memcpy(&res->a_data[res->a_count], val->a_data, val->a_count*sizeof(double));
			res->a_count += val->a_count;		free(val->a_data);
			val->a_data = 0L;			val->a_count = 0;
			val->type = NUM;			return 1;
			}
		}
	if(res->type == NUM) {
		if(!(res->a_data =  (double*)malloc(2*sizeof(double))))return 0;
		res->a_data[0] = res->val;			res->a_data[1] = val->val;
		res->a_count = 2;				res->type = ARR;
		return 1;
		}
	if(res->type == ARR) {
		if(!(res->a_data = (double*)realloc(res->a_data, (res->a_count+1)*sizeof(double))))return 0; 
		res->a_data[res->a_count] = val->val;		res->a_count++;
		return 1;
		}
	return 0;
}

int
get_range(YYSTYPE *res, char *first, char *last)
{
	char r_txt[40];
	AccRange *r;
	int row, col;
	double value;
	YYSTYPE tmp;

	if(!res || !first || !last || !curr_data) return 0;
	sprintf(r_txt, "%s:%s", first, last);
	if(res->type != ARR && (r = new AccRange(r_txt)) && r->GetFirst(&col, &row)) {
		if(!(res->a_data =  (double*)malloc(r->CountItems() * sizeof(double)))) return 0;
		res->a_count = 0;
		res->type = ARR;
		for( ; r->GetNext(&col, &row); ) {
			if(curr_data->GetValue(row, col, &value)) res->a_data[res->a_count++] = value;
			}
		delete r;		return 1;
		}
	if((r = new AccRange(r_txt)) && r->GetFirst(&col, &row)) {
		tmp.type = NUM;
		for( ; r->GetNext(&col, &row); ) {
			if(curr_data->GetValue(row, col, &value)) {
				tmp.val = value;
				push(res, &tmp);
				}
			}
		delete r;		return 1;
		}
	return 0;
}

static char *buffer = 0L;
static int buff_pos = 0;

struct parse_info  {
	char *buffer;
	int buff_pos;
	double line_result;
	DataObj *curr_data;
	symrec *sym_table;
	YYSTYPE yylval;
	struct parse_info *next;
};
static parse_info *parse_stack = 0L;

void push_parser()
{
	parse_info *ptr;

	ptr = (parse_info *) malloc(sizeof(parse_info));
	ptr->buffer = buffer;			ptr->buff_pos = buff_pos;
	ptr->line_result = line_result;		ptr->curr_data = curr_data;
	ptr->sym_table = sym_table;		sym_table = 0L;
	memcpy(&ptr->yylval, &yylval, sizeof(YYSTYPE));
	ptr->next = parse_stack;
	parse_stack = ptr;
}

void pop_parser()
{
	parse_info *ptr;

	if(ptr = parse_stack) {
		parse_stack = ptr->next;
		buffer = ptr->buffer;			buff_pos = ptr->buff_pos;
		line_result = ptr->line_result;		curr_data = ptr->curr_data;
		sym_table = ptr->sym_table;
		memcpy(&yylval, &ptr->yylval, sizeof(YYSTYPE));
		free(ptr);
		}
}

static symrec *curr_sym;
int yylex (void)
{
	int i, c, tok;
	char tmp_txt[80];
	symrec *s;

	while((c = buffer[buff_pos++]) == ' ' || c == '\t');	//get first nonwhite char
	if(!c) return 0;
	//test for number
	if(c == '.' || isdigit(c)) {
		for(buff_pos--, i = 0; i < 79 && ((c = buffer[buff_pos]) == '.' || isdigit(c)); buff_pos++) {
			tmp_txt[i++] = (char)c;
			if(buffer[buff_pos+1] == 'e' && (buffer[buff_pos+2] == '-' || buffer[buff_pos+2] == '+')){
				tmp_txt[i++] = buffer[++buff_pos];
				tmp_txt[i++] = buffer[++buff_pos];
				}
			}
		tmp_txt[i] = 0;
		sscanf(tmp_txt, "%lf", &yylval.val);
		yylval.type = NUM;
		return NUM;
		}
	//test for name
	if(isalpha(c) || c=='$') {
 		for(buff_pos--, i = 0; i < 79 && ((c = buffer[buff_pos]) && (isalnum(c) || c == '$')); buff_pos++) {
			tmp_txt[i++] = (char)c; 
			}
		tmp_txt[i] = 0;
		if(!(strcmp(tmp_txt, "pi"))) return PI;
		if(!(strcmp(tmp_txt, "e"))) return E;
		if(!(s = getsym(tmp_txt))) s = putsym(tmp_txt, VAR, 0);
		curr_sym = yylval.tptr = s;	return s->type;
		}
	tok = 0;
	switch(c) {
	case '=':
		if(buffer[buff_pos] == '=') tok = EQ;
		break;
	case '!':
		if(buffer[buff_pos] == '=') tok = NE;
		break;
	case '>':
		if(buffer[buff_pos] == '=') tok = GE;
		else return GT;
		break;
	case '<':
		if(buffer[buff_pos] == '=') tok = LE;
		else if(buffer[buff_pos] == '>') tok = NE;
		else return LT;
		break;
	case '&':
		if(buffer[buff_pos] == '&') tok = AND;
		break;
	case '|':
		if(buffer[buff_pos] == '|') tok = OR;
		break;
		}
	if(tok) {
		buff_pos++;		return tok;
		}
	//Any other character is a token by itself
	return c;
}

bool do_xyfunc(DataObj *d, double x1, double x2, double step, char *expr, lfPOINT **pts, long *npts, char *param)
{
	double x, y;
	symrec *s;
	lfPOINT *new_points;
	long npoints = 0;
	int length;

	if(x1 < x2) step = fabs(step);
	else step = -fabs(step);
	if(!(new_points = (lfPOINT*)calloc((iround(fabs(x2-x1)/fabs(step))+2), sizeof(lfPOINT))))
		return false;
	if(d) curr_data = d;
	init_table();
	if(param) {
		length = strlen(param);
		if(!(buffer = (char*)malloc(length+2))){
			pop_parser();
			return false;
			}
		strcpy(buffer, param);	buffer[length++] = ';';
		buffer[length] = 0;	buff_pos = 0;
		do {
			yyparse();
			}while(buff_pos < length);
		free(buffer);		buffer = 0L;
		}		
	length = strlen(expr);
	buffer = expr;		s = putsym("x", VAR, 0);
	for(x = x1; step > 0.0 ? x <= x2 : x >= x2; x += step) {
		if(s = getsym("x")){
			s->value.var = x;	buff_pos = 0;
			do {
				yyparse();
				}while(buff_pos < length);
			if(s = getsym("y")) y = s->value.var;
			else y = line_result;
			new_points[npoints].fx = (getsym("x"))->value.var;
			new_points[npoints++].fy = y;
			}
		}
	*pts = new_points;	*npts = npoints;
	clear_table();
	if(curr_data) {
		curr_data->Command(CMD_CLEAR_ERROR, 0L, 0L);
		curr_data->Command(CMD_REDRAW, 0L, 0L);
		}
	return true;
}

bool do_formula(DataObj *d, char *expr, double *result)
{
	int length;

	if(d) curr_data = d;
	if(!expr || !expr[0]) return false;
	push_parser();		//make code reentrant
	init_table();		length = strlen(expr);
	if(!(buffer = (char*)malloc(length+2))){
		pop_parser();
		return false;
		}
	strcpy(buffer, expr);	buffer[length++] = ';';
	buffer[length] = 0;	buff_pos = 0;
	do {
		yyparse();
		}while(buff_pos < length);
	*result = line_result;
	free(buffer);		buffer = 0L;
	clear_table();
	pop_parser();
	return true;
}

bool MoveFormula(DataObj *d, char *of, char *nf, int dx, int dy)
{
	int length, tok, pos, i;
	char *res, desc1[2], desc2[2];

	if(d) curr_data = d;
	if(!curr_data || !of || !nf) return false;
	push_parser();		//make code reentrant
	init_table();		length = strlen(of);
	if(!(buffer = (char*)malloc(length+2))){
		pop_parser();
		return false;
		}
	strcpy(buffer, of);	buffer[length++] = ';';
	buffer[length] = 0;	buff_pos = pos = 0;
	res = (char *)calloc(length*2+10, sizeof(char));
	do {
		tok = yylex ();
		if(tok && tok < 256) {
			if(res[pos-1] == ' ') pos--;
			res[pos++] = (char)tok;
			}
		else switch(tok) {
			case NUM:
				pos += sprintf(res+pos, "%g ", yylval.val);
				break;
			case FNCT:
				pos += sprintf(res+pos, "%s", curr_sym->name);
				break;
			case VAR:
				if(curr_sym->col >= 0 && curr_sym->row >= 0) {
					desc1[0] = desc1[1] = desc2[0] = desc2[1] = 0;
					for(i=strlen(curr_sym->name)-1; i>0 && isdigit(curr_sym->name[i]); i--);
					if(curr_sym->name[0] == '$') desc1[0] = '$';
					if(curr_sym->name[i] == '$') desc2[0] = '$';
					pos += sprintf(res+pos, "%s%s%s%d", desc1, 
						Int2ColLabel(desc1[0] ? curr_sym->col : curr_sym->col+dx, false),
						desc2, desc2[0]? curr_sym->row+1 : curr_sym->row+1+dy);
					}
				else pos += sprintf(res+pos, "%s ", curr_sym->name);
				break;
			case PI:
				pos += sprintf(res+pos, "pi ");
				break;
			case E:
				pos += sprintf(res+pos, "e ");
				break;
			case AND:
				pos += sprintf(res+pos, " && ");
				break;
			case OR:
				pos += sprintf(res+pos, " || ");
				break;
			case EQ:
				pos += sprintf(res+pos, " == ");
				break;
			case NE:
				pos += sprintf(res+pos, " != ");
				break;
			case GT:
				pos += sprintf(res+pos, " > ");
				break;
			case GE:
				pos += sprintf(res+pos, " >= ");
				break;
			case LT:
				pos += sprintf(res+pos, " < ");
				break;
			case LE:
				pos += sprintf(res+pos, " <= ");
				break;
			}
		}while(buff_pos < length);
	while((res[pos-1] == ';' || res[pos-1] == ' ') && pos > 0) { res[pos-1] = 0; pos--;} 
	strcpy(nf, res);	free(res);
	free(buffer);		buffer = 0L;
	clear_table();
	pop_parser();
	return true;
}

static char *txt_formula;	//function to fit
static double **parval;		//pointers to parameter values
static void fcurve(double x, double **a, double *y, double dyda[], int ma)
{
	int i, length;
	double tmp, y1, y2;
	symrec *symx, *s=0L;

	if(!(symx = getsym("x"))) symx = putsym("x", VAR, 0);
	//swap parameters to requested set
	if(a != parval) for(i = 0; i < ma; i++) {
		tmp = *parval[i];	*parval[i]  = *a[i];	*a[i] = tmp;
		}
	//calc result
	symx->value.var = x;	buffer = txt_formula;
	buff_pos = 0;		length = strlen(txt_formula);
	do {	yyparse();	}while(buff_pos < length);
	if(s = getsym("y")) *y = s->value.var;
	else *y = line_result;
	if(*y == HUGE_VAL || *y == -HUGE_VAL) {
		for(i = 0, *y = 0.0; i < ma; dyda[i++] = 0.0);
		return;
		}
	//partial derivatives for each parameter by numerical differentiation
	for(i = 0; i < ma; i++) {
		if(*parval[i] != 0.0) {
			tmp = *parval[i];
			*parval[i] = tmp*.995;
			buff_pos = 0;
			do {	yyparse();	}while(buff_pos < length);
			y1 = s ? s->value.var : line_result;
			*parval[i] = tmp*1.005;
			buff_pos = 0;
			do {	yyparse();	}while(buff_pos < length);
			y2 = s ? s->value.var : line_result;
			*parval[i] = tmp;
			dyda[i] = (y2-y1)*100.0/tmp;
			}
		else dyda[i] = 0.0;
		}
	//swap parameters back to original
	if(a != parval) for(i = 0; i < ma; i++) {
		tmp = *parval[i];	*parval[i]  = *a[i];	*a[i] = tmp;
		}
}

int do_fitfunc(DataObj *d, char *rx, char *ry, char *rz, char **par, char *expr, double conv, int maxiter)
{
	int length, i, j, k, l, ndata, nparam, r1, r2, r3, c1, c2, c3, *lista, itst, itst1;
	symrec *tab1, *tab2, *csr, **parsym;
	AccRange *arx, *ary, *arz;
	double *x, *y, *z, currx, curry, currz, alamda, chisq, ochisq;
	double **covar, **alpha;
	char tmp_txt[500];

	if(d) curr_data = d;
	txt_formula = expr;
	if(!curr_data || !par || !expr || !rx || !ry) return 0;
	//process ranges and create arrays
	arx = ary = arz = 0L;	x = y = z = 0L;	parval = 0L;	parsym = 0L;
	if(!(arx = new AccRange(rx)))return 0;
	i = arx->CountItems()+1;
	if(!(ary = new AccRange(ry))){
		delete arx;	return 0;
		}
	if(rz && !(arz = new AccRange(rz))){
		delete ary;	delete arx;	return 0;
		}
	if(!(x = (double*)malloc(i * sizeof(double)))){
		if(arz) delete arz;
		delete ary;	delete arx;	return 0;
		}
	if(!(y = (double*)malloc(i * sizeof(double)))){
		if(arz) delete arz;
		free(x);	delete arx;	delete ary;	return 0;
		}
	if(rz && !(y = (double*)malloc(i * sizeof(double)))){
		if(arz) delete arz;
		free(y);	free(x);	delete arx;	delete ary;	return 0;
		}
	arx->GetFirst(&c1, &r1);	ary->GetFirst(&c2, &r2);
	if(rz) arz->GetFirst(&c3, &r3);
	for(ndata = j = 0; j < i; j++) {
		if(rz) {
			if(arx->GetNext(&c1, &r1) && ary->GetNext(&c2, & r2) && arz->GetNext(&c3, &r3) &&
				curr_data->GetValue(r1, c1, &currx) && curr_data->GetValue(r2, c2, &curry) &&
				curr_data->GetValue(r3, c3, &currz)) {
				x[ndata] = currx;	y[ndata] = curry;	z[ndata] = currz;	ndata++;
				}
			}
		else {
			if(arx->GetNext(&c1, &r1) && ary->GetNext(&c2, & r2) &&
				curr_data->GetValue(r1, c1, &currx) && curr_data->GetValue(r2, c2, &curry)) {
				x[ndata] = currx;	y[ndata] = curry;	ndata++;
				}
			}
		}
	//common initialization for parser tasks
	push_parser();		//make code reentrant
	init_table();		length = strlen(*par);
	//process parameters
	if(!(buffer = (char*)malloc(length+2))){
		clear_table();	pop_parser();
		if(arz) delete arz;
		free(y);	free(x);	delete arx;	delete ary;
		return 0;
		}
	strcpy(buffer, *par);	buffer[length++] = ';';
	buffer[length] = 0;	buff_pos = 0;
	tab1 = sym_table;
	do {
		yyparse();
		}while(buff_pos < length);
	tab2 = sym_table;	free(buffer);	buffer =0L;
	for(nparam = 0, csr=tab2; csr != tab1; nparam++, csr = csr->next);
	parsym = (symrec**)malloc((nparam+1)*sizeof(symrec*));
	parval = (double**)malloc((nparam+1)*sizeof(double*));
	for(i = 0, csr=tab2; csr != tab1 && i < nparam; i++, csr = csr->next){
		parsym[i] = csr;	parval[i] = &csr->value.var;
		}
	//do iteratations to optimize fit
	lista = (int*)malloc(sizeof(int)*nparam);
	for(i = 0; i< nparam; i++) lista[i] = i;
	covar = dmatrix(1, nparam, 1, nparam);
	alpha = dmatrix(1, nparam, 1, nparam);
	alamda = -1.0;		itst = 0;
	mrqmin(x, y, z, ndata, parval, nparam, lista, nparam, covar, alpha, &chisq, fcurve, &alamda);
	if(!Check_MRQerror()) {
		for(itst = itst1 = 0, ochisq = chisq; itst < maxiter && chisq > conv && ochisq >= chisq && itst1 < 9; itst++) {
			ochisq = chisq;
			mrqmin(x, y, z, ndata, parval, nparam, lista, nparam, covar, alpha, &chisq, fcurve, &alamda);
			if(ochisq == chisq) itst1++;
			else itst1 = 0;
			}
		alamda = 0.0;
		mrqmin(x, y, z, ndata, parval, nparam, lista, nparam, covar, alpha, &chisq, fcurve, &alamda);
		Check_MRQerror();
		}
	for(i = nparam-1, j = k = l = 0; i >= 0; l = 0, i--) {
		if(k > 20) {
			if(tmp_txt[j-1] == ' ') j--;
			if(tmp_txt[j-1] == ';') j--;
			l = sprintf(tmp_txt+j, "\n");
			j += l;		k = 0;
			}
		l += sprintf(tmp_txt+j, "%s%s=%g;", j && k ? " " : "", parsym[i]->name, parsym[i]->value.var);
		j += l;			k += l;
		}
	free(*par);	*par = strdup(tmp_txt);
	//write back spreadsheet data if necessary
	buffer = *par;	length = strlen(buffer);
	do {
		yyparse();
		}while(buff_pos < length);
	buffer = 0L;
	free_dmatrix(alpha, 1, nparam, 1, nparam);
	free_dmatrix(covar, 1, nparam, 1, nparam);
	if(arz) delete arz;		if(z) free(z);
	free(y);	free(x);	delete arx;	delete ary;
	if(parval) free(parval);	if(parsym) free(parsym);
	clear_table();
	pop_parser();
	if(curr_data){
		curr_data->Command(CMD_CLEAR_ERROR, 0L, 0L);
		curr_data->Command(CMD_REDRAW, 0L, 0L);
		}
	return itst < maxiter ? itst+1 : maxiter;
}














