/**
 *   (c) 2001 Nathan Hjelm <hjelmn@unm.edu>
 *   v0.5.9 rio-bsd.h
 *
 *   header file for bsd.c
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU Library Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

#ifndef RIO_BSD_H
#define RIO_BSD_H

#include "rio.h"

#if defined (__FreeBSD__) || defined(__MacOSX__)
u_int32_t bswap_32(u_int32_t);
#elif defined (__NetBSD__)
#define bswap_32(x) bswap32(x)
#endif

#ifndef HAVE_LIBGEN_H
char *basename(char *x);
#endif

#ifndef HAVE_MEMMEM
void *memmem (void *haystack, size_t haystack_size,
	      void *needle, size_t needle_size);
#endif

#endif
