///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
/*
OVERVIEW:
  1. unary operations
     1.1. unary operators +x -x 
          std maths: sin(x), etc 
          and extensions: norm(x) & norm2(x)
     1.2. unary compose (f,expr) <==> f(expr)
  1. binary operations
     2.1. binary operators x+y x-y, x*y, x/y ; 
	  std maths: pow(x,y), ... 
          and extensions dot(x,y), ddot(x,y)
     2.3. binary compose (f,expr1,expr2) <==> f(expr1,expr2)

TODO:
  - compose2: loop on Types instead of explicitely write "int" or "T" => add point & tensor
  - field_functor : completer
    vraie fonction a retour general :
          template<class T, class R>
          operator* (arg1.., R(*f)(const point_basic<T>&));

    classe-fonction a retour scalaire et sans template dans l'arg :
          if (o.have_arg(i,v::s)) :
          operator* (arg1.., const function<Float(const point_basic<Float>&)>& f);
	si on met un template : le compilateur ne sait pas instancier
	si on met plusieurs types de retour : ambigu, le compilateur ne sait pas choisir

    rq. ce n'est pas urgent: on utilise pas les vraires fct ni les classes-fct dans les exprs 
        et les functor sont plus generaux : variables internes, possibilite de scalaires complexes, etc

SUMMARY:
   mixt field and nonlinear functions and operators, as:

	field vh = interpolate (Xh, pow(fabs(uh),p));
	Float err_l1 = integrate(omega, fabs(uh-u()), qopt);
	form m (Xh, Xh, "mass", 1/norm(grad_uh));

   type:			abbrev

   int 				s1
   T				s2	n_scalar=2

   field<T,M>			C1	n_class=5
   field_indirect<T,M>		C2	=> seront tous convertis en field<T,M>
   field_indirect_const<T,M>	C3
   field_component<T,M>		C4
   field_component_const<T,M>	C5

   field_expr<E>		L	linear expr
   Function			F	
   field_nonlinear_expr<E>	N	nonlinear expr

 Note: le caractere value' (field scalar, vector, tensor) peut etre connu
 a la compilation (pour les constantes ou les class-function) mais n'est connu
 qu'a l'execution pour les field.
 => il va falloir va instancier toutes les possibilites
    et essayer d'eviter au maximum les tests a l'execution

*/

#include "field_expr_ops_make.icc"
// *************************************************************************************
// part 1 : unary operations
// *************************************************************************************

// =====================================================================================
// chap 1.1 : unary operators +x -x and standard maths: sin(uh), etc
// =====================================================================================
void g_unop_base (s root, const op& o, s details, s arg, s w_arg) {
  w_arg = (w_arg != "") ? w_arg : arg;
  s x  = (!is_functor(arg)) ? "x" : "x.get_ref()";
  x = (arg == w_arg) ? x : "arg_t("+x+")";
  cout << "inline" << endl
       << root << "_expr<" << endl
       << "  " << root << "_expr_uf<" << endl
       << "      " << details << "::" << o.tag << "" << endl
       << "     ," << w_arg << endl
       << "    >" << endl
       << "  >" << endl
       << add_operator(o.name) << " (const " << arg << "& x)" << endl
       << "{" << endl
       << "  typedef " << details << "::" << o.tag << "  op_t;" << endl
       << "  typedef " << w_arg                    << "  arg_t;" << endl
       << "  typedef " << root << "_expr_uf<op_t,arg_t>  expr_t;" << endl
       << "  return  " << root << "_expr<expr_t>(expr_t(op_t(), "<<x<<"));" << endl
       << "}" << endl;
}
void nl_unop_base (const op& o, s details, s arg, s w_arg="") {
      g_unop_base ("field_nonlinear", o, details, arg, w_arg);
}
void vf_unop_base (const op& o, s details, s arg, s w_arg="") {
      g_unop_base ("field_vf", o, details, arg, w_arg);
}
void vf2_unop_base (const op& o, s details, s arg, s w_arg="") {
       g_unop_base ("form_vf", o, details, arg, w_arg);
}
// -----------------------------------------------------------------------------
void nl_unop (const op& o, const vector<s>& Class, s details) {
  if (!o.is_linear) {
    // Note: op(C) and op(L) are linear and when op.is_linear,
    // then, this has been already handled by linear field_expr<Expr>

    // f(C)
    for (size_t i = 0, nc = Class.size(); i < nc; i++) {
      cout << "template<class T, class M>" << endl;
      nl_unop_base (o, details,
                    Class[i]+"<T,M>",
                    "field_expr_terminal_field<T,M>");
    }
    // f(L)
    cout << "template<class Expr>" << endl;
    nl_unop_base (o, details,
                    "field_expr<Expr>",
                    "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
  }
  // always nonlinear:

  // op(N)
  cout << "template<class Expr>" << endl;
  nl_unop_base (o, details,
	"field_nonlinear_expr<Expr>");

  // op(F)
  cout << "template<class Function, class Result>" << endl;
  nl_unop_base (o, details,
	"field_functor<Function,Result>", 
	"field_expr_terminal_function<Function>"); 
}
// -----------------------------------------------------------------------------
void nl_all_unops (const vector<op>& Op, const vector<s>& Class, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    nl_unop (Op[i], Class, details);
  }
}
// =====================================================================================
// chap 1.2 : unary compose (f,expr) <==> f(expr)
// =====================================================================================
// TODO: use function<F> instead of function_wrapper<F> ?
// unary compose
void nl_compose1_base (s details, s arg, s w_arg="") {
  w_arg = (w_arg != "") ? w_arg : arg;
  s x = (!is_functor(arg)) ? "x" : "x.get_ref()";
  x   = (arg == w_arg) ? x : "arg_t("+x+")";
  cout << "inline" << endl
       << "field_nonlinear_expr<" << endl
       << "  field_nonlinear_expr_uf<" << endl
       << "    typename " << details << "::function_wrapper<Function>::type" << endl
       << "   ," << w_arg << endl
       << "  >" << endl
       << ">" << endl
       << "compose (const Function& f, const " << arg << "& x) {" << endl
       << "  typedef typename " << details << "::function_wrapper<Function>::type func_t;" << endl
       << "  typedef " << w_arg << "                        arg_t;" << endl
       << "  typedef field_nonlinear_expr_uf<func_t, arg_t> expr_t;" << endl
       << "  return  field_nonlinear_expr<expr_t> (expr_t(" << details << "::function_wrap(f), " << x << "));" << endl
       << "}" << endl
       ;
}
void nl_compose1 (const vector<s>& Class, s details) {
  // f(C)
  for (size_t i = 0, nc = Class.size(); i < nc; i++) {
    cout << "template<class T, class M, class Function>" << endl;
    nl_compose1_base (details,
       Class[i]+"<T,M>",
       "field_expr_terminal_field<T,M>");
  }
  // f(L)
  cout << "template<class Expr, class Function>" << endl;
  nl_compose1_base (details,
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");

  // f(N)
  cout << "template<class Expr, class Function>" << endl;
  nl_compose1_base (details,
       "field_nonlinear_expr<Expr>");

  // f(F)
  cout << "template<class Function, class Function1, class Result1>" << endl;
  nl_compose1_base (details,
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>");
}
#ifdef TO_CLEAN
// =====================================================================================
// chap 1.3 : T val = integrate (omega,f,qopt) with various f : numeric integration
// =====================================================================================
// TODO: use a direct procedure without P0-field allocation and without riesz that is obsolete !
void
numeric_integrate_init (s details) {
  cout << "namespace " << details << "{" << endl
       << "template <class T, class M, class Expr>" << endl
       << "T" << endl
       << "integrate_internal (const geo_basic<T,M>& omega, const Expr& expr, const quadrature_option_type& qopt)" << endl
       << "{" << endl
       << "  space_basic<T,M> Xh (omega, \"P0\");" << endl
       << "  field_basic<T,M> lh = riesz (Xh, expr, qopt);" << endl
       << "  return dual (1, lh);" << endl
       << "}" << endl
       << "} // namespace " << details << endl
    ;
}
void
numeric_integrate_base (s f, s details) {
  cout << "T integrate (const geo_basic<T,M>& dom, " << f <<"," 
                   << " const quadrature_option_type& qopt)" << endl
       << "{" << endl
       << "  return " << details << "::integrate_internal (dom, f, qopt);" << endl
       << "}" << endl
   ;
}
void
numeric_integrate (const vector<s>& Class, s details)
{
  numeric_integrate_init (details);

  // pointer to function:
  // TODO: function<Float(point)> that merge true functions and class-functions, but with T=Float
  cout << "template <class T, class M>" << endl;
  numeric_integrate_base ("T (*f)(const point_basic<T>&)", details);

  // field_functor
  cout << "template <class T, class M, class Function>" << endl;
  numeric_integrate_base ("const field_functor<Function,T>& f", details);

  // terminal class
  for (size_t i = 0, nc = Class.size(); i < nc; i++) {
    cout << "template <class T, class M>" << endl;
    numeric_integrate_base ("const "+Class[i]+"<T,M>& f", details);
  }
  // expression:
  cout << "template <class T, class M, class E>" << endl;
  numeric_integrate_base ("const field_nonlinear_expr<E>& f", details);
}
#endif // TO_CLEAN
// *************************************************************************************
// part 2 : binary operations
// *************************************************************************************

// =====================================================================================
// chap 2.1: binary operators x+y x-y, x*y, x/y
// =====================================================================================
void g_binop_base (s root, const op& o, s details, s arg1, s w_arg1, s arg2, s w_arg2) {
  w_arg1 = (w_arg1 != "") ? w_arg1 : arg1;
  w_arg2 = (w_arg2 != "") ? w_arg2 : arg2;
  s x  = (!is_functor(arg1)) ? "x" : "x.get_ref()";
  s y  = (!is_functor(arg2)) ? "y" : "y.get_ref()";
  x = (arg1 == w_arg1) ? x : "arg1_t("+x+")";
  y = (arg2 == w_arg2) ? y : "arg2_t("+y+")";
  cout << "inline" << endl
       << root << "_expr<" << endl
       << "  " << root << "_expr_bf<" << endl
       << "      " << details << "::" << o.tag << endl
       << "     ," << w_arg1 << endl
       << "     ," << w_arg2 << endl
       << "    >" << endl
       << "  >" << endl
       << add_operator(o.name) <<" (const " << arg1 << "& x, const " << arg2 << "& y)" << endl
       << "{" << endl
       << "  typedef " << w_arg1 << " arg1_t;" << endl
       << "  typedef " << w_arg2 << " arg2_t;" << endl
       << "  typedef " << root << "_expr_bf<" << details << "::" << o.tag << ", arg1_t, arg2_t>   expr_t;" << endl
       << "  return  " << root << "_expr<expr_t>(expr_t(" << details << "::" << o.tag << "(), " << x << ", " << y << "));" << endl
       << "}" << endl;
}
void nl_binop_base (const op& o, s details, s arg1, s w_arg1, s arg2, s w_arg2="") {
      g_binop_base ("field_nonlinear", o, details, arg1, w_arg1, arg2, w_arg2);
}
void vf_binop_base (const op& o, s details, s arg1, s w_arg1, s arg2, s w_arg2="") {
      g_binop_base ("field_vf", o, details, arg1, w_arg1, arg2, w_arg2);
}
void vf2_binop_base (const op& o, s details, s arg1, s w_arg1, s arg2, s w_arg2="") {
       g_binop_base ("form_vf", o, details, arg1, w_arg1, arg2, w_arg2);
}
// -----------------------------------------------------------------------------
void g_binop_by_constant_bind (s root, const op& o, s details, size_t i, s constant, s arg, s w_arg="") {
  w_arg = (w_arg != "") ? w_arg : arg;
  s binder = (i == 1) ? "binder_first" : "binder_second";
  s arg1 = (i == 1) ? constant : arg;
  s arg2 = (i == 2) ? constant : arg;
  s cte  = (i == 1) ? "x" : "y";
  s expr = (i == 2) ? "x" : "y";
  expr   = (!is_functor(arg)) ? expr : expr+".get_ref()";
  expr   = (arg == w_arg) ? expr : "arg_t("+expr+")";
  cout << "inline" << endl
       << root << "_expr<" << endl
       << "  " << root << "_expr_uf<" << endl
       << "    details::" << binder << "<details::" << o.tag << "," << constant << " >" << endl
       << "   ," << w_arg << endl
       << "  >" << endl
       << ">" << endl
       << add_operator(o.name) << " (const " << arg1 << "& x, const " << arg2 << "& y)" << endl
       << "{" << endl
       << "  typedef details::" << o.tag << "                op_t;" << endl
       << "  typedef " << constant << "                      ct_t;" << endl
       << "  typedef details::" << binder << "<op_t,ct_t>    fun_t;" << endl
       << "  typedef " << w_arg << "                         arg_t;" << endl
       << "  typedef " << root << "_expr_uf<fun_t, arg_t>   expr_t;" << endl
       << "  return  " << root << "_expr<expr_t>(expr_t(fun_t(op_t(), " << cte << "), " << expr << "));" << endl
       << "}" << endl;
}
void nl_binop_by_constant_bind (const op& o, s details, size_t i, s constant, s arg, s w_arg="") {
      g_binop_by_constant_bind ("field_nonlinear", o, details, i, constant, arg, w_arg);
}
void vf_binop_by_constant_bind (const op& o, s details, size_t i, s constant, s arg, s w_arg="") {
      g_binop_by_constant_bind ("field_vf", o, details, i, constant, arg, w_arg);
}
void vf2_binop_by_constant_bind (const op& o, s details, size_t i, s constant, s arg, s w_arg="") {
      g_binop_by_constant_bind ("form_vf", o, details, i, constant, arg, w_arg);
}
// -----------------------------------------------------------------------------
/*
    + -   s C L F N
	s s L L * *
	C L L L * *
        L L L L * *
	F * * * * *
        N * * * * *

  *       s C L F N
	s s L L * *   une partie est lineaire
	C L * * * *		c*uh, uh*c mais pas uh*vh
        L L * * * *
	F * * * * *
        N * * * * *

  /       s C L F N
	s s * * * *   une partie est lineaire
	C L * * * *		uh/c mais pas c/uh ni uh/vh
        L L * * * *	=> non symmetrique (non communtatif)
	F * * * * *
        N * * * * *

   Probleme: uh*vh peut etre defini avec uh scalaire et vh scalaire, vecteur ou tenseur
             resolu avec details::multiplies qui prend deux args T1 et T2 differents
		et calcule le type de retour
*/
void nl_binop_by_constant (const op& o, const vector<s>& Class, const vector<v::type>& Types, s details) {
  // ------------------
  // op(sX), X=C,L,N,F
  // ------------------
  for (size_t i = 1; i <= 2; i++) {
    for (vector<v::type>::const_iterator iter = Types.begin(), last = Types.end(); iter != last; ++iter) {
      v::type t = *iter;

      // skip type errors as v/tensor or dot(v,tensor):
      if (!o.have_arg (i, t)) continue;

      bool is_linear = o.is_linear || 
                      (o.name == "*" && t == v::s) || 
                      (o.name == "/" && i == 2);
      if (!is_linear) {
	// otherwise : 2*uh, uh*2 or uh/2 are linear and already done in field_expr 
        for (size_t j = 0, nc = Class.size(); j < nc; j++) {
          // op(sC)=s/C as 2/uh
          cout << "template<class T, class M>" << endl;
          nl_binop_by_constant_bind (o, details, i,
  	    valued(t,"typename "+Class[j]+"<T,M>::scalar_type"),
  	    Class[j]+"<T,M>", 
  	    "field_expr_terminal_field<T,M>");
        }
        // op(sL)=s/L as 2/(uh+vh)
        cout << "template<class Expr>" << endl;
        nl_binop_by_constant_bind (o, details, i, 
  	  valued(t,"typename field_expr<Expr>::scalar_type"),
          "field_expr<Expr>",
          "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
      }
      // op(sN), op(Ns)
      cout << "template<class Expr>" << endl;
      nl_binop_by_constant_bind (o, details, i, 
  	valued(t,"typename field_nonlinear_expr<Expr>::scalar_type"),
  	"field_nonlinear_expr<Expr>");
      
      // op(sF), op(Fs)
      cout << "template<class Function, class Result>" << endl;
      nl_binop_by_constant_bind (o, details, i,
  	valued(t,"typename scalar_traits<Result>::type"),
  	"field_functor<Function,Result>", 
  	"field_expr_terminal_function<Function>"); 
    }
  }
}
// -----------------------------------------------------------------------------
void nl_binop_by_field (const op& o, const vector<s>& Class, s details) {
  // -------------
  // op(CC)
  // -------------
  if (!o.is_linear) {
    for (size_t i = 0, nc = Class.size(); i < nc; i++) {
    for (size_t j = 0, nc = Class.size(); j < nc; j++) {
      cout << "template<class T, class M>" << endl;
      nl_binop_base (o, details,
   	Class[i]+"<T,M>", 
	"field_expr_terminal_field<T,M>",
   	Class[j]+"<T,M>", 
	"field_expr_terminal_field<T,M>");
    }}
  }
  // -------------
  // op(CX), X=F,N
  // -------------
  for (size_t i = 0, nc = Class.size(); i < nc; i++) {
    if (!o.is_linear) {
      // op(CL)
      cout << "template<class Expr, class T, class M>" << endl;
      nl_binop_base (o, details,
   	Class[i]+"<T,M>", 
	"field_expr_terminal_field<T,M>",
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
      // op(LC)
      cout << "template<class Expr, class T, class M>" << endl;
      nl_binop_base (o, details,
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>",
   	Class[i]+"<T,M>", 
	"field_expr_terminal_field<T,M>");
    }
    // op(CF)
    cout << "template<class Function, class Result, class T, class M>" << endl;
    nl_binop_base (o, details,
   	Class[i]+"<T,M>", 
	"field_expr_terminal_field<T,M>",
	"field_functor<Function,Result>", 
	"field_expr_terminal_function<Function>"); 

    // op(FC)
    cout << "template<class Function, class Result, class T, class M>" << endl;
    nl_binop_base (o, details,
	"field_functor<Function,Result>", 
        "field_expr_terminal_function<Function>", 
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>");

    // op(NC)
    cout << "template<class Expr, class T, class M>" << endl;
    nl_binop_base (o, details,
	"field_nonlinear_expr<Expr>", 
	"", 
	Class[i]+"<T,M>",
	"field_expr_terminal_field<T,M>");
    // op(CN)
    cout << "template<class Expr, class T, class M>" << endl;
    nl_binop_base (o, details,
	Class[i]+"<T,M>", 
	"field_expr_terminal_field<T,M>",
	"field_nonlinear_expr<Expr>");
  }
  if (!o.is_linear) {
    // op(LL)
    cout << "template<class Expr1, class Expr2>" << endl;
    nl_binop_base (o, details,
        "field_expr<Expr1>",
        "field_expr_terminal_field<typename field_expr<Expr1>::scalar_type, typename field_expr<Expr1>::memory_type>",
        "field_expr<Expr2>",
        "field_expr_terminal_field<typename field_expr<Expr2>::scalar_type, typename field_expr<Expr2>::memory_type>");
  }
  // ----------------------
  // op(XY), X,Y=L,F,N
  // ----------------------
  // op(LF)
  cout << "template<class Expr, class Function, class Result>" << endl;
  nl_binop_base (o, details,
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>",
        "field_functor<Function,Result>", 
        "field_expr_terminal_function<Function>");

  // op(FL)
  cout << "template<class Expr, class Function, class Result>" << endl;
  nl_binop_base (o, details,
        "field_functor<Function,Result>", 
        "field_expr_terminal_function<Function>",
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");

  // op(NF)
  cout << "template<class Expr, class Function, class Result>" << endl;
  nl_binop_base (o, details,
	"field_nonlinear_expr<Expr>",
        "", 
        "field_functor<Function,Result>", 
        "field_expr_terminal_function<Function>");

  // op(FN)
  cout << "template<class Expr, class Function, class Result>" << endl;
  nl_binop_base (o, details,
	"field_functor<Function,Result>", 
	"field_expr_terminal_function<Function>", 
	"field_nonlinear_expr<Expr>");

  // op(LN)
  cout << "template<class Expr1, class Expr2>" << endl;
  nl_binop_base (o, details,
        "field_expr<Expr1>",
        "field_expr_terminal_field<typename field_expr<Expr1>::scalar_type, typename field_expr<Expr1>::memory_type>",
	"field_nonlinear_expr<Expr2>");

  // op(NL)
  cout << "template<class Expr1, class Expr2>" << endl;
  nl_binop_base (o, details,
	"field_nonlinear_expr<Expr1>",
	"",
        "field_expr<Expr2>",
        "field_expr_terminal_field<typename field_expr<Expr2>::scalar_type, typename field_expr<Expr2>::memory_type>");

  // op(FF)
  cout << "template<class Function1, class Result1, class Function2, class Result2>" << endl;
  nl_binop_base (o, details,
	"field_functor<Function1,Result1>", 
	"field_expr_terminal_function<Function1>", 
	"field_functor<Function2,Result2>", 
	"field_expr_terminal_function<Function2>");

  // op(NN)
  cout << "template<class Expr1, class Expr2>" << endl;
  nl_binop_base (o, details,
	"field_nonlinear_expr<Expr1>",
	"", 
	"field_nonlinear_expr<Expr2>");
}
// -----------------------------------------------------------------------------
void nl_all_binops (const vector<op>& Op, const vector<s>& Class, const vector<v::type>& Types, s details) {
  for (size_t i = 0; i < Op.size(); i++) {
    nl_binop_by_constant (Op[i], Class, Types, details);
    nl_binop_by_field    (Op[i], Class,        details);
  }
}
// =====================================================================================
// chap 2.3: binary compose (f,expr1,expr2) <==> f(expr1,expr2)
// =====================================================================================
void nl_compose2_base (s details, s arg1, s w_arg1, s arg2, s w_arg2="") {
  w_arg1 = (w_arg1 != "") ? w_arg1 : arg1;
  w_arg2 = (w_arg2 != "") ? w_arg2 : arg2;
  s x = (!is_functor(arg1)) ? "x" : "x.get_ref()";
  s y = (!is_functor(arg2)) ? "y" : "y.get_ref()";
  x = (arg1 == w_arg1) ? x : "arg1_t("+x+")";
  y = (arg2 == w_arg2) ? y : "arg2_t("+y+")";
  cout << "inline" << endl
       << "field_nonlinear_expr<" << endl
       << "  field_nonlinear_expr_bf<" << endl
       << "    typename " << details << "::function_wrapper<Function>::type" << endl
       << "   ," << w_arg1 << endl
       << "   ," << w_arg2 << endl
       << "  >" << endl
       << ">" << endl
       << "compose (const Function& f, const " << arg1 << "& x, const " << arg2 << "& y) {" << endl
       << "  typedef typename " << details << "::function_wrapper<Function>::type func_t;" << endl
       << "  typedef " << w_arg1 << " arg1_t;" << endl
       << "  typedef " << w_arg2 << " arg2_t;" << endl
       << "  typedef field_nonlinear_expr_bf<func_t, arg1_t, arg2_t>   expr_t;" << endl
       << "  return  field_nonlinear_expr<expr_t> (expr_t(" << details << "::function_wrap(f), "
			<< x << ", " << y << "));" << endl
       << "}" << endl;
}
void nl_compose_bind_scalar (s details, size_t i, s scalar, s arg, s w_arg="") {
  w_arg = (w_arg != "") ? w_arg : arg;
  s binder = (i == 1) ? "binder1st" : "binder2nd";
  s arg1 = (i == 1) ? scalar : arg;
  s arg2 = (i == 2) ? scalar : arg;
  s cte  = (i == 1) ? "x" : "y";
  s expr = (i == 2) ? "x" : "y";
  expr = (!is_functor(arg)) ? expr : expr+".get_ref()";
  expr = (arg == w_arg) ? expr : "arg_t("+expr+")";
  cout << "inline" << endl
       << "field_nonlinear_expr<" << endl
       << "  field_nonlinear_expr_uf<" << endl
       << "    std::" << binder << "<Function>" << endl
       << "   ," << w_arg << endl
       << "  >" << endl
       << ">" << endl
       << "compose (const Function& f, const " << arg1 << "& x, const " << arg2 << "& y) {" << endl
       << "  typedef " << w_arg << "                                      arg_t;" << endl
       << "  typedef typename promote<" << scalar << ",typename arg_t::scalar_type>::type scalar_t;" << endl
       << "  typedef Function                                             funb_t;" << endl
       << "  typedef std::" << binder << "<funb_t>                        fun_t;" << endl
       << "  typedef field_nonlinear_expr_uf<fun_t,arg_t>                 expr_t;" << endl
       << "  return field_nonlinear_expr<expr_t>(expr_t(fun_t(funb_t(), " << cte << "), " << expr << "));" << endl
       << "}" << endl;
}
void nl_compose2 (const vector<s>& Class, const vector<v::type>& Types, s details) {
/*  fun   s C L F N
	s s * * * *
	C * * * * *
        L * * * * *
	F * * * * *
        N * * * * *
*/
  // -------------------
  // f(sX), X=C,F,L,N
  // -------------------
  for (size_t i = 1; i <= 2; i++) {
    for (vector<v::type>::const_iterator iter = Types.begin(), last = Types.end(); iter != last; ++iter) {
      v::type t = *iter;
  
      for (size_t j = 0, nc = Class.size(); j < nc; j++) {
        // f(sC), f(Cs)
        cout << "template<class Function, class T, class M>" << endl;
        nl_compose_bind_scalar (details, i,
  	  valued(t,"typename "+Class[j]+"<T,M>::scalar_type"),
          Class[j]+"<T,M>",
          "field_expr_terminal_field<T,M>");
      }
      // f(sF), f(Fs)
      cout << "template<class Function, class Function1, class Result1>" << endl;
      nl_compose_bind_scalar (details, i,
          valued(t,"typename field_expr_terminal_function<Function1>::scalar_type"),
          "field_functor<Function1,Result1>",
          "field_expr_terminal_function<Function1>");
  
      // f(sL), f(Ls)
      cout << "template<class Function, class Expr>" << endl;
      nl_compose_bind_scalar (details, i,
          valued(t,"typename field_expr<Expr>::scalar_type"),
          "field_expr<Expr>",
          "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
  
      // f(sN), f(Ns)
      cout << "template<class Function, class Expr>" << endl;
      nl_compose_bind_scalar (details, i,
          valued(t,"typename field_nonlinear_expr<Expr>::scalar_type"),
          "field_nonlinear_expr<Expr>");
    }
  }
  // -------------------
  // f(CC)
  // -------------------
  for (size_t i = 0, nc = Class.size(); i < nc; i++) {
  for (size_t j = 0, nc = Class.size(); j < nc; j++) {
    // f(CC)
    cout << "template<class Function, class T, class M>" << endl;
    nl_compose2_base (details,
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>",
        Class[j]+"<T,M>",
        "field_expr_terminal_field<T,M>");
  }}
  // ---------------------------
  // f(CX), X=L,F,N
  // ---------------------------
  for (size_t i = 0, nc = Class.size(); i < nc; i++) {
    // f(CF)
    cout << "template<class Function, class Function1, class Result1, class T, class M>" << endl;
    nl_compose2_base (details,
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>",
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>");
    // f(FC)
    cout << "template<class Function, class Function1, class Result1, class T, class M>" << endl;
    nl_compose2_base (details,
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>",
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>");

    // f(CL)
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    nl_compose2_base (details,
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>",
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
    // f(LC)
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    nl_compose2_base (details,
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>",
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>");

    // f(CN)
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    nl_compose2_base (details,
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>",
        "field_nonlinear_expr<Expr>");
    // f(NC)
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    nl_compose2_base (details,
        "field_nonlinear_expr<Expr>",
        "",
        Class[i]+"<T,M>",
        "field_expr_terminal_field<T,M>");
  }
  // ---------------------------
  // f(XY), X,Y=L,F,N
  // ---------------------------
  // f(LL)
  cout << "template<class Function, class Expr1, class Expr2>" << endl;
  nl_compose2_base (details,
        "field_expr<Expr1>",
        "field_expr_terminal_field<typename field_expr<Expr1>::scalar_type, typename field_expr<Expr1>::memory_type>",
        "field_expr<Expr2>",
        "field_expr_terminal_field<typename field_expr<Expr2>::scalar_type, typename field_expr<Expr2>::memory_type>");

  // f(NN)
  cout << "template<class Function, class Expr1, class Expr2>" << endl;
  nl_compose2_base (details,
        "field_nonlinear_expr<Expr1>",
        "",
        "field_nonlinear_expr<Expr2>");

  // f(LN)
  cout << "template<class Function, class Expr1, class Expr2>" << endl;
  nl_compose2_base (details,
        "field_expr<Expr1>",
        "field_expr_terminal_field<typename field_expr<Expr1>::scalar_type, typename field_expr<Expr1>::memory_type>",
        "field_nonlinear_expr<Expr2>");
  // f(NL)
  cout << "template<class Function, class Expr1, class Expr2>" << endl;
  nl_compose2_base (details,
        "field_nonlinear_expr<Expr1>",
        "",
        "field_expr<Expr2>",
        "field_expr_terminal_field<typename field_expr<Expr2>::scalar_type, typename field_expr<Expr2>::memory_type>");

  // f(FF)
  cout << "template<class Function, class Function1, class Result1, class Function2, class Result2>" << endl;
  nl_compose2_base (details,
        "field_functor<Function1,Result2>",
        "field_expr_terminal_function<Function1>",
        "field_functor<Function2,Result2>",
        "field_expr_terminal_function<Function2>");

  // f(FL)
  cout << "template<class Function, class Function1, class Result1, class Expr>" << endl;
  nl_compose2_base (details,
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>",
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>");
  // f(LF)
  cout << "template<class Function, class Function1, class Result1, class Expr>" << endl;
  nl_compose2_base (details,
        "field_expr<Expr>",
        "field_expr_terminal_field<typename field_expr<Expr>::scalar_type, typename field_expr<Expr>::memory_type>",
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>");

  // f(FN)
  cout << "template<class Function, class Function1, class Result1, class Expr>" << endl;
  nl_compose2_base (details,
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>",
        "field_nonlinear_expr<Expr>",
        "field_nonlinear_expr<Expr>");
  // f(NF)
  cout << "template<class Function, class Function1, class Result1, class Expr>" << endl;
  nl_compose2_base (details,
        "field_nonlinear_expr<Expr>",
        "field_nonlinear_expr<Expr>",
        "field_functor<Function1,Result1>",
        "field_expr_terminal_function<Function1>");
}
#ifndef _NO_FIELD_NONLINEAR_MAIN
// =====================================================================================
int main() {
// =====================================================================================
  const bool linear = true;
  const s details = "details";
  header("FIELD_NONLINEAR", "field_nonlinear");

  vector<v::type> Types;
  Types.push_back(v::s);
  Types.push_back(v::p);
  Types.push_back(v::t);

  vector<s> Class;
  Class.push_back ("field_basic");
  Class.push_back ("field_indirect");
  Class.push_back ("field_indirect_const");
  Class.push_back ("field_component");
  Class.push_back ("field_component_const");

  vector<op> Unop;
  Unop.push_back (op("+", "unary_plus", linear));
  Unop.push_back (op("-", "negate",     linear));
  Unop.push_back (op("cos",   v::s));	// std::cmath
  Unop.push_back (op("sin",   v::s));
  Unop.push_back (op("tan",   v::s));
  Unop.push_back (op("acos",  v::s));
  Unop.push_back (op("asin",  v::s));
  Unop.push_back (op("atan",  v::s));
  Unop.push_back (op("cosh",  v::s));
  Unop.push_back (op("sinh",  v::s));
  Unop.push_back (op("tanh",  v::s));
  Unop.push_back (op("exp",   v::s));
  Unop.push_back (op("log",   v::s));
  Unop.push_back (op("log10", v::s));
  Unop.push_back (op("sqrt",  v::s));
  Unop.push_back (op("abs",   v::s));
  Unop.push_back (op("fabs",  v::s));
  Unop.push_back (op("floor", v::s));
  Unop.push_back (op("ceil",  v::s));
  Unop.push_back (op("sqr",   v::s));	// rheolef extension
  Unop.push_back (op("norm",  v::all));
  Unop.push_back (op("norm2", v::all));
  Unop.push_back (op("tr",    v::t));
  Unop.push_back (op("trans", v::t));
  nl_all_unops (Unop, Class, details);

  vector<op> Binop;
  Binop.push_back (op("+", "plus",  linear));
  Binop.push_back (op("-", "minus", linear));
  Binop.push_back (op("*", "multiplies"));
  Binop.push_back (op("/", "divides",  v::all, v::s));
  Binop.push_back (op("atan2", v::s));	// std::cmath
  Binop.push_back (op("pow",   v::s));
  Binop.push_back (op("fmod",  v::s));
  Binop.push_back (op("min",   v::s));	// std::algorithm
  Binop.push_back (op("max",   v::s));
  Binop.push_back (op("dot",   v::p));  // rheolef extensions
  Binop.push_back (op("ddot",  v::t));
  nl_all_binops (Binop, Class, Types, details);

  nl_compose1 (Class,        details);
  nl_compose2 (Class, Types, details);

#ifdef TO_CLEAN
  numeric_integrate (Class, details);
#endif // TO_CLEAN

  footer("FIELD_NONLINEAR", "field_nonlinear");
}
#endif // _NO_FIELD_NONLINEAR_MAIN
