# ifndef _RHEOLEF_TENSOR4_H
# define _RHEOLEF_TENSOR4_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:tensor4
NAME: @code{tensor4} - a fouth order tensor
@cindex tensor4
@clindex tensor4
SYNOPSYS:
@noindent
The @code{tensor4} class defines a fourth tensor where
indices varie from zero to 2 (aka 3D physical space).
End:
*/

#include "rheolef/point.h"
#include "rheolef/tensor.h"
namespace rheolef {

//<tensor4:
template<class T>
class tensor4_basic {
public:

  typedef size_t size_type;
  typedef T      element_type;
  typedef T      float_type;

// allocators:

  tensor4_basic (const T& init_val = 0);
  tensor4_basic (const tensor4_basic<T>& a);

// affectation:

  tensor4_basic<T>& operator= (const tensor4_basic<T>& a);
  tensor4_basic<T>& operator= (const T& val);

// accessors:

  T&       operator()(size_type i, size_type j, size_type k, size_type l);
  const T& operator()(size_type i, size_type j, size_type k, size_type l) const;

// data:
protected:
  T _x [3][3][3][3];
};
typedef tensor4_basic<Float> tensor4;
//>tensor4:
// -----------------------------------------------------------------------
// inlined
// -----------------------------------------------------------------------
template<class T> struct  float_traits<tensor4_basic<T> > { typedef typename float_traits<T>::type type; };
template<class T> struct scalar_traits<tensor4_basic<T> > { typedef T type; };

template<class T>
inline
tensor4_basic<T>&
tensor4_basic<T>::operator= (const T& val)
{ 
    for (size_type i = 0; i < 3; i++)
    for (size_type j = 0; j < 3; j++)
    for (size_type k = 0; k < 3; k++)
    for (size_type l = 0; l < 3; l++)
      _x[i][j][k][l] = val;
    return *this;
}
template<class T>
inline
tensor4_basic<T>&
tensor4_basic<T>::operator= (const tensor4_basic<T>& a)
{
    for (size_type i = 0; i < 3; i++)
    for (size_type j = 0; j < 3; j++)
    for (size_type k = 0; k < 3; k++)
    for (size_type l = 0; l < 3; l++)
      _x[i][j][k][l] = a._x[i][j][k][l];
    return *this;
}
template<class T>
inline
tensor4_basic<T>::tensor4_basic (const T& init_val)
{ 
    operator= (init_val);
}
template<class T>
inline
tensor4_basic<T>::tensor4_basic (const tensor4_basic<T>& a)
{
    operator= (a);
}
template<class T>
inline
T&
tensor4_basic<T>::operator() (size_type i, size_type j, size_type k, size_type l)  
{
    return _x[i%3][j%3][k%3][l%3];
}
template<class T>
inline
const T&
tensor4_basic<T>::operator() (size_type i, size_type j, size_type k, size_type l) const
{
    return _x[i%3][j%3][k%3][l%3];
}

}// namespace rheolef
# endif /* _RHEOLEF_TENSOR4_H */
















