#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sinusprod.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  Float err_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  field uh; din >> uh;
  space Xh = uh.get_space();
  geo omega = Xh.get_geo();
  size_t k = Xh.degree();
  size_t d = omega.dimension();
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*k+1);
  Float err_l2 = sqrt(integrate (omega, sqr(uh-u(d)), qopt));
  space Xh1 (omega, "P"+itos(k+1)+"d");
  field eh = interpolate (Xh1, uh-u(d));
  Float err_linf = eh.max_abs();
  Float err_h1 = sqrt(integrate (omega, norm2(grad_h(eh)), qopt)
                    + integrate (omega.sides(), (1/h_local())*sqr(jump(eh)), qopt));
  derr << "err_l2   = " << err_l2 << endl
       << "err_linf = " << err_linf << endl
       << "err_h1   = " << err_h1 << endl;
  return (err_linf <= err_linf_expected) ? 0 : 1;
}
