#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "torus.icc"
int main (int argc, char**argv) {
  environment rheolef (argc, argv);
  geo gamma (argv[1]);
  space Wh (gamma, argv[2]);
  size_t d = gamma.dimension();
  form m (Wh, Wh, "mass");
  form a (Wh, Wh, "grad_grad");
  field b = m*field(Wh,1);
  field lh = riesz(Wh, f(d));
  csr<Float> A = {{  a.uu(),     b.u()},
                  {trans(b.u()),  0   }};
  vec<Float> B =  {  lh.u(),      0   };
  solver sa (A);
  vec<Float> U = sa.solve (B);
  field uh(Wh);
  uh.set_u() = U [range(0,uh.u().size())];
  dout << uh;
}
