#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sphere.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo gamma (argv[1]);
  space Wh (gamma, argv[2]);
  size_t d = gamma.dimension();
  form m (Wh, Wh, "mass");
  form a (Wh, Wh, "grad_grad");
  a = m + a;
  field lh = riesz(Wh, f(d));
  field uh (Wh);
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << uh;
}
