#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
DATA_DIR="${TOP_SRCDIR}/nfem/data"
NPROC_MAX=${NPROC_MAX-"7"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

ZDIFF="$TOP_SRCDIR/config/zdiff"

status=0

L="
carre-v1.geo
carre-v2.geo
bielle-v2.geo
line-dom-v2.geo
carre-dom-v2.geo
cube-dom-v2.geo
carre-tq-10-dom-v2.geo
extrude-TP-gmsh-dom-v2.geo
"
for geo in $L; do
  run "./geo_seq_tst ${SRCDIR}/$geo 2>/dev/null | diff -B -w ${SRCDIR}/$geo - >/dev/null"
  if test $? -ne 0; then status=1; fi
done


L="
line-dom
carre-dom
cube-dom
carre-tq-10-dom
extrude-TP-gmsh-dom
"
for geo in $L; do
  run "./geo_seq_tst ${SRCDIR}/$geo-v1.geo 2>/dev/null | diff -B -w ${SRCDIR}/$geo-v2.geo - >/dev/null"
  if test $? -ne 0; then status=1; fi
done


L="
tetra2.geo.gz
dodecaedre00.geo.gz
dodecaedre01.geo.gz
particule.geo.gz
bielle.geo.gz
"

for geo in $L; do
  run "./geo_seq_tst $DATA_DIR/$geo 2>/dev/null | $ZDIFF -B -w $DATA_DIR/$geo - >/dev/null"
  if test $? -ne 0; then status=1; fi
done
run "rm -f tmp.geo"
exit $status
