///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// spline interpolation
// Author: Jocelyn.Etienne@ujf-grenoble.fr
// Date:   5/12/2010
//
#include "rheolef/field.h"
#include "rheolef/form.h"
using namespace rheolef;
// calculate Hermite dofs with of ih defined on a Hermite space with blocked Lagrange dofs
// s.t. ih is C^2.
void
rheolef::calculate_spline(field& ih)
 {
     const space& S=ih.get_space();
     space V1h (S.get_geo(), "P1");
     space V1dh(S.get_geo(), "P1d");
     // characterisation of u in C2 with 0 BC on u'' :
     //   (u''', v) + (u'' v') = 0
     // with v in P1 since we have n+1 Hermite dofs.
     // Thus
     //   0 = < Dm M^{-1} D^2 U, V >_P1xP1 + < D^2 U, M^{-1} D V >_P1xP1 
     // <=>
     //   0 = < ( Dm M^{-1} D^2 + D^T M^{-1} D^2 ) U, V >_P1xP1 
    form invm (V1dh, V1dh, "inv_mass");
    form D  (V1h, V1dh, "d_ds");
    form D2 (S,   V1dh, "d2_ds2");
    form Dm (V1dh,V1h, "d_ds");
    form a = Dm*invm*D2 + trans(D)*invm*D2;
    // a.uu and a.ub are both tri-diagonal matrices, plus upper right and lower left 
    // corners in the periodic case
    ssk<Float> fact=ldlt(a.uu);
    ih.u=fact.solve(-1*(a.ub*ih.b));
 }
