// file automatically generated by "basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1.h"
using namespace rheolef;
using namespace std;
class basis_P1_p {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_e {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_t {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_q {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_T {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_P {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P1_H {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
basis_rep::dof_family_type
basis_P1_p::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_p::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = 1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_p::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_p::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_p::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] = 1.0;
}
void
basis_P1_p::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
}
void
basis_P1_p::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_p::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point();
}
basis_rep::dof_family_type
basis_P1_e::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_e::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val = hat_x[0];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_e::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] = -1.0;
      return val;
    }
    case 1: {
      val[0] = 1.0;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_e::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_e::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(2);
  typedef Float T;
  values[0] = -hat_x[0]+1.0;
  values[1] = hat_x[0];
}
void
basis_P1_e::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(2);
  typedef Float T;
  values[0][0] = -1.0;
  values[1][0] = 1.0;
}
void
basis_P1_e::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(2,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_e::hat_node(
  vector<point>& x)
{
  x.resize(2);
  x[0] = point(0.0);
  x[1] = point(1.0);
}
basis_rep::dof_family_type
basis_P1_t::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_t::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[1]-hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val = hat_x[0];
      return val;
    }
    case 2: {
      val = hat_x[1];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_t::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] = -1.0;
      val[1] = -1.0;
      return val;
    }
    case 1: {
      val[0] = 1.0;
      val[1] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] = 1.0;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_t::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_t::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(3);
  typedef Float T;
  values[0] = -hat_x[0]-hat_x[1]+1.0;
  values[1] = hat_x[0];
  values[2] = hat_x[1];
}
void
basis_P1_t::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(3);
  typedef Float T;
  values[0][0] = -1.0;
  values[0][1] = -1.0;
  values[1][0] = 1.0;
  values[1][1] = 0.0;
  values[2][0] = 0.0;
  values[2][1] = 1.0;
}
void
basis_P1_t::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(3,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_t::hat_node(
  vector<point>& x)
{
  x.resize(3);
  x[0] = point(0.0, 0.0);
  x[1] = point(1.0, 0.0);
  x[2] = point(0.0, 1.0);
}
basis_rep::dof_family_type
basis_P1_q::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_q::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[0]/4.0-hat_x[1]/4.0+hat_x[0]*hat_x[1]/4.0+(1.0/4.0);
      return val;
    }
    case 1: {
      val = -hat_x[1]/4.0+hat_x[0]/4.0-hat_x[1]*hat_x[0]/4.0+(1.0/4.0);
      return val;
    }
    case 2: {
      val =  hat_x[0]/4.0+hat_x[1]/4.0+hat_x[0]*hat_x[1]/4.0+(1.0/4.0);
      return val;
    }
    case 3: {
      val = -hat_x[1]*hat_x[0]/4.0+hat_x[1]/4.0-hat_x[0]/4.0+(1.0/4.0);
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_q::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  hat_x[1]/4.0-(1.0/4.0);
      val[1] =  hat_x[0]/4.0-(1.0/4.0);
      return val;
    }
    case 1: {
      val[0] = -hat_x[1]/4.0+(1.0/4.0);
      val[1] = -hat_x[0]/4.0-(1.0/4.0);
      return val;
    }
    case 2: {
      val[0] =  hat_x[1]/4.0+(1.0/4.0);
      val[1] =  hat_x[0]/4.0+(1.0/4.0);
      return val;
    }
    case 3: {
      val[0] = -hat_x[1]/4.0-(1.0/4.0);
      val[1] = -hat_x[0]/4.0+(1.0/4.0);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_q::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_q::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(4);
  typedef Float T;
  values[0] =  hat_x[0]*hat_x[1]/4.0-hat_x[0]/4.0-hat_x[1]/4.0+(1.0/4.0);
  values[1] =  hat_x[0]/4.0-hat_x[1]/4.0-hat_x[0]*hat_x[1]/4.0+(1.0/4.0);
  values[2] =  hat_x[1]/4.0+hat_x[0]/4.0+hat_x[1]*hat_x[0]/4.0+(1.0/4.0);
  values[3] = -hat_x[0]/4.0+hat_x[1]/4.0-hat_x[0]*hat_x[1]/4.0+(1.0/4.0);
}
void
basis_P1_q::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(4);
  typedef Float T;
  values[0][0] =  hat_x[1]/4.0-(1.0/4.0);
  values[0][1] =  hat_x[0]/4.0-(1.0/4.0);
  values[1][0] = -hat_x[1]/4.0+(1.0/4.0);
  values[1][1] = -hat_x[0]/4.0-(1.0/4.0);
  values[2][0] =  hat_x[1]/4.0+(1.0/4.0);
  values[2][1] =  hat_x[0]/4.0+(1.0/4.0);
  values[3][0] = -hat_x[1]/4.0-(1.0/4.0);
  values[3][1] = -hat_x[0]/4.0+(1.0/4.0);
}
void
basis_P1_q::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(4,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_q::hat_node(
  vector<point>& x)
{
  x.resize(4);
  x[0] = point(-1.0, -1.0);
  x[1] = point(1.0, -1.0);
  x[2] = point(1.0, 1.0);
  x[3] = point(-1.0, 1.0);
}
basis_rep::dof_family_type
basis_P1_T::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_T::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[0]-hat_x[1]-hat_x[2]+1.0;
      return val;
    }
    case 1: {
      val = hat_x[0];
      return val;
    }
    case 2: {
      val = hat_x[1];
      return val;
    }
    case 3: {
      val = hat_x[2];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_T::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] = -1.0;
      val[1] = -1.0;
      val[2] = -1.0;
      return val;
    }
    case 1: {
      val[0] = 1.0;
      val[1] = 0.0;
      val[2] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] = 1.0;
      val[2] = 0.0;
      return val;
    }
    case 3: {
      val[0] = 0.0;
      val[1] = 0.0;
      val[2] = 1.0;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_T::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_T::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(4);
  typedef Float T;
  values[0] = -hat_x[2]-hat_x[0]-hat_x[1]+1.0;
  values[1] = hat_x[0];
  values[2] = hat_x[1];
  values[3] = hat_x[2];
}
void
basis_P1_T::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(4);
  typedef Float T;
  values[0][0] = -1.0;
  values[0][1] = -1.0;
  values[0][2] = -1.0;
  values[1][0] = 1.0;
  values[1][1] = 0.0;
  values[1][2] = 0.0;
  values[2][0] = 0.0;
  values[2][1] = 1.0;
  values[2][2] = 0.0;
  values[3][0] = 0.0;
  values[3][1] = 0.0;
  values[3][2] = 1.0;
}
void
basis_P1_T::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(4,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_T::hat_node(
  vector<point>& x)
{
  x.resize(4);
  x[0] = point(0.0, 0.0, 0.0);
  x[1] = point(1.0, 0.0, 0.0);
  x[2] = point(0.0, 1.0, 0.0);
  x[3] = point(0.0, 0.0, 1.0);
}
basis_rep::dof_family_type
basis_P1_P::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_P::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[1]/2.0+hat_x[2]*hat_x[0]/2.0-hat_x[2]/2.0+hat_x[1]*hat_x[2]/2.0-hat_x[0]/2.0+(1.0/2.0);
      return val;
    }
    case 1: {
      val = -hat_x[2]*hat_x[0]/2.0+hat_x[0]/2.0;
      return val;
    }
    case 2: {
      val =  hat_x[1]/2.0-hat_x[1]*hat_x[2]/2.0;
      return val;
    }
    case 3: {
      val = -hat_x[2]*hat_x[1]/2.0+hat_x[2]/2.0-hat_x[0]/2.0-hat_x[2]*hat_x[0]/2.0-hat_x[1]/2.0+(1.0/2.0);
      return val;
    }
    case 4: {
      val =  hat_x[2]*hat_x[0]/2.0+hat_x[0]/2.0;
      return val;
    }
    case 5: {
      val =  hat_x[1]/2.0+hat_x[2]*hat_x[1]/2.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_P::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  hat_x[2]/2.0-(1.0/2.0);
      val[1] =  hat_x[2]/2.0-(1.0/2.0);
      val[2] =  hat_x[0]/2.0+hat_x[1]/2.0-(1.0/2.0);
      return val;
    }
    case 1: {
      val[0] = -hat_x[2]/2.0+(1.0/2.0);
      val[1] = 0.0;
      val[2] = -(1.0/2.0)*hat_x[0];
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] = -hat_x[2]/2.0+(1.0/2.0);
      val[2] = -(1.0/2.0)*hat_x[1];
      return val;
    }
    case 3: {
      val[0] = -hat_x[2]/2.0-(1.0/2.0);
      val[1] = -hat_x[2]/2.0-(1.0/2.0);
      val[2] = -hat_x[0]/2.0-hat_x[1]/2.0+(1.0/2.0);
      return val;
    }
    case 4: {
      val[0] =  hat_x[2]/2.0+(1.0/2.0);
      val[1] = 0.0;
      val[2] = (1.0/2.0)*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = 0.0;
      val[1] =  hat_x[2]/2.0+(1.0/2.0);
      val[2] = (1.0/2.0)*hat_x[1];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_P::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_P::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(6);
  typedef Float T;
  values[0] = -hat_x[2]/2.0+hat_x[2]*hat_x[0]/2.0-hat_x[0]/2.0+hat_x[2]*hat_x[1]/2.0-hat_x[1]/2.0+(1.0/2.0);
  values[1] = -hat_x[2]*hat_x[0]/2.0+hat_x[0]/2.0;
  values[2] = -hat_x[2]*hat_x[1]/2.0+hat_x[1]/2.0;
  values[3] = -hat_x[0]*hat_x[2]/2.0-hat_x[0]/2.0-hat_x[1]*hat_x[2]/2.0-hat_x[1]/2.0+hat_x[2]/2.0+(1.0/2.0);
  values[4] =  hat_x[0]*hat_x[2]/2.0+hat_x[0]/2.0;
  values[5] =  hat_x[1]*hat_x[2]/2.0+hat_x[1]/2.0;
}
void
basis_P1_P::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(6);
  typedef Float T;
  values[0][0] =  hat_x[2]/2.0-(1.0/2.0);
  values[0][1] =  hat_x[2]/2.0-(1.0/2.0);
  values[0][2] =  hat_x[0]/2.0+hat_x[1]/2.0-(1.0/2.0);
  values[1][0] = -hat_x[2]/2.0+(1.0/2.0);
  values[1][1] = 0.0;
  values[1][2] = -(1.0/2.0)*hat_x[0];
  values[2][0] = 0.0;
  values[2][1] = -hat_x[2]/2.0+(1.0/2.0);
  values[2][2] = -(1.0/2.0)*hat_x[1];
  values[3][0] = -hat_x[2]/2.0-(1.0/2.0);
  values[3][1] = -hat_x[2]/2.0-(1.0/2.0);
  values[3][2] = -hat_x[1]/2.0-hat_x[0]/2.0+(1.0/2.0);
  values[4][0] =  hat_x[2]/2.0+(1.0/2.0);
  values[4][1] = 0.0;
  values[4][2] = (1.0/2.0)*hat_x[0];
  values[5][0] = 0.0;
  values[5][1] =  hat_x[2]/2.0+(1.0/2.0);
  values[5][2] = (1.0/2.0)*hat_x[1];
}
void
basis_P1_P::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(6,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_P::hat_node(
  vector<point>& x)
{
  x.resize(6);
  x[0] = point(0.0, 0.0, -1.0);
  x[1] = point(1.0, 0.0, -1.0);
  x[2] = point(0.0, 1.0, -1.0);
  x[3] = point(0.0, 0.0, 1.0);
  x[4] = point(1.0, 0.0, 1.0);
  x[5] = point(0.0, 1.0, 1.0);
}
basis_rep::dof_family_type
basis_P1_H::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P1_H::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = -hat_x[2]*hat_x[0]*hat_x[1]/8.0-hat_x[2]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[0]*hat_x[1]/8.0-hat_x[0]/8.0-hat_x[1]/8.0+hat_x[2]*hat_x[1]/8.0+(1.0/8.0);
      return val;
    }
    case 1: {
      val =  hat_x[0]/8.0+hat_x[0]*hat_x[1]*hat_x[2]/8.0-hat_x[0]*hat_x[2]/8.0-hat_x[1]/8.0+hat_x[1]*hat_x[2]/8.0-hat_x[0]*hat_x[1]/8.0-hat_x[2]/8.0+(1.0/8.0);
      return val;
    }
    case 2: {
      val = -hat_x[0]*hat_x[2]/8.0-hat_x[0]*hat_x[1]*hat_x[2]/8.0+hat_x[0]/8.0-hat_x[1]*hat_x[2]/8.0+hat_x[1]/8.0-hat_x[2]/8.0+hat_x[0]*hat_x[1]/8.0+(1.0/8.0);
      return val;
    }
    case 3: {
      val = -hat_x[0]*hat_x[1]/8.0-hat_x[0]/8.0-hat_x[1]*hat_x[2]/8.0+hat_x[1]/8.0+hat_x[0]*hat_x[2]/8.0+hat_x[0]*hat_x[1]*hat_x[2]/8.0-hat_x[2]/8.0+(1.0/8.0);
      return val;
    }
    case 4: {
      val = -hat_x[1]*hat_x[2]/8.0-hat_x[0]/8.0+hat_x[0]*hat_x[1]/8.0-hat_x[1]/8.0+hat_x[0]*hat_x[1]*hat_x[2]/8.0+hat_x[2]/8.0-hat_x[0]*hat_x[2]/8.0+(1.0/8.0);
      return val;
    }
    case 5: {
      val =  hat_x[0]/8.0-hat_x[1]/8.0-hat_x[0]*hat_x[1]/8.0+hat_x[2]/8.0+hat_x[0]*hat_x[2]/8.0-hat_x[0]*hat_x[1]*hat_x[2]/8.0-hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
      return val;
    }
    case 6: {
      val =  hat_x[1]*hat_x[2]/8.0+hat_x[1]/8.0+hat_x[1]*hat_x[0]/8.0+hat_x[2]/8.0+hat_x[1]*hat_x[2]*hat_x[0]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0+(1.0/8.0);
      return val;
    }
    case 7: {
      val = -hat_x[0]/8.0+hat_x[1]/8.0-hat_x[0]*hat_x[1]/8.0-hat_x[0]*hat_x[2]/8.0+hat_x[2]/8.0-hat_x[0]*hat_x[1]*hat_x[2]/8.0+hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P1_H::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] = -hat_x[1]*hat_x[2]/8.0+hat_x[1]/8.0+hat_x[2]/8.0-(1.0/8.0);
      val[1] =  hat_x[2]/8.0-hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
      val[2] =  hat_x[1]/8.0-hat_x[1]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
      return val;
    }
    case 1: {
      val[0] = -hat_x[1]/8.0+hat_x[1]*hat_x[2]/8.0-hat_x[2]/8.0+(1.0/8.0);
      val[1] =  hat_x[2]*hat_x[0]/8.0+hat_x[2]/8.0-hat_x[0]/8.0-(1.0/8.0);
      val[2] =  hat_x[1]/8.0+hat_x[1]*hat_x[0]/8.0-hat_x[0]/8.0-(1.0/8.0);
      return val;
    }
    case 2: {
      val[0] =  hat_x[1]/8.0-hat_x[2]/8.0-hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
      val[1] = -hat_x[2]/8.0+hat_x[0]/8.0-hat_x[2]*hat_x[0]/8.0+(1.0/8.0);
      val[2] = -hat_x[0]/8.0-hat_x[0]*hat_x[1]/8.0-hat_x[1]/8.0-(1.0/8.0);
      return val;
    }
    case 3: {
      val[0] = -hat_x[1]/8.0+hat_x[1]*hat_x[2]/8.0+hat_x[2]/8.0-(1.0/8.0);
      val[1] = -hat_x[2]/8.0+hat_x[2]*hat_x[0]/8.0-hat_x[0]/8.0+(1.0/8.0);
      val[2] =  hat_x[0]*hat_x[1]/8.0+hat_x[0]/8.0-hat_x[1]/8.0-(1.0/8.0);
      return val;
    }
    case 4: {
      val[0] = -hat_x[2]/8.0+hat_x[1]/8.0+hat_x[2]*hat_x[1]/8.0-(1.0/8.0);
      val[1] = -hat_x[2]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
      val[2] = -hat_x[0]/8.0-hat_x[1]/8.0+hat_x[0]*hat_x[1]/8.0+(1.0/8.0);
      return val;
    }
    case 5: {
      val[0] = -hat_x[1]/8.0-hat_x[1]*hat_x[2]/8.0+hat_x[2]/8.0+(1.0/8.0);
      val[1] = -hat_x[0]/8.0-hat_x[2]/8.0-hat_x[0]*hat_x[2]/8.0-(1.0/8.0);
      val[2] =  hat_x[0]/8.0-hat_x[0]*hat_x[1]/8.0-hat_x[1]/8.0+(1.0/8.0);
      return val;
    }
    case 6: {
      val[0] =  hat_x[1]/8.0+hat_x[2]/8.0+hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
      val[1] =  hat_x[2]*hat_x[0]/8.0+hat_x[2]/8.0+hat_x[0]/8.0+(1.0/8.0);
      val[2] =  hat_x[1]/8.0+hat_x[0]/8.0+hat_x[1]*hat_x[0]/8.0+(1.0/8.0);
      return val;
    }
    case 7: {
      val[0] = -hat_x[1]/8.0-hat_x[2]/8.0-hat_x[1]*hat_x[2]/8.0-(1.0/8.0);
      val[1] =  hat_x[2]/8.0-hat_x[0]/8.0-hat_x[2]*hat_x[0]/8.0+(1.0/8.0);
      val[2] =  hat_x[1]/8.0-hat_x[1]*hat_x[0]/8.0-hat_x[0]/8.0+(1.0/8.0);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P1_H::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P1");
  return val;
}
void
basis_P1_H::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(8);
  typedef Float T;
  values[0] =  hat_x[2]*hat_x[1]/8.0-hat_x[2]/8.0+hat_x[2]*hat_x[0]/8.0-hat_x[0]/8.0+hat_x[0]*hat_x[1]/8.0-hat_x[2]*hat_x[0]*hat_x[1]/8.0-hat_x[1]/8.0+(1.0/8.0);
  values[1] = -hat_x[2]*hat_x[0]/8.0+hat_x[1]*hat_x[2]/8.0-hat_x[1]/8.0-hat_x[2]/8.0+hat_x[1]*hat_x[2]*hat_x[0]/8.0-hat_x[1]*hat_x[0]/8.0+hat_x[0]/8.0+(1.0/8.0);
  values[2] =  hat_x[1]/8.0-hat_x[2]/8.0-hat_x[2]*hat_x[0]/8.0-hat_x[1]*hat_x[2]/8.0-hat_x[1]*hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0+hat_x[1]*hat_x[0]/8.0+(1.0/8.0);
  values[3] =  hat_x[1]/8.0-hat_x[1]*hat_x[2]/8.0-hat_x[2]/8.0-hat_x[1]*hat_x[0]/8.0-hat_x[0]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[1]*hat_x[2]*hat_x[0]/8.0+(1.0/8.0);
  values[4] = -hat_x[2]*hat_x[1]/8.0+hat_x[2]/8.0+hat_x[0]*hat_x[1]/8.0-hat_x[0]/8.0+hat_x[2]*hat_x[0]*hat_x[1]/8.0-hat_x[2]*hat_x[0]/8.0-hat_x[1]/8.0+(1.0/8.0);
  values[5] =  hat_x[2]*hat_x[0]/8.0+hat_x[2]/8.0-hat_x[0]*hat_x[1]/8.0+hat_x[0]/8.0-hat_x[2]*hat_x[0]*hat_x[1]/8.0-hat_x[1]/8.0-hat_x[2]*hat_x[1]/8.0+(1.0/8.0);
  values[6] =  hat_x[2]*hat_x[1]/8.0+hat_x[0]*hat_x[1]/8.0+hat_x[2]/8.0+hat_x[2]*hat_x[0]*hat_x[1]/8.0+hat_x[0]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[1]/8.0+(1.0/8.0);
  values[7] =  hat_x[2]/8.0-hat_x[0]*hat_x[1]/8.0-hat_x[2]*hat_x[0]*hat_x[1]/8.0-hat_x[2]*hat_x[0]/8.0-hat_x[0]/8.0+hat_x[2]*hat_x[1]/8.0+hat_x[1]/8.0+(1.0/8.0);
}
void
basis_P1_H::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(8);
  typedef Float T;
  values[0][0] =  hat_x[2]/8.0-hat_x[2]*hat_x[1]/8.0+hat_x[1]/8.0-(1.0/8.0);
  values[0][1] =  hat_x[2]/8.0-hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
  values[0][2] =  hat_x[0]/8.0+hat_x[1]/8.0-hat_x[0]*hat_x[1]/8.0-(1.0/8.0);
  values[1][0] =  hat_x[1]*hat_x[2]/8.0-hat_x[1]/8.0-hat_x[2]/8.0+(1.0/8.0);
  values[1][1] = -hat_x[0]/8.0+hat_x[2]/8.0+hat_x[0]*hat_x[2]/8.0-(1.0/8.0);
  values[1][2] = -hat_x[0]/8.0+hat_x[1]/8.0+hat_x[0]*hat_x[1]/8.0-(1.0/8.0);
  values[2][0] =  hat_x[1]/8.0-hat_x[2]/8.0-hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
  values[2][1] = -hat_x[2]/8.0-hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0+(1.0/8.0);
  values[2][2] = -hat_x[1]/8.0-hat_x[1]*hat_x[0]/8.0-hat_x[0]/8.0-(1.0/8.0);
  values[3][0] = -hat_x[1]/8.0+hat_x[2]/8.0+hat_x[1]*hat_x[2]/8.0-(1.0/8.0);
  values[3][1] = -hat_x[2]/8.0-hat_x[0]/8.0+hat_x[2]*hat_x[0]/8.0+(1.0/8.0);
  values[3][2] = -hat_x[1]/8.0+hat_x[1]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
  values[4][0] = -hat_x[2]/8.0+hat_x[1]/8.0+hat_x[2]*hat_x[1]/8.0-(1.0/8.0);
  values[4][1] = -hat_x[2]/8.0+hat_x[2]*hat_x[0]/8.0+hat_x[0]/8.0-(1.0/8.0);
  values[4][2] = -hat_x[1]/8.0+hat_x[1]*hat_x[0]/8.0-hat_x[0]/8.0+(1.0/8.0);
  values[5][0] = -hat_x[1]/8.0+hat_x[2]/8.0-hat_x[1]*hat_x[2]/8.0+(1.0/8.0);
  values[5][1] = -hat_x[2]/8.0-hat_x[2]*hat_x[0]/8.0-hat_x[0]/8.0-(1.0/8.0);
  values[5][2] = -hat_x[0]*hat_x[1]/8.0+hat_x[0]/8.0-hat_x[1]/8.0+(1.0/8.0);
  values[6][0] =  hat_x[2]/8.0+hat_x[1]/8.0+hat_x[2]*hat_x[1]/8.0+(1.0/8.0);
  values[6][1] =  hat_x[2]/8.0+hat_x[0]/8.0+hat_x[2]*hat_x[0]/8.0+(1.0/8.0);
  values[6][2] =  hat_x[0]/8.0+hat_x[0]*hat_x[1]/8.0+hat_x[1]/8.0+(1.0/8.0);
  values[7][0] = -hat_x[2]/8.0-hat_x[2]*hat_x[1]/8.0-hat_x[1]/8.0-(1.0/8.0);
  values[7][1] = -hat_x[0]/8.0-hat_x[0]*hat_x[2]/8.0+hat_x[2]/8.0+(1.0/8.0);
  values[7][2] = -hat_x[0]/8.0+hat_x[1]/8.0-hat_x[0]*hat_x[1]/8.0+(1.0/8.0);
}
void
basis_P1_H::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(8,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1_H::hat_node(
  vector<point>& x)
{
  x.resize(8);
  x[0] = point(-1.0, -1.0, -1.0);
  x[1] = point(1.0, -1.0, -1.0);
  x[2] = point(1.0, 1.0, -1.0);
  x[3] = point(-1.0, 1.0, -1.0);
  x[4] = point(-1.0, -1.0, 1.0);
  x[5] = point(1.0, -1.0, 1.0);
  x[6] = point(1.0, 1.0, 1.0);
  x[7] = point(-1.0, 1.0, 1.0);
}
basis_P1::~basis_P1()
{
}
basis_P1::size_type
basis_P1::degree () const
{
    return 1;
}
basis_P1::size_type
basis_P1::size (
    reference_element hat_K, basis_rep::dof_family_type family) const
{
    if (family!=reference_element::Lagrange && family!=reference_element::dof_family_max) return 0;
    switch (hat_K.type()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 2;
      }
      case reference_element::t: {
        return 3;
      }
      case reference_element::q: {
        return 4;
      }
      case reference_element::T: {
        return 4;
      }
      case reference_element::P: {
        return 6;
      }
      case reference_element::H: {
        return 8;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
basis_rep::dof_family_type
basis_P1::dof_family(
    reference_element hat_K,
    size_type         i_dof_local) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::dof_family (i_dof_local);
      }
      case reference_element::e: {
      return basis_P1_e::dof_family (i_dof_local);
      }
      case reference_element::t: {
      return basis_P1_t::dof_family (i_dof_local);
      }
      case reference_element::q: {
      return basis_P1_q::dof_family (i_dof_local);
      }
      case reference_element::T: {
      return basis_P1_T::dof_family (i_dof_local);
      }
      case reference_element::P: {
      return basis_P1_P::dof_family (i_dof_local);
      }
      case reference_element::H: {
      return basis_P1_H::dof_family (i_dof_local);
      }
      default : {
        error_macro ("dof_family: unsupported `" << hat_K.name() << "' element type");
        return reference_element::dof_family_max;
      }
    }
}
Float
basis_P1::eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P1_e::eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P1_t::eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P1_q::eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P1_T::eval (i_dof_local,hat_x);
      }
      case reference_element::P: {
      return basis_P1_P::eval (i_dof_local,hat_x);
      }
      case reference_element::H: {
      return basis_P1_H::eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
point
basis_P1::grad_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P1_e::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P1_t::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P1_q::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P1_T::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::P: {
      return basis_P1_P::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::H: {
      return basis_P1_H::grad_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
        return point();
      }
    }
}
basic_point<point>
basis_P1::hessian_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
  error_macro ("hessian_eval: invalid basis P1");
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  return ini_val;
}
void
basis_P1::eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<Float>&    values) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P1_e::eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P1_t::eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P1_q::eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P1_T::eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P1_P::eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P1_H::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P1::grad_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<point>&    values) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P1_e::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P1_t::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P1_q::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P1_T::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P1_P::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P1_H::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P1::hessian_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<basic_point<point> >&    values) const
{
  error_macro ("hessian_eval: invalid basis P1");
}
void
basis_P1::hat_node(
    reference_element hat_K,
    vector<point>&    hat_node) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P1_p::hat_node (hat_node);
      }
      case reference_element::e: {
      return basis_P1_e::hat_node (hat_node);
      }
      case reference_element::t: {
      return basis_P1_t::hat_node (hat_node);
      }
      case reference_element::q: {
      return basis_P1_q::hat_node (hat_node);
      }
      case reference_element::T: {
      return basis_P1_T::hat_node (hat_node);
      }
      case reference_element::P: {
      return basis_P1_P::hat_node (hat_node);
      }
      case reference_element::H: {
      return basis_P1_H::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
basis_rep* make_P1(void) { return new_macro(basis_P1); }
