# ifndef _RHEO_PARALLEL_H
# define _RHEO_PARALLEL_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/compiler.h"
struct sequential {};

#ifndef _RHEOLEF_HAVE_MPI
   // -----------------------------------------------------------------------
   // parallelized code & library should compile even without mpi
   // -----------------------------------------------------------------------
#  define rheo_default_memory_model sequential
   // emulate a minimal boost::mpi interface:
   struct environment { // as the boost::mpi::environment main interface, for portability
     environment (int& argc, char**& argv) {}
   };
   struct communicator {
     typedef std::vector<int>::size_type size_type;
     size_type rank() const { return 0; }
     size_type size() const { return 1; }
   };
#else
   // -----------------------------------------------------------------------
   // parallelized code here
   // -----------------------------------------------------------------------
   struct distributed {};
#  define rheo_default_memory_model distributed
#  include <mpi.h>
#  ifdef _RHEOLEF_HAVE_BOOST_MPI_HPP
#    include <boost/mpi.hpp>
     namespace rheolef {
       namespace mpi = boost::mpi;
       using mpi::environment;
       using mpi::communicator;
     } // namespace rheolef
#  else
#    error "boost.mpi library expected"
#  endif // _RHEOLEF_HAVE_BOOST_MPI_HPP

#endif // _RHEOLEF_HAVE_MPI

namespace rheolef {

} // namespace rheolef
# endif // _RHEO_PARALLEL_H
