#ifndef _RHEOLEF_INTERPOLATE_H
#define _RHEOLEF_INTERPOLATE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// interpolation with a class-function or a function
//
#include "rheolef/tensor.h"
namespace rheolef { 

template <class T, class Function>
field_basic<T> __interpolate_tag (const space_basic<T>& V, Function f, const T&)
{
  typedef typename field_basic<T>::size_type size_type;

  const geo_basic<T>& omega  = V.get_geo();
  const element<T>&   method = V.get_element() ;  
  field_basic<T> u (V);
  std::vector<bool> marked (V.size(), false);
  typename vec<T>::iterator xu = u.u().begin();
  typename vec<T>::iterator xb = u.b().begin();
  std::vector<size_type> par_idof_on_K;
  size_type par_first_idof = V.ownership().first_index();
  size_type par_last_idof  = V.ownership().last_index();
  for (size_type ie = 0, ne = omega.size(); ie < ne; ie++) {
      const geo_element& K = omega[ie];
      V.set_par_dof (K, par_idof_on_K);
      for (size_type loc_idof = 0, n = par_idof_on_K.size(); loc_idof < n; loc_idof++) {
	  size_type par_idof = par_idof_on_K [loc_idof];
	  if (par_idof < par_first_idof || par_idof >= par_last_idof) continue;
	  size_type idof = par_idof - par_first_idof;
	  if (marked [idof]) continue;
          marked [idof] = true;
	  Float value = momentum (method, f, loc_idof, K, omega);
	  size_type iub = V.iub (idof);
	  if (V.is_blocked(idof))
	    xb [iub] = value;
	  else
	    xu [iub] = value;
      }
  }
  return u;
}
template <class T, class Func>
inline
field_basic<T>
interpolate (const space_basic<T>& V, Func f) {
    typedef typename Func::result_type  result_type ;
    return __interpolate_tag (V, f, result_type());
}
// specialization for functions:
template <class T>
inline
field_basic<T>
interpolate (const space_basic<T>& V, T (*f)(const basic_point<T>&)) {
    return __interpolate_tag (V, f, T());
}

}// namespace rheolef
#endif // _RHEOLEF_INTERPOLATE_H
