///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/reference_element.h"
using namespace rheolef;
using namespace std;

#include "reference_element_declare.cc"

const reference_element::size_type reference_element::not_set
	= numeric_limits<size_type>::max();

// ------------------------------------------
// measure
// ------------------------------------------
static
Float
hat_K_measure [reference_element::max_size+1] = {
        1, 	// p
        1, 	// e
        1./2, 	// t
        4,	// q
        1./6,	// T
        1,	// P
        8,      // H
	0       // undef
};
Float
measure (reference_element hat_K) {
    return hat_K_measure [hat_K.type()];
}
// ------------------------------------------
void
reference_element::set_name (char name)
{
    unsigned int i = 0;
    for (; i < max_size; i++) {
        if (_name [i] == name) {
            _x = enum_type(i);
            break;
        }
    }
    if (i == max_size) {
        error_macro ("undefined reference element `" << name << "'");
    }
}
void
reference_element::set_type (size_type n_vertex, size_type dim)
{
    unsigned int i = 0;
    for (; i < max_size; i++) {

        if (_dimension[i] == dim && _n_subgeo [i][0] == n_vertex) {
            _x = enum_type(i);
            break;
        }
    }
    if (i == max_size) {
        error_macro ("undefined reference element with n_vertex = "
        << n_vertex << " in " << dim << "D");
    }
}

