///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1pw_numbering.h"
using namespace rheolef;
using namespace std;

numbering_P1pw::numbering_P1pw()
 : numbering_rep(), has_K_special(false), nb_interface_nodes(0), K_special()
{
}
std::string
numbering_P1pw::name() const
{
  return "P1pw";
}
void
numbering_P1pw::initialize(size_type _nb_interface_nodes,
        std::map<size_type,tiny_vector<size_type> > special_elements) const
{
    has_K_special=true;
    nb_interface_nodes=_nb_interface_nodes;
    K_special=special_elements;
}
numbering_P1pw::size_type
numbering_P1pw::ndof (
               size_type  mesh_map_dimension,
         const size_type* mesh_n_geo,
         const size_type* mesh_n_element) const
{
        // number of vertices
        return mesh_n_geo[0]+nb_interface_nodes;
}
numbering_P1pw::size_type 
numbering_P1pw::idof (   
         const size_type*      mesh_n_geo,
         const size_type*      mesh_n_element,
         const geo_element&    K, 
         size_type             i_dof_local) const
{
        std::map<size_type,tiny_vector<size_type> >::const_iterator iK = K_special.find(K.index());
        if (iK==K_special.end())
                return K [i_dof_local];
        else
         {	
                if ((*iK).second[i_dof_local]==std::numeric_limits<size_type>::max())
                        return K [i_dof_local];
                else
                        return mesh_n_geo[0]+(*iK).second[i_dof_local];
         }
}
void
numbering_P1pw::idof (   
        const size_type*        mesh_n_geo,
        const size_type*        mesh_n_element,
        const geo_element&      K, 
	std::vector<size_type>& i_dof) const
{
  for (size_type i_dof_local = 0; i_dof_local < K.size(); i_dof_local++)
    i_dof[i_dof_local]
     = numbering_P1pw::idof (mesh_n_geo, mesh_n_element, K, i_dof_local);
}
