# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Splash screen handling routines
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

package provide splash 1.0

set splashDelay 3

proc displaySplash { splashImage } {
    global hideSplashAfterId
    global splashStartTime
    global splashDelay

    wm withdraw .

    toplevel .placard -background black -borderwidth 2 -relief flat
    wm overrideredirect .placard yes
    wm withdraw .placard

    frame .placard.info -borderwidth 2 -relief raised
    pack .placard.info

    label .placard.info.logo -image $splashImage
    pack .placard.info.logo

    update idletasks
    set x [expr ([winfo screenwidth .]-[winfo reqwidth .placard]) / 2]
    set y [expr ([winfo screenheight .]-[winfo reqheight .placard]) / 2]
    wm geometry .placard "+$x+$y"

    update
    wm deiconify .placard
    update

    set hideSplashAfterId [after [expr $splashDelay * 1000] _hideSplash 1 0]
    set splashStartTime [clock seconds]

    # Add a binding to hide the splash screen prematurely if it is 
    # clicked on

    bind .placard.info.logo <ButtonRelease-1> "_hideSplash 0 1"
}

# Wrapper to _hideSplash (real routine) -- lets _hideSplash know it is being
# called explicity rather than via the after

proc hideSplash {} {
    _hideSplash 0 0
}

# proc _hideSplash:
# First Argument isAfterDelay: True if this splash hide is being triggered by
# the delay time after event.
# Second Argument: True if this splash hide is being triggered by explicit user
# request (i.e. click on splash).

# Splash is only hidden after minimum splash display time is elapsed
# or is immediately hidden after any hide request explicitly requested by
# the user. Note that therefore an automated hide may incur a wait for minimum
# display time to elapsed before the splash display is hidden. However, a user
# requested splash hide never incurs such a wait.

proc _hideSplash { isAfterDelay isExplicit } {
    global hideSplashAfterId
    global splashStartTime
    global splashDelay
    global configDone
    
    # If we finished before the delay is elapsed, then cancel the after
    # event to avoid two calls to _hideSplash

    if {!$isAfterDelay || $isExplicit} {
	after cancel $hideSplashAfterId

	# Sleep to finish up the delay (so we get to see the
	# splash, even on fast machines / clusters)
	# Don't do the sleep if the user explicitly forced the splash to
	# be hidden

	if { !$isExplicit } {
	    after [expr ($splashDelay - [clock seconds] + $splashStartTime) * 1000]
	}
    }

    update
    destroy .placard
    wm geometry . 800x520
}

# End of file



