
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <xclass/OXClient.h>
#include <xclass/OXTransientFrame.h>
#include <xclass/OXIcon.h>
#include <xclass/OXTextButton.h>
#include <xclass/OXComboBox.h>
#include <xclass/OXLabel.h>
#include <X11/Xatom.h>

#include "../icons/connect.xpm"


static OXClient *clientX;


void connect( unsigned char *client )
{
    Atom prop = XInternAtom( clientX->GetDisplay(), "VNC_CONNECT", False);

    XChangeProperty( clientX->GetDisplay(),
                     clientX->GetRoot()->GetId(),
                     prop, XA_STRING, 8, PropModeReplace,
                     client, strlen((char*) client) );
}


class OXAppMainFrame
  : public OXTransientFrame
{
    protected:
        OXComboBox *comboBoxViewer;

    public:
        OXAppMainFrame( const OXWindow *p )
          : OXTransientFrame( p, new OXMainFrame( p, 16, 16 ), 16, 16,
                              HORIZONTAL_FRAME )
        {
  	    char tmp[2048];
            strcpy( tmp, "Connect to VNC Viewer" );
 	    SetWindowName( tmp );
            SetIconName( tmp );

            OXIcon *icon = new OXIcon( this, _client->GetPicture("", connect_xpm ), 16, 16 );
            AddFrame( icon, new OLayoutHints( LHINTS_LEFT | LHINTS_TOP, 8, 8, 8, 8 ) );


            OXCompositeFrame *viewerFrame = new OXVerticalFrame( this, 16, 16 );
            AddFrame( viewerFrame, new OLayoutHints( LHINTS_EXPAND_X | LHINTS_TOP, 8, 8, 8 ) );

            OXLabel *labelViewer = new OXLabel( viewerFrame, new OString( "VNC Viewer:" ) );
            viewerFrame->AddFrame( labelViewer, new OLayoutHints( LHINTS_TOP | LHINTS_LEFT ) );
            
            comboBoxViewer = new OXComboBox( viewerFrame, "viewer", 1000 );
            viewerFrame->AddFrame( comboBoxViewer, new OLayoutHints( LHINTS_TOP | LHINTS_EXPAND_X ) );
            comboBoxViewer->SetWidth( 200 );

            OXCompositeFrame *buttonFrame = new OXVerticalFrame( this, 16, 16 );
            AddFrame( buttonFrame, new OLayoutHints( LHINTS_RIGHT | LHINTS_TOP, 8, 8, 8, 8 ) );
            
            OXButton *buttonAccept = new OXTextButton( buttonFrame, new OString( "OK" ), 100 );
            buttonFrame->AddFrame( buttonAccept, new OLayoutHints( LHINTS_TOP | LHINTS_EXPAND_X ) );
            OXButton *buttonCancel = new OXTextButton( buttonFrame, new OString( " Cancel " ), 101 );
            buttonFrame->AddFrame( buttonCancel, new OLayoutHints( LHINTS_TOP | LHINTS_EXPAND_X, 0, 0, 4 ) );
            buttonAccept->Associate( this );
            buttonCancel->Associate( this );

            SetDefaultAcceptButton( buttonAccept );
            SetDefaultCancelButton( buttonCancel );

   	    MapSubwindows();
            Resize( GetDefaultSize() );
            Layout();
            Move( (_client->GetDisplayWidth() - GetWidth()) / 2,
                  (_client->GetDisplayHeight() - GetHeight()) / 2 );

            SetFocusOwner( comboBoxViewer->GetTextEntry() );

            MapWindow();
            _client->WaitFor(this);
            
        }

        virtual int ProcessMessage(OMessage *msg) {
            OWidgetMessage *wmsg = (OWidgetMessage *) msg;
 
            // Button Accept
            if ((msg->type == MSG_BUTTON) &&
                (msg->action == MSG_CLICK) &&
                (wmsg->id == 100)) {
              	UnmapWindow();
                char tmp[256];
                strncpy( tmp, comboBoxViewer->GetTextEntry()->GetString(), 255 );
                connect( (unsigned char*) tmp );
    	        delete this;
            }
            else
            // Button Cancel
            if ((msg->type == MSG_BUTTON) &&
                (msg->action == MSG_CLICK) &&
                (wmsg->id == 101)) {
      	        delete this;
            }
            return true;
        }
};



void xconnect()
{
    new OXAppMainFrame( clientX->GetRoot() );
}


static char *programName;

void usage()
{
    fprintf(stderr, "usage: %s [-display display] [host[:port]]\n"
	            "Connects the display to a listening VNC viewer"
                    " on the given host and port\n",
	    programName);
    exit(1);
}

int main( int argc, char **argv )
{
    char *displayname = NULL;
    int i;

    programName = argv[0];
    
    for (i = 1; i < argc; i++) {
	if (argv[i][0] != '-')
	    break;

	switch (argv[i][1]) {
	case 'd':			/* -display dpyname */
	    if (++i >= argc) usage();
	    displayname = argv[i];
	    break;
	default:
	    usage();
	}
    }

    clientX = new OXClient( displayname );

    if ( !clientX->GetDisplay() ) {
	fprintf(stderr,"%s: unable to open display \"%s\"\n",
		programName, XDisplayName (displayname));
	exit(1);
    }

    if (argc != i+1)
	xconnect();
    else
        connect( (unsigned char*) argv[i] );

    delete clientX;
    return 0;
}
