/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef _hexonet_RFMacroRecorder_h_
#define _hexonet_RFMacroRecorder_h_

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>

#include "rfb.h"

namespace rfb {

class RFMacroRecorder
{
  public:
    RFMacroRecorder( char* _filename );
    RFMacroRecorder( int _fd );
    ~RFMacroRecorder();

    void recordKeyDown( CARD32 keysym );
    void recordKeyUp( CARD32 keysym );

    void recordPointer( CARD16 x, CARD16 y );

    void recordButtonDown( int button );
    void recordButtonUp( int button );

    void record( unsigned char* _data, unsigned int _size );
    void flush();

    void startTimer();
    void stopTimer();
    void updateTimestamp();

  private:
    void writeHeader();
  
    int fd;
    bool timer;
    CARD32 timestamp;
    struct timeval tvStart;
    unsigned char* buffer;
    unsigned int pos;
    bool delay;
};


} // namespace rfb

#endif // _hexonet_RFMacroRecorder_h_
