repopush(1)
; 
; Copyright (c) 2021  Peter Pentchev <roam@ringlet.net>
; All rights reserved.
; 
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
; 1. Redistributions of source code must retain the above copyright
;    notice, this list of conditions and the following disclaimer.
; 2. Redistributions in binary form must reproduce the above copyright
;    notice, this list of conditions and the following disclaimer in the
;    documentation and/or other materials provided with the distribution.
; 
; THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
; SUCH DAMAGE.

# NAME

repopush - safely rsync a package repository to another location

# SYNOPSIS

*repopush* *[-Nv]* _/path/to/local/repo_ _remote_

*repopush* *[-Nv]* *[-f configfile]* *-s* _section_

# DESCRIPTION

The *repopush* tool is yet another program that helps with copying
the various package files and repository metadata from one OS package
repository to another, taking care to copy and remove files in such
a way as to never have the remote repository present an inconsistent view.
This is done by first copying the new package files, then copying the new
metadata files, then removing the outdated metadata files, and only then
removing the outdated package files.

The *repopush* tool supports APT and YUM repositories and figures out
which one to handle by analyzing the contents of the local repository.
This is one of the reasons why the latter must indeed be a directory on
a locally-mounted filesystem.

The *repopush* tool accepts the following command-line options:

- *-f* _configfile_ ++
  If the *-s* option is specified, the config file to read.
  The default is _$XDG_CONFIG_HOME_*/repopush.conf*
  (with a _$HOME_*/.config* default for _$XDG_CONFIG_HOME_).

- *-N* ++
  No-operation mode; display what would have been done.

- *-s* _section_ ++
  The config file section to read the *local* and *remote* variables from.

- *-v* ++
  Verbose mode; display diagnostic output.

There are two ways to specify the _local_ and _remote_ parameters:
directly on the command line or in a INI-style configuration file.
If the *-s* option is specified, *repopush* will use the *confget* tool to
read the configuration file (either the one specified by the *-f* option or
a default one in the user's home directory), look for the specified section,
and use the "local" and "remote" values from that section.

As noted above, the _local_ parameter should be a path to a directory.
The _remote_ parameter can be in any format that the *rsync* tool
accepts.

# FILES

If the _local_ and _remote_ parameters are specified on the command line,
the operation of the *repopush* tool is not affected by any files.

If a configuration section is specified via the *-s* option, *repopush* will
look for a configuration file (either one specified via the *-f* option or
a default one in the user's home directory) and treat it as an INI-style file
containing one or more sections.
See the documentation of the *confget* tool for more information about
the supported format of the INI-style files.

# EXAMPLES

Test-run a repository update:

	repopush -Nv /var/lib/repos/infra www:/var/www/repo/infra

Perform the actual update, a bit quieter:

	repopush /var/lib/repos/infra www:/var/www/repo/infra

The same, but with the "to-www-infra" section specified in
the _$HOME_*/.config/repopush.conf* file:

	repopush -s to-www-infra

To achieve the above result, the *repopush.conf* file should contain
a section like this:

```
[to-www-infra]
local=/var/lib/repos/infra
remote=www:/var/www/repo/infra
```

# HISTORY

The *repopush* tool was first written by Peter Pentchev in 2020.
This manual page was created in 2021.

# AUTHORS

Peter Pentchev <roam@ringlet.net>
