/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Baldur Karlsson
 * Copyright (c) 2014 Crytek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#pragma once

// in official/
/*
   grep -Eih '#define[ \t]*[A-Z_0-9]*[ \t]*0x[0-9A-F]{4,}\s*$' \
       gl32.h glcorearb.h glext.h glxext.h wglext.h gl3platform.h legacygl.h glesext.h \
       egl.h eglext.h eglplatform.h khrplatform.h |
       awk '{print $2" "$3}' | sed -e '{s%\(.*\) \(.*\)%  e\1 = \2,%g}' |
       awk ' !x[$0]++'
   */

enum RDCGLenum
{
  eGL_NONE = 0x0,
  eGL_DEPTH_BUFFER_BIT = 0x00000100,
  eGL_STENCIL_BUFFER_BIT = 0x00000400,
  eGL_COLOR_BUFFER_BIT = 0x00004000,
  eGL_POINTS = 0x0000,
  eGL_LINES = 0x0001,
  eGL_LINE_LOOP = 0x0002,
  eGL_LINE_STRIP = 0x0003,
  eGL_TRIANGLES = 0x0004,
  eGL_TRIANGLE_STRIP = 0x0005,
  eGL_TRIANGLE_FAN = 0x0006,
  eGL_SRC_COLOR = 0x0300,
  eGL_ONE_MINUS_SRC_COLOR = 0x0301,
  eGL_SRC_ALPHA = 0x0302,
  eGL_ONE_MINUS_SRC_ALPHA = 0x0303,
  eGL_DST_ALPHA = 0x0304,
  eGL_ONE_MINUS_DST_ALPHA = 0x0305,
  eGL_DST_COLOR = 0x0306,
  eGL_ONE_MINUS_DST_COLOR = 0x0307,
  eGL_SRC_ALPHA_SATURATE = 0x0308,
  eGL_FUNC_ADD = 0x8006,
  eGL_BLEND_EQUATION = 0x8009,
  eGL_BLEND_EQUATION_RGB = 0x8009,
  eGL_BLEND_EQUATION_ALPHA = 0x883D,
  eGL_FUNC_SUBTRACT = 0x800A,
  eGL_FUNC_REVERSE_SUBTRACT = 0x800B,
  eGL_BLEND_DST_RGB = 0x80C8,
  eGL_BLEND_SRC_RGB = 0x80C9,
  eGL_BLEND_DST_ALPHA = 0x80CA,
  eGL_BLEND_SRC_ALPHA = 0x80CB,
  eGL_CONSTANT_COLOR = 0x8001,
  eGL_ONE_MINUS_CONSTANT_COLOR = 0x8002,
  eGL_CONSTANT_ALPHA = 0x8003,
  eGL_ONE_MINUS_CONSTANT_ALPHA = 0x8004,
  eGL_BLEND_COLOR = 0x8005,
  eGL_ARRAY_BUFFER = 0x8892,
  eGL_ELEMENT_ARRAY_BUFFER = 0x8893,
  eGL_ARRAY_BUFFER_BINDING = 0x8894,
  eGL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895,
  eGL_STREAM_DRAW = 0x88E0,
  eGL_STATIC_DRAW = 0x88E4,
  eGL_DYNAMIC_DRAW = 0x88E8,
  eGL_BUFFER_SIZE = 0x8764,
  eGL_BUFFER_USAGE = 0x8765,
  eGL_CURRENT_VERTEX_ATTRIB = 0x8626,
  eGL_FRONT = 0x0404,
  eGL_BACK = 0x0405,
  eGL_FRONT_AND_BACK = 0x0408,
  eGL_TEXTURE_2D = 0x0DE1,
  eGL_CULL_FACE = 0x0B44,
  eGL_BLEND = 0x0BE2,
  eGL_DITHER = 0x0BD0,
  eGL_STENCIL_TEST = 0x0B90,
  eGL_DEPTH_TEST = 0x0B71,
  eGL_SCISSOR_TEST = 0x0C11,
  eGL_POLYGON_OFFSET_FILL = 0x8037,
  eGL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E,
  eGL_SAMPLE_COVERAGE = 0x80A0,
  eGL_INVALID_ENUM = 0x0500,
  eGL_INVALID_VALUE = 0x0501,
  eGL_INVALID_OPERATION = 0x0502,
  eGL_OUT_OF_MEMORY = 0x0505,
  eGL_CW = 0x0900,
  eGL_CCW = 0x0901,
  eGL_LINE_WIDTH = 0x0B21,
  eGL_ALIASED_POINT_SIZE_RANGE = 0x846D,
  eGL_ALIASED_LINE_WIDTH_RANGE = 0x846E,
  eGL_CULL_FACE_MODE = 0x0B45,
  eGL_FRONT_FACE = 0x0B46,
  eGL_DEPTH_RANGE = 0x0B70,
  eGL_DEPTH_WRITEMASK = 0x0B72,
  eGL_DEPTH_CLEAR_VALUE = 0x0B73,
  eGL_DEPTH_FUNC = 0x0B74,
  eGL_STENCIL_CLEAR_VALUE = 0x0B91,
  eGL_STENCIL_FUNC = 0x0B92,
  eGL_STENCIL_FAIL = 0x0B94,
  eGL_STENCIL_PASS_DEPTH_FAIL = 0x0B95,
  eGL_STENCIL_PASS_DEPTH_PASS = 0x0B96,
  eGL_STENCIL_REF = 0x0B97,
  eGL_STENCIL_VALUE_MASK = 0x0B93,
  eGL_STENCIL_WRITEMASK = 0x0B98,
  eGL_STENCIL_BACK_FUNC = 0x8800,
  eGL_STENCIL_BACK_FAIL = 0x8801,
  eGL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802,
  eGL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803,
  eGL_STENCIL_BACK_REF = 0x8CA3,
  eGL_STENCIL_BACK_VALUE_MASK = 0x8CA4,
  eGL_STENCIL_BACK_WRITEMASK = 0x8CA5,
  eGL_VIEWPORT = 0x0BA2,
  eGL_SCISSOR_BOX = 0x0C10,
  eGL_COLOR_CLEAR_VALUE = 0x0C22,
  eGL_COLOR_WRITEMASK = 0x0C23,
  eGL_UNPACK_ALIGNMENT = 0x0CF5,
  eGL_PACK_ALIGNMENT = 0x0D05,
  eGL_MAX_TEXTURE_SIZE = 0x0D33,
  eGL_MAX_VIEWPORT_DIMS = 0x0D3A,
  eGL_SUBPIXEL_BITS = 0x0D50,
  eGL_RED_BITS = 0x0D52,
  eGL_GREEN_BITS = 0x0D53,
  eGL_BLUE_BITS = 0x0D54,
  eGL_ALPHA_BITS = 0x0D55,
  eGL_DEPTH_BITS = 0x0D56,
  eGL_STENCIL_BITS = 0x0D57,
  eGL_POLYGON_OFFSET_UNITS = 0x2A00,
  eGL_POLYGON_OFFSET_FACTOR = 0x8038,
  eGL_TEXTURE_BINDING_2D = 0x8069,
  eGL_SAMPLE_BUFFERS = 0x80A8,
  eGL_SAMPLES = 0x80A9,
  eGL_SAMPLE_COVERAGE_VALUE = 0x80AA,
  eGL_SAMPLE_COVERAGE_INVERT = 0x80AB,
  eGL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2,
  eGL_COMPRESSED_TEXTURE_FORMATS = 0x86A3,
  eGL_DONT_CARE = 0x1100,
  eGL_FASTEST = 0x1101,
  eGL_NICEST = 0x1102,
  eGL_GENERATE_MIPMAP_HINT = 0x8192,
  eGL_BYTE = 0x1400,
  eGL_UNSIGNED_BYTE = 0x1401,
  eGL_SHORT = 0x1402,
  eGL_UNSIGNED_SHORT = 0x1403,
  eGL_INT = 0x1404,
  eGL_UNSIGNED_INT = 0x1405,
  eGL_FLOAT = 0x1406,
  eGL_FIXED = 0x140C,
  eGL_DEPTH_COMPONENT = 0x1902,
  eGL_ALPHA = 0x1906,
  eGL_RGB = 0x1907,
  eGL_RGBA = 0x1908,
  eGL_LUMINANCE = 0x1909,
  eGL_LUMINANCE_ALPHA = 0x190A,
  eGL_UNSIGNED_SHORT_4_4_4_4 = 0x8033,
  eGL_UNSIGNED_SHORT_5_5_5_1 = 0x8034,
  eGL_UNSIGNED_SHORT_5_6_5 = 0x8363,
  eGL_FRAGMENT_SHADER = 0x8B30,
  eGL_VERTEX_SHADER = 0x8B31,
  eGL_MAX_VERTEX_ATTRIBS = 0x8869,
  eGL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB,
  eGL_MAX_VARYING_VECTORS = 0x8DFC,
  eGL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D,
  eGL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C,
  eGL_MAX_TEXTURE_IMAGE_UNITS = 0x8872,
  eGL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD,
  eGL_SHADER_TYPE = 0x8B4F,
  eGL_DELETE_STATUS = 0x8B80,
  eGL_LINK_STATUS = 0x8B82,
  eGL_VALIDATE_STATUS = 0x8B83,
  eGL_ATTACHED_SHADERS = 0x8B85,
  eGL_ACTIVE_UNIFORMS = 0x8B86,
  eGL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87,
  eGL_ACTIVE_ATTRIBUTES = 0x8B89,
  eGL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A,
  eGL_SHADING_LANGUAGE_VERSION = 0x8B8C,
  eGL_CURRENT_PROGRAM = 0x8B8D,
  eGL_NEVER = 0x0200,
  eGL_LESS = 0x0201,
  eGL_EQUAL = 0x0202,
  eGL_LEQUAL = 0x0203,
  eGL_GREATER = 0x0204,
  eGL_NOTEQUAL = 0x0205,
  eGL_GEQUAL = 0x0206,
  eGL_ALWAYS = 0x0207,
  eGL_KEEP = 0x1E00,
  eGL_REPLACE = 0x1E01,
  eGL_INCR = 0x1E02,
  eGL_DECR = 0x1E03,
  eGL_INVERT = 0x150A,
  eGL_INCR_WRAP = 0x8507,
  eGL_DECR_WRAP = 0x8508,
  eGL_VENDOR = 0x1F00,
  eGL_RENDERER = 0x1F01,
  eGL_VERSION = 0x1F02,
  eGL_EXTENSIONS = 0x1F03,
  eGL_NEAREST = 0x2600,
  eGL_LINEAR = 0x2601,
  eGL_NEAREST_MIPMAP_NEAREST = 0x2700,
  eGL_LINEAR_MIPMAP_NEAREST = 0x2701,
  eGL_NEAREST_MIPMAP_LINEAR = 0x2702,
  eGL_LINEAR_MIPMAP_LINEAR = 0x2703,
  eGL_TEXTURE_MAG_FILTER = 0x2800,
  eGL_TEXTURE_MIN_FILTER = 0x2801,
  eGL_TEXTURE_WRAP_S = 0x2802,
  eGL_TEXTURE_WRAP_T = 0x2803,
  eGL_TEXTURE = 0x1702,
  eGL_TEXTURE_CUBE_MAP = 0x8513,
  eGL_TEXTURE_BINDING_CUBE_MAP = 0x8514,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A,
  eGL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C,
  eGL_TEXTURE0 = 0x84C0,
  eGL_TEXTURE1 = 0x84C1,
  eGL_TEXTURE2 = 0x84C2,
  eGL_TEXTURE3 = 0x84C3,
  eGL_TEXTURE4 = 0x84C4,
  eGL_TEXTURE5 = 0x84C5,
  eGL_TEXTURE6 = 0x84C6,
  eGL_TEXTURE7 = 0x84C7,
  eGL_TEXTURE8 = 0x84C8,
  eGL_TEXTURE9 = 0x84C9,
  eGL_TEXTURE10 = 0x84CA,
  eGL_TEXTURE11 = 0x84CB,
  eGL_TEXTURE12 = 0x84CC,
  eGL_TEXTURE13 = 0x84CD,
  eGL_TEXTURE14 = 0x84CE,
  eGL_TEXTURE15 = 0x84CF,
  eGL_TEXTURE16 = 0x84D0,
  eGL_TEXTURE17 = 0x84D1,
  eGL_TEXTURE18 = 0x84D2,
  eGL_TEXTURE19 = 0x84D3,
  eGL_TEXTURE20 = 0x84D4,
  eGL_TEXTURE21 = 0x84D5,
  eGL_TEXTURE22 = 0x84D6,
  eGL_TEXTURE23 = 0x84D7,
  eGL_TEXTURE24 = 0x84D8,
  eGL_TEXTURE25 = 0x84D9,
  eGL_TEXTURE26 = 0x84DA,
  eGL_TEXTURE27 = 0x84DB,
  eGL_TEXTURE28 = 0x84DC,
  eGL_TEXTURE29 = 0x84DD,
  eGL_TEXTURE30 = 0x84DE,
  eGL_TEXTURE31 = 0x84DF,
  eGL_ACTIVE_TEXTURE = 0x84E0,
  eGL_REPEAT = 0x2901,
  eGL_CLAMP_TO_EDGE = 0x812F,
  eGL_MIRRORED_REPEAT = 0x8370,
  eGL_FLOAT_VEC2 = 0x8B50,
  eGL_FLOAT_VEC3 = 0x8B51,
  eGL_FLOAT_VEC4 = 0x8B52,
  eGL_INT_VEC2 = 0x8B53,
  eGL_INT_VEC3 = 0x8B54,
  eGL_INT_VEC4 = 0x8B55,
  eGL_BOOL = 0x8B56,
  eGL_BOOL_VEC2 = 0x8B57,
  eGL_BOOL_VEC3 = 0x8B58,
  eGL_BOOL_VEC4 = 0x8B59,
  eGL_FLOAT_MAT2 = 0x8B5A,
  eGL_FLOAT_MAT3 = 0x8B5B,
  eGL_FLOAT_MAT4 = 0x8B5C,
  eGL_SAMPLER_2D = 0x8B5E,
  eGL_SAMPLER_CUBE = 0x8B60,
  eGL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622,
  eGL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623,
  eGL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624,
  eGL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625,
  eGL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A,
  eGL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645,
  eGL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F,
  eGL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A,
  eGL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B,
  eGL_COMPILE_STATUS = 0x8B81,
  eGL_INFO_LOG_LENGTH = 0x8B84,
  eGL_SHADER_SOURCE_LENGTH = 0x8B88,
  eGL_SHADER_COMPILER = 0x8DFA,
  eGL_SHADER_BINARY_FORMATS = 0x8DF8,
  eGL_NUM_SHADER_BINARY_FORMATS = 0x8DF9,
  eGL_LOW_FLOAT = 0x8DF0,
  eGL_MEDIUM_FLOAT = 0x8DF1,
  eGL_HIGH_FLOAT = 0x8DF2,
  eGL_LOW_INT = 0x8DF3,
  eGL_MEDIUM_INT = 0x8DF4,
  eGL_HIGH_INT = 0x8DF5,
  eGL_FRAMEBUFFER = 0x8D40,
  eGL_RENDERBUFFER = 0x8D41,
  eGL_RGBA4 = 0x8056,
  eGL_RGB5_A1 = 0x8057,
  eGL_RGB565 = 0x8D62,
  eGL_DEPTH_COMPONENT16 = 0x81A5,
  eGL_STENCIL_INDEX8 = 0x8D48,
  eGL_RENDERBUFFER_WIDTH = 0x8D42,
  eGL_RENDERBUFFER_HEIGHT = 0x8D43,
  eGL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44,
  eGL_RENDERBUFFER_RED_SIZE = 0x8D50,
  eGL_RENDERBUFFER_GREEN_SIZE = 0x8D51,
  eGL_RENDERBUFFER_BLUE_SIZE = 0x8D52,
  eGL_RENDERBUFFER_ALPHA_SIZE = 0x8D53,
  eGL_RENDERBUFFER_DEPTH_SIZE = 0x8D54,
  eGL_RENDERBUFFER_STENCIL_SIZE = 0x8D55,
  eGL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0,
  eGL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3,
  eGL_COLOR_ATTACHMENT0 = 0x8CE0,
  eGL_DEPTH_ATTACHMENT = 0x8D00,
  eGL_STENCIL_ATTACHMENT = 0x8D20,
  eGL_FRAMEBUFFER_COMPLETE = 0x8CD5,
  eGL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6,
  eGL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7,
  eGL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 0x8CD9,
  eGL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD,
  eGL_FRAMEBUFFER_BINDING = 0x8CA6,
  eGL_RENDERBUFFER_BINDING = 0x8CA7,
  eGL_MAX_RENDERBUFFER_SIZE = 0x84E8,
  eGL_INVALID_FRAMEBUFFER_OPERATION = 0x0506,
  eGL_READ_BUFFER = 0x0C02,
  eGL_UNPACK_ROW_LENGTH = 0x0CF2,
  eGL_UNPACK_SKIP_ROWS = 0x0CF3,
  eGL_UNPACK_SKIP_PIXELS = 0x0CF4,
  eGL_PACK_ROW_LENGTH = 0x0D02,
  eGL_PACK_SKIP_ROWS = 0x0D03,
  eGL_PACK_SKIP_PIXELS = 0x0D04,
  eGL_COLOR = 0x1800,
  eGL_DEPTH = 0x1801,
  eGL_STENCIL = 0x1802,
  eGL_RED = 0x1903,
  eGL_RGB8 = 0x8051,
  eGL_RGBA8 = 0x8058,
  eGL_RGB10_A2 = 0x8059,
  eGL_TEXTURE_BINDING_3D = 0x806A,
  eGL_UNPACK_SKIP_IMAGES = 0x806D,
  eGL_UNPACK_IMAGE_HEIGHT = 0x806E,
  eGL_TEXTURE_3D = 0x806F,
  eGL_TEXTURE_WRAP_R = 0x8072,
  eGL_MAX_3D_TEXTURE_SIZE = 0x8073,
  eGL_UNSIGNED_INT_2_10_10_10_REV = 0x8368,
  eGL_MAX_ELEMENTS_VERTICES = 0x80E8,
  eGL_MAX_ELEMENTS_INDICES = 0x80E9,
  eGL_TEXTURE_MIN_LOD = 0x813A,
  eGL_TEXTURE_MAX_LOD = 0x813B,
  eGL_TEXTURE_BASE_LEVEL = 0x813C,
  eGL_TEXTURE_MAX_LEVEL = 0x813D,
  eGL_MIN = 0x8007,
  eGL_MAX = 0x8008,
  eGL_DEPTH_COMPONENT24 = 0x81A6,
  eGL_MAX_TEXTURE_LOD_BIAS = 0x84FD,
  eGL_TEXTURE_COMPARE_MODE = 0x884C,
  eGL_TEXTURE_COMPARE_FUNC = 0x884D,
  eGL_CURRENT_QUERY = 0x8865,
  eGL_QUERY_RESULT = 0x8866,
  eGL_QUERY_RESULT_AVAILABLE = 0x8867,
  eGL_BUFFER_MAPPED = 0x88BC,
  eGL_BUFFER_MAP_POINTER = 0x88BD,
  eGL_STREAM_READ = 0x88E1,
  eGL_STREAM_COPY = 0x88E2,
  eGL_STATIC_READ = 0x88E5,
  eGL_STATIC_COPY = 0x88E6,
  eGL_DYNAMIC_READ = 0x88E9,
  eGL_DYNAMIC_COPY = 0x88EA,
  eGL_MAX_DRAW_BUFFERS = 0x8824,
  eGL_DRAW_BUFFER0 = 0x8825,
  eGL_DRAW_BUFFER1 = 0x8826,
  eGL_DRAW_BUFFER2 = 0x8827,
  eGL_DRAW_BUFFER3 = 0x8828,
  eGL_DRAW_BUFFER4 = 0x8829,
  eGL_DRAW_BUFFER5 = 0x882A,
  eGL_DRAW_BUFFER6 = 0x882B,
  eGL_DRAW_BUFFER7 = 0x882C,
  eGL_DRAW_BUFFER8 = 0x882D,
  eGL_DRAW_BUFFER9 = 0x882E,
  eGL_DRAW_BUFFER10 = 0x882F,
  eGL_DRAW_BUFFER11 = 0x8830,
  eGL_DRAW_BUFFER12 = 0x8831,
  eGL_DRAW_BUFFER13 = 0x8832,
  eGL_DRAW_BUFFER14 = 0x8833,
  eGL_DRAW_BUFFER15 = 0x8834,
  eGL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49,
  eGL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A,
  eGL_SAMPLER_3D = 0x8B5F,
  eGL_SAMPLER_2D_SHADOW = 0x8B62,
  eGL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B,
  eGL_PIXEL_PACK_BUFFER = 0x88EB,
  eGL_PIXEL_UNPACK_BUFFER = 0x88EC,
  eGL_PIXEL_PACK_BUFFER_BINDING = 0x88ED,
  eGL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF,
  eGL_FLOAT_MAT2x3 = 0x8B65,
  eGL_FLOAT_MAT2x4 = 0x8B66,
  eGL_FLOAT_MAT3x2 = 0x8B67,
  eGL_FLOAT_MAT3x4 = 0x8B68,
  eGL_FLOAT_MAT4x2 = 0x8B69,
  eGL_FLOAT_MAT4x3 = 0x8B6A,
  eGL_SRGB = 0x8C40,
  eGL_SRGB8 = 0x8C41,
  eGL_SRGB8_ALPHA8 = 0x8C43,
  eGL_COMPARE_REF_TO_TEXTURE = 0x884E,
  eGL_MAJOR_VERSION = 0x821B,
  eGL_MINOR_VERSION = 0x821C,
  eGL_NUM_EXTENSIONS = 0x821D,
  eGL_RGBA32F = 0x8814,
  eGL_RGB32F = 0x8815,
  eGL_RGBA16F = 0x881A,
  eGL_RGB16F = 0x881B,
  eGL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD,
  eGL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF,
  eGL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904,
  eGL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905,
  eGL_MAX_VARYING_COMPONENTS = 0x8B4B,
  eGL_TEXTURE_2D_ARRAY = 0x8C1A,
  eGL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D,
  eGL_R11F_G11F_B10F = 0x8C3A,
  eGL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B,
  eGL_RGB9_E5 = 0x8C3D,
  eGL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E,
  eGL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76,
  eGL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80,
  eGL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83,
  eGL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84,
  eGL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85,
  eGL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88,
  eGL_RASTERIZER_DISCARD = 0x8C89,
  eGL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B,
  eGL_INTERLEAVED_ATTRIBS = 0x8C8C,
  eGL_SEPARATE_ATTRIBS = 0x8C8D,
  eGL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E,
  eGL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F,
  eGL_RGBA32UI = 0x8D70,
  eGL_RGB32UI = 0x8D71,
  eGL_RGBA16UI = 0x8D76,
  eGL_RGB16UI = 0x8D77,
  eGL_RGBA8UI = 0x8D7C,
  eGL_RGB8UI = 0x8D7D,
  eGL_RGBA32I = 0x8D82,
  eGL_RGB32I = 0x8D83,
  eGL_RGBA16I = 0x8D88,
  eGL_RGB16I = 0x8D89,
  eGL_RGBA8I = 0x8D8E,
  eGL_RGB8I = 0x8D8F,
  eGL_RED_INTEGER = 0x8D94,
  eGL_RGB_INTEGER = 0x8D98,
  eGL_RGBA_INTEGER = 0x8D99,
  eGL_SAMPLER_2D_ARRAY = 0x8DC1,
  eGL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4,
  eGL_SAMPLER_CUBE_SHADOW = 0x8DC5,
  eGL_UNSIGNED_INT_VEC2 = 0x8DC6,
  eGL_UNSIGNED_INT_VEC3 = 0x8DC7,
  eGL_UNSIGNED_INT_VEC4 = 0x8DC8,
  eGL_INT_SAMPLER_2D = 0x8DCA,
  eGL_INT_SAMPLER_3D = 0x8DCB,
  eGL_INT_SAMPLER_CUBE = 0x8DCC,
  eGL_INT_SAMPLER_2D_ARRAY = 0x8DCF,
  eGL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2,
  eGL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3,
  eGL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4,
  eGL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7,
  eGL_BUFFER_ACCESS_FLAGS = 0x911F,
  eGL_BUFFER_MAP_LENGTH = 0x9120,
  eGL_BUFFER_MAP_OFFSET = 0x9121,
  eGL_DEPTH_COMPONENT32F = 0x8CAC,
  eGL_DEPTH32F_STENCIL8 = 0x8CAD,
  eGL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD,
  eGL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210,
  eGL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211,
  eGL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212,
  eGL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213,
  eGL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214,
  eGL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215,
  eGL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216,
  eGL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217,
  eGL_FRAMEBUFFER_DEFAULT = 0x8218,
  eGL_FRAMEBUFFER_UNDEFINED = 0x8219,
  eGL_DEPTH_STENCIL_ATTACHMENT = 0x821A,
  eGL_DEPTH_STENCIL = 0x84F9,
  eGL_UNSIGNED_INT_24_8 = 0x84FA,
  eGL_DEPTH24_STENCIL8 = 0x88F0,
  eGL_UNSIGNED_NORMALIZED = 0x8C17,
  eGL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6,
  eGL_READ_FRAMEBUFFER = 0x8CA8,
  eGL_DRAW_FRAMEBUFFER = 0x8CA9,
  eGL_READ_FRAMEBUFFER_BINDING = 0x8CAA,
  eGL_RENDERBUFFER_SAMPLES = 0x8CAB,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4,
  eGL_MAX_COLOR_ATTACHMENTS = 0x8CDF,
  eGL_COLOR_ATTACHMENT1 = 0x8CE1,
  eGL_COLOR_ATTACHMENT2 = 0x8CE2,
  eGL_COLOR_ATTACHMENT3 = 0x8CE3,
  eGL_COLOR_ATTACHMENT4 = 0x8CE4,
  eGL_COLOR_ATTACHMENT5 = 0x8CE5,
  eGL_COLOR_ATTACHMENT6 = 0x8CE6,
  eGL_COLOR_ATTACHMENT7 = 0x8CE7,
  eGL_COLOR_ATTACHMENT8 = 0x8CE8,
  eGL_COLOR_ATTACHMENT9 = 0x8CE9,
  eGL_COLOR_ATTACHMENT10 = 0x8CEA,
  eGL_COLOR_ATTACHMENT11 = 0x8CEB,
  eGL_COLOR_ATTACHMENT12 = 0x8CEC,
  eGL_COLOR_ATTACHMENT13 = 0x8CED,
  eGL_COLOR_ATTACHMENT14 = 0x8CEE,
  eGL_COLOR_ATTACHMENT15 = 0x8CEF,
  eGL_COLOR_ATTACHMENT16 = 0x8CF0,
  eGL_COLOR_ATTACHMENT17 = 0x8CF1,
  eGL_COLOR_ATTACHMENT18 = 0x8CF2,
  eGL_COLOR_ATTACHMENT19 = 0x8CF3,
  eGL_COLOR_ATTACHMENT20 = 0x8CF4,
  eGL_COLOR_ATTACHMENT21 = 0x8CF5,
  eGL_COLOR_ATTACHMENT22 = 0x8CF6,
  eGL_COLOR_ATTACHMENT23 = 0x8CF7,
  eGL_COLOR_ATTACHMENT24 = 0x8CF8,
  eGL_COLOR_ATTACHMENT25 = 0x8CF9,
  eGL_COLOR_ATTACHMENT26 = 0x8CFA,
  eGL_COLOR_ATTACHMENT27 = 0x8CFB,
  eGL_COLOR_ATTACHMENT28 = 0x8CFC,
  eGL_COLOR_ATTACHMENT29 = 0x8CFD,
  eGL_COLOR_ATTACHMENT30 = 0x8CFE,
  eGL_COLOR_ATTACHMENT31 = 0x8CFF,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56,
  eGL_MAX_SAMPLES = 0x8D57,
  eGL_HALF_FLOAT = 0x140B,
  eGL_MAP_READ_BIT = 0x0001,
  eGL_MAP_WRITE_BIT = 0x0002,
  eGL_MAP_INVALIDATE_RANGE_BIT = 0x0004,
  eGL_MAP_INVALIDATE_BUFFER_BIT = 0x0008,
  eGL_MAP_FLUSH_EXPLICIT_BIT = 0x0010,
  eGL_MAP_UNSYNCHRONIZED_BIT = 0x0020,
  eGL_RG = 0x8227,
  eGL_RG_INTEGER = 0x8228,
  eGL_R8 = 0x8229,
  eGL_RG8 = 0x822B,
  eGL_R16F = 0x822D,
  eGL_R32F = 0x822E,
  eGL_RG16F = 0x822F,
  eGL_RG32F = 0x8230,
  eGL_R8I = 0x8231,
  eGL_R8UI = 0x8232,
  eGL_R16I = 0x8233,
  eGL_R16UI = 0x8234,
  eGL_R32I = 0x8235,
  eGL_R32UI = 0x8236,
  eGL_RG8I = 0x8237,
  eGL_RG8UI = 0x8238,
  eGL_RG16I = 0x8239,
  eGL_RG16UI = 0x823A,
  eGL_RG32I = 0x823B,
  eGL_RG32UI = 0x823C,
  eGL_VERTEX_ARRAY_BINDING = 0x85B5,
  eGL_R8_SNORM = 0x8F94,
  eGL_RG8_SNORM = 0x8F95,
  eGL_RGB8_SNORM = 0x8F96,
  eGL_RGBA8_SNORM = 0x8F97,
  eGL_SIGNED_NORMALIZED = 0x8F9C,
  eGL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69,
  eGL_COPY_READ_BUFFER = 0x8F36,
  eGL_COPY_WRITE_BUFFER = 0x8F37,
  eGL_COPY_READ_BUFFER_BINDING = 0x8F36,
  eGL_COPY_WRITE_BUFFER_BINDING = 0x8F37,
  eGL_UNIFORM_BUFFER = 0x8A11,
  eGL_UNIFORM_BUFFER_BINDING = 0x8A28,
  eGL_UNIFORM_BUFFER_START = 0x8A29,
  eGL_UNIFORM_BUFFER_SIZE = 0x8A2A,
  eGL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B,
  eGL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D,
  eGL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E,
  eGL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F,
  eGL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30,
  eGL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31,
  eGL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33,
  eGL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34,
  eGL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35,
  eGL_ACTIVE_UNIFORM_BLOCKS = 0x8A36,
  eGL_UNIFORM_TYPE = 0x8A37,
  eGL_UNIFORM_SIZE = 0x8A38,
  eGL_UNIFORM_NAME_LENGTH = 0x8A39,
  eGL_UNIFORM_BLOCK_INDEX = 0x8A3A,
  eGL_UNIFORM_OFFSET = 0x8A3B,
  eGL_UNIFORM_ARRAY_STRIDE = 0x8A3C,
  eGL_UNIFORM_MATRIX_STRIDE = 0x8A3D,
  eGL_UNIFORM_IS_ROW_MAJOR = 0x8A3E,
  eGL_UNIFORM_BLOCK_BINDING = 0x8A3F,
  eGL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40,
  eGL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41,
  eGL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42,
  eGL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46,
  eGL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122,
  eGL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125,
  eGL_MAX_SERVER_WAIT_TIMEOUT = 0x9111,
  eGL_OBJECT_TYPE = 0x9112,
  eGL_SYNC_CONDITION = 0x9113,
  eGL_SYNC_STATUS = 0x9114,
  eGL_SYNC_FLAGS = 0x9115,
  eGL_SYNC_FENCE = 0x9116,
  eGL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117,
  eGL_UNSIGNALED = 0x9118,
  eGL_SIGNALED = 0x9119,
  eGL_ALREADY_SIGNALED = 0x911A,
  eGL_TIMEOUT_EXPIRED = 0x911B,
  eGL_CONDITION_SATISFIED = 0x911C,
  eGL_WAIT_FAILED = 0x911D,
  eGL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001,
  eGL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE,
  eGL_ANY_SAMPLES_PASSED = 0x8C2F,
  eGL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A,
  eGL_SAMPLER_BINDING = 0x8919,
  eGL_RGB10_A2UI = 0x906F,
  eGL_TEXTURE_SWIZZLE_R = 0x8E42,
  eGL_TEXTURE_SWIZZLE_G = 0x8E43,
  eGL_TEXTURE_SWIZZLE_B = 0x8E44,
  eGL_TEXTURE_SWIZZLE_A = 0x8E45,
  eGL_GREEN = 0x1904,
  eGL_BLUE = 0x1905,
  eGL_INT_2_10_10_10_REV = 0x8D9F,
  eGL_TRANSFORM_FEEDBACK = 0x8E22,
  eGL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23,
  eGL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24,
  eGL_TRANSFORM_FEEDBACK_BINDING = 0x8E25,
  eGL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257,
  eGL_PROGRAM_BINARY_LENGTH = 0x8741,
  eGL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE,
  eGL_PROGRAM_BINARY_FORMATS = 0x87FF,
  eGL_COMPRESSED_R11_EAC = 0x9270,
  eGL_COMPRESSED_SIGNED_R11_EAC = 0x9271,
  eGL_COMPRESSED_RG11_EAC = 0x9272,
  eGL_COMPRESSED_SIGNED_RG11_EAC = 0x9273,
  eGL_COMPRESSED_RGB8_ETC2 = 0x9274,
  eGL_COMPRESSED_SRGB8_ETC2 = 0x9275,
  eGL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276,
  eGL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277,
  eGL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278,
  eGL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279,
  eGL_TEXTURE_IMMUTABLE_FORMAT = 0x912F,
  eGL_MAX_ELEMENT_INDEX = 0x8D6B,
  eGL_NUM_SAMPLE_COUNTS = 0x9380,
  eGL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF,
  eGL_COMPUTE_SHADER = 0x91B9,
  eGL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB,
  eGL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC,
  eGL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD,
  eGL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262,
  eGL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263,
  eGL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264,
  eGL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265,
  eGL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266,
  eGL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB,
  eGL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE,
  eGL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF,
  eGL_COMPUTE_WORK_GROUP_SIZE = 0x8267,
  eGL_DISPATCH_INDIRECT_BUFFER = 0x90EE,
  eGL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF,
  eGL_COMPUTE_SHADER_BIT = 0x00000020,
  eGL_DRAW_INDIRECT_BUFFER = 0x8F3F,
  eGL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43,
  eGL_MAX_UNIFORM_LOCATIONS = 0x826E,
  eGL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310,
  eGL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311,
  eGL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313,
  eGL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314,
  eGL_MAX_FRAMEBUFFER_WIDTH = 0x9315,
  eGL_MAX_FRAMEBUFFER_HEIGHT = 0x9316,
  eGL_MAX_FRAMEBUFFER_SAMPLES = 0x9318,
  eGL_UNIFORM = 0x92E1,
  eGL_UNIFORM_BLOCK = 0x92E2,
  eGL_PROGRAM_INPUT = 0x92E3,
  eGL_PROGRAM_OUTPUT = 0x92E4,
  eGL_BUFFER_VARIABLE = 0x92E5,
  eGL_SHADER_STORAGE_BLOCK = 0x92E6,
  eGL_ATOMIC_COUNTER_BUFFER = 0x92C0,
  eGL_TRANSFORM_FEEDBACK_VARYING = 0x92F4,
  eGL_ACTIVE_RESOURCES = 0x92F5,
  eGL_MAX_NAME_LENGTH = 0x92F6,
  eGL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7,
  eGL_NAME_LENGTH = 0x92F9,
  eGL_TYPE = 0x92FA,
  eGL_ARRAY_SIZE = 0x92FB,
  eGL_OFFSET = 0x92FC,
  eGL_BLOCK_INDEX = 0x92FD,
  eGL_ARRAY_STRIDE = 0x92FE,
  eGL_MATRIX_STRIDE = 0x92FF,
  eGL_IS_ROW_MAJOR = 0x9300,
  eGL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301,
  eGL_BUFFER_BINDING = 0x9302,
  eGL_BUFFER_DATA_SIZE = 0x9303,
  eGL_NUM_ACTIVE_VARIABLES = 0x9304,
  eGL_ACTIVE_VARIABLES = 0x9305,
  eGL_REFERENCED_BY_VERTEX_SHADER = 0x9306,
  eGL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A,
  eGL_REFERENCED_BY_COMPUTE_SHADER = 0x930B,
  eGL_TOP_LEVEL_ARRAY_SIZE = 0x930C,
  eGL_TOP_LEVEL_ARRAY_STRIDE = 0x930D,
  eGL_LOCATION = 0x930E,
  eGL_VERTEX_SHADER_BIT = 0x00000001,
  eGL_FRAGMENT_SHADER_BIT = 0x00000002,
  eGL_ALL_SHADER_BITS = 0xFFFFFFFF,
  eGL_PROGRAM_SEPARABLE = 0x8258,
  eGL_ACTIVE_PROGRAM = 0x8259,
  eGL_PROGRAM_PIPELINE_BINDING = 0x825A,
  eGL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1,
  eGL_ATOMIC_COUNTER_BUFFER_START = 0x92C2,
  eGL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3,
  eGL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC,
  eGL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0,
  eGL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1,
  eGL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2,
  eGL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6,
  eGL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7,
  eGL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8,
  eGL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC,
  eGL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9,
  eGL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB,
  eGL_MAX_IMAGE_UNITS = 0x8F38,
  eGL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA,
  eGL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE,
  eGL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF,
  eGL_IMAGE_BINDING_NAME = 0x8F3A,
  eGL_IMAGE_BINDING_LEVEL = 0x8F3B,
  eGL_IMAGE_BINDING_LAYERED = 0x8F3C,
  eGL_IMAGE_BINDING_LAYER = 0x8F3D,
  eGL_IMAGE_BINDING_ACCESS = 0x8F3E,
  eGL_IMAGE_BINDING_FORMAT = 0x906E,
  eGL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001,
  eGL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002,
  eGL_UNIFORM_BARRIER_BIT = 0x00000004,
  eGL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008,
  eGL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020,
  eGL_COMMAND_BARRIER_BIT = 0x00000040,
  eGL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080,
  eGL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100,
  eGL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200,
  eGL_FRAMEBUFFER_BARRIER_BIT = 0x00000400,
  eGL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800,
  eGL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000,
  eGL_ALL_BARRIER_BITS = 0xFFFFFFFF,
  eGL_IMAGE_2D = 0x904D,
  eGL_IMAGE_3D = 0x904E,
  eGL_IMAGE_CUBE = 0x9050,
  eGL_IMAGE_2D_ARRAY = 0x9053,
  eGL_INT_IMAGE_2D = 0x9058,
  eGL_INT_IMAGE_3D = 0x9059,
  eGL_INT_IMAGE_CUBE = 0x905B,
  eGL_INT_IMAGE_2D_ARRAY = 0x905E,
  eGL_UNSIGNED_INT_IMAGE_2D = 0x9063,
  eGL_UNSIGNED_INT_IMAGE_3D = 0x9064,
  eGL_UNSIGNED_INT_IMAGE_CUBE = 0x9066,
  eGL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069,
  eGL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7,
  eGL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8,
  eGL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9,
  eGL_READ_ONLY = 0x88B8,
  eGL_WRITE_ONLY = 0x88B9,
  eGL_READ_WRITE = 0x88BA,
  eGL_SHADER_STORAGE_BUFFER = 0x90D2,
  eGL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3,
  eGL_SHADER_STORAGE_BUFFER_START = 0x90D4,
  eGL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5,
  eGL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6,
  eGL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA,
  eGL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB,
  eGL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC,
  eGL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD,
  eGL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE,
  eGL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF,
  eGL_SHADER_STORAGE_BARRIER_BIT = 0x00002000,
  eGL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39,
  eGL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA,
  eGL_STENCIL_INDEX = 0x1901,
  eGL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E,
  eGL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F,
  eGL_SAMPLE_POSITION = 0x8E50,
  eGL_SAMPLE_MASK = 0x8E51,
  eGL_SAMPLE_MASK_VALUE = 0x8E52,
  eGL_TEXTURE_2D_MULTISAMPLE = 0x9100,
  eGL_MAX_SAMPLE_MASK_WORDS = 0x8E59,
  eGL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E,
  eGL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F,
  eGL_MAX_INTEGER_SAMPLES = 0x9110,
  eGL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104,
  eGL_TEXTURE_SAMPLES = 0x9106,
  eGL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107,
  eGL_TEXTURE_WIDTH = 0x1000,
  eGL_TEXTURE_HEIGHT = 0x1001,
  eGL_TEXTURE_DEPTH = 0x8071,
  eGL_TEXTURE_INTERNAL_FORMAT = 0x1003,
  eGL_TEXTURE_RED_SIZE = 0x805C,
  eGL_TEXTURE_GREEN_SIZE = 0x805D,
  eGL_TEXTURE_BLUE_SIZE = 0x805E,
  eGL_TEXTURE_ALPHA_SIZE = 0x805F,
  eGL_TEXTURE_DEPTH_SIZE = 0x884A,
  eGL_TEXTURE_STENCIL_SIZE = 0x88F1,
  eGL_TEXTURE_SHARED_SIZE = 0x8C3F,
  eGL_TEXTURE_RED_TYPE = 0x8C10,
  eGL_TEXTURE_GREEN_TYPE = 0x8C11,
  eGL_TEXTURE_BLUE_TYPE = 0x8C12,
  eGL_TEXTURE_ALPHA_TYPE = 0x8C13,
  eGL_TEXTURE_DEPTH_TYPE = 0x8C16,
  eGL_TEXTURE_COMPRESSED = 0x86A1,
  eGL_SAMPLER_2D_MULTISAMPLE = 0x9108,
  eGL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109,
  eGL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A,
  eGL_VERTEX_ATTRIB_BINDING = 0x82D4,
  eGL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5,
  eGL_VERTEX_BINDING_DIVISOR = 0x82D6,
  eGL_VERTEX_BINDING_OFFSET = 0x82D7,
  eGL_VERTEX_BINDING_STRIDE = 0x82D8,
  eGL_VERTEX_BINDING_BUFFER = 0x8F4F,
  eGL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9,
  eGL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA,
  eGL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5,
  eGL_MULTISAMPLE_LINE_WIDTH_RANGE = 0x9381,
  eGL_MULTISAMPLE_LINE_WIDTH_GRANULARITY = 0x9382,
  eGL_MULTIPLY = 0x9294,
  eGL_SCREEN = 0x9295,
  eGL_OVERLAY = 0x9296,
  eGL_DARKEN = 0x9297,
  eGL_LIGHTEN = 0x9298,
  eGL_COLORDODGE = 0x9299,
  eGL_COLORBURN = 0x929A,
  eGL_HARDLIGHT = 0x929B,
  eGL_SOFTLIGHT = 0x929C,
  eGL_DIFFERENCE = 0x929E,
  eGL_EXCLUSION = 0x92A0,
  eGL_HSL_HUE = 0x92AD,
  eGL_HSL_SATURATION = 0x92AE,
  eGL_HSL_COLOR = 0x92AF,
  eGL_HSL_LUMINOSITY = 0x92B0,
  eGL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242,
  eGL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243,
  eGL_DEBUG_CALLBACK_FUNCTION = 0x8244,
  eGL_DEBUG_CALLBACK_USER_PARAM = 0x8245,
  eGL_DEBUG_SOURCE_API = 0x8246,
  eGL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247,
  eGL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248,
  eGL_DEBUG_SOURCE_THIRD_PARTY = 0x8249,
  eGL_DEBUG_SOURCE_APPLICATION = 0x824A,
  eGL_DEBUG_SOURCE_OTHER = 0x824B,
  eGL_DEBUG_TYPE_ERROR = 0x824C,
  eGL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D,
  eGL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E,
  eGL_DEBUG_TYPE_PORTABILITY = 0x824F,
  eGL_DEBUG_TYPE_PERFORMANCE = 0x8250,
  eGL_DEBUG_TYPE_OTHER = 0x8251,
  eGL_DEBUG_TYPE_MARKER = 0x8268,
  eGL_DEBUG_TYPE_PUSH_GROUP = 0x8269,
  eGL_DEBUG_TYPE_POP_GROUP = 0x826A,
  eGL_DEBUG_SEVERITY_NOTIFICATION = 0x826B,
  eGL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C,
  eGL_DEBUG_GROUP_STACK_DEPTH = 0x826D,
  eGL_BUFFER = 0x82E0,
  eGL_SHADER = 0x82E1,
  eGL_PROGRAM = 0x82E2,
  eGL_VERTEX_ARRAY = 0x8074,
  eGL_QUERY = 0x82E3,
  eGL_PROGRAM_PIPELINE = 0x82E4,
  eGL_SAMPLER = 0x82E6,
  eGL_MAX_LABEL_LENGTH = 0x82E8,
  eGL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143,
  eGL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144,
  eGL_DEBUG_LOGGED_MESSAGES = 0x9145,
  eGL_DEBUG_SEVERITY_HIGH = 0x9146,
  eGL_DEBUG_SEVERITY_MEDIUM = 0x9147,
  eGL_DEBUG_SEVERITY_LOW = 0x9148,
  eGL_DEBUG_OUTPUT = 0x92E0,
  eGL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002,
  eGL_STACK_OVERFLOW = 0x0503,
  eGL_STACK_UNDERFLOW = 0x0504,
  eGL_GEOMETRY_SHADER = 0x8DD9,
  eGL_GEOMETRY_SHADER_BIT = 0x00000004,
  eGL_GEOMETRY_VERTICES_OUT = 0x8916,
  eGL_GEOMETRY_INPUT_TYPE = 0x8917,
  eGL_GEOMETRY_OUTPUT_TYPE = 0x8918,
  eGL_GEOMETRY_SHADER_INVOCATIONS = 0x887F,
  eGL_LAYER_PROVOKING_VERTEX = 0x825E,
  eGL_LINES_ADJACENCY = 0x000A,
  eGL_LINE_STRIP_ADJACENCY = 0x000B,
  eGL_TRIANGLES_ADJACENCY = 0x000C,
  eGL_TRIANGLE_STRIP_ADJACENCY = 0x000D,
  eGL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF,
  eGL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C,
  eGL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32,
  eGL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123,
  eGL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124,
  eGL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0,
  eGL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1,
  eGL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A,
  eGL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5,
  eGL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD,
  eGL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7,
  eGL_FIRST_VERTEX_CONVENTION = 0x8E4D,
  eGL_LAST_VERTEX_CONVENTION = 0x8E4E,
  eGL_UNDEFINED_VERTEX = 0x8260,
  eGL_PRIMITIVES_GENERATED = 0x8C87,
  eGL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312,
  eGL_MAX_FRAMEBUFFER_LAYERS = 0x9317,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8,
  eGL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7,
  eGL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309,
  eGL_PRIMITIVE_BOUNDING_BOX = 0x92BE,
  eGL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 0x00000004,
  eGL_CONTEXT_FLAGS = 0x821E,
  eGL_LOSE_CONTEXT_ON_RESET = 0x8252,
  eGL_GUILTY_CONTEXT_RESET = 0x8253,
  eGL_INNOCENT_CONTEXT_RESET = 0x8254,
  eGL_UNKNOWN_CONTEXT_RESET = 0x8255,
  eGL_RESET_NOTIFICATION_STRATEGY = 0x8256,
  eGL_NO_RESET_NOTIFICATION = 0x8261,
  eGL_CONTEXT_LOST = 0x0507,
  eGL_SAMPLE_SHADING = 0x8C36,
  eGL_MIN_SAMPLE_SHADING_VALUE = 0x8C37,
  eGL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B,
  eGL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C,
  eGL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D,
  eGL_PATCHES = 0x000E,
  eGL_PATCH_VERTICES = 0x8E72,
  eGL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75,
  eGL_TESS_GEN_MODE = 0x8E76,
  eGL_TESS_GEN_SPACING = 0x8E77,
  eGL_TESS_GEN_VERTEX_ORDER = 0x8E78,
  eGL_TESS_GEN_POINT_MODE = 0x8E79,
  eGL_ISOLINES = 0x8E7A,
  eGL_QUADS = 0x0007,
  eGL_FRACTIONAL_ODD = 0x8E7B,
  eGL_FRACTIONAL_EVEN = 0x8E7C,
  eGL_MAX_PATCH_VERTICES = 0x8E7D,
  eGL_MAX_TESS_GEN_LEVEL = 0x8E7E,
  eGL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F,
  eGL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80,
  eGL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81,
  eGL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82,
  eGL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83,
  eGL_MAX_TESS_PATCH_COMPONENTS = 0x8E84,
  eGL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85,
  eGL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86,
  eGL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89,
  eGL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A,
  eGL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C,
  eGL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D,
  eGL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E,
  eGL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4,
  eGL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB,
  eGL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC,
  eGL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8,
  eGL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9,
  eGL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 0x8221,
  eGL_IS_PER_PATCH = 0x92E7,
  eGL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307,
  eGL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308,
  eGL_TESS_CONTROL_SHADER = 0x8E88,
  eGL_TESS_EVALUATION_SHADER = 0x8E87,
  eGL_TESS_CONTROL_SHADER_BIT = 0x00000008,
  eGL_TESS_EVALUATION_SHADER_BIT = 0x00000010,
  eGL_TEXTURE_BORDER_COLOR = 0x1004,
  eGL_CLAMP_TO_BORDER = 0x812D,
  eGL_TEXTURE_BUFFER = 0x8C2A,
  eGL_TEXTURE_BUFFER_BINDING = 0x8C2A,
  eGL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B,
  eGL_TEXTURE_BINDING_BUFFER = 0x8C2C,
  eGL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D,
  eGL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F,
  eGL_SAMPLER_BUFFER = 0x8DC2,
  eGL_INT_SAMPLER_BUFFER = 0x8DD0,
  eGL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8,
  eGL_IMAGE_BUFFER = 0x9051,
  eGL_INT_IMAGE_BUFFER = 0x905C,
  eGL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067,
  eGL_TEXTURE_BUFFER_OFFSET = 0x919D,
  eGL_TEXTURE_BUFFER_SIZE = 0x919E,
  eGL_COMPRESSED_RGBA_ASTC_4x4 = 0x93B0,
  eGL_COMPRESSED_RGBA_ASTC_5x4 = 0x93B1,
  eGL_COMPRESSED_RGBA_ASTC_5x5 = 0x93B2,
  eGL_COMPRESSED_RGBA_ASTC_6x5 = 0x93B3,
  eGL_COMPRESSED_RGBA_ASTC_6x6 = 0x93B4,
  eGL_COMPRESSED_RGBA_ASTC_8x5 = 0x93B5,
  eGL_COMPRESSED_RGBA_ASTC_8x6 = 0x93B6,
  eGL_COMPRESSED_RGBA_ASTC_8x8 = 0x93B7,
  eGL_COMPRESSED_RGBA_ASTC_10x5 = 0x93B8,
  eGL_COMPRESSED_RGBA_ASTC_10x6 = 0x93B9,
  eGL_COMPRESSED_RGBA_ASTC_10x8 = 0x93BA,
  eGL_COMPRESSED_RGBA_ASTC_10x10 = 0x93BB,
  eGL_COMPRESSED_RGBA_ASTC_12x10 = 0x93BC,
  eGL_COMPRESSED_RGBA_ASTC_12x12 = 0x93BD,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = 0x93D0,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = 0x93D1,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = 0x93D2,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = 0x93D3,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = 0x93D4,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = 0x93D5,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = 0x93D6,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = 0x93D7,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = 0x93D8,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = 0x93D9,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = 0x93DA,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = 0x93DB,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = 0x93DC,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = 0x93DD,
  eGL_TEXTURE_CUBE_MAP_ARRAY = 0x9009,
  eGL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A,
  eGL_SAMPLER_CUBE_MAP_ARRAY = 0x900C,
  eGL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D,
  eGL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E,
  eGL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F,
  eGL_IMAGE_CUBE_MAP_ARRAY = 0x9054,
  eGL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F,
  eGL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A,
  eGL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102,
  eGL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105,
  eGL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B,
  eGL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C,
  eGL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D,
  eGL_FRONT_LEFT = 0x0400,
  eGL_FRONT_RIGHT = 0x0401,
  eGL_BACK_LEFT = 0x0402,
  eGL_BACK_RIGHT = 0x0403,
  eGL_LEFT = 0x0406,
  eGL_RIGHT = 0x0407,
  eGL_POINT_SIZE = 0x0B11,
  eGL_POINT_SIZE_RANGE = 0x0B12,
  eGL_POINT_SIZE_GRANULARITY = 0x0B13,
  eGL_LINE_SMOOTH = 0x0B20,
  eGL_LINE_WIDTH_RANGE = 0x0B22,
  eGL_LINE_WIDTH_GRANULARITY = 0x0B23,
  eGL_POLYGON_MODE = 0x0B40,
  eGL_POLYGON_SMOOTH = 0x0B41,
  eGL_BLEND_DST = 0x0BE0,
  eGL_BLEND_SRC = 0x0BE1,
  eGL_LOGIC_OP_MODE = 0x0BF0,
  eGL_DRAW_BUFFER = 0x0C01,
  eGL_DOUBLEBUFFER = 0x0C32,
  eGL_STEREO = 0x0C33,
  eGL_LINE_SMOOTH_HINT = 0x0C52,
  eGL_POLYGON_SMOOTH_HINT = 0x0C53,
  eGL_UNPACK_SWAP_BYTES = 0x0CF0,
  eGL_UNPACK_LSB_FIRST = 0x0CF1,
  eGL_PACK_SWAP_BYTES = 0x0D00,
  eGL_PACK_LSB_FIRST = 0x0D01,
  eGL_TEXTURE_1D = 0x0DE0,
  eGL_CLEAR = 0x1500,
  eGL_AND = 0x1501,
  eGL_AND_REVERSE = 0x1502,
  eGL_COPY = 0x1503,
  eGL_AND_INVERTED = 0x1504,
  eGL_NOOP = 0x1505,
  eGL_XOR = 0x1506,
  eGL_OR = 0x1507,
  eGL_NOR = 0x1508,
  eGL_EQUIV = 0x1509,
  eGL_OR_REVERSE = 0x150B,
  eGL_COPY_INVERTED = 0x150C,
  eGL_OR_INVERTED = 0x150D,
  eGL_NAND = 0x150E,
  eGL_SET = 0x150F,
  eGL_POINT = 0x1B00,
  eGL_LINE = 0x1B01,
  eGL_FILL = 0x1B02,
  eGL_COLOR_LOGIC_OP = 0x0BF2,
  eGL_POLYGON_OFFSET_POINT = 0x2A01,
  eGL_POLYGON_OFFSET_LINE = 0x2A02,
  eGL_TEXTURE_BINDING_1D = 0x8068,
  eGL_DOUBLE = 0x140A,
  eGL_PROXY_TEXTURE_1D = 0x8063,
  eGL_PROXY_TEXTURE_2D = 0x8064,
  eGL_R3_G3_B2 = 0x2A10,
  eGL_RGB4 = 0x804F,
  eGL_RGB5 = 0x8050,
  eGL_RGB10 = 0x8052,
  eGL_RGB12 = 0x8053,
  eGL_RGB16 = 0x8054,
  eGL_RGBA2 = 0x8055,
  eGL_RGBA12 = 0x805A,
  eGL_RGBA16 = 0x805B,
  eGL_UNSIGNED_BYTE_3_3_2 = 0x8032,
  eGL_UNSIGNED_INT_8_8_8_8 = 0x8035,
  eGL_UNSIGNED_INT_10_10_10_2 = 0x8036,
  eGL_PACK_SKIP_IMAGES = 0x806B,
  eGL_PACK_IMAGE_HEIGHT = 0x806C,
  eGL_PROXY_TEXTURE_3D = 0x8070,
  eGL_UNSIGNED_BYTE_2_3_3_REV = 0x8362,
  eGL_UNSIGNED_SHORT_5_6_5_REV = 0x8364,
  eGL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365,
  eGL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366,
  eGL_UNSIGNED_INT_8_8_8_8_REV = 0x8367,
  eGL_BGR = 0x80E0,
  eGL_BGRA = 0x80E1,
  eGL_SMOOTH_POINT_SIZE_RANGE = 0x0B12,
  eGL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13,
  eGL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22,
  eGL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23,
  eGL_MULTISAMPLE = 0x809D,
  eGL_SAMPLE_ALPHA_TO_ONE = 0x809F,
  eGL_PROXY_TEXTURE_CUBE_MAP = 0x851B,
  eGL_COMPRESSED_RGB = 0x84ED,
  eGL_COMPRESSED_RGBA = 0x84EE,
  eGL_TEXTURE_COMPRESSION_HINT = 0x84EF,
  eGL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0,
  eGL_POINT_FADE_THRESHOLD_SIZE = 0x8128,
  eGL_DEPTH_COMPONENT32 = 0x81A7,
  eGL_TEXTURE_LOD_BIAS = 0x8501,
  eGL_QUERY_COUNTER_BITS = 0x8864,
  eGL_BUFFER_ACCESS = 0x88BB,
  eGL_SAMPLES_PASSED = 0x8914,
  eGL_SRC1_ALPHA = 0x8589,
  eGL_VERTEX_PROGRAM_POINT_SIZE = 0x8642,
  eGL_MAX_VARYING_FLOATS = 0x8B4B,
  eGL_SAMPLER_1D = 0x8B5D,
  eGL_SAMPLER_1D_SHADOW = 0x8B61,
  eGL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0,
  eGL_LOWER_LEFT = 0x8CA1,
  eGL_UPPER_LEFT = 0x8CA2,
  eGL_SRGB_ALPHA = 0x8C42,
  eGL_COMPRESSED_SRGB = 0x8C48,
  eGL_COMPRESSED_SRGB_ALPHA = 0x8C49,
  eGL_CLIP_DISTANCE0 = 0x3000,
  eGL_CLIP_DISTANCE1 = 0x3001,
  eGL_CLIP_DISTANCE2 = 0x3002,
  eGL_CLIP_DISTANCE3 = 0x3003,
  eGL_CLIP_DISTANCE4 = 0x3004,
  eGL_CLIP_DISTANCE5 = 0x3005,
  eGL_CLIP_DISTANCE6 = 0x3006,
  eGL_CLIP_DISTANCE7 = 0x3007,
  eGL_MAX_CLIP_DISTANCES = 0x0D32,
  eGL_COMPRESSED_RED = 0x8225,
  eGL_COMPRESSED_RG = 0x8226,
  eGL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001,
  eGL_CLAMP_READ_COLOR = 0x891C,
  eGL_FIXED_ONLY = 0x891D,
  eGL_TEXTURE_1D_ARRAY = 0x8C18,
  eGL_PROXY_TEXTURE_1D_ARRAY = 0x8C19,
  eGL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B,
  eGL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C,
  eGL_GREEN_INTEGER = 0x8D95,
  eGL_BLUE_INTEGER = 0x8D96,
  eGL_BGR_INTEGER = 0x8D9A,
  eGL_BGRA_INTEGER = 0x8D9B,
  eGL_SAMPLER_1D_ARRAY = 0x8DC0,
  eGL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3,
  eGL_INT_SAMPLER_1D = 0x8DC9,
  eGL_INT_SAMPLER_1D_ARRAY = 0x8DCE,
  eGL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1,
  eGL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6,
  eGL_QUERY_WAIT = 0x8E13,
  eGL_QUERY_NO_WAIT = 0x8E14,
  eGL_QUERY_BY_REGION_WAIT = 0x8E15,
  eGL_QUERY_BY_REGION_NO_WAIT = 0x8E16,
  eGL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB,
  eGL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC,
  eGL_STENCIL_INDEX1 = 0x8D46,
  eGL_STENCIL_INDEX4 = 0x8D47,
  eGL_STENCIL_INDEX16 = 0x8D49,
  eGL_FRAMEBUFFER_SRGB = 0x8DB9,
  eGL_COMPRESSED_RED_RGTC1 = 0x8DBB,
  eGL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC,
  eGL_COMPRESSED_RG_RGTC2 = 0x8DBD,
  eGL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE,
  eGL_R16 = 0x822A,
  eGL_RG16 = 0x822C,
  eGL_SAMPLER_2D_RECT = 0x8B63,
  eGL_SAMPLER_2D_RECT_SHADOW = 0x8B64,
  eGL_INT_SAMPLER_2D_RECT = 0x8DCD,
  eGL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5,
  eGL_TEXTURE_RECTANGLE = 0x84F5,
  eGL_TEXTURE_BINDING_RECTANGLE = 0x84F6,
  eGL_PROXY_TEXTURE_RECTANGLE = 0x84F7,
  eGL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8,
  eGL_R16_SNORM = 0x8F98,
  eGL_RG16_SNORM = 0x8F99,
  eGL_RGB16_SNORM = 0x8F9A,
  eGL_RGBA16_SNORM = 0x8F9B,
  eGL_PRIMITIVE_RESTART = 0x8F9D,
  eGL_PRIMITIVE_RESTART_INDEX = 0x8F9E,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45,
  eGL_CONTEXT_CORE_PROFILE_BIT = 0x00000001,
  eGL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002,
  eGL_PROGRAM_POINT_SIZE = 0x8642,
  eGL_CONTEXT_PROFILE_MASK = 0x9126,
  eGL_DEPTH_CLAMP = 0x864F,
  eGL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C,
  eGL_PROVOKING_VERTEX = 0x8E4F,
  eGL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F,
  eGL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101,
  eGL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103,
  eGL_SRC1_COLOR = 0x88F9,
  eGL_ONE_MINUS_SRC1_COLOR = 0x88FA,
  eGL_ONE_MINUS_SRC1_ALPHA = 0x88FB,
  eGL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC,
  eGL_TEXTURE_SWIZZLE_RGBA = 0x8E46,
  eGL_TIME_ELAPSED = 0x88BF,
  eGL_TIMESTAMP = 0x8E28,
  eGL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B,
  eGL_MAX_VERTEX_STREAMS = 0x8E71,
  eGL_DOUBLE_VEC2 = 0x8FFC,
  eGL_DOUBLE_VEC3 = 0x8FFD,
  eGL_DOUBLE_VEC4 = 0x8FFE,
  eGL_DOUBLE_MAT2 = 0x8F46,
  eGL_DOUBLE_MAT3 = 0x8F47,
  eGL_DOUBLE_MAT4 = 0x8F48,
  eGL_DOUBLE_MAT2x3 = 0x8F49,
  eGL_DOUBLE_MAT2x4 = 0x8F4A,
  eGL_DOUBLE_MAT3x2 = 0x8F4B,
  eGL_DOUBLE_MAT3x4 = 0x8F4C,
  eGL_DOUBLE_MAT4x2 = 0x8F4D,
  eGL_DOUBLE_MAT4x3 = 0x8F4E,
  eGL_ACTIVE_SUBROUTINES = 0x8DE5,
  eGL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6,
  eGL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47,
  eGL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48,
  eGL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49,
  eGL_MAX_SUBROUTINES = 0x8DE7,
  eGL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8,
  eGL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A,
  eGL_COMPATIBLE_SUBROUTINES = 0x8E4B,
  eGL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73,
  eGL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1,
  eGL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23,
  eGL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24,
  eGL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70,
  eGL_MAX_VIEWPORTS = 0x825B,
  eGL_VIEWPORT_SUBPIXEL_BITS = 0x825C,
  eGL_VIEWPORT_BOUNDS_RANGE = 0x825D,
  eGL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F,
  eGL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127,
  eGL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128,
  eGL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129,
  eGL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A,
  eGL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B,
  eGL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C,
  eGL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D,
  eGL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E,
  eGL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC,
  eGL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4,
  eGL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5,
  eGL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB,
  eGL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA,
  eGL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39,
  eGL_IMAGE_1D = 0x904C,
  eGL_IMAGE_2D_RECT = 0x904F,
  eGL_IMAGE_1D_ARRAY = 0x9052,
  eGL_IMAGE_2D_MULTISAMPLE = 0x9055,
  eGL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056,
  eGL_INT_IMAGE_1D = 0x9057,
  eGL_INT_IMAGE_2D_RECT = 0x905A,
  eGL_INT_IMAGE_1D_ARRAY = 0x905D,
  eGL_INT_IMAGE_2D_MULTISAMPLE = 0x9060,
  eGL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061,
  eGL_UNSIGNED_INT_IMAGE_1D = 0x9062,
  eGL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065,
  eGL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068,
  eGL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B,
  eGL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C,
  eGL_MAX_IMAGE_SAMPLES = 0x906D,
  eGL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C,
  eGL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D,
  eGL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E,
  eGL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F,
  eGL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9,
  eGL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E,
  eGL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC,
  eGL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED,
  eGL_INTERNALFORMAT_SUPPORTED = 0x826F,
  eGL_INTERNALFORMAT_PREFERRED = 0x8270,
  eGL_INTERNALFORMAT_RED_SIZE = 0x8271,
  eGL_INTERNALFORMAT_GREEN_SIZE = 0x8272,
  eGL_INTERNALFORMAT_BLUE_SIZE = 0x8273,
  eGL_INTERNALFORMAT_ALPHA_SIZE = 0x8274,
  eGL_INTERNALFORMAT_DEPTH_SIZE = 0x8275,
  eGL_INTERNALFORMAT_STENCIL_SIZE = 0x8276,
  eGL_INTERNALFORMAT_SHARED_SIZE = 0x8277,
  eGL_INTERNALFORMAT_RED_TYPE = 0x8278,
  eGL_INTERNALFORMAT_GREEN_TYPE = 0x8279,
  eGL_INTERNALFORMAT_BLUE_TYPE = 0x827A,
  eGL_INTERNALFORMAT_ALPHA_TYPE = 0x827B,
  eGL_INTERNALFORMAT_DEPTH_TYPE = 0x827C,
  eGL_INTERNALFORMAT_STENCIL_TYPE = 0x827D,
  eGL_MAX_WIDTH = 0x827E,
  eGL_MAX_HEIGHT = 0x827F,
  eGL_MAX_DEPTH = 0x8280,
  eGL_MAX_LAYERS = 0x8281,
  eGL_MAX_COMBINED_DIMENSIONS = 0x8282,
  eGL_COLOR_COMPONENTS = 0x8283,
  eGL_DEPTH_COMPONENTS = 0x8284,
  eGL_STENCIL_COMPONENTS = 0x8285,
  eGL_COLOR_RENDERABLE = 0x8286,
  eGL_DEPTH_RENDERABLE = 0x8287,
  eGL_STENCIL_RENDERABLE = 0x8288,
  eGL_FRAMEBUFFER_RENDERABLE = 0x8289,
  eGL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A,
  eGL_FRAMEBUFFER_BLEND = 0x828B,
  eGL_READ_PIXELS = 0x828C,
  eGL_READ_PIXELS_FORMAT = 0x828D,
  eGL_READ_PIXELS_TYPE = 0x828E,
  eGL_TEXTURE_IMAGE_FORMAT = 0x828F,
  eGL_TEXTURE_IMAGE_TYPE = 0x8290,
  eGL_GET_TEXTURE_IMAGE_FORMAT = 0x8291,
  eGL_GET_TEXTURE_IMAGE_TYPE = 0x8292,
  eGL_MIPMAP = 0x8293,
  eGL_MANUAL_GENERATE_MIPMAP = 0x8294,
  eGL_AUTO_GENERATE_MIPMAP = 0x8295,
  eGL_COLOR_ENCODING = 0x8296,
  eGL_SRGB_READ = 0x8297,
  eGL_SRGB_WRITE = 0x8298,
  eGL_FILTER = 0x829A,
  eGL_VERTEX_TEXTURE = 0x829B,
  eGL_TESS_CONTROL_TEXTURE = 0x829C,
  eGL_TESS_EVALUATION_TEXTURE = 0x829D,
  eGL_GEOMETRY_TEXTURE = 0x829E,
  eGL_FRAGMENT_TEXTURE = 0x829F,
  eGL_COMPUTE_TEXTURE = 0x82A0,
  eGL_TEXTURE_SHADOW = 0x82A1,
  eGL_TEXTURE_GATHER = 0x82A2,
  eGL_TEXTURE_GATHER_SHADOW = 0x82A3,
  eGL_SHADER_IMAGE_LOAD = 0x82A4,
  eGL_SHADER_IMAGE_STORE = 0x82A5,
  eGL_SHADER_IMAGE_ATOMIC = 0x82A6,
  eGL_IMAGE_TEXEL_SIZE = 0x82A7,
  eGL_IMAGE_COMPATIBILITY_CLASS = 0x82A8,
  eGL_IMAGE_PIXEL_FORMAT = 0x82A9,
  eGL_IMAGE_PIXEL_TYPE = 0x82AA,
  eGL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC,
  eGL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD,
  eGL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE,
  eGL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF,
  eGL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1,
  eGL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2,
  eGL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3,
  eGL_CLEAR_BUFFER = 0x82B4,
  eGL_TEXTURE_VIEW = 0x82B5,
  eGL_VIEW_COMPATIBILITY_CLASS = 0x82B6,
  eGL_FULL_SUPPORT = 0x82B7,
  eGL_CAVEAT_SUPPORT = 0x82B8,
  eGL_IMAGE_CLASS_4_X_32 = 0x82B9,
  eGL_IMAGE_CLASS_2_X_32 = 0x82BA,
  eGL_IMAGE_CLASS_1_X_32 = 0x82BB,
  eGL_IMAGE_CLASS_4_X_16 = 0x82BC,
  eGL_IMAGE_CLASS_2_X_16 = 0x82BD,
  eGL_IMAGE_CLASS_1_X_16 = 0x82BE,
  eGL_IMAGE_CLASS_4_X_8 = 0x82BF,
  eGL_IMAGE_CLASS_2_X_8 = 0x82C0,
  eGL_IMAGE_CLASS_1_X_8 = 0x82C1,
  eGL_IMAGE_CLASS_11_11_10 = 0x82C2,
  eGL_IMAGE_CLASS_10_10_10_2 = 0x82C3,
  eGL_VIEW_CLASS_128_BITS = 0x82C4,
  eGL_VIEW_CLASS_96_BITS = 0x82C5,
  eGL_VIEW_CLASS_64_BITS = 0x82C6,
  eGL_VIEW_CLASS_48_BITS = 0x82C7,
  eGL_VIEW_CLASS_32_BITS = 0x82C8,
  eGL_VIEW_CLASS_24_BITS = 0x82C9,
  eGL_VIEW_CLASS_16_BITS = 0x82CA,
  eGL_VIEW_CLASS_8_BITS = 0x82CB,
  eGL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC,
  eGL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD,
  eGL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE,
  eGL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF,
  eGL_VIEW_CLASS_RGTC1_RED = 0x82D0,
  eGL_VIEW_CLASS_RGTC2_RG = 0x82D1,
  eGL_VIEW_CLASS_BPTC_UNORM = 0x82D2,
  eGL_VIEW_CLASS_BPTC_FLOAT = 0x82D3,
  eGL_VERTEX_SUBROUTINE = 0x92E8,
  eGL_TESS_CONTROL_SUBROUTINE = 0x92E9,
  eGL_TESS_EVALUATION_SUBROUTINE = 0x92EA,
  eGL_GEOMETRY_SUBROUTINE = 0x92EB,
  eGL_FRAGMENT_SUBROUTINE = 0x92EC,
  eGL_COMPUTE_SUBROUTINE = 0x92ED,
  eGL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE,
  eGL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF,
  eGL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0,
  eGL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1,
  eGL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2,
  eGL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3,
  eGL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8,
  eGL_LOCATION_INDEX = 0x930F,
  eGL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB,
  eGL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC,
  eGL_TEXTURE_VIEW_MIN_LAYER = 0x82DD,
  eGL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE,
  eGL_MAP_PERSISTENT_BIT = 0x0040,
  eGL_MAP_COHERENT_BIT = 0x0080,
  eGL_DYNAMIC_STORAGE_BIT = 0x0100,
  eGL_CLIENT_STORAGE_BIT = 0x0200,
  eGL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000,
  eGL_BUFFER_IMMUTABLE_STORAGE = 0x821F,
  eGL_BUFFER_STORAGE_FLAGS = 0x8220,
  eGL_CLEAR_TEXTURE = 0x9365,
  eGL_LOCATION_COMPONENT = 0x934A,
  eGL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B,
  eGL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C,
  eGL_QUERY_BUFFER = 0x9192,
  eGL_QUERY_BUFFER_BARRIER_BIT = 0x00008000,
  eGL_QUERY_BUFFER_BINDING = 0x9193,
  eGL_QUERY_RESULT_NO_WAIT = 0x9194,
  eGL_MIRROR_CLAMP_TO_EDGE = 0x8743,
  eGL_NEGATIVE_ONE_TO_ONE = 0x935E,
  eGL_ZERO_TO_ONE = 0x935F,
  eGL_CLIP_ORIGIN = 0x935C,
  eGL_CLIP_DEPTH_MODE = 0x935D,
  eGL_QUERY_WAIT_INVERTED = 0x8E17,
  eGL_QUERY_NO_WAIT_INVERTED = 0x8E18,
  eGL_QUERY_BY_REGION_WAIT_INVERTED = 0x8E19,
  eGL_QUERY_BY_REGION_NO_WAIT_INVERTED = 0x8E1A,
  eGL_MAX_CULL_DISTANCES = 0x82F9,
  eGL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 0x82FA,
  eGL_TEXTURE_TARGET = 0x1006,
  eGL_QUERY_TARGET = 0x82EA,
  eGL_CONTEXT_RELEASE_BEHAVIOR = 0x82FB,
  eGL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 0x82FC,
  eGL_SHADER_BINARY_FORMAT_SPIR_V = 0x9551,
  eGL_SPIR_V_BINARY = 0x9552,
  eGL_PARAMETER_BUFFER = 0x80EE,
  eGL_PARAMETER_BUFFER_BINDING = 0x80EF,
  eGL_CONTEXT_FLAG_NO_ERROR_BIT = 0x00000008,
  eGL_VERTICES_SUBMITTED = 0x82EE,
  eGL_PRIMITIVES_SUBMITTED = 0x82EF,
  eGL_VERTEX_SHADER_INVOCATIONS = 0x82F0,
  eGL_TESS_CONTROL_SHADER_PATCHES = 0x82F1,
  eGL_TESS_EVALUATION_SHADER_INVOCATIONS = 0x82F2,
  eGL_GEOMETRY_SHADER_PRIMITIVES_EMITTED = 0x82F3,
  eGL_FRAGMENT_SHADER_INVOCATIONS = 0x82F4,
  eGL_COMPUTE_SHADER_INVOCATIONS = 0x82F5,
  eGL_CLIPPING_INPUT_PRIMITIVES = 0x82F6,
  eGL_CLIPPING_OUTPUT_PRIMITIVES = 0x82F7,
  eGL_POLYGON_OFFSET_CLAMP = 0x8E1B,
  eGL_SPIR_V_EXTENSIONS = 0x9553,
  eGL_NUM_SPIR_V_EXTENSIONS = 0x9554,
  eGL_TEXTURE_MAX_ANISOTROPY = 0x84FE,
  eGL_MAX_TEXTURE_MAX_ANISOTROPY = 0x84FF,
  eGL_TRANSFORM_FEEDBACK_OVERFLOW = 0x82EC,
  eGL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW = 0x82ED,
  eGL_PRIMITIVE_BOUNDING_BOX_ARB = 0x92BE,
  eGL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = 0x9381,
  eGL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = 0x9382,
  eGL_UNSIGNED_INT64_ARB = 0x140F,
  eGL_SYNC_CL_EVENT_ARB = 0x8240,
  eGL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241,
  eGL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344,
  eGL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB,
  eGL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345,
  eGL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF,
  eGL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242,
  eGL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243,
  eGL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244,
  eGL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245,
  eGL_DEBUG_SOURCE_API_ARB = 0x8246,
  eGL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247,
  eGL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248,
  eGL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249,
  eGL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A,
  eGL_DEBUG_SOURCE_OTHER_ARB = 0x824B,
  eGL_DEBUG_TYPE_ERROR_ARB = 0x824C,
  eGL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D,
  eGL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E,
  eGL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F,
  eGL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250,
  eGL_DEBUG_TYPE_OTHER_ARB = 0x8251,
  eGL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143,
  eGL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144,
  eGL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145,
  eGL_DEBUG_SEVERITY_HIGH_ARB = 0x9146,
  eGL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147,
  eGL_DEBUG_SEVERITY_LOW_ARB = 0x9148,
  eGL_LINES_ADJACENCY_ARB = 0x000A,
  eGL_LINE_STRIP_ADJACENCY_ARB = 0x000B,
  eGL_TRIANGLES_ADJACENCY_ARB = 0x000C,
  eGL_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D,
  eGL_PROGRAM_POINT_SIZE_ARB = 0x8642,
  eGL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29,
  eGL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9,
  eGL_GEOMETRY_SHADER_ARB = 0x8DD9,
  eGL_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA,
  eGL_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB,
  eGL_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC,
  eGL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD,
  eGL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE,
  eGL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF,
  eGL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0,
  eGL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1,
  eGL_SHADER_BINARY_FORMAT_SPIR_V_ARB = 0x9551,
  eGL_SPIR_V_BINARY_ARB = 0x9552,
  eGL_INT64_ARB = 0x140E,
  eGL_INT64_VEC2_ARB = 0x8FE9,
  eGL_INT64_VEC3_ARB = 0x8FEA,
  eGL_INT64_VEC4_ARB = 0x8FEB,
  eGL_UNSIGNED_INT64_VEC2_ARB = 0x8FF5,
  eGL_UNSIGNED_INT64_VEC3_ARB = 0x8FF6,
  eGL_UNSIGNED_INT64_VEC4_ARB = 0x8FF7,
  eGL_PARAMETER_BUFFER_ARB = 0x80EE,
  eGL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF,
  eGL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE,
  eGL_SRGB_DECODE_ARB = 0x8299,
  eGL_MAX_SHADER_COMPILER_THREADS_ARB = 0x91B0,
  eGL_COMPLETION_STATUS_ARB = 0x91B1,
  eGL_VERTICES_SUBMITTED_ARB = 0x82EE,
  eGL_PRIMITIVES_SUBMITTED_ARB = 0x82EF,
  eGL_VERTEX_SHADER_INVOCATIONS_ARB = 0x82F0,
  eGL_TESS_CONTROL_SHADER_PATCHES_ARB = 0x82F1,
  eGL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = 0x82F2,
  eGL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = 0x82F3,
  eGL_FRAGMENT_SHADER_INVOCATIONS_ARB = 0x82F4,
  eGL_COMPUTE_SHADER_INVOCATIONS_ARB = 0x82F5,
  eGL_CLIPPING_INPUT_PRIMITIVES_ARB = 0x82F6,
  eGL_CLIPPING_OUTPUT_PRIMITIVES_ARB = 0x82F7,
  eGL_PIXEL_PACK_BUFFER_ARB = 0x88EB,
  eGL_PIXEL_UNPACK_BUFFER_ARB = 0x88EC,
  eGL_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED,
  eGL_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF,
  eGL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004,
  eGL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252,
  eGL_GUILTY_CONTEXT_RESET_ARB = 0x8253,
  eGL_INNOCENT_CONTEXT_RESET_ARB = 0x8254,
  eGL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255,
  eGL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256,
  eGL_NO_RESET_NOTIFICATION_ARB = 0x8261,
  eGL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB = 0x933D,
  eGL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB = 0x933E,
  eGL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB = 0x933F,
  eGL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB = 0x9340,
  eGL_SAMPLE_LOCATION_ARB = 0x8E50,
  eGL_PROGRAMMABLE_SAMPLE_LOCATION_ARB = 0x9341,
  eGL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB = 0x9342,
  eGL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB = 0x9343,
  eGL_SAMPLE_SHADING_ARB = 0x8C36,
  eGL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37,
  eGL_SHADER_INCLUDE_ARB = 0x8DAE,
  eGL_NAMED_STRING_LENGTH_ARB = 0x8DE9,
  eGL_NAMED_STRING_TYPE_ARB = 0x8DEA,
  eGL_SPARSE_STORAGE_BIT_ARB = 0x0400,
  eGL_SPARSE_BUFFER_PAGE_SIZE_ARB = 0x82F8,
  eGL_TEXTURE_SPARSE_ARB = 0x91A6,
  eGL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7,
  eGL_NUM_SPARSE_LEVELS_ARB = 0x91AA,
  eGL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8,
  eGL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195,
  eGL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196,
  eGL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197,
  eGL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198,
  eGL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199,
  eGL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A,
  eGL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9,
  eGL_CLAMP_TO_BORDER_ARB = 0x812D,
  eGL_TEXTURE_BUFFER_ARB = 0x8C2A,
  eGL_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B,
  eGL_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C,
  eGL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D,
  eGL_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E,
  eGL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C,
  eGL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D,
  eGL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E,
  eGL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F,
  eGL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009,
  eGL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A,
  eGL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B,
  eGL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C,
  eGL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D,
  eGL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E,
  eGL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F,
  eGL_TEXTURE_REDUCTION_MODE_ARB = 0x9366,
  eGL_WEIGHTED_AVERAGE_ARB = 0x9367,
  eGL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E,
  eGL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F,
  eGL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F,
  eGL_MIRRORED_REPEAT_ARB = 0x8370,
  eGL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = 0x82EC,
  eGL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = 0x82ED,
  eGL_MULTIPLY_KHR = 0x9294,
  eGL_SCREEN_KHR = 0x9295,
  eGL_OVERLAY_KHR = 0x9296,
  eGL_DARKEN_KHR = 0x9297,
  eGL_LIGHTEN_KHR = 0x9298,
  eGL_COLORDODGE_KHR = 0x9299,
  eGL_COLORBURN_KHR = 0x929A,
  eGL_HARDLIGHT_KHR = 0x929B,
  eGL_SOFTLIGHT_KHR = 0x929C,
  eGL_DIFFERENCE_KHR = 0x929E,
  eGL_EXCLUSION_KHR = 0x92A0,
  eGL_HSL_HUE_KHR = 0x92AD,
  eGL_HSL_SATURATION_KHR = 0x92AE,
  eGL_HSL_COLOR_KHR = 0x92AF,
  eGL_HSL_LUMINOSITY_KHR = 0x92B0,
  eGL_BLEND_ADVANCED_COHERENT_KHR = 0x9285,
  eGL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = 0x00000008,
  eGL_MAX_SHADER_COMPILER_THREADS_KHR = 0x91B0,
  eGL_COMPLETION_STATUS_KHR = 0x91B1,
  eGL_CONTEXT_ROBUST_ACCESS = 0x90F3,
  eGL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0,
  eGL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1,
  eGL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2,
  eGL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3,
  eGL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4,
  eGL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5,
  eGL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6,
  eGL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7,
  eGL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8,
  eGL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9,
  eGL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA,
  eGL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB,
  eGL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC,
  eGL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD,
  eGL_COUNTER_TYPE_AMD = 0x8BC0,
  eGL_COUNTER_RANGE_AMD = 0x8BC1,
  eGL_UNSIGNED_INT64_AMD = 0x8BC2,
  eGL_PERCENTAGE_AMD = 0x8BC3,
  eGL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4,
  eGL_PERFMON_RESULT_SIZE_AMD = 0x8BC5,
  eGL_PERFMON_RESULT_AMD = 0x8BC6,
  eGL_RGB_422_APPLE = 0x8A1F,
  eGL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA,
  eGL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB,
  eGL_RGB_RAW_422_APPLE = 0x8A51,
  eGL_PROGRAM_PIPELINE_OBJECT_EXT = 0x8A4F,
  eGL_PROGRAM_OBJECT_EXT = 0x8B40,
  eGL_SHADER_OBJECT_EXT = 0x8B48,
  eGL_BUFFER_OBJECT_EXT = 0x9151,
  eGL_QUERY_OBJECT_EXT = 0x9153,
  eGL_VERTEX_ARRAY_OBJECT_EXT = 0x9154,
  eGL_PROGRAM_MATRIX_EXT = 0x8E2D,
  eGL_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E,
  eGL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F,
  eGL_POLYGON_OFFSET_CLAMP_EXT = 0x8E1B,
  eGL_RASTER_MULTISAMPLE_EXT = 0x9327,
  eGL_RASTER_SAMPLES_EXT = 0x9328,
  eGL_MAX_RASTER_SAMPLES_EXT = 0x9329,
  eGL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = 0x932A,
  eGL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = 0x932B,
  eGL_EFFECTIVE_RASTER_SAMPLES_EXT = 0x932C,
  eGL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0,
  eGL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1,
  eGL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2,
  eGL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3,
  eGL_TEXTURE_REDUCTION_MODE_EXT = 0x9366,
  eGL_WEIGHTED_AVERAGE_EXT = 0x9367,
  eGL_TEXTURE_SRGB_DECODE_EXT = 0x8A48,
  eGL_DECODE_EXT = 0x8A49,
  eGL_SKIP_DECODE_EXT = 0x8A4A,
  eGL_INCLUSIVE_EXT = 0x8F10,
  eGL_EXCLUSIVE_EXT = 0x8F11,
  eGL_WINDOW_RECTANGLE_EXT = 0x8F12,
  eGL_WINDOW_RECTANGLE_MODE_EXT = 0x8F13,
  eGL_MAX_WINDOW_RECTANGLES_EXT = 0x8F14,
  eGL_NUM_WINDOW_RECTANGLES_EXT = 0x8F15,
  eGL_CONSERVATIVE_RASTERIZATION_INTEL = 0x83FE,
  eGL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0x00000000,
  eGL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 0x00000001,
  eGL_PERFQUERY_WAIT_INTEL = 0x83FB,
  eGL_PERFQUERY_FLUSH_INTEL = 0x83FA,
  eGL_PERFQUERY_DONOT_FLUSH_INTEL = 0x83F9,
  eGL_PERFQUERY_COUNTER_EVENT_INTEL = 0x94F0,
  eGL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 0x94F1,
  eGL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 0x94F2,
  eGL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 0x94F3,
  eGL_PERFQUERY_COUNTER_RAW_INTEL = 0x94F4,
  eGL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 0x94F5,
  eGL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 0x94F8,
  eGL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 0x94F9,
  eGL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 0x94FA,
  eGL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 0x94FB,
  eGL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 0x94FC,
  eGL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 0x94FD,
  eGL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 0x94FE,
  eGL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 0x94FF,
  eGL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 0x9500,
  eGL_BLEND_OVERLAP_NV = 0x9281,
  eGL_BLEND_PREMULTIPLIED_SRC_NV = 0x9280,
  eGL_BLUE_NV = 0x1905,
  eGL_COLORBURN_NV = 0x929A,
  eGL_COLORDODGE_NV = 0x9299,
  eGL_CONJOINT_NV = 0x9284,
  eGL_CONTRAST_NV = 0x92A1,
  eGL_DARKEN_NV = 0x9297,
  eGL_DIFFERENCE_NV = 0x929E,
  eGL_DISJOINT_NV = 0x9283,
  eGL_DST_ATOP_NV = 0x928F,
  eGL_DST_IN_NV = 0x928B,
  eGL_DST_NV = 0x9287,
  eGL_DST_OUT_NV = 0x928D,
  eGL_DST_OVER_NV = 0x9289,
  eGL_EXCLUSION_NV = 0x92A0,
  eGL_GREEN_NV = 0x1904,
  eGL_HARDLIGHT_NV = 0x929B,
  eGL_HARDMIX_NV = 0x92A9,
  eGL_HSL_COLOR_NV = 0x92AF,
  eGL_HSL_HUE_NV = 0x92AD,
  eGL_HSL_LUMINOSITY_NV = 0x92B0,
  eGL_HSL_SATURATION_NV = 0x92AE,
  eGL_INVERT_OVG_NV = 0x92B4,
  eGL_INVERT_RGB_NV = 0x92A3,
  eGL_LIGHTEN_NV = 0x9298,
  eGL_LINEARBURN_NV = 0x92A5,
  eGL_LINEARDODGE_NV = 0x92A4,
  eGL_LINEARLIGHT_NV = 0x92A7,
  eGL_MINUS_CLAMPED_NV = 0x92B3,
  eGL_MINUS_NV = 0x929F,
  eGL_MULTIPLY_NV = 0x9294,
  eGL_OVERLAY_NV = 0x9296,
  eGL_PINLIGHT_NV = 0x92A8,
  eGL_PLUS_CLAMPED_ALPHA_NV = 0x92B2,
  eGL_PLUS_CLAMPED_NV = 0x92B1,
  eGL_PLUS_DARKER_NV = 0x9292,
  eGL_PLUS_NV = 0x9291,
  eGL_RED_NV = 0x1903,
  eGL_SCREEN_NV = 0x9295,
  eGL_SOFTLIGHT_NV = 0x929C,
  eGL_SRC_ATOP_NV = 0x928E,
  eGL_SRC_IN_NV = 0x928A,
  eGL_SRC_NV = 0x9286,
  eGL_SRC_OUT_NV = 0x928C,
  eGL_SRC_OVER_NV = 0x9288,
  eGL_UNCORRELATED_NV = 0x9282,
  eGL_VIVIDLIGHT_NV = 0x92A6,
  eGL_XOR_NV = 0x1506,
  eGL_BLEND_ADVANCED_COHERENT_NV = 0x9285,
  eGL_FACTOR_MIN_AMD = 0x901C,
  eGL_FACTOR_MAX_AMD = 0x901D,
  eGL_VIEWPORT_POSITION_W_SCALE_NV = 0x937C,
  eGL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV = 0x937D,
  eGL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV = 0x937E,
  eGL_TERMINATE_SEQUENCE_COMMAND_NV = 0x0000,
  eGL_NOP_COMMAND_NV = 0x0001,
  eGL_DRAW_ELEMENTS_COMMAND_NV = 0x0002,
  eGL_DRAW_ARRAYS_COMMAND_NV = 0x0003,
  eGL_DRAW_ELEMENTS_STRIP_COMMAND_NV = 0x0004,
  eGL_DRAW_ARRAYS_STRIP_COMMAND_NV = 0x0005,
  eGL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = 0x0006,
  eGL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = 0x0007,
  eGL_ELEMENT_ADDRESS_COMMAND_NV = 0x0008,
  eGL_ATTRIBUTE_ADDRESS_COMMAND_NV = 0x0009,
  eGL_UNIFORM_ADDRESS_COMMAND_NV = 0x000A,
  eGL_BLEND_COLOR_COMMAND_NV = 0x000B,
  eGL_STENCIL_REF_COMMAND_NV = 0x000C,
  eGL_LINE_WIDTH_COMMAND_NV = 0x000D,
  eGL_POLYGON_OFFSET_COMMAND_NV = 0x000E,
  eGL_ALPHA_REF_COMMAND_NV = 0x000F,
  eGL_VIEWPORT_COMMAND_NV = 0x0010,
  eGL_SCISSOR_COMMAND_NV = 0x0011,
  eGL_FRONT_FACE_COMMAND_NV = 0x0012,
  eGL_QUERY_WAIT_NV = 0x8E13,
  eGL_QUERY_NO_WAIT_NV = 0x8E14,
  eGL_QUERY_BY_REGION_WAIT_NV = 0x8E15,
  eGL_QUERY_BY_REGION_NO_WAIT_NV = 0x8E16,
  eGL_CONSERVATIVE_RASTERIZATION_NV = 0x9346,
  eGL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = 0x9347,
  eGL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = 0x9348,
  eGL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = 0x9349,
  eGL_CONSERVATIVE_RASTER_DILATE_NV = 0x9379,
  eGL_CONSERVATIVE_RASTER_DILATE_RANGE_NV = 0x937A,
  eGL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV = 0x937B,
  eGL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV = 0x9550,
  eGL_CONSERVATIVE_RASTER_MODE_NV = 0x954D,
  eGL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV = 0x954E,
  eGL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV = 0x954F,
  eGL_FILL_RECTANGLE_NV = 0x933C,
  eGL_FRAGMENT_COVERAGE_TO_COLOR_NV = 0x92DD,
  eGL_FRAGMENT_COVERAGE_COLOR_NV = 0x92DE,
  eGL_COVERAGE_MODULATION_TABLE_NV = 0x9331,
  eGL_COLOR_SAMPLES_NV = 0x8E20,
  eGL_DEPTH_SAMPLES_NV = 0x932D,
  eGL_STENCIL_SAMPLES_NV = 0x932E,
  eGL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = 0x932F,
  eGL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = 0x9330,
  eGL_COVERAGE_MODULATION_NV = 0x9332,
  eGL_COVERAGE_MODULATION_TABLE_SIZE_NV = 0x9333,
  eGL_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB,
  eGL_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10,
  eGL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11,
  eGL_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12,
  eGL_INT64_NV = 0x140E,
  eGL_UNSIGNED_INT64_NV = 0x140F,
  eGL_INT8_NV = 0x8FE0,
  eGL_INT8_VEC2_NV = 0x8FE1,
  eGL_INT8_VEC3_NV = 0x8FE2,
  eGL_INT8_VEC4_NV = 0x8FE3,
  eGL_INT16_NV = 0x8FE4,
  eGL_INT16_VEC2_NV = 0x8FE5,
  eGL_INT16_VEC3_NV = 0x8FE6,
  eGL_INT16_VEC4_NV = 0x8FE7,
  eGL_INT64_VEC2_NV = 0x8FE9,
  eGL_INT64_VEC3_NV = 0x8FEA,
  eGL_INT64_VEC4_NV = 0x8FEB,
  eGL_UNSIGNED_INT8_NV = 0x8FEC,
  eGL_UNSIGNED_INT8_VEC2_NV = 0x8FED,
  eGL_UNSIGNED_INT8_VEC3_NV = 0x8FEE,
  eGL_UNSIGNED_INT8_VEC4_NV = 0x8FEF,
  eGL_UNSIGNED_INT16_NV = 0x8FF0,
  eGL_UNSIGNED_INT16_VEC2_NV = 0x8FF1,
  eGL_UNSIGNED_INT16_VEC3_NV = 0x8FF2,
  eGL_UNSIGNED_INT16_VEC4_NV = 0x8FF3,
  eGL_UNSIGNED_INT64_VEC2_NV = 0x8FF5,
  eGL_UNSIGNED_INT64_VEC3_NV = 0x8FF6,
  eGL_UNSIGNED_INT64_VEC4_NV = 0x8FF7,
  eGL_FLOAT16_NV = 0x8FF8,
  eGL_FLOAT16_VEC2_NV = 0x8FF9,
  eGL_FLOAT16_VEC3_NV = 0x8FFA,
  eGL_FLOAT16_VEC4_NV = 0x8FFB,
  eGL_MULTISAMPLES_NV = 0x9371,
  eGL_SUPERSAMPLE_SCALE_X_NV = 0x9372,
  eGL_SUPERSAMPLE_SCALE_Y_NV = 0x9373,
  eGL_CONFORMANT_NV = 0x9374,
  eGL_PATH_FORMAT_SVG_NV = 0x9070,
  eGL_PATH_FORMAT_PS_NV = 0x9071,
  eGL_STANDARD_FONT_NAME_NV = 0x9072,
  eGL_SYSTEM_FONT_NAME_NV = 0x9073,
  eGL_FILE_NAME_NV = 0x9074,
  eGL_PATH_STROKE_WIDTH_NV = 0x9075,
  eGL_PATH_END_CAPS_NV = 0x9076,
  eGL_PATH_INITIAL_END_CAP_NV = 0x9077,
  eGL_PATH_TERMINAL_END_CAP_NV = 0x9078,
  eGL_PATH_JOIN_STYLE_NV = 0x9079,
  eGL_PATH_MITER_LIMIT_NV = 0x907A,
  eGL_PATH_DASH_CAPS_NV = 0x907B,
  eGL_PATH_INITIAL_DASH_CAP_NV = 0x907C,
  eGL_PATH_TERMINAL_DASH_CAP_NV = 0x907D,
  eGL_PATH_DASH_OFFSET_NV = 0x907E,
  eGL_PATH_CLIENT_LENGTH_NV = 0x907F,
  eGL_PATH_FILL_MODE_NV = 0x9080,
  eGL_PATH_FILL_MASK_NV = 0x9081,
  eGL_PATH_FILL_COVER_MODE_NV = 0x9082,
  eGL_PATH_STROKE_COVER_MODE_NV = 0x9083,
  eGL_PATH_STROKE_MASK_NV = 0x9084,
  eGL_COUNT_UP_NV = 0x9088,
  eGL_COUNT_DOWN_NV = 0x9089,
  eGL_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A,
  eGL_CONVEX_HULL_NV = 0x908B,
  eGL_BOUNDING_BOX_NV = 0x908D,
  eGL_TRANSLATE_X_NV = 0x908E,
  eGL_TRANSLATE_Y_NV = 0x908F,
  eGL_TRANSLATE_2D_NV = 0x9090,
  eGL_TRANSLATE_3D_NV = 0x9091,
  eGL_AFFINE_2D_NV = 0x9092,
  eGL_AFFINE_3D_NV = 0x9094,
  eGL_TRANSPOSE_AFFINE_2D_NV = 0x9096,
  eGL_TRANSPOSE_AFFINE_3D_NV = 0x9098,
  eGL_UTF8_NV = 0x909A,
  eGL_UTF16_NV = 0x909B,
  eGL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C,
  eGL_PATH_COMMAND_COUNT_NV = 0x909D,
  eGL_PATH_COORD_COUNT_NV = 0x909E,
  eGL_PATH_DASH_ARRAY_COUNT_NV = 0x909F,
  eGL_PATH_COMPUTED_LENGTH_NV = 0x90A0,
  eGL_PATH_FILL_BOUNDING_BOX_NV = 0x90A1,
  eGL_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2,
  eGL_SQUARE_NV = 0x90A3,
  eGL_ROUND_NV = 0x90A4,
  eGL_TRIANGULAR_NV = 0x90A5,
  eGL_BEVEL_NV = 0x90A6,
  eGL_MITER_REVERT_NV = 0x90A7,
  eGL_MITER_TRUNCATE_NV = 0x90A8,
  eGL_SKIP_MISSING_GLYPH_NV = 0x90A9,
  eGL_USE_MISSING_GLYPH_NV = 0x90AA,
  eGL_PATH_ERROR_POSITION_NV = 0x90AB,
  eGL_ACCUM_ADJACENT_PAIRS_NV = 0x90AD,
  eGL_ADJACENT_PAIRS_NV = 0x90AE,
  eGL_FIRST_TO_REST_NV = 0x90AF,
  eGL_PATH_GEN_MODE_NV = 0x90B0,
  eGL_PATH_GEN_COEFF_NV = 0x90B1,
  eGL_PATH_GEN_COMPONENTS_NV = 0x90B3,
  eGL_PATH_STENCIL_FUNC_NV = 0x90B7,
  eGL_PATH_STENCIL_REF_NV = 0x90B8,
  eGL_PATH_STENCIL_VALUE_MASK_NV = 0x90B9,
  eGL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD,
  eGL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE,
  eGL_PATH_COVER_DEPTH_FUNC_NV = 0x90BF,
  eGL_PATH_DASH_OFFSET_RESET_NV = 0x90B4,
  eGL_MOVE_TO_RESETS_NV = 0x90B5,
  eGL_MOVE_TO_CONTINUES_NV = 0x90B6,
  eGL_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000,
  eGL_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000,
  eGL_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000,
  eGL_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000,
  eGL_FONT_UNITS_PER_EM_BIT_NV = 0x00100000,
  eGL_FONT_ASCENDER_BIT_NV = 0x00200000,
  eGL_FONT_DESCENDER_BIT_NV = 0x00400000,
  eGL_FONT_HEIGHT_BIT_NV = 0x00800000,
  eGL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000,
  eGL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000,
  eGL_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000,
  eGL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000,
  eGL_FONT_HAS_KERNING_BIT_NV = 0x10000000,
  eGL_FONT_GLYPHS_AVAILABLE_NV = 0x9368,
  eGL_FONT_TARGET_UNAVAILABLE_NV = 0x9369,
  eGL_FONT_UNAVAILABLE_NV = 0x936A,
  eGL_FONT_UNINTELLIGIBLE_NV = 0x936B,
  eGL_FONT_NUM_GLYPH_INDICES_BIT_NV = 0x20000000,
  eGL_STANDARD_FONT_FORMAT_NV = 0x936C,
  eGL_PATH_PROJECTION_NV = 0x1701,
  eGL_PATH_MODELVIEW_NV = 0x1700,
  eGL_PATH_MODELVIEW_STACK_DEPTH_NV = 0x0BA3,
  eGL_PATH_MODELVIEW_MATRIX_NV = 0x0BA6,
  eGL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = 0x0D36,
  eGL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = 0x84E3,
  eGL_PATH_PROJECTION_STACK_DEPTH_NV = 0x0BA4,
  eGL_PATH_PROJECTION_MATRIX_NV = 0x0BA7,
  eGL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = 0x0D38,
  eGL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = 0x84E4,
  eGL_FRAGMENT_INPUT_NV = 0x936D,
  eGL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 0x933D,
  eGL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 0x933E,
  eGL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 0x933F,
  eGL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 0x9340,
  eGL_SAMPLE_LOCATION_NV = 0x8E50,
  eGL_PROGRAMMABLE_SAMPLE_LOCATION_NV = 0x9341,
  eGL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 0x9342,
  eGL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 0x9343,
  eGL_BUFFER_GPU_ADDRESS_NV = 0x8F1D,
  eGL_GPU_ADDRESS_NV = 0x8F34,
  eGL_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35,
  eGL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = 0x00000010,
  eGL_WARP_SIZE_NV = 0x9339,
  eGL_WARPS_PER_SM_NV = 0x933A,
  eGL_SM_COUNT_NV = 0x933B,
  eGL_UNIFORM_BUFFER_UNIFIED_NV = 0x936E,
  eGL_UNIFORM_BUFFER_ADDRESS_NV = 0x936F,
  eGL_UNIFORM_BUFFER_LENGTH_NV = 0x9370,
  eGL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E,
  eGL_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F,
  eGL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20,
  eGL_VERTEX_ARRAY_ADDRESS_NV = 0x8F21,
  eGL_NORMAL_ARRAY_ADDRESS_NV = 0x8F22,
  eGL_COLOR_ARRAY_ADDRESS_NV = 0x8F23,
  eGL_INDEX_ARRAY_ADDRESS_NV = 0x8F24,
  eGL_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25,
  eGL_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26,
  eGL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27,
  eGL_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28,
  eGL_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29,
  eGL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A,
  eGL_VERTEX_ARRAY_LENGTH_NV = 0x8F2B,
  eGL_NORMAL_ARRAY_LENGTH_NV = 0x8F2C,
  eGL_COLOR_ARRAY_LENGTH_NV = 0x8F2D,
  eGL_INDEX_ARRAY_LENGTH_NV = 0x8F2E,
  eGL_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F,
  eGL_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30,
  eGL_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31,
  eGL_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32,
  eGL_ELEMENT_ARRAY_LENGTH_NV = 0x8F33,
  eGL_DRAW_INDIRECT_UNIFIED_NV = 0x8F40,
  eGL_DRAW_INDIRECT_ADDRESS_NV = 0x8F41,
  eGL_DRAW_INDIRECT_LENGTH_NV = 0x8F42,
  eGL_VIEWPORT_SWIZZLE_POSITIVE_X_NV = 0x9350,
  eGL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV = 0x9351,
  eGL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV = 0x9352,
  eGL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV = 0x9353,
  eGL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV = 0x9354,
  eGL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV = 0x9355,
  eGL_VIEWPORT_SWIZZLE_POSITIVE_W_NV = 0x9356,
  eGL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV = 0x9357,
  eGL_VIEWPORT_SWIZZLE_X_NV = 0x9358,
  eGL_VIEWPORT_SWIZZLE_Y_NV = 0x9359,
  eGL_VIEWPORT_SWIZZLE_Z_NV = 0x935A,
  eGL_VIEWPORT_SWIZZLE_W_NV = 0x935B,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = 0x9630,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = 0x9632,
  eGL_MAX_VIEWS_OVR = 0x9631,
  eGL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR = 0x9633,
  eGL_RESCALE_NORMAL = 0x803A,
  eGL_LIGHT_MODEL_COLOR_CONTROL = 0x81F8,
  eGL_SINGLE_COLOR = 0x81F9,
  eGL_SEPARATE_SPECULAR_COLOR = 0x81FA,
  eGL_CLIENT_ACTIVE_TEXTURE = 0x84E1,
  eGL_MAX_TEXTURE_UNITS = 0x84E2,
  eGL_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3,
  eGL_TRANSPOSE_PROJECTION_MATRIX = 0x84E4,
  eGL_TRANSPOSE_TEXTURE_MATRIX = 0x84E5,
  eGL_TRANSPOSE_COLOR_MATRIX = 0x84E6,
  eGL_MULTISAMPLE_BIT = 0x20000000,
  eGL_NORMAL_MAP = 0x8511,
  eGL_REFLECTION_MAP = 0x8512,
  eGL_COMPRESSED_ALPHA = 0x84E9,
  eGL_COMPRESSED_LUMINANCE = 0x84EA,
  eGL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB,
  eGL_COMPRESSED_INTENSITY = 0x84EC,
  eGL_COMBINE = 0x8570,
  eGL_COMBINE_RGB = 0x8571,
  eGL_COMBINE_ALPHA = 0x8572,
  eGL_SOURCE0_RGB = 0x8580,
  eGL_SOURCE1_RGB = 0x8581,
  eGL_SOURCE2_RGB = 0x8582,
  eGL_SOURCE0_ALPHA = 0x8588,
  eGL_SOURCE1_ALPHA = 0x8589,
  eGL_SOURCE2_ALPHA = 0x858A,
  eGL_OPERAND0_RGB = 0x8590,
  eGL_OPERAND1_RGB = 0x8591,
  eGL_OPERAND2_RGB = 0x8592,
  eGL_OPERAND0_ALPHA = 0x8598,
  eGL_OPERAND1_ALPHA = 0x8599,
  eGL_OPERAND2_ALPHA = 0x859A,
  eGL_RGB_SCALE = 0x8573,
  eGL_ADD_SIGNED = 0x8574,
  eGL_INTERPOLATE = 0x8575,
  eGL_SUBTRACT = 0x84E7,
  eGL_CONSTANT = 0x8576,
  eGL_PRIMARY_COLOR = 0x8577,
  eGL_PREVIOUS = 0x8578,
  eGL_DOT3_RGB = 0x86AE,
  eGL_DOT3_RGBA = 0x86AF,
  eGL_POINT_SIZE_MIN = 0x8126,
  eGL_POINT_SIZE_MAX = 0x8127,
  eGL_POINT_DISTANCE_ATTENUATION = 0x8129,
  eGL_GENERATE_MIPMAP = 0x8191,
  eGL_FOG_COORDINATE_SOURCE = 0x8450,
  eGL_FOG_COORDINATE = 0x8451,
  eGL_FRAGMENT_DEPTH = 0x8452,
  eGL_CURRENT_FOG_COORDINATE = 0x8453,
  eGL_FOG_COORDINATE_ARRAY_TYPE = 0x8454,
  eGL_FOG_COORDINATE_ARRAY_STRIDE = 0x8455,
  eGL_FOG_COORDINATE_ARRAY_POINTER = 0x8456,
  eGL_FOG_COORDINATE_ARRAY = 0x8457,
  eGL_COLOR_SUM = 0x8458,
  eGL_CURRENT_SECONDARY_COLOR = 0x8459,
  eGL_SECONDARY_COLOR_ARRAY_SIZE = 0x845A,
  eGL_SECONDARY_COLOR_ARRAY_TYPE = 0x845B,
  eGL_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C,
  eGL_SECONDARY_COLOR_ARRAY_POINTER = 0x845D,
  eGL_SECONDARY_COLOR_ARRAY = 0x845E,
  eGL_TEXTURE_FILTER_CONTROL = 0x8500,
  eGL_DEPTH_TEXTURE_MODE = 0x884B,
  eGL_COMPARE_R_TO_TEXTURE = 0x884E,
  eGL_VERTEX_ARRAY_BUFFER_BINDING = 0x8896,
  eGL_NORMAL_ARRAY_BUFFER_BINDING = 0x8897,
  eGL_COLOR_ARRAY_BUFFER_BINDING = 0x8898,
  eGL_INDEX_ARRAY_BUFFER_BINDING = 0x8899,
  eGL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A,
  eGL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B,
  eGL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C,
  eGL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D,
  eGL_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E,
  eGL_FOG_COORD_SRC = 0x8450,
  eGL_FOG_COORD = 0x8451,
  eGL_CURRENT_FOG_COORD = 0x8453,
  eGL_FOG_COORD_ARRAY_TYPE = 0x8454,
  eGL_FOG_COORD_ARRAY_STRIDE = 0x8455,
  eGL_FOG_COORD_ARRAY_POINTER = 0x8456,
  eGL_FOG_COORD_ARRAY = 0x8457,
  eGL_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D,
  eGL_SRC0_RGB = 0x8580,
  eGL_SRC1_RGB = 0x8581,
  eGL_SRC2_RGB = 0x8582,
  eGL_SRC0_ALPHA = 0x8588,
  eGL_SRC2_ALPHA = 0x858A,
  eGL_VERTEX_PROGRAM_TWO_SIDE = 0x8643,
  eGL_POINT_SPRITE = 0x8861,
  eGL_COORD_REPLACE = 0x8862,
  eGL_MAX_TEXTURE_COORDS = 0x8871,
  eGL_CURRENT_RASTER_SECONDARY_COLOR = 0x845F,
  eGL_SLUMINANCE_ALPHA = 0x8C44,
  eGL_SLUMINANCE8_ALPHA8 = 0x8C45,
  eGL_SLUMINANCE = 0x8C46,
  eGL_SLUMINANCE8 = 0x8C47,
  eGL_COMPRESSED_SLUMINANCE = 0x8C4A,
  eGL_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B,
  eGL_INDEX = 0x8222,
  eGL_TEXTURE_LUMINANCE_TYPE = 0x8C14,
  eGL_TEXTURE_INTENSITY_TYPE = 0x8C15,
  eGL_CLAMP_VERTEX_COLOR = 0x891A,
  eGL_CLAMP_FRAGMENT_COLOR = 0x891B,
  eGL_ALPHA_INTEGER = 0x8D97,
  eGL_DISPLAY_LIST = 0x82E7,
  eGL_RGBA_FLOAT_MODE_ARB = 0x8820,
  eGL_CLAMP_VERTEX_COLOR_ARB = 0x891A,
  eGL_CLAMP_FRAGMENT_COLOR_ARB = 0x891B,
  eGL_CLAMP_READ_COLOR_ARB = 0x891C,
  eGL_FIXED_ONLY_ARB = 0x891D,
  eGL_DEPTH_COMPONENT16_ARB = 0x81A5,
  eGL_DEPTH_COMPONENT24_ARB = 0x81A6,
  eGL_DEPTH_COMPONENT32_ARB = 0x81A7,
  eGL_TEXTURE_DEPTH_SIZE_ARB = 0x884A,
  eGL_DEPTH_TEXTURE_MODE_ARB = 0x884B,
  eGL_MAX_DRAW_BUFFERS_ARB = 0x8824,
  eGL_DRAW_BUFFER0_ARB = 0x8825,
  eGL_DRAW_BUFFER1_ARB = 0x8826,
  eGL_DRAW_BUFFER2_ARB = 0x8827,
  eGL_DRAW_BUFFER3_ARB = 0x8828,
  eGL_DRAW_BUFFER4_ARB = 0x8829,
  eGL_DRAW_BUFFER5_ARB = 0x882A,
  eGL_DRAW_BUFFER6_ARB = 0x882B,
  eGL_DRAW_BUFFER7_ARB = 0x882C,
  eGL_DRAW_BUFFER8_ARB = 0x882D,
  eGL_DRAW_BUFFER9_ARB = 0x882E,
  eGL_DRAW_BUFFER10_ARB = 0x882F,
  eGL_DRAW_BUFFER11_ARB = 0x8830,
  eGL_DRAW_BUFFER12_ARB = 0x8831,
  eGL_DRAW_BUFFER13_ARB = 0x8832,
  eGL_DRAW_BUFFER14_ARB = 0x8833,
  eGL_DRAW_BUFFER15_ARB = 0x8834,
  eGL_FRAGMENT_PROGRAM_ARB = 0x8804,
  eGL_PROGRAM_FORMAT_ASCII_ARB = 0x8875,
  eGL_PROGRAM_LENGTH_ARB = 0x8627,
  eGL_PROGRAM_FORMAT_ARB = 0x8876,
  eGL_PROGRAM_BINDING_ARB = 0x8677,
  eGL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0,
  eGL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1,
  eGL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2,
  eGL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3,
  eGL_PROGRAM_TEMPORARIES_ARB = 0x88A4,
  eGL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5,
  eGL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6,
  eGL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7,
  eGL_PROGRAM_PARAMETERS_ARB = 0x88A8,
  eGL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9,
  eGL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA,
  eGL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB,
  eGL_PROGRAM_ATTRIBS_ARB = 0x88AC,
  eGL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD,
  eGL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE,
  eGL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF,
  eGL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4,
  eGL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5,
  eGL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6,
  eGL_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805,
  eGL_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806,
  eGL_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807,
  eGL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808,
  eGL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809,
  eGL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A,
  eGL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B,
  eGL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C,
  eGL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D,
  eGL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E,
  eGL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F,
  eGL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810,
  eGL_PROGRAM_STRING_ARB = 0x8628,
  eGL_PROGRAM_ERROR_POSITION_ARB = 0x864B,
  eGL_CURRENT_MATRIX_ARB = 0x8641,
  eGL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7,
  eGL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640,
  eGL_MAX_PROGRAM_MATRICES_ARB = 0x862F,
  eGL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E,
  eGL_MAX_TEXTURE_COORDS_ARB = 0x8871,
  eGL_MAX_TEXTURE_IMAGE_UNITS_ARB = 0x8872,
  eGL_PROGRAM_ERROR_STRING_ARB = 0x8874,
  eGL_MATRIX0_ARB = 0x88C0,
  eGL_MATRIX1_ARB = 0x88C1,
  eGL_MATRIX2_ARB = 0x88C2,
  eGL_MATRIX3_ARB = 0x88C3,
  eGL_MATRIX4_ARB = 0x88C4,
  eGL_MATRIX5_ARB = 0x88C5,
  eGL_MATRIX6_ARB = 0x88C6,
  eGL_MATRIX7_ARB = 0x88C7,
  eGL_MATRIX8_ARB = 0x88C8,
  eGL_MATRIX9_ARB = 0x88C9,
  eGL_MATRIX10_ARB = 0x88CA,
  eGL_MATRIX11_ARB = 0x88CB,
  eGL_MATRIX12_ARB = 0x88CC,
  eGL_MATRIX13_ARB = 0x88CD,
  eGL_MATRIX14_ARB = 0x88CE,
  eGL_MATRIX15_ARB = 0x88CF,
  eGL_MATRIX16_ARB = 0x88D0,
  eGL_MATRIX17_ARB = 0x88D1,
  eGL_MATRIX18_ARB = 0x88D2,
  eGL_MATRIX19_ARB = 0x88D3,
  eGL_MATRIX20_ARB = 0x88D4,
  eGL_MATRIX21_ARB = 0x88D5,
  eGL_MATRIX22_ARB = 0x88D6,
  eGL_MATRIX23_ARB = 0x88D7,
  eGL_MATRIX24_ARB = 0x88D8,
  eGL_MATRIX25_ARB = 0x88D9,
  eGL_MATRIX26_ARB = 0x88DA,
  eGL_MATRIX27_ARB = 0x88DB,
  eGL_MATRIX28_ARB = 0x88DC,
  eGL_MATRIX29_ARB = 0x88DD,
  eGL_MATRIX30_ARB = 0x88DE,
  eGL_MATRIX31_ARB = 0x88DF,
  eGL_FRAGMENT_SHADER_ARB = 0x8B30,
  eGL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49,
  eGL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B,
  eGL_HALF_FLOAT_ARB = 0x140B,
  eGL_CONVOLUTION_1D = 0x8010,
  eGL_CONVOLUTION_2D = 0x8011,
  eGL_SEPARABLE_2D = 0x8012,
  eGL_CONVOLUTION_BORDER_MODE = 0x8013,
  eGL_CONVOLUTION_FILTER_SCALE = 0x8014,
  eGL_CONVOLUTION_FILTER_BIAS = 0x8015,
  eGL_REDUCE = 0x8016,
  eGL_CONVOLUTION_FORMAT = 0x8017,
  eGL_CONVOLUTION_WIDTH = 0x8018,
  eGL_CONVOLUTION_HEIGHT = 0x8019,
  eGL_MAX_CONVOLUTION_WIDTH = 0x801A,
  eGL_MAX_CONVOLUTION_HEIGHT = 0x801B,
  eGL_POST_CONVOLUTION_RED_SCALE = 0x801C,
  eGL_POST_CONVOLUTION_GREEN_SCALE = 0x801D,
  eGL_POST_CONVOLUTION_BLUE_SCALE = 0x801E,
  eGL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F,
  eGL_POST_CONVOLUTION_RED_BIAS = 0x8020,
  eGL_POST_CONVOLUTION_GREEN_BIAS = 0x8021,
  eGL_POST_CONVOLUTION_BLUE_BIAS = 0x8022,
  eGL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023,
  eGL_HISTOGRAM = 0x8024,
  eGL_PROXY_HISTOGRAM = 0x8025,
  eGL_HISTOGRAM_WIDTH = 0x8026,
  eGL_HISTOGRAM_FORMAT = 0x8027,
  eGL_HISTOGRAM_RED_SIZE = 0x8028,
  eGL_HISTOGRAM_GREEN_SIZE = 0x8029,
  eGL_HISTOGRAM_BLUE_SIZE = 0x802A,
  eGL_HISTOGRAM_ALPHA_SIZE = 0x802B,
  eGL_HISTOGRAM_LUMINANCE_SIZE = 0x802C,
  eGL_HISTOGRAM_SINK = 0x802D,
  eGL_MINMAX = 0x802E,
  eGL_MINMAX_FORMAT = 0x802F,
  eGL_MINMAX_SINK = 0x8030,
  eGL_TABLE_TOO_LARGE = 0x8031,
  eGL_COLOR_MATRIX = 0x80B1,
  eGL_COLOR_MATRIX_STACK_DEPTH = 0x80B2,
  eGL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3,
  eGL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4,
  eGL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5,
  eGL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6,
  eGL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7,
  eGL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8,
  eGL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9,
  eGL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA,
  eGL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB,
  eGL_COLOR_TABLE = 0x80D0,
  eGL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1,
  eGL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2,
  eGL_PROXY_COLOR_TABLE = 0x80D3,
  eGL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4,
  eGL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5,
  eGL_COLOR_TABLE_SCALE = 0x80D6,
  eGL_COLOR_TABLE_BIAS = 0x80D7,
  eGL_COLOR_TABLE_FORMAT = 0x80D8,
  eGL_COLOR_TABLE_WIDTH = 0x80D9,
  eGL_COLOR_TABLE_RED_SIZE = 0x80DA,
  eGL_COLOR_TABLE_GREEN_SIZE = 0x80DB,
  eGL_COLOR_TABLE_BLUE_SIZE = 0x80DC,
  eGL_COLOR_TABLE_ALPHA_SIZE = 0x80DD,
  eGL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE,
  eGL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF,
  eGL_CONSTANT_BORDER = 0x8151,
  eGL_REPLICATE_BORDER = 0x8153,
  eGL_CONVOLUTION_BORDER_COLOR = 0x8154,
  eGL_MATRIX_PALETTE_ARB = 0x8840,
  eGL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841,
  eGL_MAX_PALETTE_MATRICES_ARB = 0x8842,
  eGL_CURRENT_PALETTE_MATRIX_ARB = 0x8843,
  eGL_MATRIX_INDEX_ARRAY_ARB = 0x8844,
  eGL_CURRENT_MATRIX_INDEX_ARB = 0x8845,
  eGL_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846,
  eGL_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847,
  eGL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848,
  eGL_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849,
  eGL_MULTISAMPLE_ARB = 0x809D,
  eGL_SAMPLE_ALPHA_TO_COVERAGE_ARB = 0x809E,
  eGL_SAMPLE_ALPHA_TO_ONE_ARB = 0x809F,
  eGL_SAMPLE_COVERAGE_ARB = 0x80A0,
  eGL_SAMPLE_BUFFERS_ARB = 0x80A8,
  eGL_SAMPLES_ARB = 0x80A9,
  eGL_SAMPLE_COVERAGE_VALUE_ARB = 0x80AA,
  eGL_SAMPLE_COVERAGE_INVERT_ARB = 0x80AB,
  eGL_MULTISAMPLE_BIT_ARB = 0x20000000,
  eGL_TEXTURE0_ARB = 0x84C0,
  eGL_TEXTURE1_ARB = 0x84C1,
  eGL_TEXTURE2_ARB = 0x84C2,
  eGL_TEXTURE3_ARB = 0x84C3,
  eGL_TEXTURE4_ARB = 0x84C4,
  eGL_TEXTURE5_ARB = 0x84C5,
  eGL_TEXTURE6_ARB = 0x84C6,
  eGL_TEXTURE7_ARB = 0x84C7,
  eGL_TEXTURE8_ARB = 0x84C8,
  eGL_TEXTURE9_ARB = 0x84C9,
  eGL_TEXTURE10_ARB = 0x84CA,
  eGL_TEXTURE11_ARB = 0x84CB,
  eGL_TEXTURE12_ARB = 0x84CC,
  eGL_TEXTURE13_ARB = 0x84CD,
  eGL_TEXTURE14_ARB = 0x84CE,
  eGL_TEXTURE15_ARB = 0x84CF,
  eGL_TEXTURE16_ARB = 0x84D0,
  eGL_TEXTURE17_ARB = 0x84D1,
  eGL_TEXTURE18_ARB = 0x84D2,
  eGL_TEXTURE19_ARB = 0x84D3,
  eGL_TEXTURE20_ARB = 0x84D4,
  eGL_TEXTURE21_ARB = 0x84D5,
  eGL_TEXTURE22_ARB = 0x84D6,
  eGL_TEXTURE23_ARB = 0x84D7,
  eGL_TEXTURE24_ARB = 0x84D8,
  eGL_TEXTURE25_ARB = 0x84D9,
  eGL_TEXTURE26_ARB = 0x84DA,
  eGL_TEXTURE27_ARB = 0x84DB,
  eGL_TEXTURE28_ARB = 0x84DC,
  eGL_TEXTURE29_ARB = 0x84DD,
  eGL_TEXTURE30_ARB = 0x84DE,
  eGL_TEXTURE31_ARB = 0x84DF,
  eGL_ACTIVE_TEXTURE_ARB = 0x84E0,
  eGL_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1,
  eGL_MAX_TEXTURE_UNITS_ARB = 0x84E2,
  eGL_QUERY_COUNTER_BITS_ARB = 0x8864,
  eGL_CURRENT_QUERY_ARB = 0x8865,
  eGL_QUERY_RESULT_ARB = 0x8866,
  eGL_QUERY_RESULT_AVAILABLE_ARB = 0x8867,
  eGL_SAMPLES_PASSED_ARB = 0x8914,
  eGL_POINT_SIZE_MIN_ARB = 0x8126,
  eGL_POINT_SIZE_MAX_ARB = 0x8127,
  eGL_POINT_FADE_THRESHOLD_SIZE_ARB = 0x8128,
  eGL_POINT_DISTANCE_ATTENUATION_ARB = 0x8129,
  eGL_POINT_SPRITE_ARB = 0x8861,
  eGL_COORD_REPLACE_ARB = 0x8862,
  eGL_PROGRAM_OBJECT_ARB = 0x8B40,
  eGL_SHADER_OBJECT_ARB = 0x8B48,
  eGL_OBJECT_TYPE_ARB = 0x8B4E,
  eGL_OBJECT_SUBTYPE_ARB = 0x8B4F,
  eGL_FLOAT_VEC2_ARB = 0x8B50,
  eGL_FLOAT_VEC3_ARB = 0x8B51,
  eGL_FLOAT_VEC4_ARB = 0x8B52,
  eGL_INT_VEC2_ARB = 0x8B53,
  eGL_INT_VEC3_ARB = 0x8B54,
  eGL_INT_VEC4_ARB = 0x8B55,
  eGL_BOOL_ARB = 0x8B56,
  eGL_BOOL_VEC2_ARB = 0x8B57,
  eGL_BOOL_VEC3_ARB = 0x8B58,
  eGL_BOOL_VEC4_ARB = 0x8B59,
  eGL_FLOAT_MAT2_ARB = 0x8B5A,
  eGL_FLOAT_MAT3_ARB = 0x8B5B,
  eGL_FLOAT_MAT4_ARB = 0x8B5C,
  eGL_SAMPLER_1D_ARB = 0x8B5D,
  eGL_SAMPLER_2D_ARB = 0x8B5E,
  eGL_SAMPLER_3D_ARB = 0x8B5F,
  eGL_SAMPLER_CUBE_ARB = 0x8B60,
  eGL_SAMPLER_1D_SHADOW_ARB = 0x8B61,
  eGL_SAMPLER_2D_SHADOW_ARB = 0x8B62,
  eGL_SAMPLER_2D_RECT_ARB = 0x8B63,
  eGL_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64,
  eGL_OBJECT_DELETE_STATUS_ARB = 0x8B80,
  eGL_OBJECT_COMPILE_STATUS_ARB = 0x8B81,
  eGL_OBJECT_LINK_STATUS_ARB = 0x8B82,
  eGL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83,
  eGL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84,
  eGL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85,
  eGL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86,
  eGL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87,
  eGL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88,
  eGL_SHADING_LANGUAGE_VERSION_ARB = 0x8B8C,
  eGL_TEXTURE_COMPARE_MODE_ARB = 0x884C,
  eGL_TEXTURE_COMPARE_FUNC_ARB = 0x884D,
  eGL_COMPARE_R_TO_TEXTURE_ARB = 0x884E,
  eGL_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF,
  eGL_COMPRESSED_ALPHA_ARB = 0x84E9,
  eGL_COMPRESSED_LUMINANCE_ARB = 0x84EA,
  eGL_COMPRESSED_LUMINANCE_ALPHA_ARB = 0x84EB,
  eGL_COMPRESSED_INTENSITY_ARB = 0x84EC,
  eGL_COMPRESSED_RGB_ARB = 0x84ED,
  eGL_COMPRESSED_RGBA_ARB = 0x84EE,
  eGL_TEXTURE_COMPRESSION_HINT_ARB = 0x84EF,
  eGL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 0x86A0,
  eGL_TEXTURE_COMPRESSED_ARB = 0x86A1,
  eGL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A2,
  eGL_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A3,
  eGL_NORMAL_MAP_ARB = 0x8511,
  eGL_REFLECTION_MAP_ARB = 0x8512,
  eGL_TEXTURE_CUBE_MAP_ARB = 0x8513,
  eGL_TEXTURE_BINDING_CUBE_MAP_ARB = 0x8514,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x8515,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x8516,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x8517,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x8518,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x8519,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x851A,
  eGL_PROXY_TEXTURE_CUBE_MAP_ARB = 0x851B,
  eGL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = 0x851C,
  eGL_COMBINE_ARB = 0x8570,
  eGL_COMBINE_RGB_ARB = 0x8571,
  eGL_COMBINE_ALPHA_ARB = 0x8572,
  eGL_SOURCE0_RGB_ARB = 0x8580,
  eGL_SOURCE1_RGB_ARB = 0x8581,
  eGL_SOURCE2_RGB_ARB = 0x8582,
  eGL_SOURCE0_ALPHA_ARB = 0x8588,
  eGL_SOURCE1_ALPHA_ARB = 0x8589,
  eGL_SOURCE2_ALPHA_ARB = 0x858A,
  eGL_OPERAND0_RGB_ARB = 0x8590,
  eGL_OPERAND1_RGB_ARB = 0x8591,
  eGL_OPERAND2_RGB_ARB = 0x8592,
  eGL_OPERAND0_ALPHA_ARB = 0x8598,
  eGL_OPERAND1_ALPHA_ARB = 0x8599,
  eGL_OPERAND2_ALPHA_ARB = 0x859A,
  eGL_RGB_SCALE_ARB = 0x8573,
  eGL_ADD_SIGNED_ARB = 0x8574,
  eGL_INTERPOLATE_ARB = 0x8575,
  eGL_SUBTRACT_ARB = 0x84E7,
  eGL_CONSTANT_ARB = 0x8576,
  eGL_PRIMARY_COLOR_ARB = 0x8577,
  eGL_PREVIOUS_ARB = 0x8578,
  eGL_DOT3_RGB_ARB = 0x86AE,
  eGL_DOT3_RGBA_ARB = 0x86AF,
  eGL_TEXTURE_RED_TYPE_ARB = 0x8C10,
  eGL_TEXTURE_GREEN_TYPE_ARB = 0x8C11,
  eGL_TEXTURE_BLUE_TYPE_ARB = 0x8C12,
  eGL_TEXTURE_ALPHA_TYPE_ARB = 0x8C13,
  eGL_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14,
  eGL_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15,
  eGL_TEXTURE_DEPTH_TYPE_ARB = 0x8C16,
  eGL_UNSIGNED_NORMALIZED_ARB = 0x8C17,
  eGL_RGBA32F_ARB = 0x8814,
  eGL_RGB32F_ARB = 0x8815,
  eGL_ALPHA32F_ARB = 0x8816,
  eGL_INTENSITY32F_ARB = 0x8817,
  eGL_LUMINANCE32F_ARB = 0x8818,
  eGL_LUMINANCE_ALPHA32F_ARB = 0x8819,
  eGL_RGBA16F_ARB = 0x881A,
  eGL_RGB16F_ARB = 0x881B,
  eGL_ALPHA16F_ARB = 0x881C,
  eGL_INTENSITY16F_ARB = 0x881D,
  eGL_LUMINANCE16F_ARB = 0x881E,
  eGL_LUMINANCE_ALPHA16F_ARB = 0x881F,
  eGL_TEXTURE_RECTANGLE_ARB = 0x84F5,
  eGL_TEXTURE_BINDING_RECTANGLE_ARB = 0x84F6,
  eGL_PROXY_TEXTURE_RECTANGLE_ARB = 0x84F7,
  eGL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = 0x84F8,
  eGL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 0x84E3,
  eGL_TRANSPOSE_PROJECTION_MATRIX_ARB = 0x84E4,
  eGL_TRANSPOSE_TEXTURE_MATRIX_ARB = 0x84E5,
  eGL_TRANSPOSE_COLOR_MATRIX_ARB = 0x84E6,
  eGL_MAX_VERTEX_UNITS_ARB = 0x86A4,
  eGL_ACTIVE_VERTEX_UNITS_ARB = 0x86A5,
  eGL_WEIGHT_SUM_UNITY_ARB = 0x86A6,
  eGL_VERTEX_BLEND_ARB = 0x86A7,
  eGL_CURRENT_WEIGHT_ARB = 0x86A8,
  eGL_WEIGHT_ARRAY_TYPE_ARB = 0x86A9,
  eGL_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA,
  eGL_WEIGHT_ARRAY_SIZE_ARB = 0x86AB,
  eGL_WEIGHT_ARRAY_POINTER_ARB = 0x86AC,
  eGL_WEIGHT_ARRAY_ARB = 0x86AD,
  eGL_MODELVIEW0_ARB = 0x1700,
  eGL_MODELVIEW1_ARB = 0x850A,
  eGL_MODELVIEW2_ARB = 0x8722,
  eGL_MODELVIEW3_ARB = 0x8723,
  eGL_MODELVIEW4_ARB = 0x8724,
  eGL_MODELVIEW5_ARB = 0x8725,
  eGL_MODELVIEW6_ARB = 0x8726,
  eGL_MODELVIEW7_ARB = 0x8727,
  eGL_MODELVIEW8_ARB = 0x8728,
  eGL_MODELVIEW9_ARB = 0x8729,
  eGL_MODELVIEW10_ARB = 0x872A,
  eGL_MODELVIEW11_ARB = 0x872B,
  eGL_MODELVIEW12_ARB = 0x872C,
  eGL_MODELVIEW13_ARB = 0x872D,
  eGL_MODELVIEW14_ARB = 0x872E,
  eGL_MODELVIEW15_ARB = 0x872F,
  eGL_MODELVIEW16_ARB = 0x8730,
  eGL_MODELVIEW17_ARB = 0x8731,
  eGL_MODELVIEW18_ARB = 0x8732,
  eGL_MODELVIEW19_ARB = 0x8733,
  eGL_MODELVIEW20_ARB = 0x8734,
  eGL_MODELVIEW21_ARB = 0x8735,
  eGL_MODELVIEW22_ARB = 0x8736,
  eGL_MODELVIEW23_ARB = 0x8737,
  eGL_MODELVIEW24_ARB = 0x8738,
  eGL_MODELVIEW25_ARB = 0x8739,
  eGL_MODELVIEW26_ARB = 0x873A,
  eGL_MODELVIEW27_ARB = 0x873B,
  eGL_MODELVIEW28_ARB = 0x873C,
  eGL_MODELVIEW29_ARB = 0x873D,
  eGL_MODELVIEW30_ARB = 0x873E,
  eGL_MODELVIEW31_ARB = 0x873F,
  eGL_BUFFER_SIZE_ARB = 0x8764,
  eGL_BUFFER_USAGE_ARB = 0x8765,
  eGL_ARRAY_BUFFER_ARB = 0x8892,
  eGL_ELEMENT_ARRAY_BUFFER_ARB = 0x8893,
  eGL_ARRAY_BUFFER_BINDING_ARB = 0x8894,
  eGL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895,
  eGL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896,
  eGL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897,
  eGL_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898,
  eGL_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899,
  eGL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 0x889A,
  eGL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 0x889B,
  eGL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x889C,
  eGL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 0x889D,
  eGL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 0x889E,
  eGL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 0x889F,
  eGL_READ_ONLY_ARB = 0x88B8,
  eGL_WRITE_ONLY_ARB = 0x88B9,
  eGL_READ_WRITE_ARB = 0x88BA,
  eGL_BUFFER_ACCESS_ARB = 0x88BB,
  eGL_BUFFER_MAPPED_ARB = 0x88BC,
  eGL_BUFFER_MAP_POINTER_ARB = 0x88BD,
  eGL_STREAM_DRAW_ARB = 0x88E0,
  eGL_STREAM_READ_ARB = 0x88E1,
  eGL_STREAM_COPY_ARB = 0x88E2,
  eGL_STATIC_DRAW_ARB = 0x88E4,
  eGL_STATIC_READ_ARB = 0x88E5,
  eGL_STATIC_COPY_ARB = 0x88E6,
  eGL_DYNAMIC_DRAW_ARB = 0x88E8,
  eGL_DYNAMIC_READ_ARB = 0x88E9,
  eGL_DYNAMIC_COPY_ARB = 0x88EA,
  eGL_COLOR_SUM_ARB = 0x8458,
  eGL_VERTEX_PROGRAM_ARB = 0x8620,
  eGL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = 0x8622,
  eGL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = 0x8623,
  eGL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = 0x8624,
  eGL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = 0x8625,
  eGL_CURRENT_VERTEX_ATTRIB_ARB = 0x8626,
  eGL_VERTEX_PROGRAM_POINT_SIZE_ARB = 0x8642,
  eGL_VERTEX_PROGRAM_TWO_SIDE_ARB = 0x8643,
  eGL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = 0x8645,
  eGL_MAX_VERTEX_ATTRIBS_ARB = 0x8869,
  eGL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = 0x886A,
  eGL_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0,
  eGL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1,
  eGL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2,
  eGL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3,
  eGL_VERTEX_SHADER_ARB = 0x8B31,
  eGL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = 0x8B4A,
  eGL_MAX_VARYING_FLOATS_ARB = 0x8B4B,
  eGL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C,
  eGL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = 0x8B4D,
  eGL_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89,
  eGL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A,
  eGL_PALETTE4_RGB8_OES = 0x8B90,
  eGL_PALETTE4_RGBA8_OES = 0x8B91,
  eGL_PALETTE4_R5_G6_B5_OES = 0x8B92,
  eGL_PALETTE4_RGBA4_OES = 0x8B93,
  eGL_PALETTE4_RGB5_A1_OES = 0x8B94,
  eGL_PALETTE8_RGB8_OES = 0x8B95,
  eGL_PALETTE8_RGBA8_OES = 0x8B96,
  eGL_PALETTE8_R5_G6_B5_OES = 0x8B97,
  eGL_PALETTE8_RGBA4_OES = 0x8B98,
  eGL_PALETTE8_RGB5_A1_OES = 0x8B99,
  eGL_FIXED_OES = 0x140C,
  eGL_IMPLEMENTATION_COLOR_READ_TYPE_OES = 0x8B9A,
  eGL_IMPLEMENTATION_COLOR_READ_FORMAT_OES = 0x8B9B,
  eGL_MULTISAMPLE_3DFX = 0x86B2,
  eGL_SAMPLE_BUFFERS_3DFX = 0x86B3,
  eGL_SAMPLES_3DFX = 0x86B4,
  eGL_MULTISAMPLE_BIT_3DFX = 0x20000000,
  eGL_COMPRESSED_RGB_FXT1_3DFX = 0x86B0,
  eGL_COMPRESSED_RGBA_FXT1_3DFX = 0x86B1,
  eGL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 0x9143,
  eGL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 0x9144,
  eGL_DEBUG_LOGGED_MESSAGES_AMD = 0x9145,
  eGL_DEBUG_SEVERITY_HIGH_AMD = 0x9146,
  eGL_DEBUG_SEVERITY_MEDIUM_AMD = 0x9147,
  eGL_DEBUG_SEVERITY_LOW_AMD = 0x9148,
  eGL_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149,
  eGL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A,
  eGL_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B,
  eGL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C,
  eGL_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D,
  eGL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E,
  eGL_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F,
  eGL_DEBUG_CATEGORY_OTHER_AMD = 0x9150,
  eGL_DEPTH_CLAMP_NEAR_AMD = 0x901E,
  eGL_DEPTH_CLAMP_FAR_AMD = 0x901F,
  eGL_SUBSAMPLE_DISTANCE_AMD = 0x883F,
  eGL_PIXELS_PER_SAMPLE_PATTERN_X_AMD = 0x91AE,
  eGL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD = 0x91AF,
  eGL_ALL_PIXELS_AMD = 0xFFFFFFFF,
  eGL_FLOAT16_MAT2_AMD = 0x91C5,
  eGL_FLOAT16_MAT3_AMD = 0x91C6,
  eGL_FLOAT16_MAT4_AMD = 0x91C7,
  eGL_FLOAT16_MAT2x3_AMD = 0x91C8,
  eGL_FLOAT16_MAT2x4_AMD = 0x91C9,
  eGL_FLOAT16_MAT3x2_AMD = 0x91CA,
  eGL_FLOAT16_MAT3x4_AMD = 0x91CB,
  eGL_FLOAT16_MAT4x2_AMD = 0x91CC,
  eGL_FLOAT16_MAT4x3_AMD = 0x91CD,
  eGL_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4,
  eGL_VERTEX_ID_SWIZZLE_AMD = 0x91A5,
  eGL_DATA_BUFFER_AMD = 0x9151,
  eGL_PERFORMANCE_MONITOR_AMD = 0x9152,
  eGL_QUERY_OBJECT_AMD = 0x9153,
  eGL_VERTEX_ARRAY_OBJECT_AMD = 0x9154,
  eGL_SAMPLER_OBJECT_AMD = 0x9155,
  eGL_OCCLUSION_QUERY_EVENT_MASK_AMD = 0x874F,
  eGL_QUERY_DEPTH_PASS_EVENT_BIT_AMD = 0x00000001,
  eGL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = 0x00000002,
  eGL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = 0x00000004,
  eGL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = 0x00000008,
  eGL_QUERY_ALL_EVENT_BITS_AMD = 0xFFFFFFFF,
  eGL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160,
  eGL_QUERY_BUFFER_AMD = 0x9192,
  eGL_QUERY_BUFFER_BINDING_AMD = 0x9193,
  eGL_QUERY_RESULT_NO_WAIT_AMD = 0x9194,
  eGL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195,
  eGL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196,
  eGL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197,
  eGL_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198,
  eGL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199,
  eGL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A,
  eGL_MIN_SPARSE_LEVEL_AMD = 0x919B,
  eGL_MIN_LOD_WARNING_AMD = 0x919C,
  eGL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001,
  eGL_SET_AMD = 0x874A,
  eGL_REPLACE_VALUE_AMD = 0x874B,
  eGL_STENCIL_OP_VALUE_AMD = 0x874C,
  eGL_STENCIL_BACK_OP_VALUE_AMD = 0x874D,
  eGL_STREAM_RASTERIZATION_AMD = 0x91A0,
  eGL_SAMPLER_BUFFER_AMD = 0x9001,
  eGL_INT_SAMPLER_BUFFER_AMD = 0x9002,
  eGL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003,
  eGL_TESSELLATION_MODE_AMD = 0x9004,
  eGL_TESSELLATION_FACTOR_AMD = 0x9005,
  eGL_DISCRETE_AMD = 0x9006,
  eGL_CONTINUOUS_AMD = 0x9007,
  eGL_AUX_DEPTH_STENCIL_APPLE = 0x8A14,
  eGL_UNPACK_CLIENT_STORAGE_APPLE = 0x85B2,
  eGL_ELEMENT_ARRAY_APPLE = 0x8A0C,
  eGL_ELEMENT_ARRAY_TYPE_APPLE = 0x8A0D,
  eGL_ELEMENT_ARRAY_POINTER_APPLE = 0x8A0E,
  eGL_DRAW_PIXELS_APPLE = 0x8A0A,
  eGL_FENCE_APPLE = 0x8A0B,
  eGL_HALF_APPLE = 0x140B,
  eGL_RGBA_FLOAT32_APPLE = 0x8814,
  eGL_RGB_FLOAT32_APPLE = 0x8815,
  eGL_ALPHA_FLOAT32_APPLE = 0x8816,
  eGL_INTENSITY_FLOAT32_APPLE = 0x8817,
  eGL_LUMINANCE_FLOAT32_APPLE = 0x8818,
  eGL_LUMINANCE_ALPHA_FLOAT32_APPLE = 0x8819,
  eGL_RGBA_FLOAT16_APPLE = 0x881A,
  eGL_RGB_FLOAT16_APPLE = 0x881B,
  eGL_ALPHA_FLOAT16_APPLE = 0x881C,
  eGL_INTENSITY_FLOAT16_APPLE = 0x881D,
  eGL_LUMINANCE_FLOAT16_APPLE = 0x881E,
  eGL_LUMINANCE_ALPHA_FLOAT16_APPLE = 0x881F,
  eGL_COLOR_FLOAT_APPLE = 0x8A0F,
  eGL_BUFFER_SERIALIZED_MODIFY_APPLE = 0x8A12,
  eGL_BUFFER_FLUSHING_UNMAP_APPLE = 0x8A13,
  eGL_BUFFER_OBJECT_APPLE = 0x85B3,
  eGL_RELEASED_APPLE = 0x8A19,
  eGL_VOLATILE_APPLE = 0x8A1A,
  eGL_RETAINED_APPLE = 0x8A1B,
  eGL_UNDEFINED_APPLE = 0x8A1C,
  eGL_PURGEABLE_APPLE = 0x8A1D,
  eGL_PACK_ROW_BYTES_APPLE = 0x8A15,
  eGL_UNPACK_ROW_BYTES_APPLE = 0x8A16,
  eGL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = 0x85B0,
  eGL_TEXTURE_RANGE_LENGTH_APPLE = 0x85B7,
  eGL_TEXTURE_RANGE_POINTER_APPLE = 0x85B8,
  eGL_TEXTURE_STORAGE_HINT_APPLE = 0x85BC,
  eGL_STORAGE_PRIVATE_APPLE = 0x85BD,
  eGL_STORAGE_CACHED_APPLE = 0x85BE,
  eGL_STORAGE_SHARED_APPLE = 0x85BF,
  eGL_TRANSFORM_HINT_APPLE = 0x85B1,
  eGL_VERTEX_ARRAY_BINDING_APPLE = 0x85B5,
  eGL_VERTEX_ARRAY_RANGE_APPLE = 0x851D,
  eGL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = 0x851E,
  eGL_VERTEX_ARRAY_STORAGE_HINT_APPLE = 0x851F,
  eGL_VERTEX_ARRAY_RANGE_POINTER_APPLE = 0x8521,
  eGL_STORAGE_CLIENT_APPLE = 0x85B4,
  eGL_VERTEX_ATTRIB_MAP1_APPLE = 0x8A00,
  eGL_VERTEX_ATTRIB_MAP2_APPLE = 0x8A01,
  eGL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = 0x8A02,
  eGL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = 0x8A03,
  eGL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = 0x8A04,
  eGL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = 0x8A05,
  eGL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = 0x8A06,
  eGL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = 0x8A07,
  eGL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = 0x8A08,
  eGL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = 0x8A09,
  eGL_YCBCR_422_APPLE = 0x85B9,
  eGL_MAX_DRAW_BUFFERS_ATI = 0x8824,
  eGL_DRAW_BUFFER0_ATI = 0x8825,
  eGL_DRAW_BUFFER1_ATI = 0x8826,
  eGL_DRAW_BUFFER2_ATI = 0x8827,
  eGL_DRAW_BUFFER3_ATI = 0x8828,
  eGL_DRAW_BUFFER4_ATI = 0x8829,
  eGL_DRAW_BUFFER5_ATI = 0x882A,
  eGL_DRAW_BUFFER6_ATI = 0x882B,
  eGL_DRAW_BUFFER7_ATI = 0x882C,
  eGL_DRAW_BUFFER8_ATI = 0x882D,
  eGL_DRAW_BUFFER9_ATI = 0x882E,
  eGL_DRAW_BUFFER10_ATI = 0x882F,
  eGL_DRAW_BUFFER11_ATI = 0x8830,
  eGL_DRAW_BUFFER12_ATI = 0x8831,
  eGL_DRAW_BUFFER13_ATI = 0x8832,
  eGL_DRAW_BUFFER14_ATI = 0x8833,
  eGL_DRAW_BUFFER15_ATI = 0x8834,
  eGL_ELEMENT_ARRAY_ATI = 0x8768,
  eGL_ELEMENT_ARRAY_TYPE_ATI = 0x8769,
  eGL_ELEMENT_ARRAY_POINTER_ATI = 0x876A,
  eGL_BUMP_ROT_MATRIX_ATI = 0x8775,
  eGL_BUMP_ROT_MATRIX_SIZE_ATI = 0x8776,
  eGL_BUMP_NUM_TEX_UNITS_ATI = 0x8777,
  eGL_BUMP_TEX_UNITS_ATI = 0x8778,
  eGL_DUDV_ATI = 0x8779,
  eGL_DU8DV8_ATI = 0x877A,
  eGL_BUMP_ENVMAP_ATI = 0x877B,
  eGL_BUMP_TARGET_ATI = 0x877C,
  eGL_FRAGMENT_SHADER_ATI = 0x8920,
  eGL_REG_0_ATI = 0x8921,
  eGL_REG_1_ATI = 0x8922,
  eGL_REG_2_ATI = 0x8923,
  eGL_REG_3_ATI = 0x8924,
  eGL_REG_4_ATI = 0x8925,
  eGL_REG_5_ATI = 0x8926,
  eGL_REG_6_ATI = 0x8927,
  eGL_REG_7_ATI = 0x8928,
  eGL_REG_8_ATI = 0x8929,
  eGL_REG_9_ATI = 0x892A,
  eGL_REG_10_ATI = 0x892B,
  eGL_REG_11_ATI = 0x892C,
  eGL_REG_12_ATI = 0x892D,
  eGL_REG_13_ATI = 0x892E,
  eGL_REG_14_ATI = 0x892F,
  eGL_REG_15_ATI = 0x8930,
  eGL_REG_16_ATI = 0x8931,
  eGL_REG_17_ATI = 0x8932,
  eGL_REG_18_ATI = 0x8933,
  eGL_REG_19_ATI = 0x8934,
  eGL_REG_20_ATI = 0x8935,
  eGL_REG_21_ATI = 0x8936,
  eGL_REG_22_ATI = 0x8937,
  eGL_REG_23_ATI = 0x8938,
  eGL_REG_24_ATI = 0x8939,
  eGL_REG_25_ATI = 0x893A,
  eGL_REG_26_ATI = 0x893B,
  eGL_REG_27_ATI = 0x893C,
  eGL_REG_28_ATI = 0x893D,
  eGL_REG_29_ATI = 0x893E,
  eGL_REG_30_ATI = 0x893F,
  eGL_REG_31_ATI = 0x8940,
  eGL_CON_0_ATI = 0x8941,
  eGL_CON_1_ATI = 0x8942,
  eGL_CON_2_ATI = 0x8943,
  eGL_CON_3_ATI = 0x8944,
  eGL_CON_4_ATI = 0x8945,
  eGL_CON_5_ATI = 0x8946,
  eGL_CON_6_ATI = 0x8947,
  eGL_CON_7_ATI = 0x8948,
  eGL_CON_8_ATI = 0x8949,
  eGL_CON_9_ATI = 0x894A,
  eGL_CON_10_ATI = 0x894B,
  eGL_CON_11_ATI = 0x894C,
  eGL_CON_12_ATI = 0x894D,
  eGL_CON_13_ATI = 0x894E,
  eGL_CON_14_ATI = 0x894F,
  eGL_CON_15_ATI = 0x8950,
  eGL_CON_16_ATI = 0x8951,
  eGL_CON_17_ATI = 0x8952,
  eGL_CON_18_ATI = 0x8953,
  eGL_CON_19_ATI = 0x8954,
  eGL_CON_20_ATI = 0x8955,
  eGL_CON_21_ATI = 0x8956,
  eGL_CON_22_ATI = 0x8957,
  eGL_CON_23_ATI = 0x8958,
  eGL_CON_24_ATI = 0x8959,
  eGL_CON_25_ATI = 0x895A,
  eGL_CON_26_ATI = 0x895B,
  eGL_CON_27_ATI = 0x895C,
  eGL_CON_28_ATI = 0x895D,
  eGL_CON_29_ATI = 0x895E,
  eGL_CON_30_ATI = 0x895F,
  eGL_CON_31_ATI = 0x8960,
  eGL_MOV_ATI = 0x8961,
  eGL_ADD_ATI = 0x8963,
  eGL_MUL_ATI = 0x8964,
  eGL_SUB_ATI = 0x8965,
  eGL_DOT3_ATI = 0x8966,
  eGL_DOT4_ATI = 0x8967,
  eGL_MAD_ATI = 0x8968,
  eGL_LERP_ATI = 0x8969,
  eGL_CND_ATI = 0x896A,
  eGL_CND0_ATI = 0x896B,
  eGL_DOT2_ADD_ATI = 0x896C,
  eGL_SECONDARY_INTERPOLATOR_ATI = 0x896D,
  eGL_NUM_FRAGMENT_REGISTERS_ATI = 0x896E,
  eGL_NUM_FRAGMENT_CONSTANTS_ATI = 0x896F,
  eGL_NUM_PASSES_ATI = 0x8970,
  eGL_NUM_INSTRUCTIONS_PER_PASS_ATI = 0x8971,
  eGL_NUM_INSTRUCTIONS_TOTAL_ATI = 0x8972,
  eGL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = 0x8973,
  eGL_NUM_LOOPBACK_COMPONENTS_ATI = 0x8974,
  eGL_COLOR_ALPHA_PAIRING_ATI = 0x8975,
  eGL_SWIZZLE_STR_ATI = 0x8976,
  eGL_SWIZZLE_STQ_ATI = 0x8977,
  eGL_SWIZZLE_STR_DR_ATI = 0x8978,
  eGL_SWIZZLE_STQ_DQ_ATI = 0x8979,
  eGL_SWIZZLE_STRQ_ATI = 0x897A,
  eGL_SWIZZLE_STRQ_DQ_ATI = 0x897B,
  eGL_RED_BIT_ATI = 0x00000001,
  eGL_GREEN_BIT_ATI = 0x00000002,
  eGL_BLUE_BIT_ATI = 0x00000004,
  eGL_2X_BIT_ATI = 0x00000001,
  eGL_4X_BIT_ATI = 0x00000002,
  eGL_8X_BIT_ATI = 0x00000004,
  eGL_HALF_BIT_ATI = 0x00000008,
  eGL_QUARTER_BIT_ATI = 0x00000010,
  eGL_EIGHTH_BIT_ATI = 0x00000020,
  eGL_SATURATE_BIT_ATI = 0x00000040,
  eGL_COMP_BIT_ATI = 0x00000002,
  eGL_NEGATE_BIT_ATI = 0x00000004,
  eGL_BIAS_BIT_ATI = 0x00000008,
  eGL_VBO_FREE_MEMORY_ATI = 0x87FB,
  eGL_TEXTURE_FREE_MEMORY_ATI = 0x87FC,
  eGL_RENDERBUFFER_FREE_MEMORY_ATI = 0x87FD,
  eGL_RGBA_FLOAT_MODE_ATI = 0x8820,
  eGL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = 0x8835,
  eGL_PN_TRIANGLES_ATI = 0x87F0,
  eGL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F1,
  eGL_PN_TRIANGLES_POINT_MODE_ATI = 0x87F2,
  eGL_PN_TRIANGLES_NORMAL_MODE_ATI = 0x87F3,
  eGL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F4,
  eGL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = 0x87F5,
  eGL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = 0x87F6,
  eGL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = 0x87F7,
  eGL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = 0x87F8,
  eGL_STENCIL_BACK_FUNC_ATI = 0x8800,
  eGL_STENCIL_BACK_FAIL_ATI = 0x8801,
  eGL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = 0x8802,
  eGL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = 0x8803,
  eGL_TEXT_FRAGMENT_SHADER_ATI = 0x8200,
  eGL_MODULATE_ADD_ATI = 0x8744,
  eGL_MODULATE_SIGNED_ADD_ATI = 0x8745,
  eGL_MODULATE_SUBTRACT_ATI = 0x8746,
  eGL_RGBA_FLOAT32_ATI = 0x8814,
  eGL_RGB_FLOAT32_ATI = 0x8815,
  eGL_ALPHA_FLOAT32_ATI = 0x8816,
  eGL_INTENSITY_FLOAT32_ATI = 0x8817,
  eGL_LUMINANCE_FLOAT32_ATI = 0x8818,
  eGL_LUMINANCE_ALPHA_FLOAT32_ATI = 0x8819,
  eGL_RGBA_FLOAT16_ATI = 0x881A,
  eGL_RGB_FLOAT16_ATI = 0x881B,
  eGL_ALPHA_FLOAT16_ATI = 0x881C,
  eGL_INTENSITY_FLOAT16_ATI = 0x881D,
  eGL_LUMINANCE_FLOAT16_ATI = 0x881E,
  eGL_LUMINANCE_ALPHA_FLOAT16_ATI = 0x881F,
  eGL_MIRROR_CLAMP_ATI = 0x8742,
  eGL_MIRROR_CLAMP_TO_EDGE_ATI = 0x8743,
  eGL_STATIC_ATI = 0x8760,
  eGL_DYNAMIC_ATI = 0x8761,
  eGL_PRESERVE_ATI = 0x8762,
  eGL_DISCARD_ATI = 0x8763,
  eGL_OBJECT_BUFFER_SIZE_ATI = 0x8764,
  eGL_OBJECT_BUFFER_USAGE_ATI = 0x8765,
  eGL_ARRAY_OBJECT_BUFFER_ATI = 0x8766,
  eGL_ARRAY_OBJECT_OFFSET_ATI = 0x8767,
  eGL_MAX_VERTEX_STREAMS_ATI = 0x876B,
  eGL_VERTEX_STREAM0_ATI = 0x876C,
  eGL_VERTEX_STREAM1_ATI = 0x876D,
  eGL_VERTEX_STREAM2_ATI = 0x876E,
  eGL_VERTEX_STREAM3_ATI = 0x876F,
  eGL_VERTEX_STREAM4_ATI = 0x8770,
  eGL_VERTEX_STREAM5_ATI = 0x8771,
  eGL_VERTEX_STREAM6_ATI = 0x8772,
  eGL_VERTEX_STREAM7_ATI = 0x8773,
  eGL_VERTEX_SOURCE_ATI = 0x8774,
  eGL_422_EXT = 0x80CC,
  eGL_422_REV_EXT = 0x80CD,
  eGL_422_AVERAGE_EXT = 0x80CE,
  eGL_422_REV_AVERAGE_EXT = 0x80CF,
  eGL_ABGR_EXT = 0x8000,
  eGL_BGR_EXT = 0x80E0,
  eGL_BGRA_EXT = 0x80E1,
  eGL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = 0x8DE2,
  eGL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = 0x8DE3,
  eGL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = 0x8DE4,
  eGL_MAX_BINDABLE_UNIFORM_SIZE_EXT = 0x8DED,
  eGL_UNIFORM_BUFFER_EXT = 0x8DEE,
  eGL_UNIFORM_BUFFER_BINDING_EXT = 0x8DEF,
  eGL_CONSTANT_COLOR_EXT = 0x8001,
  eGL_ONE_MINUS_CONSTANT_COLOR_EXT = 0x8002,
  eGL_CONSTANT_ALPHA_EXT = 0x8003,
  eGL_ONE_MINUS_CONSTANT_ALPHA_EXT = 0x8004,
  eGL_BLEND_COLOR_EXT = 0x8005,
  eGL_BLEND_EQUATION_RGB_EXT = 0x8009,
  eGL_BLEND_EQUATION_ALPHA_EXT = 0x883D,
  eGL_BLEND_DST_RGB_EXT = 0x80C8,
  eGL_BLEND_SRC_RGB_EXT = 0x80C9,
  eGL_BLEND_DST_ALPHA_EXT = 0x80CA,
  eGL_BLEND_SRC_ALPHA_EXT = 0x80CB,
  eGL_MIN_EXT = 0x8007,
  eGL_MAX_EXT = 0x8008,
  eGL_FUNC_ADD_EXT = 0x8006,
  eGL_BLEND_EQUATION_EXT = 0x8009,
  eGL_FUNC_SUBTRACT_EXT = 0x800A,
  eGL_FUNC_REVERSE_SUBTRACT_EXT = 0x800B,
  eGL_CLIP_VOLUME_CLIPPING_HINT_EXT = 0x80F0,
  eGL_CMYK_EXT = 0x800C,
  eGL_CMYKA_EXT = 0x800D,
  eGL_PACK_CMYK_HINT_EXT = 0x800E,
  eGL_UNPACK_CMYK_HINT_EXT = 0x800F,
  eGL_ARRAY_ELEMENT_LOCK_FIRST_EXT = 0x81A8,
  eGL_ARRAY_ELEMENT_LOCK_COUNT_EXT = 0x81A9,
  eGL_CONVOLUTION_1D_EXT = 0x8010,
  eGL_CONVOLUTION_2D_EXT = 0x8011,
  eGL_SEPARABLE_2D_EXT = 0x8012,
  eGL_CONVOLUTION_BORDER_MODE_EXT = 0x8013,
  eGL_CONVOLUTION_FILTER_SCALE_EXT = 0x8014,
  eGL_CONVOLUTION_FILTER_BIAS_EXT = 0x8015,
  eGL_REDUCE_EXT = 0x8016,
  eGL_CONVOLUTION_FORMAT_EXT = 0x8017,
  eGL_CONVOLUTION_WIDTH_EXT = 0x8018,
  eGL_CONVOLUTION_HEIGHT_EXT = 0x8019,
  eGL_MAX_CONVOLUTION_WIDTH_EXT = 0x801A,
  eGL_MAX_CONVOLUTION_HEIGHT_EXT = 0x801B,
  eGL_POST_CONVOLUTION_RED_SCALE_EXT = 0x801C,
  eGL_POST_CONVOLUTION_GREEN_SCALE_EXT = 0x801D,
  eGL_POST_CONVOLUTION_BLUE_SCALE_EXT = 0x801E,
  eGL_POST_CONVOLUTION_ALPHA_SCALE_EXT = 0x801F,
  eGL_POST_CONVOLUTION_RED_BIAS_EXT = 0x8020,
  eGL_POST_CONVOLUTION_GREEN_BIAS_EXT = 0x8021,
  eGL_POST_CONVOLUTION_BLUE_BIAS_EXT = 0x8022,
  eGL_POST_CONVOLUTION_ALPHA_BIAS_EXT = 0x8023,
  eGL_TANGENT_ARRAY_EXT = 0x8439,
  eGL_BINORMAL_ARRAY_EXT = 0x843A,
  eGL_CURRENT_TANGENT_EXT = 0x843B,
  eGL_CURRENT_BINORMAL_EXT = 0x843C,
  eGL_TANGENT_ARRAY_TYPE_EXT = 0x843E,
  eGL_TANGENT_ARRAY_STRIDE_EXT = 0x843F,
  eGL_BINORMAL_ARRAY_TYPE_EXT = 0x8440,
  eGL_BINORMAL_ARRAY_STRIDE_EXT = 0x8441,
  eGL_TANGENT_ARRAY_POINTER_EXT = 0x8442,
  eGL_BINORMAL_ARRAY_POINTER_EXT = 0x8443,
  eGL_MAP1_TANGENT_EXT = 0x8444,
  eGL_MAP2_TANGENT_EXT = 0x8445,
  eGL_MAP1_BINORMAL_EXT = 0x8446,
  eGL_MAP2_BINORMAL_EXT = 0x8447,
  eGL_CULL_VERTEX_EXT = 0x81AA,
  eGL_CULL_VERTEX_EYE_POSITION_EXT = 0x81AB,
  eGL_CULL_VERTEX_OBJECT_POSITION_EXT = 0x81AC,
  eGL_DEPTH_BOUNDS_TEST_EXT = 0x8890,
  eGL_DEPTH_BOUNDS_EXT = 0x8891,
  eGL_MAX_ELEMENTS_VERTICES_EXT = 0x80E8,
  eGL_MAX_ELEMENTS_INDICES_EXT = 0x80E9,
  eGL_FOG_COORDINATE_SOURCE_EXT = 0x8450,
  eGL_FOG_COORDINATE_EXT = 0x8451,
  eGL_FRAGMENT_DEPTH_EXT = 0x8452,
  eGL_CURRENT_FOG_COORDINATE_EXT = 0x8453,
  eGL_FOG_COORDINATE_ARRAY_TYPE_EXT = 0x8454,
  eGL_FOG_COORDINATE_ARRAY_STRIDE_EXT = 0x8455,
  eGL_FOG_COORDINATE_ARRAY_POINTER_EXT = 0x8456,
  eGL_FOG_COORDINATE_ARRAY_EXT = 0x8457,
  eGL_READ_FRAMEBUFFER_EXT = 0x8CA8,
  eGL_DRAW_FRAMEBUFFER_EXT = 0x8CA9,
  eGL_DRAW_FRAMEBUFFER_BINDING_EXT = 0x8CA6,
  eGL_READ_FRAMEBUFFER_BINDING_EXT = 0x8CAA,
  eGL_RENDERBUFFER_SAMPLES_EXT = 0x8CAB,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = 0x8D56,
  eGL_MAX_SAMPLES_EXT = 0x8D57,
  eGL_SCALED_RESOLVE_FASTEST_EXT = 0x90BA,
  eGL_SCALED_RESOLVE_NICEST_EXT = 0x90BB,
  eGL_INVALID_FRAMEBUFFER_OPERATION_EXT = 0x0506,
  eGL_MAX_RENDERBUFFER_SIZE_EXT = 0x84E8,
  eGL_FRAMEBUFFER_BINDING_EXT = 0x8CA6,
  eGL_RENDERBUFFER_BINDING_EXT = 0x8CA7,
  eGL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 0x8CD0,
  eGL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 0x8CD1,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 0x8CD2,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 0x8CD3,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 0x8CD4,
  eGL_FRAMEBUFFER_COMPLETE_EXT = 0x8CD5,
  eGL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 0x8CD6,
  eGL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 0x8CD7,
  eGL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 0x8CD9,
  eGL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 0x8CDA,
  eGL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 0x8CDB,
  eGL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 0x8CDC,
  eGL_FRAMEBUFFER_UNSUPPORTED_EXT = 0x8CDD,
  eGL_MAX_COLOR_ATTACHMENTS_EXT = 0x8CDF,
  eGL_COLOR_ATTACHMENT0_EXT = 0x8CE0,
  eGL_COLOR_ATTACHMENT1_EXT = 0x8CE1,
  eGL_COLOR_ATTACHMENT2_EXT = 0x8CE2,
  eGL_COLOR_ATTACHMENT3_EXT = 0x8CE3,
  eGL_COLOR_ATTACHMENT4_EXT = 0x8CE4,
  eGL_COLOR_ATTACHMENT5_EXT = 0x8CE5,
  eGL_COLOR_ATTACHMENT6_EXT = 0x8CE6,
  eGL_COLOR_ATTACHMENT7_EXT = 0x8CE7,
  eGL_COLOR_ATTACHMENT8_EXT = 0x8CE8,
  eGL_COLOR_ATTACHMENT9_EXT = 0x8CE9,
  eGL_COLOR_ATTACHMENT10_EXT = 0x8CEA,
  eGL_COLOR_ATTACHMENT11_EXT = 0x8CEB,
  eGL_COLOR_ATTACHMENT12_EXT = 0x8CEC,
  eGL_COLOR_ATTACHMENT13_EXT = 0x8CED,
  eGL_COLOR_ATTACHMENT14_EXT = 0x8CEE,
  eGL_COLOR_ATTACHMENT15_EXT = 0x8CEF,
  eGL_DEPTH_ATTACHMENT_EXT = 0x8D00,
  eGL_STENCIL_ATTACHMENT_EXT = 0x8D20,
  eGL_FRAMEBUFFER_EXT = 0x8D40,
  eGL_RENDERBUFFER_EXT = 0x8D41,
  eGL_RENDERBUFFER_WIDTH_EXT = 0x8D42,
  eGL_RENDERBUFFER_HEIGHT_EXT = 0x8D43,
  eGL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 0x8D44,
  eGL_STENCIL_INDEX1_EXT = 0x8D46,
  eGL_STENCIL_INDEX4_EXT = 0x8D47,
  eGL_STENCIL_INDEX8_EXT = 0x8D48,
  eGL_STENCIL_INDEX16_EXT = 0x8D49,
  eGL_RENDERBUFFER_RED_SIZE_EXT = 0x8D50,
  eGL_RENDERBUFFER_GREEN_SIZE_EXT = 0x8D51,
  eGL_RENDERBUFFER_BLUE_SIZE_EXT = 0x8D52,
  eGL_RENDERBUFFER_ALPHA_SIZE_EXT = 0x8D53,
  eGL_RENDERBUFFER_DEPTH_SIZE_EXT = 0x8D54,
  eGL_RENDERBUFFER_STENCIL_SIZE_EXT = 0x8D55,
  eGL_FRAMEBUFFER_SRGB_EXT = 0x8DB9,
  eGL_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x8DBA,
  eGL_GEOMETRY_SHADER_EXT = 0x8DD9,
  eGL_GEOMETRY_VERTICES_OUT_EXT = 0x8DDA,
  eGL_GEOMETRY_INPUT_TYPE_EXT = 0x8DDB,
  eGL_GEOMETRY_OUTPUT_TYPE_EXT = 0x8DDC,
  eGL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = 0x8C29,
  eGL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = 0x8DDD,
  eGL_MAX_VERTEX_VARYING_COMPONENTS_EXT = 0x8DDE,
  eGL_MAX_VARYING_COMPONENTS_EXT = 0x8B4B,
  eGL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8DDF,
  eGL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = 0x8DE0,
  eGL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8DE1,
  eGL_LINES_ADJACENCY_EXT = 0x000A,
  eGL_LINE_STRIP_ADJACENCY_EXT = 0x000B,
  eGL_TRIANGLES_ADJACENCY_EXT = 0x000C,
  eGL_TRIANGLE_STRIP_ADJACENCY_EXT = 0x000D,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = 0x8DA8,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = 0x8DA9,
  eGL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = 0x8DA7,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = 0x8CD4,
  eGL_PROGRAM_POINT_SIZE_EXT = 0x8642,
  eGL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = 0x88FD,
  eGL_SAMPLER_1D_ARRAY_EXT = 0x8DC0,
  eGL_SAMPLER_2D_ARRAY_EXT = 0x8DC1,
  eGL_SAMPLER_BUFFER_EXT = 0x8DC2,
  eGL_SAMPLER_1D_ARRAY_SHADOW_EXT = 0x8DC3,
  eGL_SAMPLER_2D_ARRAY_SHADOW_EXT = 0x8DC4,
  eGL_SAMPLER_CUBE_SHADOW_EXT = 0x8DC5,
  eGL_UNSIGNED_INT_VEC2_EXT = 0x8DC6,
  eGL_UNSIGNED_INT_VEC3_EXT = 0x8DC7,
  eGL_UNSIGNED_INT_VEC4_EXT = 0x8DC8,
  eGL_INT_SAMPLER_1D_EXT = 0x8DC9,
  eGL_INT_SAMPLER_2D_EXT = 0x8DCA,
  eGL_INT_SAMPLER_3D_EXT = 0x8DCB,
  eGL_INT_SAMPLER_CUBE_EXT = 0x8DCC,
  eGL_INT_SAMPLER_2D_RECT_EXT = 0x8DCD,
  eGL_INT_SAMPLER_1D_ARRAY_EXT = 0x8DCE,
  eGL_INT_SAMPLER_2D_ARRAY_EXT = 0x8DCF,
  eGL_INT_SAMPLER_BUFFER_EXT = 0x8DD0,
  eGL_UNSIGNED_INT_SAMPLER_1D_EXT = 0x8DD1,
  eGL_UNSIGNED_INT_SAMPLER_2D_EXT = 0x8DD2,
  eGL_UNSIGNED_INT_SAMPLER_3D_EXT = 0x8DD3,
  eGL_UNSIGNED_INT_SAMPLER_CUBE_EXT = 0x8DD4,
  eGL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = 0x8DD5,
  eGL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = 0x8DD6,
  eGL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = 0x8DD7,
  eGL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = 0x8DD8,
  eGL_MIN_PROGRAM_TEXEL_OFFSET_EXT = 0x8904,
  eGL_MAX_PROGRAM_TEXEL_OFFSET_EXT = 0x8905,
  eGL_HISTOGRAM_EXT = 0x8024,
  eGL_PROXY_HISTOGRAM_EXT = 0x8025,
  eGL_HISTOGRAM_WIDTH_EXT = 0x8026,
  eGL_HISTOGRAM_FORMAT_EXT = 0x8027,
  eGL_HISTOGRAM_RED_SIZE_EXT = 0x8028,
  eGL_HISTOGRAM_GREEN_SIZE_EXT = 0x8029,
  eGL_HISTOGRAM_BLUE_SIZE_EXT = 0x802A,
  eGL_HISTOGRAM_ALPHA_SIZE_EXT = 0x802B,
  eGL_HISTOGRAM_LUMINANCE_SIZE_EXT = 0x802C,
  eGL_HISTOGRAM_SINK_EXT = 0x802D,
  eGL_MINMAX_EXT = 0x802E,
  eGL_MINMAX_FORMAT_EXT = 0x802F,
  eGL_MINMAX_SINK_EXT = 0x8030,
  eGL_TABLE_TOO_LARGE_EXT = 0x8031,
  eGL_IUI_V2F_EXT = 0x81AD,
  eGL_IUI_V3F_EXT = 0x81AE,
  eGL_IUI_N3F_V2F_EXT = 0x81AF,
  eGL_IUI_N3F_V3F_EXT = 0x81B0,
  eGL_T2F_IUI_V2F_EXT = 0x81B1,
  eGL_T2F_IUI_V3F_EXT = 0x81B2,
  eGL_T2F_IUI_N3F_V2F_EXT = 0x81B3,
  eGL_T2F_IUI_N3F_V3F_EXT = 0x81B4,
  eGL_INDEX_TEST_EXT = 0x81B5,
  eGL_INDEX_TEST_FUNC_EXT = 0x81B6,
  eGL_INDEX_TEST_REF_EXT = 0x81B7,
  eGL_INDEX_MATERIAL_EXT = 0x81B8,
  eGL_INDEX_MATERIAL_PARAMETER_EXT = 0x81B9,
  eGL_INDEX_MATERIAL_FACE_EXT = 0x81BA,
  eGL_FRAGMENT_MATERIAL_EXT = 0x8349,
  eGL_FRAGMENT_NORMAL_EXT = 0x834A,
  eGL_FRAGMENT_COLOR_EXT = 0x834C,
  eGL_ATTENUATION_EXT = 0x834D,
  eGL_SHADOW_ATTENUATION_EXT = 0x834E,
  eGL_TEXTURE_APPLICATION_MODE_EXT = 0x834F,
  eGL_TEXTURE_LIGHT_EXT = 0x8350,
  eGL_TEXTURE_MATERIAL_FACE_EXT = 0x8351,
  eGL_TEXTURE_MATERIAL_PARAMETER_EXT = 0x8352,
  eGL_TEXTURE_TILING_EXT = 0x9580,
  eGL_DEDICATED_MEMORY_OBJECT_EXT = 0x9581,
  eGL_PROTECTED_MEMORY_OBJECT_EXT = 0x959B,
  eGL_NUM_TILING_TYPES_EXT = 0x9582,
  eGL_TILING_TYPES_EXT = 0x9583,
  eGL_OPTIMAL_TILING_EXT = 0x9584,
  eGL_LINEAR_TILING_EXT = 0x9585,
  eGL_NUM_DEVICE_UUIDS_EXT = 0x9596,
  eGL_DEVICE_UUID_EXT = 0x9597,
  eGL_DRIVER_UUID_EXT = 0x9598,
  eGL_HANDLE_TYPE_OPAQUE_FD_EXT = 0x9586,
  eGL_HANDLE_TYPE_OPAQUE_WIN32_EXT = 0x9587,
  eGL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT = 0x9588,
  eGL_DEVICE_LUID_EXT = 0x9599,
  eGL_DEVICE_NODE_MASK_EXT = 0x959A,
  eGL_HANDLE_TYPE_D3D12_TILEPOOL_EXT = 0x9589,
  eGL_HANDLE_TYPE_D3D12_RESOURCE_EXT = 0x958A,
  eGL_HANDLE_TYPE_D3D11_IMAGE_EXT = 0x958B,
  eGL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT = 0x958C,
  eGL_MULTISAMPLE_EXT = 0x809D,
  eGL_SAMPLE_ALPHA_TO_MASK_EXT = 0x809E,
  eGL_SAMPLE_ALPHA_TO_ONE_EXT = 0x809F,
  eGL_SAMPLE_MASK_EXT = 0x80A0,
  eGL_1PASS_EXT = 0x80A1,
  eGL_2PASS_0_EXT = 0x80A2,
  eGL_2PASS_1_EXT = 0x80A3,
  eGL_4PASS_0_EXT = 0x80A4,
  eGL_4PASS_1_EXT = 0x80A5,
  eGL_4PASS_2_EXT = 0x80A6,
  eGL_4PASS_3_EXT = 0x80A7,
  eGL_SAMPLE_BUFFERS_EXT = 0x80A8,
  eGL_SAMPLES_EXT = 0x80A9,
  eGL_SAMPLE_MASK_VALUE_EXT = 0x80AA,
  eGL_SAMPLE_MASK_INVERT_EXT = 0x80AB,
  eGL_SAMPLE_PATTERN_EXT = 0x80AC,
  eGL_MULTISAMPLE_BIT_EXT = 0x20000000,
  eGL_DEPTH_STENCIL_EXT = 0x84F9,
  eGL_UNSIGNED_INT_24_8_EXT = 0x84FA,
  eGL_DEPTH24_STENCIL8_EXT = 0x88F0,
  eGL_TEXTURE_STENCIL_SIZE_EXT = 0x88F1,
  eGL_R11F_G11F_B10F_EXT = 0x8C3A,
  eGL_UNSIGNED_INT_10F_11F_11F_REV_EXT = 0x8C3B,
  eGL_RGBA_SIGNED_COMPONENTS_EXT = 0x8C3C,
  eGL_UNSIGNED_BYTE_3_3_2_EXT = 0x8032,
  eGL_UNSIGNED_SHORT_4_4_4_4_EXT = 0x8033,
  eGL_UNSIGNED_SHORT_5_5_5_1_EXT = 0x8034,
  eGL_UNSIGNED_INT_8_8_8_8_EXT = 0x8035,
  eGL_UNSIGNED_INT_10_10_10_2_EXT = 0x8036,
  eGL_COLOR_INDEX1_EXT = 0x80E2,
  eGL_COLOR_INDEX2_EXT = 0x80E3,
  eGL_COLOR_INDEX4_EXT = 0x80E4,
  eGL_COLOR_INDEX8_EXT = 0x80E5,
  eGL_COLOR_INDEX12_EXT = 0x80E6,
  eGL_COLOR_INDEX16_EXT = 0x80E7,
  eGL_TEXTURE_INDEX_SIZE_EXT = 0x80ED,
  eGL_PIXEL_PACK_BUFFER_EXT = 0x88EB,
  eGL_PIXEL_UNPACK_BUFFER_EXT = 0x88EC,
  eGL_PIXEL_PACK_BUFFER_BINDING_EXT = 0x88ED,
  eGL_PIXEL_UNPACK_BUFFER_BINDING_EXT = 0x88EF,
  eGL_PIXEL_TRANSFORM_2D_EXT = 0x8330,
  eGL_PIXEL_MAG_FILTER_EXT = 0x8331,
  eGL_PIXEL_MIN_FILTER_EXT = 0x8332,
  eGL_PIXEL_CUBIC_WEIGHT_EXT = 0x8333,
  eGL_CUBIC_EXT = 0x8334,
  eGL_AVERAGE_EXT = 0x8335,
  eGL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8336,
  eGL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8337,
  eGL_PIXEL_TRANSFORM_2D_MATRIX_EXT = 0x8338,
  eGL_POINT_SIZE_MIN_EXT = 0x8126,
  eGL_POINT_SIZE_MAX_EXT = 0x8127,
  eGL_POINT_FADE_THRESHOLD_SIZE_EXT = 0x8128,
  eGL_DISTANCE_ATTENUATION_EXT = 0x8129,
  eGL_POLYGON_OFFSET_EXT = 0x8037,
  eGL_POLYGON_OFFSET_FACTOR_EXT = 0x8038,
  eGL_POLYGON_OFFSET_BIAS_EXT = 0x8039,
  eGL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT = 0x8E4C,
  eGL_FIRST_VERTEX_CONVENTION_EXT = 0x8E4D,
  eGL_LAST_VERTEX_CONVENTION_EXT = 0x8E4E,
  eGL_PROVOKING_VERTEX_EXT = 0x8E4F,
  eGL_RESCALE_NORMAL_EXT = 0x803A,
  eGL_COLOR_SUM_EXT = 0x8458,
  eGL_CURRENT_SECONDARY_COLOR_EXT = 0x8459,
  eGL_SECONDARY_COLOR_ARRAY_SIZE_EXT = 0x845A,
  eGL_SECONDARY_COLOR_ARRAY_TYPE_EXT = 0x845B,
  eGL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = 0x845C,
  eGL_SECONDARY_COLOR_ARRAY_POINTER_EXT = 0x845D,
  eGL_SECONDARY_COLOR_ARRAY_EXT = 0x845E,
  eGL_LAYOUT_GENERAL_EXT = 0x958D,
  eGL_LAYOUT_COLOR_ATTACHMENT_EXT = 0x958E,
  eGL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = 0x958F,
  eGL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = 0x9590,
  eGL_LAYOUT_SHADER_READ_ONLY_EXT = 0x9591,
  eGL_LAYOUT_TRANSFER_SRC_EXT = 0x9592,
  eGL_LAYOUT_TRANSFER_DST_EXT = 0x9593,
  eGL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT = 0x9530,
  eGL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT = 0x9531,
  eGL_HANDLE_TYPE_D3D12_FENCE_EXT = 0x9594,
  eGL_D3D12_FENCE_VALUE_EXT = 0x9595,
  eGL_LIGHT_MODEL_COLOR_CONTROL_EXT = 0x81F8,
  eGL_SINGLE_COLOR_EXT = 0x81F9,
  eGL_SEPARATE_SPECULAR_COLOR_EXT = 0x81FA,
  eGL_MAX_IMAGE_UNITS_EXT = 0x8F38,
  eGL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT = 0x8F39,
  eGL_IMAGE_BINDING_NAME_EXT = 0x8F3A,
  eGL_IMAGE_BINDING_LEVEL_EXT = 0x8F3B,
  eGL_IMAGE_BINDING_LAYERED_EXT = 0x8F3C,
  eGL_IMAGE_BINDING_LAYER_EXT = 0x8F3D,
  eGL_IMAGE_BINDING_ACCESS_EXT = 0x8F3E,
  eGL_IMAGE_1D_EXT = 0x904C,
  eGL_IMAGE_2D_EXT = 0x904D,
  eGL_IMAGE_3D_EXT = 0x904E,
  eGL_IMAGE_2D_RECT_EXT = 0x904F,
  eGL_IMAGE_CUBE_EXT = 0x9050,
  eGL_IMAGE_BUFFER_EXT = 0x9051,
  eGL_IMAGE_1D_ARRAY_EXT = 0x9052,
  eGL_IMAGE_2D_ARRAY_EXT = 0x9053,
  eGL_IMAGE_CUBE_MAP_ARRAY_EXT = 0x9054,
  eGL_IMAGE_2D_MULTISAMPLE_EXT = 0x9055,
  eGL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9056,
  eGL_INT_IMAGE_1D_EXT = 0x9057,
  eGL_INT_IMAGE_2D_EXT = 0x9058,
  eGL_INT_IMAGE_3D_EXT = 0x9059,
  eGL_INT_IMAGE_2D_RECT_EXT = 0x905A,
  eGL_INT_IMAGE_CUBE_EXT = 0x905B,
  eGL_INT_IMAGE_BUFFER_EXT = 0x905C,
  eGL_INT_IMAGE_1D_ARRAY_EXT = 0x905D,
  eGL_INT_IMAGE_2D_ARRAY_EXT = 0x905E,
  eGL_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x905F,
  eGL_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x9060,
  eGL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9061,
  eGL_UNSIGNED_INT_IMAGE_1D_EXT = 0x9062,
  eGL_UNSIGNED_INT_IMAGE_2D_EXT = 0x9063,
  eGL_UNSIGNED_INT_IMAGE_3D_EXT = 0x9064,
  eGL_UNSIGNED_INT_IMAGE_2D_RECT_EXT = 0x9065,
  eGL_UNSIGNED_INT_IMAGE_CUBE_EXT = 0x9066,
  eGL_UNSIGNED_INT_IMAGE_BUFFER_EXT = 0x9067,
  eGL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT = 0x9068,
  eGL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT = 0x9069,
  eGL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x906A,
  eGL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x906B,
  eGL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x906C,
  eGL_MAX_IMAGE_SAMPLES_EXT = 0x906D,
  eGL_IMAGE_BINDING_FORMAT_EXT = 0x906E,
  eGL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT = 0x00000001,
  eGL_ELEMENT_ARRAY_BARRIER_BIT_EXT = 0x00000002,
  eGL_UNIFORM_BARRIER_BIT_EXT = 0x00000004,
  eGL_TEXTURE_FETCH_BARRIER_BIT_EXT = 0x00000008,
  eGL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT = 0x00000020,
  eGL_COMMAND_BARRIER_BIT_EXT = 0x00000040,
  eGL_PIXEL_BUFFER_BARRIER_BIT_EXT = 0x00000080,
  eGL_TEXTURE_UPDATE_BARRIER_BIT_EXT = 0x00000100,
  eGL_BUFFER_UPDATE_BARRIER_BIT_EXT = 0x00000200,
  eGL_FRAMEBUFFER_BARRIER_BIT_EXT = 0x00000400,
  eGL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT = 0x00000800,
  eGL_ATOMIC_COUNTER_BARRIER_BIT_EXT = 0x00001000,
  eGL_ALL_BARRIER_BITS_EXT = 0xFFFFFFFF,
  eGL_SHARED_TEXTURE_PALETTE_EXT = 0x81FB,
  eGL_STENCIL_TAG_BITS_EXT = 0x88F2,
  eGL_STENCIL_CLEAR_TAG_VALUE_EXT = 0x88F3,
  eGL_STENCIL_TEST_TWO_SIDE_EXT = 0x8910,
  eGL_ACTIVE_STENCIL_FACE_EXT = 0x8911,
  eGL_INCR_WRAP_EXT = 0x8507,
  eGL_DECR_WRAP_EXT = 0x8508,
  eGL_ALPHA4_EXT = 0x803B,
  eGL_ALPHA8_EXT = 0x803C,
  eGL_ALPHA12_EXT = 0x803D,
  eGL_ALPHA16_EXT = 0x803E,
  eGL_LUMINANCE4_EXT = 0x803F,
  eGL_LUMINANCE8_EXT = 0x8040,
  eGL_LUMINANCE12_EXT = 0x8041,
  eGL_LUMINANCE16_EXT = 0x8042,
  eGL_LUMINANCE4_ALPHA4_EXT = 0x8043,
  eGL_LUMINANCE6_ALPHA2_EXT = 0x8044,
  eGL_LUMINANCE8_ALPHA8_EXT = 0x8045,
  eGL_LUMINANCE12_ALPHA4_EXT = 0x8046,
  eGL_LUMINANCE12_ALPHA12_EXT = 0x8047,
  eGL_LUMINANCE16_ALPHA16_EXT = 0x8048,
  eGL_INTENSITY_EXT = 0x8049,
  eGL_INTENSITY4_EXT = 0x804A,
  eGL_INTENSITY8_EXT = 0x804B,
  eGL_INTENSITY12_EXT = 0x804C,
  eGL_INTENSITY16_EXT = 0x804D,
  eGL_RGB2_EXT = 0x804E,
  eGL_RGB4_EXT = 0x804F,
  eGL_RGB5_EXT = 0x8050,
  eGL_RGB8_EXT = 0x8051,
  eGL_RGB10_EXT = 0x8052,
  eGL_RGB12_EXT = 0x8053,
  eGL_RGB16_EXT = 0x8054,
  eGL_RGBA2_EXT = 0x8055,
  eGL_RGBA4_EXT = 0x8056,
  eGL_RGB5_A1_EXT = 0x8057,
  eGL_RGBA8_EXT = 0x8058,
  eGL_RGB10_A2_EXT = 0x8059,
  eGL_RGBA12_EXT = 0x805A,
  eGL_RGBA16_EXT = 0x805B,
  eGL_TEXTURE_RED_SIZE_EXT = 0x805C,
  eGL_TEXTURE_GREEN_SIZE_EXT = 0x805D,
  eGL_TEXTURE_BLUE_SIZE_EXT = 0x805E,
  eGL_TEXTURE_ALPHA_SIZE_EXT = 0x805F,
  eGL_TEXTURE_LUMINANCE_SIZE_EXT = 0x8060,
  eGL_TEXTURE_INTENSITY_SIZE_EXT = 0x8061,
  eGL_REPLACE_EXT = 0x8062,
  eGL_PROXY_TEXTURE_1D_EXT = 0x8063,
  eGL_PROXY_TEXTURE_2D_EXT = 0x8064,
  eGL_TEXTURE_TOO_LARGE_EXT = 0x8065,
  eGL_PACK_SKIP_IMAGES_EXT = 0x806B,
  eGL_PACK_IMAGE_HEIGHT_EXT = 0x806C,
  eGL_UNPACK_SKIP_IMAGES_EXT = 0x806D,
  eGL_UNPACK_IMAGE_HEIGHT_EXT = 0x806E,
  eGL_TEXTURE_3D_EXT = 0x806F,
  eGL_PROXY_TEXTURE_3D_EXT = 0x8070,
  eGL_TEXTURE_DEPTH_EXT = 0x8071,
  eGL_TEXTURE_WRAP_R_EXT = 0x8072,
  eGL_MAX_3D_TEXTURE_SIZE_EXT = 0x8073,
  eGL_TEXTURE_1D_ARRAY_EXT = 0x8C18,
  eGL_PROXY_TEXTURE_1D_ARRAY_EXT = 0x8C19,
  eGL_TEXTURE_2D_ARRAY_EXT = 0x8C1A,
  eGL_PROXY_TEXTURE_2D_ARRAY_EXT = 0x8C1B,
  eGL_TEXTURE_BINDING_1D_ARRAY_EXT = 0x8C1C,
  eGL_TEXTURE_BINDING_2D_ARRAY_EXT = 0x8C1D,
  eGL_MAX_ARRAY_TEXTURE_LAYERS_EXT = 0x88FF,
  eGL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = 0x884E,
  eGL_TEXTURE_BUFFER_EXT = 0x8C2A,
  eGL_MAX_TEXTURE_BUFFER_SIZE_EXT = 0x8C2B,
  eGL_TEXTURE_BINDING_BUFFER_EXT = 0x8C2C,
  eGL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = 0x8C2D,
  eGL_TEXTURE_BUFFER_FORMAT_EXT = 0x8C2E,
  eGL_COMPRESSED_LUMINANCE_LATC1_EXT = 0x8C70,
  eGL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = 0x8C71,
  eGL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C72,
  eGL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C73,
  eGL_COMPRESSED_RED_RGTC1_EXT = 0x8DBB,
  eGL_COMPRESSED_SIGNED_RED_RGTC1_EXT = 0x8DBC,
  eGL_COMPRESSED_RED_GREEN_RGTC2_EXT = 0x8DBD,
  eGL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = 0x8DBE,
  eGL_NORMAL_MAP_EXT = 0x8511,
  eGL_REFLECTION_MAP_EXT = 0x8512,
  eGL_TEXTURE_CUBE_MAP_EXT = 0x8513,
  eGL_TEXTURE_BINDING_CUBE_MAP_EXT = 0x8514,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = 0x8515,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = 0x8516,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = 0x8517,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = 0x8518,
  eGL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = 0x8519,
  eGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = 0x851A,
  eGL_PROXY_TEXTURE_CUBE_MAP_EXT = 0x851B,
  eGL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = 0x851C,
  eGL_COMBINE_EXT = 0x8570,
  eGL_COMBINE_RGB_EXT = 0x8571,
  eGL_COMBINE_ALPHA_EXT = 0x8572,
  eGL_RGB_SCALE_EXT = 0x8573,
  eGL_ADD_SIGNED_EXT = 0x8574,
  eGL_INTERPOLATE_EXT = 0x8575,
  eGL_CONSTANT_EXT = 0x8576,
  eGL_PRIMARY_COLOR_EXT = 0x8577,
  eGL_PREVIOUS_EXT = 0x8578,
  eGL_SOURCE0_RGB_EXT = 0x8580,
  eGL_SOURCE1_RGB_EXT = 0x8581,
  eGL_SOURCE2_RGB_EXT = 0x8582,
  eGL_SOURCE0_ALPHA_EXT = 0x8588,
  eGL_SOURCE1_ALPHA_EXT = 0x8589,
  eGL_SOURCE2_ALPHA_EXT = 0x858A,
  eGL_OPERAND0_RGB_EXT = 0x8590,
  eGL_OPERAND1_RGB_EXT = 0x8591,
  eGL_OPERAND2_RGB_EXT = 0x8592,
  eGL_OPERAND0_ALPHA_EXT = 0x8598,
  eGL_OPERAND1_ALPHA_EXT = 0x8599,
  eGL_OPERAND2_ALPHA_EXT = 0x859A,
  eGL_DOT3_RGB_EXT = 0x8740,
  eGL_DOT3_RGBA_EXT = 0x8741,
  eGL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE,
  eGL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF,
  eGL_RGBA32UI_EXT = 0x8D70,
  eGL_RGB32UI_EXT = 0x8D71,
  eGL_ALPHA32UI_EXT = 0x8D72,
  eGL_INTENSITY32UI_EXT = 0x8D73,
  eGL_LUMINANCE32UI_EXT = 0x8D74,
  eGL_LUMINANCE_ALPHA32UI_EXT = 0x8D75,
  eGL_RGBA16UI_EXT = 0x8D76,
  eGL_RGB16UI_EXT = 0x8D77,
  eGL_ALPHA16UI_EXT = 0x8D78,
  eGL_INTENSITY16UI_EXT = 0x8D79,
  eGL_LUMINANCE16UI_EXT = 0x8D7A,
  eGL_LUMINANCE_ALPHA16UI_EXT = 0x8D7B,
  eGL_RGBA8UI_EXT = 0x8D7C,
  eGL_RGB8UI_EXT = 0x8D7D,
  eGL_ALPHA8UI_EXT = 0x8D7E,
  eGL_INTENSITY8UI_EXT = 0x8D7F,
  eGL_LUMINANCE8UI_EXT = 0x8D80,
  eGL_LUMINANCE_ALPHA8UI_EXT = 0x8D81,
  eGL_RGBA32I_EXT = 0x8D82,
  eGL_RGB32I_EXT = 0x8D83,
  eGL_ALPHA32I_EXT = 0x8D84,
  eGL_INTENSITY32I_EXT = 0x8D85,
  eGL_LUMINANCE32I_EXT = 0x8D86,
  eGL_LUMINANCE_ALPHA32I_EXT = 0x8D87,
  eGL_RGBA16I_EXT = 0x8D88,
  eGL_RGB16I_EXT = 0x8D89,
  eGL_ALPHA16I_EXT = 0x8D8A,
  eGL_INTENSITY16I_EXT = 0x8D8B,
  eGL_LUMINANCE16I_EXT = 0x8D8C,
  eGL_LUMINANCE_ALPHA16I_EXT = 0x8D8D,
  eGL_RGBA8I_EXT = 0x8D8E,
  eGL_RGB8I_EXT = 0x8D8F,
  eGL_ALPHA8I_EXT = 0x8D90,
  eGL_INTENSITY8I_EXT = 0x8D91,
  eGL_LUMINANCE8I_EXT = 0x8D92,
  eGL_LUMINANCE_ALPHA8I_EXT = 0x8D93,
  eGL_RED_INTEGER_EXT = 0x8D94,
  eGL_GREEN_INTEGER_EXT = 0x8D95,
  eGL_BLUE_INTEGER_EXT = 0x8D96,
  eGL_ALPHA_INTEGER_EXT = 0x8D97,
  eGL_RGB_INTEGER_EXT = 0x8D98,
  eGL_RGBA_INTEGER_EXT = 0x8D99,
  eGL_BGR_INTEGER_EXT = 0x8D9A,
  eGL_BGRA_INTEGER_EXT = 0x8D9B,
  eGL_LUMINANCE_INTEGER_EXT = 0x8D9C,
  eGL_LUMINANCE_ALPHA_INTEGER_EXT = 0x8D9D,
  eGL_RGBA_INTEGER_MODE_EXT = 0x8D9E,
  eGL_MAX_TEXTURE_LOD_BIAS_EXT = 0x84FD,
  eGL_TEXTURE_FILTER_CONTROL_EXT = 0x8500,
  eGL_TEXTURE_LOD_BIAS_EXT = 0x8501,
  eGL_MIRROR_CLAMP_EXT = 0x8742,
  eGL_MIRROR_CLAMP_TO_EDGE_EXT = 0x8743,
  eGL_MIRROR_CLAMP_TO_BORDER_EXT = 0x8912,
  eGL_TEXTURE_PRIORITY_EXT = 0x8066,
  eGL_TEXTURE_RESIDENT_EXT = 0x8067,
  eGL_TEXTURE_1D_BINDING_EXT = 0x8068,
  eGL_TEXTURE_2D_BINDING_EXT = 0x8069,
  eGL_TEXTURE_3D_BINDING_EXT = 0x806A,
  eGL_PERTURB_EXT = 0x85AE,
  eGL_TEXTURE_NORMAL_EXT = 0x85AF,
  eGL_SRGB_EXT = 0x8C40,
  eGL_SRGB8_EXT = 0x8C41,
  eGL_SRGB_ALPHA_EXT = 0x8C42,
  eGL_SRGB8_ALPHA8_EXT = 0x8C43,
  eGL_SLUMINANCE_ALPHA_EXT = 0x8C44,
  eGL_SLUMINANCE8_ALPHA8_EXT = 0x8C45,
  eGL_SLUMINANCE_EXT = 0x8C46,
  eGL_SLUMINANCE8_EXT = 0x8C47,
  eGL_COMPRESSED_SRGB_EXT = 0x8C48,
  eGL_COMPRESSED_SRGB_ALPHA_EXT = 0x8C49,
  eGL_COMPRESSED_SLUMINANCE_EXT = 0x8C4A,
  eGL_COMPRESSED_SLUMINANCE_ALPHA_EXT = 0x8C4B,
  eGL_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F,
  eGL_RGB9_E5_EXT = 0x8C3D,
  eGL_UNSIGNED_INT_5_9_9_9_REV_EXT = 0x8C3E,
  eGL_TEXTURE_SHARED_SIZE_EXT = 0x8C3F,
  eGL_ALPHA_SNORM = 0x9010,
  eGL_LUMINANCE_SNORM = 0x9011,
  eGL_LUMINANCE_ALPHA_SNORM = 0x9012,
  eGL_INTENSITY_SNORM = 0x9013,
  eGL_ALPHA8_SNORM = 0x9014,
  eGL_LUMINANCE8_SNORM = 0x9015,
  eGL_LUMINANCE8_ALPHA8_SNORM = 0x9016,
  eGL_INTENSITY8_SNORM = 0x9017,
  eGL_ALPHA16_SNORM = 0x9018,
  eGL_LUMINANCE16_SNORM = 0x9019,
  eGL_LUMINANCE16_ALPHA16_SNORM = 0x901A,
  eGL_INTENSITY16_SNORM = 0x901B,
  eGL_RED_SNORM = 0x8F90,
  eGL_RG_SNORM = 0x8F91,
  eGL_RGB_SNORM = 0x8F92,
  eGL_RGBA_SNORM = 0x8F93,
  eGL_TEXTURE_SWIZZLE_R_EXT = 0x8E42,
  eGL_TEXTURE_SWIZZLE_G_EXT = 0x8E43,
  eGL_TEXTURE_SWIZZLE_B_EXT = 0x8E44,
  eGL_TEXTURE_SWIZZLE_A_EXT = 0x8E45,
  eGL_TEXTURE_SWIZZLE_RGBA_EXT = 0x8E46,
  eGL_TIME_ELAPSED_EXT = 0x88BF,
  eGL_TRANSFORM_FEEDBACK_BUFFER_EXT = 0x8C8E,
  eGL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 0x8C84,
  eGL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 0x8C85,
  eGL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 0x8C8F,
  eGL_INTERLEAVED_ATTRIBS_EXT = 0x8C8C,
  eGL_SEPARATE_ATTRIBS_EXT = 0x8C8D,
  eGL_PRIMITIVES_GENERATED_EXT = 0x8C87,
  eGL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 0x8C88,
  eGL_RASTERIZER_DISCARD_EXT = 0x8C89,
  eGL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 0x8C8A,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 0x8C8B,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 0x8C80,
  eGL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 0x8C83,
  eGL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 0x8C7F,
  eGL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 0x8C76,
  eGL_VERTEX_ARRAY_EXT = 0x8074,
  eGL_NORMAL_ARRAY_EXT = 0x8075,
  eGL_COLOR_ARRAY_EXT = 0x8076,
  eGL_INDEX_ARRAY_EXT = 0x8077,
  eGL_TEXTURE_COORD_ARRAY_EXT = 0x8078,
  eGL_EDGE_FLAG_ARRAY_EXT = 0x8079,
  eGL_VERTEX_ARRAY_SIZE_EXT = 0x807A,
  eGL_VERTEX_ARRAY_TYPE_EXT = 0x807B,
  eGL_VERTEX_ARRAY_STRIDE_EXT = 0x807C,
  eGL_VERTEX_ARRAY_COUNT_EXT = 0x807D,
  eGL_NORMAL_ARRAY_TYPE_EXT = 0x807E,
  eGL_NORMAL_ARRAY_STRIDE_EXT = 0x807F,
  eGL_NORMAL_ARRAY_COUNT_EXT = 0x8080,
  eGL_COLOR_ARRAY_SIZE_EXT = 0x8081,
  eGL_COLOR_ARRAY_TYPE_EXT = 0x8082,
  eGL_COLOR_ARRAY_STRIDE_EXT = 0x8083,
  eGL_COLOR_ARRAY_COUNT_EXT = 0x8084,
  eGL_INDEX_ARRAY_TYPE_EXT = 0x8085,
  eGL_INDEX_ARRAY_STRIDE_EXT = 0x8086,
  eGL_INDEX_ARRAY_COUNT_EXT = 0x8087,
  eGL_TEXTURE_COORD_ARRAY_SIZE_EXT = 0x8088,
  eGL_TEXTURE_COORD_ARRAY_TYPE_EXT = 0x8089,
  eGL_TEXTURE_COORD_ARRAY_STRIDE_EXT = 0x808A,
  eGL_TEXTURE_COORD_ARRAY_COUNT_EXT = 0x808B,
  eGL_EDGE_FLAG_ARRAY_STRIDE_EXT = 0x808C,
  eGL_EDGE_FLAG_ARRAY_COUNT_EXT = 0x808D,
  eGL_VERTEX_ARRAY_POINTER_EXT = 0x808E,
  eGL_NORMAL_ARRAY_POINTER_EXT = 0x808F,
  eGL_COLOR_ARRAY_POINTER_EXT = 0x8090,
  eGL_INDEX_ARRAY_POINTER_EXT = 0x8091,
  eGL_TEXTURE_COORD_ARRAY_POINTER_EXT = 0x8092,
  eGL_EDGE_FLAG_ARRAY_POINTER_EXT = 0x8093,
  eGL_DOUBLE_VEC2_EXT = 0x8FFC,
  eGL_DOUBLE_VEC3_EXT = 0x8FFD,
  eGL_DOUBLE_VEC4_EXT = 0x8FFE,
  eGL_DOUBLE_MAT2_EXT = 0x8F46,
  eGL_DOUBLE_MAT3_EXT = 0x8F47,
  eGL_DOUBLE_MAT4_EXT = 0x8F48,
  eGL_DOUBLE_MAT2x3_EXT = 0x8F49,
  eGL_DOUBLE_MAT2x4_EXT = 0x8F4A,
  eGL_DOUBLE_MAT3x2_EXT = 0x8F4B,
  eGL_DOUBLE_MAT3x4_EXT = 0x8F4C,
  eGL_DOUBLE_MAT4x2_EXT = 0x8F4D,
  eGL_DOUBLE_MAT4x3_EXT = 0x8F4E,
  eGL_VERTEX_SHADER_EXT = 0x8780,
  eGL_VERTEX_SHADER_BINDING_EXT = 0x8781,
  eGL_OP_INDEX_EXT = 0x8782,
  eGL_OP_NEGATE_EXT = 0x8783,
  eGL_OP_DOT3_EXT = 0x8784,
  eGL_OP_DOT4_EXT = 0x8785,
  eGL_OP_MUL_EXT = 0x8786,
  eGL_OP_ADD_EXT = 0x8787,
  eGL_OP_MADD_EXT = 0x8788,
  eGL_OP_FRAC_EXT = 0x8789,
  eGL_OP_MAX_EXT = 0x878A,
  eGL_OP_MIN_EXT = 0x878B,
  eGL_OP_SET_GE_EXT = 0x878C,
  eGL_OP_SET_LT_EXT = 0x878D,
  eGL_OP_CLAMP_EXT = 0x878E,
  eGL_OP_FLOOR_EXT = 0x878F,
  eGL_OP_ROUND_EXT = 0x8790,
  eGL_OP_EXP_BASE_2_EXT = 0x8791,
  eGL_OP_LOG_BASE_2_EXT = 0x8792,
  eGL_OP_POWER_EXT = 0x8793,
  eGL_OP_RECIP_EXT = 0x8794,
  eGL_OP_RECIP_SQRT_EXT = 0x8795,
  eGL_OP_SUB_EXT = 0x8796,
  eGL_OP_CROSS_PRODUCT_EXT = 0x8797,
  eGL_OP_MULTIPLY_MATRIX_EXT = 0x8798,
  eGL_OP_MOV_EXT = 0x8799,
  eGL_OUTPUT_VERTEX_EXT = 0x879A,
  eGL_OUTPUT_COLOR0_EXT = 0x879B,
  eGL_OUTPUT_COLOR1_EXT = 0x879C,
  eGL_OUTPUT_TEXTURE_COORD0_EXT = 0x879D,
  eGL_OUTPUT_TEXTURE_COORD1_EXT = 0x879E,
  eGL_OUTPUT_TEXTURE_COORD2_EXT = 0x879F,
  eGL_OUTPUT_TEXTURE_COORD3_EXT = 0x87A0,
  eGL_OUTPUT_TEXTURE_COORD4_EXT = 0x87A1,
  eGL_OUTPUT_TEXTURE_COORD5_EXT = 0x87A2,
  eGL_OUTPUT_TEXTURE_COORD6_EXT = 0x87A3,
  eGL_OUTPUT_TEXTURE_COORD7_EXT = 0x87A4,
  eGL_OUTPUT_TEXTURE_COORD8_EXT = 0x87A5,
  eGL_OUTPUT_TEXTURE_COORD9_EXT = 0x87A6,
  eGL_OUTPUT_TEXTURE_COORD10_EXT = 0x87A7,
  eGL_OUTPUT_TEXTURE_COORD11_EXT = 0x87A8,
  eGL_OUTPUT_TEXTURE_COORD12_EXT = 0x87A9,
  eGL_OUTPUT_TEXTURE_COORD13_EXT = 0x87AA,
  eGL_OUTPUT_TEXTURE_COORD14_EXT = 0x87AB,
  eGL_OUTPUT_TEXTURE_COORD15_EXT = 0x87AC,
  eGL_OUTPUT_TEXTURE_COORD16_EXT = 0x87AD,
  eGL_OUTPUT_TEXTURE_COORD17_EXT = 0x87AE,
  eGL_OUTPUT_TEXTURE_COORD18_EXT = 0x87AF,
  eGL_OUTPUT_TEXTURE_COORD19_EXT = 0x87B0,
  eGL_OUTPUT_TEXTURE_COORD20_EXT = 0x87B1,
  eGL_OUTPUT_TEXTURE_COORD21_EXT = 0x87B2,
  eGL_OUTPUT_TEXTURE_COORD22_EXT = 0x87B3,
  eGL_OUTPUT_TEXTURE_COORD23_EXT = 0x87B4,
  eGL_OUTPUT_TEXTURE_COORD24_EXT = 0x87B5,
  eGL_OUTPUT_TEXTURE_COORD25_EXT = 0x87B6,
  eGL_OUTPUT_TEXTURE_COORD26_EXT = 0x87B7,
  eGL_OUTPUT_TEXTURE_COORD27_EXT = 0x87B8,
  eGL_OUTPUT_TEXTURE_COORD28_EXT = 0x87B9,
  eGL_OUTPUT_TEXTURE_COORD29_EXT = 0x87BA,
  eGL_OUTPUT_TEXTURE_COORD30_EXT = 0x87BB,
  eGL_OUTPUT_TEXTURE_COORD31_EXT = 0x87BC,
  eGL_OUTPUT_FOG_EXT = 0x87BD,
  eGL_SCALAR_EXT = 0x87BE,
  eGL_VECTOR_EXT = 0x87BF,
  eGL_MATRIX_EXT = 0x87C0,
  eGL_VARIANT_EXT = 0x87C1,
  eGL_INVARIANT_EXT = 0x87C2,
  eGL_LOCAL_CONSTANT_EXT = 0x87C3,
  eGL_LOCAL_EXT = 0x87C4,
  eGL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87C5,
  eGL_MAX_VERTEX_SHADER_VARIANTS_EXT = 0x87C6,
  eGL_MAX_VERTEX_SHADER_INVARIANTS_EXT = 0x87C7,
  eGL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87C8,
  eGL_MAX_VERTEX_SHADER_LOCALS_EXT = 0x87C9,
  eGL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CA,
  eGL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = 0x87CB,
  eGL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87CC,
  eGL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = 0x87CD,
  eGL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = 0x87CE,
  eGL_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CF,
  eGL_VERTEX_SHADER_VARIANTS_EXT = 0x87D0,
  eGL_VERTEX_SHADER_INVARIANTS_EXT = 0x87D1,
  eGL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87D2,
  eGL_VERTEX_SHADER_LOCALS_EXT = 0x87D3,
  eGL_VERTEX_SHADER_OPTIMIZED_EXT = 0x87D4,
  eGL_X_EXT = 0x87D5,
  eGL_Y_EXT = 0x87D6,
  eGL_Z_EXT = 0x87D7,
  eGL_W_EXT = 0x87D8,
  eGL_NEGATIVE_X_EXT = 0x87D9,
  eGL_NEGATIVE_Y_EXT = 0x87DA,
  eGL_NEGATIVE_Z_EXT = 0x87DB,
  eGL_NEGATIVE_W_EXT = 0x87DC,
  eGL_ZERO_EXT = 0x87DD,
  eGL_ONE_EXT = 0x87DE,
  eGL_NEGATIVE_ONE_EXT = 0x87DF,
  eGL_NORMALIZED_RANGE_EXT = 0x87E0,
  eGL_FULL_RANGE_EXT = 0x87E1,
  eGL_CURRENT_VERTEX_EXT = 0x87E2,
  eGL_MVP_MATRIX_EXT = 0x87E3,
  eGL_VARIANT_VALUE_EXT = 0x87E4,
  eGL_VARIANT_DATATYPE_EXT = 0x87E5,
  eGL_VARIANT_ARRAY_STRIDE_EXT = 0x87E6,
  eGL_VARIANT_ARRAY_TYPE_EXT = 0x87E7,
  eGL_VARIANT_ARRAY_EXT = 0x87E8,
  eGL_VARIANT_ARRAY_POINTER_EXT = 0x87E9,
  eGL_INVARIANT_VALUE_EXT = 0x87EA,
  eGL_INVARIANT_DATATYPE_EXT = 0x87EB,
  eGL_LOCAL_CONSTANT_VALUE_EXT = 0x87EC,
  eGL_LOCAL_CONSTANT_DATATYPE_EXT = 0x87ED,
  eGL_MODELVIEW0_STACK_DEPTH_EXT = 0x0BA3,
  eGL_MODELVIEW1_STACK_DEPTH_EXT = 0x8502,
  eGL_MODELVIEW0_MATRIX_EXT = 0x0BA6,
  eGL_MODELVIEW1_MATRIX_EXT = 0x8506,
  eGL_VERTEX_WEIGHTING_EXT = 0x8509,
  eGL_MODELVIEW0_EXT = 0x1700,
  eGL_MODELVIEW1_EXT = 0x850A,
  eGL_CURRENT_VERTEX_WEIGHT_EXT = 0x850B,
  eGL_VERTEX_WEIGHT_ARRAY_EXT = 0x850C,
  eGL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = 0x850D,
  eGL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = 0x850E,
  eGL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = 0x850F,
  eGL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = 0x8510,
  eGL_SYNC_X11_FENCE_EXT = 0x90E1,
  eGL_DEBUG_TOOL_EXT = 0x6789,
  eGL_DEBUG_TOOL_NAME_EXT = 0x678A,
  eGL_DEBUG_TOOL_PURPOSE_EXT = 0x678B,
  eGL_DEBUG_TOOL_FRAME_CAPTURE_BIT_EXT = 0x0001,
  eGL_DEBUG_TOOL_TRACE_CAPTURE_BIT_EXT = 0x0002,
  eGL_DEBUG_TOOL_API_CALL_LOG_BIT_EXT = 0x0004,
  eGL_DEBUG_TOOL_PROFILING_BIT_EXT = 0x0008,
  eGL_DEBUG_TOOL_VALIDATION_BIT_EXT = 0x0010,
  eGL_IGNORE_BORDER_HP = 0x8150,
  eGL_CONSTANT_BORDER_HP = 0x8151,
  eGL_REPLICATE_BORDER_HP = 0x8153,
  eGL_CONVOLUTION_BORDER_COLOR_HP = 0x8154,
  eGL_IMAGE_SCALE_X_HP = 0x8155,
  eGL_IMAGE_SCALE_Y_HP = 0x8156,
  eGL_IMAGE_TRANSLATE_X_HP = 0x8157,
  eGL_IMAGE_TRANSLATE_Y_HP = 0x8158,
  eGL_IMAGE_ROTATE_ANGLE_HP = 0x8159,
  eGL_IMAGE_ROTATE_ORIGIN_X_HP = 0x815A,
  eGL_IMAGE_ROTATE_ORIGIN_Y_HP = 0x815B,
  eGL_IMAGE_MAG_FILTER_HP = 0x815C,
  eGL_IMAGE_MIN_FILTER_HP = 0x815D,
  eGL_IMAGE_CUBIC_WEIGHT_HP = 0x815E,
  eGL_CUBIC_HP = 0x815F,
  eGL_AVERAGE_HP = 0x8160,
  eGL_IMAGE_TRANSFORM_2D_HP = 0x8161,
  eGL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8162,
  eGL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8163,
  eGL_OCCLUSION_TEST_HP = 0x8165,
  eGL_OCCLUSION_TEST_RESULT_HP = 0x8166,
  eGL_TEXTURE_LIGHTING_MODE_HP = 0x8167,
  eGL_TEXTURE_POST_SPECULAR_HP = 0x8168,
  eGL_TEXTURE_PRE_SPECULAR_HP = 0x8169,
  eGL_RASTER_POSITION_UNCLIPPED_IBM = 0x19262,
  eGL_MIRRORED_REPEAT_IBM = 0x8370,
  eGL_RED_MIN_CLAMP_INGR = 0x8560,
  eGL_GREEN_MIN_CLAMP_INGR = 0x8561,
  eGL_BLUE_MIN_CLAMP_INGR = 0x8562,
  eGL_ALPHA_MIN_CLAMP_INGR = 0x8563,
  eGL_RED_MAX_CLAMP_INGR = 0x8564,
  eGL_GREEN_MAX_CLAMP_INGR = 0x8565,
  eGL_BLUE_MAX_CLAMP_INGR = 0x8566,
  eGL_ALPHA_MAX_CLAMP_INGR = 0x8567,
  eGL_INTERLACE_READ_INGR = 0x8568,
  eGL_TEXTURE_MEMORY_LAYOUT_INTEL = 0x83FF,
  eGL_PARALLEL_ARRAYS_INTEL = 0x83F4,
  eGL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F5,
  eGL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F6,
  eGL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F7,
  eGL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F8,
  eGL_TEXTURE_1D_STACK_MESAX = 0x8759,
  eGL_TEXTURE_2D_STACK_MESAX = 0x875A,
  eGL_PROXY_TEXTURE_1D_STACK_MESAX = 0x875B,
  eGL_PROXY_TEXTURE_2D_STACK_MESAX = 0x875C,
  eGL_TEXTURE_1D_STACK_BINDING_MESAX = 0x875D,
  eGL_TEXTURE_2D_STACK_BINDING_MESAX = 0x875E,
  eGL_PACK_INVERT_MESA = 0x8758,
  eGL_PROGRAM_BINARY_FORMAT_MESA = 0x875F,
  eGL_TILE_RASTER_ORDER_FIXED_MESA = 0x8BB8,
  eGL_TILE_RASTER_ORDER_INCREASING_X_MESA = 0x8BB9,
  eGL_TILE_RASTER_ORDER_INCREASING_Y_MESA = 0x8BBA,
  eGL_UNSIGNED_SHORT_8_8_MESA = 0x85BA,
  eGL_UNSIGNED_SHORT_8_8_REV_MESA = 0x85BB,
  eGL_YCBCR_MESA = 0x8757,
  eGL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = 0x9047,
  eGL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = 0x9048,
  eGL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = 0x9049,
  eGL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = 0x904A,
  eGL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = 0x904B,
  eGL_LGPU_SEPARATE_STORAGE_BIT_NVX = 0x0800,
  eGL_MAX_LGPU_GPUS_NVX = 0x92BA,
  eGL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV = 0x934D,
  eGL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV = 0x934E,
  eGL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV = 0x934F,
  eGL_ALPHA_TO_COVERAGE_DITHER_MODE_NV = 0x92BF,
  eGL_COMPUTE_PROGRAM_NV = 0x90FB,
  eGL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = 0x90FC,
  eGL_DEPTH_STENCIL_TO_RGBA_NV = 0x886E,
  eGL_DEPTH_STENCIL_TO_BGRA_NV = 0x886F,
  eGL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = 0x90D0,
  eGL_MAX_DEEP_3D_TEXTURE_DEPTH_NV = 0x90D1,
  eGL_DEPTH_COMPONENT32F_NV = 0x8DAB,
  eGL_DEPTH32F_STENCIL8_NV = 0x8DAC,
  eGL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = 0x8DAD,
  eGL_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF,
  eGL_DEPTH_CLAMP_NV = 0x864F,
  eGL_EVAL_2D_NV = 0x86C0,
  eGL_EVAL_TRIANGULAR_2D_NV = 0x86C1,
  eGL_MAP_TESSELLATION_NV = 0x86C2,
  eGL_MAP_ATTRIB_U_ORDER_NV = 0x86C3,
  eGL_MAP_ATTRIB_V_ORDER_NV = 0x86C4,
  eGL_EVAL_FRACTIONAL_TESSELLATION_NV = 0x86C5,
  eGL_EVAL_VERTEX_ATTRIB0_NV = 0x86C6,
  eGL_EVAL_VERTEX_ATTRIB1_NV = 0x86C7,
  eGL_EVAL_VERTEX_ATTRIB2_NV = 0x86C8,
  eGL_EVAL_VERTEX_ATTRIB3_NV = 0x86C9,
  eGL_EVAL_VERTEX_ATTRIB4_NV = 0x86CA,
  eGL_EVAL_VERTEX_ATTRIB5_NV = 0x86CB,
  eGL_EVAL_VERTEX_ATTRIB6_NV = 0x86CC,
  eGL_EVAL_VERTEX_ATTRIB7_NV = 0x86CD,
  eGL_EVAL_VERTEX_ATTRIB8_NV = 0x86CE,
  eGL_EVAL_VERTEX_ATTRIB9_NV = 0x86CF,
  eGL_EVAL_VERTEX_ATTRIB10_NV = 0x86D0,
  eGL_EVAL_VERTEX_ATTRIB11_NV = 0x86D1,
  eGL_EVAL_VERTEX_ATTRIB12_NV = 0x86D2,
  eGL_EVAL_VERTEX_ATTRIB13_NV = 0x86D3,
  eGL_EVAL_VERTEX_ATTRIB14_NV = 0x86D4,
  eGL_EVAL_VERTEX_ATTRIB15_NV = 0x86D5,
  eGL_MAX_MAP_TESSELLATION_NV = 0x86D6,
  eGL_MAX_RATIONAL_EVAL_ORDER_NV = 0x86D7,
  eGL_SAMPLE_POSITION_NV = 0x8E50,
  eGL_SAMPLE_MASK_NV = 0x8E51,
  eGL_SAMPLE_MASK_VALUE_NV = 0x8E52,
  eGL_TEXTURE_BINDING_RENDERBUFFER_NV = 0x8E53,
  eGL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 0x8E54,
  eGL_TEXTURE_RENDERBUFFER_NV = 0x8E55,
  eGL_SAMPLER_RENDERBUFFER_NV = 0x8E56,
  eGL_INT_SAMPLER_RENDERBUFFER_NV = 0x8E57,
  eGL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 0x8E58,
  eGL_MAX_SAMPLE_MASK_WORDS_NV = 0x8E59,
  eGL_ALL_COMPLETED_NV = 0x84F2,
  eGL_FENCE_STATUS_NV = 0x84F3,
  eGL_FENCE_CONDITION_NV = 0x84F4,
  eGL_FLOAT_R_NV = 0x8880,
  eGL_FLOAT_RG_NV = 0x8881,
  eGL_FLOAT_RGB_NV = 0x8882,
  eGL_FLOAT_RGBA_NV = 0x8883,
  eGL_FLOAT_R16_NV = 0x8884,
  eGL_FLOAT_R32_NV = 0x8885,
  eGL_FLOAT_RG16_NV = 0x8886,
  eGL_FLOAT_RG32_NV = 0x8887,
  eGL_FLOAT_RGB16_NV = 0x8888,
  eGL_FLOAT_RGB32_NV = 0x8889,
  eGL_FLOAT_RGBA16_NV = 0x888A,
  eGL_FLOAT_RGBA32_NV = 0x888B,
  eGL_TEXTURE_FLOAT_COMPONENTS_NV = 0x888C,
  eGL_FLOAT_CLEAR_COLOR_VALUE_NV = 0x888D,
  eGL_FLOAT_RGBA_MODE_NV = 0x888E,
  eGL_FOG_DISTANCE_MODE_NV = 0x855A,
  eGL_EYE_RADIAL_NV = 0x855B,
  eGL_EYE_PLANE_ABSOLUTE_NV = 0x855C,
  eGL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = 0x8868,
  eGL_FRAGMENT_PROGRAM_NV = 0x8870,
  eGL_MAX_TEXTURE_COORDS_NV = 0x8871,
  eGL_MAX_TEXTURE_IMAGE_UNITS_NV = 0x8872,
  eGL_FRAGMENT_PROGRAM_BINDING_NV = 0x8873,
  eGL_PROGRAM_ERROR_STRING_NV = 0x8874,
  eGL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4,
  eGL_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5,
  eGL_MAX_PROGRAM_IF_DEPTH_NV = 0x88F6,
  eGL_MAX_PROGRAM_LOOP_DEPTH_NV = 0x88F7,
  eGL_MAX_PROGRAM_LOOP_COUNT_NV = 0x88F8,
  eGL_GEOMETRY_PROGRAM_NV = 0x8C26,
  eGL_MAX_PROGRAM_OUTPUT_VERTICES_NV = 0x8C27,
  eGL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = 0x8C28,
  eGL_PER_GPU_STORAGE_BIT_NV = 0x0800,
  eGL_MULTICAST_GPUS_NV = 0x92BA,
  eGL_RENDER_GPU_MASK_NV = 0x9558,
  eGL_PER_GPU_STORAGE_NV = 0x9548,
  eGL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV = 0x9549,
  eGL_MIN_PROGRAM_TEXEL_OFFSET_NV = 0x8904,
  eGL_MAX_PROGRAM_TEXEL_OFFSET_NV = 0x8905,
  eGL_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8906,
  eGL_PROGRAM_RESULT_COMPONENTS_NV = 0x8907,
  eGL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8908,
  eGL_MAX_PROGRAM_RESULT_COMPONENTS_NV = 0x8909,
  eGL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = 0x8DA5,
  eGL_MAX_PROGRAM_GENERIC_RESULTS_NV = 0x8DA6,
  eGL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = 0x8E5A,
  eGL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5B,
  eGL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5C,
  eGL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = 0x8E5D,
  eGL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5E,
  eGL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5F,
  eGL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV = 0x8F44,
  eGL_MAX_PROGRAM_SUBROUTINE_NUM_NV = 0x8F45,
  eGL_HALF_FLOAT_NV = 0x140B,
  eGL_MAX_SHININESS_NV = 0x8504,
  eGL_MAX_SPOT_EXPONENT_NV = 0x8505,
  eGL_MULTISAMPLE_FILTER_HINT_NV = 0x8534,
  eGL_PIXEL_COUNTER_BITS_NV = 0x8864,
  eGL_CURRENT_OCCLUSION_QUERY_ID_NV = 0x8865,
  eGL_PIXEL_COUNT_NV = 0x8866,
  eGL_PIXEL_COUNT_AVAILABLE_NV = 0x8867,
  eGL_DEPTH_STENCIL_NV = 0x84F9,
  eGL_UNSIGNED_INT_24_8_NV = 0x84FA,
  eGL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = 0x8DA0,
  eGL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = 0x8DA1,
  eGL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA2,
  eGL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA3,
  eGL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA4,
  eGL_2_BYTES_NV = 0x1407,
  eGL_3_BYTES_NV = 0x1408,
  eGL_4_BYTES_NV = 0x1409,
  eGL_EYE_LINEAR_NV = 0x2400,
  eGL_OBJECT_LINEAR_NV = 0x2401,
  eGL_CONSTANT_NV = 0x8576,
  eGL_PATH_FOG_GEN_MODE_NV = 0x90AC,
  eGL_PRIMARY_COLOR_NV = 0x852C,
  eGL_SECONDARY_COLOR_NV = 0x852D,
  eGL_PATH_GEN_COLOR_FORMAT_NV = 0x90B2,
  eGL_WRITE_PIXEL_DATA_RANGE_NV = 0x8878,
  eGL_READ_PIXEL_DATA_RANGE_NV = 0x8879,
  eGL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 0x887A,
  eGL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 0x887B,
  eGL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 0x887C,
  eGL_READ_PIXEL_DATA_RANGE_POINTER_NV = 0x887D,
  eGL_POINT_SPRITE_NV = 0x8861,
  eGL_COORD_REPLACE_NV = 0x8862,
  eGL_POINT_SPRITE_R_MODE_NV = 0x8863,
  eGL_FRAME_NV = 0x8E26,
  eGL_FIELDS_NV = 0x8E27,
  eGL_CURRENT_TIME_NV = 0x8E28,
  eGL_NUM_FILL_STREAMS_NV = 0x8E29,
  eGL_PRESENT_TIME_NV = 0x8E2A,
  eGL_PRESENT_DURATION_NV = 0x8E2B,
  eGL_PRIMITIVE_RESTART_NV = 0x8558,
  eGL_PRIMITIVE_RESTART_INDEX_NV = 0x8559,
  eGL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV = 0x9540,
  eGL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV = 0x9542,
  eGL_QUERY_RESOURCE_SYS_RESERVED_NV = 0x9544,
  eGL_QUERY_RESOURCE_TEXTURE_NV = 0x9545,
  eGL_QUERY_RESOURCE_RENDERBUFFER_NV = 0x9546,
  eGL_QUERY_RESOURCE_BUFFEROBJECT_NV = 0x9547,
  eGL_REGISTER_COMBINERS_NV = 0x8522,
  eGL_VARIABLE_A_NV = 0x8523,
  eGL_VARIABLE_B_NV = 0x8524,
  eGL_VARIABLE_C_NV = 0x8525,
  eGL_VARIABLE_D_NV = 0x8526,
  eGL_VARIABLE_E_NV = 0x8527,
  eGL_VARIABLE_F_NV = 0x8528,
  eGL_VARIABLE_G_NV = 0x8529,
  eGL_CONSTANT_COLOR0_NV = 0x852A,
  eGL_CONSTANT_COLOR1_NV = 0x852B,
  eGL_SPARE0_NV = 0x852E,
  eGL_SPARE1_NV = 0x852F,
  eGL_DISCARD_NV = 0x8530,
  eGL_E_TIMES_F_NV = 0x8531,
  eGL_SPARE0_PLUS_SECONDARY_COLOR_NV = 0x8532,
  eGL_UNSIGNED_IDENTITY_NV = 0x8536,
  eGL_UNSIGNED_INVERT_NV = 0x8537,
  eGL_EXPAND_NORMAL_NV = 0x8538,
  eGL_EXPAND_NEGATE_NV = 0x8539,
  eGL_HALF_BIAS_NORMAL_NV = 0x853A,
  eGL_HALF_BIAS_NEGATE_NV = 0x853B,
  eGL_SIGNED_IDENTITY_NV = 0x853C,
  eGL_SIGNED_NEGATE_NV = 0x853D,
  eGL_SCALE_BY_TWO_NV = 0x853E,
  eGL_SCALE_BY_FOUR_NV = 0x853F,
  eGL_SCALE_BY_ONE_HALF_NV = 0x8540,
  eGL_BIAS_BY_NEGATIVE_ONE_HALF_NV = 0x8541,
  eGL_COMBINER_INPUT_NV = 0x8542,
  eGL_COMBINER_MAPPING_NV = 0x8543,
  eGL_COMBINER_COMPONENT_USAGE_NV = 0x8544,
  eGL_COMBINER_AB_DOT_PRODUCT_NV = 0x8545,
  eGL_COMBINER_CD_DOT_PRODUCT_NV = 0x8546,
  eGL_COMBINER_MUX_SUM_NV = 0x8547,
  eGL_COMBINER_SCALE_NV = 0x8548,
  eGL_COMBINER_BIAS_NV = 0x8549,
  eGL_COMBINER_AB_OUTPUT_NV = 0x854A,
  eGL_COMBINER_CD_OUTPUT_NV = 0x854B,
  eGL_COMBINER_SUM_OUTPUT_NV = 0x854C,
  eGL_MAX_GENERAL_COMBINERS_NV = 0x854D,
  eGL_NUM_GENERAL_COMBINERS_NV = 0x854E,
  eGL_COLOR_SUM_CLAMP_NV = 0x854F,
  eGL_COMBINER0_NV = 0x8550,
  eGL_COMBINER1_NV = 0x8551,
  eGL_COMBINER2_NV = 0x8552,
  eGL_COMBINER3_NV = 0x8553,
  eGL_COMBINER4_NV = 0x8554,
  eGL_COMBINER5_NV = 0x8555,
  eGL_COMBINER6_NV = 0x8556,
  eGL_COMBINER7_NV = 0x8557,
  eGL_PER_STAGE_CONSTANTS_NV = 0x8535,
  eGL_PURGED_CONTEXT_RESET_NV = 0x92BB,
  eGL_MAX_PROGRAM_PATCH_ATTRIBS_NV = 0x86D8,
  eGL_TESS_CONTROL_PROGRAM_NV = 0x891E,
  eGL_TESS_EVALUATION_PROGRAM_NV = 0x891F,
  eGL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = 0x8C74,
  eGL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = 0x8C75,
  eGL_EMBOSS_LIGHT_NV = 0x855D,
  eGL_EMBOSS_CONSTANT_NV = 0x855E,
  eGL_EMBOSS_MAP_NV = 0x855F,
  eGL_NORMAL_MAP_NV = 0x8511,
  eGL_REFLECTION_MAP_NV = 0x8512,
  eGL_COMBINE4_NV = 0x8503,
  eGL_SOURCE3_RGB_NV = 0x8583,
  eGL_SOURCE3_ALPHA_NV = 0x858B,
  eGL_OPERAND3_RGB_NV = 0x8593,
  eGL_OPERAND3_ALPHA_NV = 0x859B,
  eGL_TEXTURE_UNSIGNED_REMAP_MODE_NV = 0x888F,
  eGL_TEXTURE_COVERAGE_SAMPLES_NV = 0x9045,
  eGL_TEXTURE_COLOR_SAMPLES_NV = 0x9046,
  eGL_TEXTURE_RECTANGLE_NV = 0x84F5,
  eGL_TEXTURE_BINDING_RECTANGLE_NV = 0x84F6,
  eGL_PROXY_TEXTURE_RECTANGLE_NV = 0x84F7,
  eGL_MAX_RECTANGLE_TEXTURE_SIZE_NV = 0x84F8,
  eGL_OFFSET_TEXTURE_RECTANGLE_NV = 0x864C,
  eGL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = 0x864D,
  eGL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = 0x864E,
  eGL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = 0x86D9,
  eGL_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA,
  eGL_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB,
  eGL_DSDT_MAG_INTENSITY_NV = 0x86DC,
  eGL_SHADER_CONSISTENT_NV = 0x86DD,
  eGL_TEXTURE_SHADER_NV = 0x86DE,
  eGL_SHADER_OPERATION_NV = 0x86DF,
  eGL_CULL_MODES_NV = 0x86E0,
  eGL_OFFSET_TEXTURE_MATRIX_NV = 0x86E1,
  eGL_OFFSET_TEXTURE_SCALE_NV = 0x86E2,
  eGL_OFFSET_TEXTURE_BIAS_NV = 0x86E3,
  eGL_OFFSET_TEXTURE_2D_MATRIX_NV = 0x86E1,
  eGL_OFFSET_TEXTURE_2D_SCALE_NV = 0x86E2,
  eGL_OFFSET_TEXTURE_2D_BIAS_NV = 0x86E3,
  eGL_PREVIOUS_TEXTURE_INPUT_NV = 0x86E4,
  eGL_CONST_EYE_NV = 0x86E5,
  eGL_PASS_THROUGH_NV = 0x86E6,
  eGL_CULL_FRAGMENT_NV = 0x86E7,
  eGL_OFFSET_TEXTURE_2D_NV = 0x86E8,
  eGL_DEPENDENT_AR_TEXTURE_2D_NV = 0x86E9,
  eGL_DEPENDENT_GB_TEXTURE_2D_NV = 0x86EA,
  eGL_DOT_PRODUCT_NV = 0x86EC,
  eGL_DOT_PRODUCT_DEPTH_REPLACE_NV = 0x86ED,
  eGL_DOT_PRODUCT_TEXTURE_2D_NV = 0x86EE,
  eGL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = 0x86F0,
  eGL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = 0x86F1,
  eGL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = 0x86F2,
  eGL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = 0x86F3,
  eGL_HILO_NV = 0x86F4,
  eGL_DSDT_NV = 0x86F5,
  eGL_DSDT_MAG_NV = 0x86F6,
  eGL_DSDT_MAG_VIB_NV = 0x86F7,
  eGL_HILO16_NV = 0x86F8,
  eGL_SIGNED_HILO_NV = 0x86F9,
  eGL_SIGNED_HILO16_NV = 0x86FA,
  eGL_SIGNED_RGBA_NV = 0x86FB,
  eGL_SIGNED_RGBA8_NV = 0x86FC,
  eGL_SIGNED_RGB_NV = 0x86FE,
  eGL_SIGNED_RGB8_NV = 0x86FF,
  eGL_SIGNED_LUMINANCE_NV = 0x8701,
  eGL_SIGNED_LUMINANCE8_NV = 0x8702,
  eGL_SIGNED_LUMINANCE_ALPHA_NV = 0x8703,
  eGL_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704,
  eGL_SIGNED_ALPHA_NV = 0x8705,
  eGL_SIGNED_ALPHA8_NV = 0x8706,
  eGL_SIGNED_INTENSITY_NV = 0x8707,
  eGL_SIGNED_INTENSITY8_NV = 0x8708,
  eGL_DSDT8_NV = 0x8709,
  eGL_DSDT8_MAG8_NV = 0x870A,
  eGL_DSDT8_MAG8_INTENSITY8_NV = 0x870B,
  eGL_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C,
  eGL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D,
  eGL_HI_SCALE_NV = 0x870E,
  eGL_LO_SCALE_NV = 0x870F,
  eGL_DS_SCALE_NV = 0x8710,
  eGL_DT_SCALE_NV = 0x8711,
  eGL_MAGNITUDE_SCALE_NV = 0x8712,
  eGL_VIBRANCE_SCALE_NV = 0x8713,
  eGL_HI_BIAS_NV = 0x8714,
  eGL_LO_BIAS_NV = 0x8715,
  eGL_DS_BIAS_NV = 0x8716,
  eGL_DT_BIAS_NV = 0x8717,
  eGL_MAGNITUDE_BIAS_NV = 0x8718,
  eGL_VIBRANCE_BIAS_NV = 0x8719,
  eGL_TEXTURE_BORDER_VALUES_NV = 0x871A,
  eGL_TEXTURE_HI_SIZE_NV = 0x871B,
  eGL_TEXTURE_LO_SIZE_NV = 0x871C,
  eGL_TEXTURE_DS_SIZE_NV = 0x871D,
  eGL_TEXTURE_DT_SIZE_NV = 0x871E,
  eGL_TEXTURE_MAG_SIZE_NV = 0x871F,
  eGL_DOT_PRODUCT_TEXTURE_3D_NV = 0x86EF,
  eGL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = 0x8850,
  eGL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = 0x8851,
  eGL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8852,
  eGL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = 0x8853,
  eGL_OFFSET_HILO_TEXTURE_2D_NV = 0x8854,
  eGL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = 0x8855,
  eGL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = 0x8856,
  eGL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8857,
  eGL_DEPENDENT_HILO_TEXTURE_2D_NV = 0x8858,
  eGL_DEPENDENT_RGB_TEXTURE_3D_NV = 0x8859,
  eGL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = 0x885A,
  eGL_DOT_PRODUCT_PASS_THROUGH_NV = 0x885B,
  eGL_DOT_PRODUCT_TEXTURE_1D_NV = 0x885C,
  eGL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = 0x885D,
  eGL_HILO8_NV = 0x885E,
  eGL_SIGNED_HILO8_NV = 0x885F,
  eGL_FORCE_BLUE_TO_ONE_NV = 0x8860,
  eGL_BACK_PRIMARY_COLOR_NV = 0x8C77,
  eGL_BACK_SECONDARY_COLOR_NV = 0x8C78,
  eGL_TEXTURE_COORD_NV = 0x8C79,
  eGL_CLIP_DISTANCE_NV = 0x8C7A,
  eGL_VERTEX_ID_NV = 0x8C7B,
  eGL_PRIMITIVE_ID_NV = 0x8C7C,
  eGL_GENERIC_ATTRIB_NV = 0x8C7D,
  eGL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 0x8C7E,
  eGL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 0x8C7F,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 0x8C80,
  eGL_ACTIVE_VARYINGS_NV = 0x8C81,
  eGL_ACTIVE_VARYING_MAX_LENGTH_NV = 0x8C82,
  eGL_TRANSFORM_FEEDBACK_VARYINGS_NV = 0x8C83,
  eGL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 0x8C84,
  eGL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 0x8C85,
  eGL_TRANSFORM_FEEDBACK_RECORD_NV = 0x8C86,
  eGL_PRIMITIVES_GENERATED_NV = 0x8C87,
  eGL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 0x8C88,
  eGL_RASTERIZER_DISCARD_NV = 0x8C89,
  eGL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 0x8C8A,
  eGL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 0x8C8B,
  eGL_INTERLEAVED_ATTRIBS_NV = 0x8C8C,
  eGL_SEPARATE_ATTRIBS_NV = 0x8C8D,
  eGL_TRANSFORM_FEEDBACK_BUFFER_NV = 0x8C8E,
  eGL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 0x8C8F,
  eGL_LAYER_NV = 0x8DAA,
  eGL_TRANSFORM_FEEDBACK_NV = 0x8E22,
  eGL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV = 0x8E23,
  eGL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV = 0x8E24,
  eGL_TRANSFORM_FEEDBACK_BINDING_NV = 0x8E25,
  eGL_SURFACE_STATE_NV = 0x86EB,
  eGL_SURFACE_REGISTERED_NV = 0x86FD,
  eGL_SURFACE_MAPPED_NV = 0x8700,
  eGL_WRITE_DISCARD_NV = 0x88BE,
  eGL_VERTEX_ARRAY_RANGE_NV = 0x851D,
  eGL_VERTEX_ARRAY_RANGE_LENGTH_NV = 0x851E,
  eGL_VERTEX_ARRAY_RANGE_VALID_NV = 0x851F,
  eGL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 0x8520,
  eGL_VERTEX_ARRAY_RANGE_POINTER_NV = 0x8521,
  eGL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = 0x8533,
  eGL_VERTEX_PROGRAM_NV = 0x8620,
  eGL_VERTEX_STATE_PROGRAM_NV = 0x8621,
  eGL_ATTRIB_ARRAY_SIZE_NV = 0x8623,
  eGL_ATTRIB_ARRAY_STRIDE_NV = 0x8624,
  eGL_ATTRIB_ARRAY_TYPE_NV = 0x8625,
  eGL_CURRENT_ATTRIB_NV = 0x8626,
  eGL_PROGRAM_LENGTH_NV = 0x8627,
  eGL_PROGRAM_STRING_NV = 0x8628,
  eGL_MODELVIEW_PROJECTION_NV = 0x8629,
  eGL_IDENTITY_NV = 0x862A,
  eGL_INVERSE_NV = 0x862B,
  eGL_TRANSPOSE_NV = 0x862C,
  eGL_INVERSE_TRANSPOSE_NV = 0x862D,
  eGL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = 0x862E,
  eGL_MAX_TRACK_MATRICES_NV = 0x862F,
  eGL_MATRIX0_NV = 0x8630,
  eGL_MATRIX1_NV = 0x8631,
  eGL_MATRIX2_NV = 0x8632,
  eGL_MATRIX3_NV = 0x8633,
  eGL_MATRIX4_NV = 0x8634,
  eGL_MATRIX5_NV = 0x8635,
  eGL_MATRIX6_NV = 0x8636,
  eGL_MATRIX7_NV = 0x8637,
  eGL_CURRENT_MATRIX_STACK_DEPTH_NV = 0x8640,
  eGL_CURRENT_MATRIX_NV = 0x8641,
  eGL_VERTEX_PROGRAM_POINT_SIZE_NV = 0x8642,
  eGL_VERTEX_PROGRAM_TWO_SIDE_NV = 0x8643,
  eGL_PROGRAM_PARAMETER_NV = 0x8644,
  eGL_ATTRIB_ARRAY_POINTER_NV = 0x8645,
  eGL_PROGRAM_TARGET_NV = 0x8646,
  eGL_PROGRAM_RESIDENT_NV = 0x8647,
  eGL_TRACK_MATRIX_NV = 0x8648,
  eGL_TRACK_MATRIX_TRANSFORM_NV = 0x8649,
  eGL_VERTEX_PROGRAM_BINDING_NV = 0x864A,
  eGL_PROGRAM_ERROR_POSITION_NV = 0x864B,
  eGL_VERTEX_ATTRIB_ARRAY0_NV = 0x8650,
  eGL_VERTEX_ATTRIB_ARRAY1_NV = 0x8651,
  eGL_VERTEX_ATTRIB_ARRAY2_NV = 0x8652,
  eGL_VERTEX_ATTRIB_ARRAY3_NV = 0x8653,
  eGL_VERTEX_ATTRIB_ARRAY4_NV = 0x8654,
  eGL_VERTEX_ATTRIB_ARRAY5_NV = 0x8655,
  eGL_VERTEX_ATTRIB_ARRAY6_NV = 0x8656,
  eGL_VERTEX_ATTRIB_ARRAY7_NV = 0x8657,
  eGL_VERTEX_ATTRIB_ARRAY8_NV = 0x8658,
  eGL_VERTEX_ATTRIB_ARRAY9_NV = 0x8659,
  eGL_VERTEX_ATTRIB_ARRAY10_NV = 0x865A,
  eGL_VERTEX_ATTRIB_ARRAY11_NV = 0x865B,
  eGL_VERTEX_ATTRIB_ARRAY12_NV = 0x865C,
  eGL_VERTEX_ATTRIB_ARRAY13_NV = 0x865D,
  eGL_VERTEX_ATTRIB_ARRAY14_NV = 0x865E,
  eGL_VERTEX_ATTRIB_ARRAY15_NV = 0x865F,
  eGL_MAP1_VERTEX_ATTRIB0_4_NV = 0x8660,
  eGL_MAP1_VERTEX_ATTRIB1_4_NV = 0x8661,
  eGL_MAP1_VERTEX_ATTRIB2_4_NV = 0x8662,
  eGL_MAP1_VERTEX_ATTRIB3_4_NV = 0x8663,
  eGL_MAP1_VERTEX_ATTRIB4_4_NV = 0x8664,
  eGL_MAP1_VERTEX_ATTRIB5_4_NV = 0x8665,
  eGL_MAP1_VERTEX_ATTRIB6_4_NV = 0x8666,
  eGL_MAP1_VERTEX_ATTRIB7_4_NV = 0x8667,
  eGL_MAP1_VERTEX_ATTRIB8_4_NV = 0x8668,
  eGL_MAP1_VERTEX_ATTRIB9_4_NV = 0x8669,
  eGL_MAP1_VERTEX_ATTRIB10_4_NV = 0x866A,
  eGL_MAP1_VERTEX_ATTRIB11_4_NV = 0x866B,
  eGL_MAP1_VERTEX_ATTRIB12_4_NV = 0x866C,
  eGL_MAP1_VERTEX_ATTRIB13_4_NV = 0x866D,
  eGL_MAP1_VERTEX_ATTRIB14_4_NV = 0x866E,
  eGL_MAP1_VERTEX_ATTRIB15_4_NV = 0x866F,
  eGL_MAP2_VERTEX_ATTRIB0_4_NV = 0x8670,
  eGL_MAP2_VERTEX_ATTRIB1_4_NV = 0x8671,
  eGL_MAP2_VERTEX_ATTRIB2_4_NV = 0x8672,
  eGL_MAP2_VERTEX_ATTRIB3_4_NV = 0x8673,
  eGL_MAP2_VERTEX_ATTRIB4_4_NV = 0x8674,
  eGL_MAP2_VERTEX_ATTRIB5_4_NV = 0x8675,
  eGL_MAP2_VERTEX_ATTRIB6_4_NV = 0x8676,
  eGL_MAP2_VERTEX_ATTRIB7_4_NV = 0x8677,
  eGL_MAP2_VERTEX_ATTRIB8_4_NV = 0x8678,
  eGL_MAP2_VERTEX_ATTRIB9_4_NV = 0x8679,
  eGL_MAP2_VERTEX_ATTRIB10_4_NV = 0x867A,
  eGL_MAP2_VERTEX_ATTRIB11_4_NV = 0x867B,
  eGL_MAP2_VERTEX_ATTRIB12_4_NV = 0x867C,
  eGL_MAP2_VERTEX_ATTRIB13_4_NV = 0x867D,
  eGL_MAP2_VERTEX_ATTRIB14_4_NV = 0x867E,
  eGL_MAP2_VERTEX_ATTRIB15_4_NV = 0x867F,
  eGL_VERTEX_ATTRIB_ARRAY_INTEGER_NV = 0x88FD,
  eGL_VIDEO_BUFFER_NV = 0x9020,
  eGL_VIDEO_BUFFER_BINDING_NV = 0x9021,
  eGL_FIELD_UPPER_NV = 0x9022,
  eGL_FIELD_LOWER_NV = 0x9023,
  eGL_NUM_VIDEO_CAPTURE_STREAMS_NV = 0x9024,
  eGL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = 0x9025,
  eGL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = 0x9026,
  eGL_LAST_VIDEO_CAPTURE_STATUS_NV = 0x9027,
  eGL_VIDEO_BUFFER_PITCH_NV = 0x9028,
  eGL_VIDEO_COLOR_CONVERSION_MATRIX_NV = 0x9029,
  eGL_VIDEO_COLOR_CONVERSION_MAX_NV = 0x902A,
  eGL_VIDEO_COLOR_CONVERSION_MIN_NV = 0x902B,
  eGL_VIDEO_COLOR_CONVERSION_OFFSET_NV = 0x902C,
  eGL_VIDEO_BUFFER_INTERNAL_FORMAT_NV = 0x902D,
  eGL_PARTIAL_SUCCESS_NV = 0x902E,
  eGL_SUCCESS_NV = 0x902F,
  eGL_FAILURE_NV = 0x9030,
  eGL_YCBYCR8_422_NV = 0x9031,
  eGL_YCBAYCR8A_4224_NV = 0x9032,
  eGL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = 0x9033,
  eGL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = 0x9034,
  eGL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = 0x9035,
  eGL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = 0x9036,
  eGL_Z4Y12Z4CB12Z4CR12_444_NV = 0x9037,
  eGL_VIDEO_CAPTURE_FRAME_WIDTH_NV = 0x9038,
  eGL_VIDEO_CAPTURE_FRAME_HEIGHT_NV = 0x9039,
  eGL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = 0x903A,
  eGL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = 0x903B,
  eGL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = 0x903C,
  eGL_INTERLACE_OML = 0x8980,
  eGL_INTERLACE_READ_OML = 0x8981,
  eGL_PACK_RESAMPLE_OML = 0x8984,
  eGL_UNPACK_RESAMPLE_OML = 0x8985,
  eGL_RESAMPLE_REPLICATE_OML = 0x8986,
  eGL_RESAMPLE_ZERO_FILL_OML = 0x8987,
  eGL_RESAMPLE_AVERAGE_OML = 0x8988,
  eGL_RESAMPLE_DECIMATE_OML = 0x8989,
  eGL_FORMAT_SUBSAMPLE_24_24_OML = 0x8982,
  eGL_FORMAT_SUBSAMPLE_244_244_OML = 0x8983,
  eGL_PREFER_DOUBLEBUFFER_HINT_PGI = 0x1A1F8,
  eGL_CONSERVE_MEMORY_HINT_PGI = 0x1A1FD,
  eGL_RECLAIM_MEMORY_HINT_PGI = 0x1A1FE,
  eGL_NATIVE_GRAPHICS_HANDLE_PGI = 0x1A202,
  eGL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = 0x1A203,
  eGL_NATIVE_GRAPHICS_END_HINT_PGI = 0x1A204,
  eGL_ALWAYS_FAST_HINT_PGI = 0x1A20C,
  eGL_ALWAYS_SOFT_HINT_PGI = 0x1A20D,
  eGL_ALLOW_DRAW_OBJ_HINT_PGI = 0x1A20E,
  eGL_ALLOW_DRAW_WIN_HINT_PGI = 0x1A20F,
  eGL_ALLOW_DRAW_FRG_HINT_PGI = 0x1A210,
  eGL_ALLOW_DRAW_MEM_HINT_PGI = 0x1A211,
  eGL_STRICT_DEPTHFUNC_HINT_PGI = 0x1A216,
  eGL_STRICT_LIGHTING_HINT_PGI = 0x1A217,
  eGL_STRICT_SCISSOR_HINT_PGI = 0x1A218,
  eGL_FULL_STIPPLE_HINT_PGI = 0x1A219,
  eGL_CLIP_NEAR_HINT_PGI = 0x1A220,
  eGL_CLIP_FAR_HINT_PGI = 0x1A221,
  eGL_WIDE_LINE_HINT_PGI = 0x1A222,
  eGL_BACK_NORMALS_HINT_PGI = 0x1A223,
  eGL_VERTEX_DATA_HINT_PGI = 0x1A22A,
  eGL_VERTEX_CONSISTENT_HINT_PGI = 0x1A22B,
  eGL_MATERIAL_SIDE_HINT_PGI = 0x1A22C,
  eGL_MAX_VERTEX_HINT_PGI = 0x1A22D,
  eGL_COLOR3_BIT_PGI = 0x00010000,
  eGL_COLOR4_BIT_PGI = 0x00020000,
  eGL_EDGEFLAG_BIT_PGI = 0x00040000,
  eGL_INDEX_BIT_PGI = 0x00080000,
  eGL_MAT_AMBIENT_BIT_PGI = 0x00100000,
  eGL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = 0x00200000,
  eGL_MAT_DIFFUSE_BIT_PGI = 0x00400000,
  eGL_MAT_EMISSION_BIT_PGI = 0x00800000,
  eGL_MAT_COLOR_INDEXES_BIT_PGI = 0x01000000,
  eGL_MAT_SHININESS_BIT_PGI = 0x02000000,
  eGL_MAT_SPECULAR_BIT_PGI = 0x04000000,
  eGL_NORMAL_BIT_PGI = 0x08000000,
  eGL_TEXCOORD1_BIT_PGI = 0x10000000,
  eGL_TEXCOORD2_BIT_PGI = 0x20000000,
  eGL_TEXCOORD3_BIT_PGI = 0x40000000,
  eGL_TEXCOORD4_BIT_PGI = 0x80000000,
  eGL_VERTEX23_BIT_PGI = 0x00000004,
  eGL_VERTEX4_BIT_PGI = 0x00000008,
  eGL_SCREEN_COORDINATES_REND = 0x8490,
  eGL_INVERTED_SCREEN_W_REND = 0x8491,
  eGL_RGB_S3TC = 0x83A0,
  eGL_RGB4_S3TC = 0x83A1,
  eGL_RGBA_S3TC = 0x83A2,
  eGL_RGBA4_S3TC = 0x83A3,
  eGL_RGBA_DXT5_S3TC = 0x83A4,
  eGL_RGBA4_DXT5_S3TC = 0x83A5,
  eGL_DETAIL_TEXTURE_2D_SGIS = 0x8095,
  eGL_DETAIL_TEXTURE_2D_BINDING_SGIS = 0x8096,
  eGL_LINEAR_DETAIL_SGIS = 0x8097,
  eGL_LINEAR_DETAIL_ALPHA_SGIS = 0x8098,
  eGL_LINEAR_DETAIL_COLOR_SGIS = 0x8099,
  eGL_DETAIL_TEXTURE_LEVEL_SGIS = 0x809A,
  eGL_DETAIL_TEXTURE_MODE_SGIS = 0x809B,
  eGL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = 0x809C,
  eGL_FOG_FUNC_SGIS = 0x812A,
  eGL_FOG_FUNC_POINTS_SGIS = 0x812B,
  eGL_MAX_FOG_FUNC_POINTS_SGIS = 0x812C,
  eGL_GENERATE_MIPMAP_SGIS = 0x8191,
  eGL_GENERATE_MIPMAP_HINT_SGIS = 0x8192,
  eGL_MULTISAMPLE_SGIS = 0x809D,
  eGL_SAMPLE_ALPHA_TO_MASK_SGIS = 0x809E,
  eGL_SAMPLE_ALPHA_TO_ONE_SGIS = 0x809F,
  eGL_SAMPLE_MASK_SGIS = 0x80A0,
  eGL_1PASS_SGIS = 0x80A1,
  eGL_2PASS_0_SGIS = 0x80A2,
  eGL_2PASS_1_SGIS = 0x80A3,
  eGL_4PASS_0_SGIS = 0x80A4,
  eGL_4PASS_1_SGIS = 0x80A5,
  eGL_4PASS_2_SGIS = 0x80A6,
  eGL_4PASS_3_SGIS = 0x80A7,
  eGL_SAMPLE_BUFFERS_SGIS = 0x80A8,
  eGL_SAMPLES_SGIS = 0x80A9,
  eGL_SAMPLE_MASK_VALUE_SGIS = 0x80AA,
  eGL_SAMPLE_MASK_INVERT_SGIS = 0x80AB,
  eGL_SAMPLE_PATTERN_SGIS = 0x80AC,
  eGL_PIXEL_TEXTURE_SGIS = 0x8353,
  eGL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = 0x8354,
  eGL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = 0x8355,
  eGL_PIXEL_GROUP_COLOR_SGIS = 0x8356,
  eGL_EYE_DISTANCE_TO_POINT_SGIS = 0x81F0,
  eGL_OBJECT_DISTANCE_TO_POINT_SGIS = 0x81F1,
  eGL_EYE_DISTANCE_TO_LINE_SGIS = 0x81F2,
  eGL_OBJECT_DISTANCE_TO_LINE_SGIS = 0x81F3,
  eGL_EYE_POINT_SGIS = 0x81F4,
  eGL_OBJECT_POINT_SGIS = 0x81F5,
  eGL_EYE_LINE_SGIS = 0x81F6,
  eGL_OBJECT_LINE_SGIS = 0x81F7,
  eGL_POINT_SIZE_MIN_SGIS = 0x8126,
  eGL_POINT_SIZE_MAX_SGIS = 0x8127,
  eGL_POINT_FADE_THRESHOLD_SIZE_SGIS = 0x8128,
  eGL_DISTANCE_ATTENUATION_SGIS = 0x8129,
  eGL_LINEAR_SHARPEN_SGIS = 0x80AD,
  eGL_LINEAR_SHARPEN_ALPHA_SGIS = 0x80AE,
  eGL_LINEAR_SHARPEN_COLOR_SGIS = 0x80AF,
  eGL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = 0x80B0,
  eGL_PACK_SKIP_VOLUMES_SGIS = 0x8130,
  eGL_PACK_IMAGE_DEPTH_SGIS = 0x8131,
  eGL_UNPACK_SKIP_VOLUMES_SGIS = 0x8132,
  eGL_UNPACK_IMAGE_DEPTH_SGIS = 0x8133,
  eGL_TEXTURE_4D_SGIS = 0x8134,
  eGL_PROXY_TEXTURE_4D_SGIS = 0x8135,
  eGL_TEXTURE_4DSIZE_SGIS = 0x8136,
  eGL_TEXTURE_WRAP_Q_SGIS = 0x8137,
  eGL_MAX_4D_TEXTURE_SIZE_SGIS = 0x8138,
  eGL_TEXTURE_4D_BINDING_SGIS = 0x814F,
  eGL_CLAMP_TO_BORDER_SGIS = 0x812D,
  eGL_TEXTURE_COLOR_WRITEMASK_SGIS = 0x81EF,
  eGL_CLAMP_TO_EDGE_SGIS = 0x812F,
  eGL_FILTER4_SGIS = 0x8146,
  eGL_TEXTURE_FILTER4_SIZE_SGIS = 0x8147,
  eGL_TEXTURE_MIN_LOD_SGIS = 0x813A,
  eGL_TEXTURE_MAX_LOD_SGIS = 0x813B,
  eGL_TEXTURE_BASE_LEVEL_SGIS = 0x813C,
  eGL_TEXTURE_MAX_LEVEL_SGIS = 0x813D,
  eGL_DUAL_ALPHA4_SGIS = 0x8110,
  eGL_DUAL_ALPHA8_SGIS = 0x8111,
  eGL_DUAL_ALPHA12_SGIS = 0x8112,
  eGL_DUAL_ALPHA16_SGIS = 0x8113,
  eGL_DUAL_LUMINANCE4_SGIS = 0x8114,
  eGL_DUAL_LUMINANCE8_SGIS = 0x8115,
  eGL_DUAL_LUMINANCE12_SGIS = 0x8116,
  eGL_DUAL_LUMINANCE16_SGIS = 0x8117,
  eGL_DUAL_INTENSITY4_SGIS = 0x8118,
  eGL_DUAL_INTENSITY8_SGIS = 0x8119,
  eGL_DUAL_INTENSITY12_SGIS = 0x811A,
  eGL_DUAL_INTENSITY16_SGIS = 0x811B,
  eGL_DUAL_LUMINANCE_ALPHA4_SGIS = 0x811C,
  eGL_DUAL_LUMINANCE_ALPHA8_SGIS = 0x811D,
  eGL_QUAD_ALPHA4_SGIS = 0x811E,
  eGL_QUAD_ALPHA8_SGIS = 0x811F,
  eGL_QUAD_LUMINANCE4_SGIS = 0x8120,
  eGL_QUAD_LUMINANCE8_SGIS = 0x8121,
  eGL_QUAD_INTENSITY4_SGIS = 0x8122,
  eGL_QUAD_INTENSITY8_SGIS = 0x8123,
  eGL_DUAL_TEXTURE_SELECT_SGIS = 0x8124,
  eGL_QUAD_TEXTURE_SELECT_SGIS = 0x8125,
  eGL_ASYNC_MARKER_SGIX = 0x8329,
  eGL_ASYNC_HISTOGRAM_SGIX = 0x832C,
  eGL_MAX_ASYNC_HISTOGRAM_SGIX = 0x832D,
  eGL_ASYNC_TEX_IMAGE_SGIX = 0x835C,
  eGL_ASYNC_DRAW_PIXELS_SGIX = 0x835D,
  eGL_ASYNC_READ_PIXELS_SGIX = 0x835E,
  eGL_MAX_ASYNC_TEX_IMAGE_SGIX = 0x835F,
  eGL_MAX_ASYNC_DRAW_PIXELS_SGIX = 0x8360,
  eGL_MAX_ASYNC_READ_PIXELS_SGIX = 0x8361,
  eGL_ALPHA_MIN_SGIX = 0x8320,
  eGL_ALPHA_MAX_SGIX = 0x8321,
  eGL_CALLIGRAPHIC_FRAGMENT_SGIX = 0x8183,
  eGL_LINEAR_CLIPMAP_LINEAR_SGIX = 0x8170,
  eGL_TEXTURE_CLIPMAP_CENTER_SGIX = 0x8171,
  eGL_TEXTURE_CLIPMAP_FRAME_SGIX = 0x8172,
  eGL_TEXTURE_CLIPMAP_OFFSET_SGIX = 0x8173,
  eGL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8174,
  eGL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = 0x8175,
  eGL_TEXTURE_CLIPMAP_DEPTH_SGIX = 0x8176,
  eGL_MAX_CLIPMAP_DEPTH_SGIX = 0x8177,
  eGL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8178,
  eGL_NEAREST_CLIPMAP_NEAREST_SGIX = 0x844D,
  eGL_NEAREST_CLIPMAP_LINEAR_SGIX = 0x844E,
  eGL_LINEAR_CLIPMAP_NEAREST_SGIX = 0x844F,
  eGL_CONVOLUTION_HINT_SGIX = 0x8316,
  eGL_DEPTH_COMPONENT16_SGIX = 0x81A5,
  eGL_DEPTH_COMPONENT24_SGIX = 0x81A6,
  eGL_DEPTH_COMPONENT32_SGIX = 0x81A7,
  eGL_FOG_OFFSET_SGIX = 0x8198,
  eGL_FOG_OFFSET_VALUE_SGIX = 0x8199,
  eGL_FRAGMENT_LIGHTING_SGIX = 0x8400,
  eGL_FRAGMENT_COLOR_MATERIAL_SGIX = 0x8401,
  eGL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = 0x8402,
  eGL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = 0x8403,
  eGL_MAX_FRAGMENT_LIGHTS_SGIX = 0x8404,
  eGL_MAX_ACTIVE_LIGHTS_SGIX = 0x8405,
  eGL_CURRENT_RASTER_NORMAL_SGIX = 0x8406,
  eGL_LIGHT_ENV_MODE_SGIX = 0x8407,
  eGL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = 0x8408,
  eGL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = 0x8409,
  eGL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = 0x840A,
  eGL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = 0x840B,
  eGL_FRAGMENT_LIGHT0_SGIX = 0x840C,
  eGL_FRAGMENT_LIGHT1_SGIX = 0x840D,
  eGL_FRAGMENT_LIGHT2_SGIX = 0x840E,
  eGL_FRAGMENT_LIGHT3_SGIX = 0x840F,
  eGL_FRAGMENT_LIGHT4_SGIX = 0x8410,
  eGL_FRAGMENT_LIGHT5_SGIX = 0x8411,
  eGL_FRAGMENT_LIGHT6_SGIX = 0x8412,
  eGL_FRAGMENT_LIGHT7_SGIX = 0x8413,
  eGL_FRAMEZOOM_SGIX = 0x818B,
  eGL_FRAMEZOOM_FACTOR_SGIX = 0x818C,
  eGL_MAX_FRAMEZOOM_FACTOR_SGIX = 0x818D,
  eGL_INSTRUMENT_BUFFER_POINTER_SGIX = 0x8180,
  eGL_INSTRUMENT_MEASUREMENTS_SGIX = 0x8181,
  eGL_INTERLACE_SGIX = 0x8094,
  eGL_IR_INSTRUMENT1_SGIX = 0x817F,
  eGL_LIST_PRIORITY_SGIX = 0x8182,
  eGL_PIXEL_TEX_GEN_SGIX = 0x8139,
  eGL_PIXEL_TEX_GEN_MODE_SGIX = 0x832B,
  eGL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = 0x813E,
  eGL_PIXEL_TILE_CACHE_INCREMENT_SGIX = 0x813F,
  eGL_PIXEL_TILE_WIDTH_SGIX = 0x8140,
  eGL_PIXEL_TILE_HEIGHT_SGIX = 0x8141,
  eGL_PIXEL_TILE_GRID_WIDTH_SGIX = 0x8142,
  eGL_PIXEL_TILE_GRID_HEIGHT_SGIX = 0x8143,
  eGL_PIXEL_TILE_GRID_DEPTH_SGIX = 0x8144,
  eGL_PIXEL_TILE_CACHE_SIZE_SGIX = 0x8145,
  eGL_TEXTURE_DEFORMATION_BIT_SGIX = 0x00000001,
  eGL_GEOMETRY_DEFORMATION_BIT_SGIX = 0x00000002,
  eGL_GEOMETRY_DEFORMATION_SGIX = 0x8194,
  eGL_TEXTURE_DEFORMATION_SGIX = 0x8195,
  eGL_DEFORMATIONS_MASK_SGIX = 0x8196,
  eGL_MAX_DEFORMATION_ORDER_SGIX = 0x8197,
  eGL_REFERENCE_PLANE_SGIX = 0x817D,
  eGL_REFERENCE_PLANE_EQUATION_SGIX = 0x817E,
  eGL_PACK_RESAMPLE_SGIX = 0x842E,
  eGL_UNPACK_RESAMPLE_SGIX = 0x842F,
  eGL_RESAMPLE_REPLICATE_SGIX = 0x8433,
  eGL_RESAMPLE_ZERO_FILL_SGIX = 0x8434,
  eGL_RESAMPLE_DECIMATE_SGIX = 0x8430,
  eGL_SCALEBIAS_HINT_SGIX = 0x8322,
  eGL_TEXTURE_COMPARE_SGIX = 0x819A,
  eGL_TEXTURE_COMPARE_OPERATOR_SGIX = 0x819B,
  eGL_TEXTURE_LEQUAL_R_SGIX = 0x819C,
  eGL_TEXTURE_GEQUAL_R_SGIX = 0x819D,
  eGL_SHADOW_AMBIENT_SGIX = 0x80BF,
  eGL_SPRITE_SGIX = 0x8148,
  eGL_SPRITE_MODE_SGIX = 0x8149,
  eGL_SPRITE_AXIS_SGIX = 0x814A,
  eGL_SPRITE_TRANSLATION_SGIX = 0x814B,
  eGL_SPRITE_AXIAL_SGIX = 0x814C,
  eGL_SPRITE_OBJECT_ALIGNED_SGIX = 0x814D,
  eGL_SPRITE_EYE_ALIGNED_SGIX = 0x814E,
  eGL_PACK_SUBSAMPLE_RATE_SGIX = 0x85A0,
  eGL_UNPACK_SUBSAMPLE_RATE_SGIX = 0x85A1,
  eGL_PIXEL_SUBSAMPLE_4444_SGIX = 0x85A2,
  eGL_PIXEL_SUBSAMPLE_2424_SGIX = 0x85A3,
  eGL_PIXEL_SUBSAMPLE_4242_SGIX = 0x85A4,
  eGL_TEXTURE_ENV_BIAS_SGIX = 0x80BE,
  eGL_TEXTURE_MAX_CLAMP_S_SGIX = 0x8369,
  eGL_TEXTURE_MAX_CLAMP_T_SGIX = 0x836A,
  eGL_TEXTURE_MAX_CLAMP_R_SGIX = 0x836B,
  eGL_TEXTURE_LOD_BIAS_S_SGIX = 0x818E,
  eGL_TEXTURE_LOD_BIAS_T_SGIX = 0x818F,
  eGL_TEXTURE_LOD_BIAS_R_SGIX = 0x8190,
  eGL_TEXTURE_MULTI_BUFFER_HINT_SGIX = 0x812E,
  eGL_POST_TEXTURE_FILTER_BIAS_SGIX = 0x8179,
  eGL_POST_TEXTURE_FILTER_SCALE_SGIX = 0x817A,
  eGL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = 0x817B,
  eGL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = 0x817C,
  eGL_VERTEX_PRECLIP_SGIX = 0x83EE,
  eGL_VERTEX_PRECLIP_HINT_SGIX = 0x83EF,
  eGL_YCRCB_422_SGIX = 0x81BB,
  eGL_YCRCB_444_SGIX = 0x81BC,
  eGL_YCRCB_SGIX = 0x8318,
  eGL_YCRCBA_SGIX = 0x8319,
  eGL_COLOR_MATRIX_SGI = 0x80B1,
  eGL_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B2,
  eGL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B3,
  eGL_POST_COLOR_MATRIX_RED_SCALE_SGI = 0x80B4,
  eGL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = 0x80B5,
  eGL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = 0x80B6,
  eGL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = 0x80B7,
  eGL_POST_COLOR_MATRIX_RED_BIAS_SGI = 0x80B8,
  eGL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = 0x80B9,
  eGL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = 0x80BA,
  eGL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = 0x80BB,
  eGL_COLOR_TABLE_SGI = 0x80D0,
  eGL_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D1,
  eGL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D2,
  eGL_PROXY_COLOR_TABLE_SGI = 0x80D3,
  eGL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D4,
  eGL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D5,
  eGL_COLOR_TABLE_SCALE_SGI = 0x80D6,
  eGL_COLOR_TABLE_BIAS_SGI = 0x80D7,
  eGL_COLOR_TABLE_FORMAT_SGI = 0x80D8,
  eGL_COLOR_TABLE_WIDTH_SGI = 0x80D9,
  eGL_COLOR_TABLE_RED_SIZE_SGI = 0x80DA,
  eGL_COLOR_TABLE_GREEN_SIZE_SGI = 0x80DB,
  eGL_COLOR_TABLE_BLUE_SIZE_SGI = 0x80DC,
  eGL_COLOR_TABLE_ALPHA_SIZE_SGI = 0x80DD,
  eGL_COLOR_TABLE_LUMINANCE_SIZE_SGI = 0x80DE,
  eGL_COLOR_TABLE_INTENSITY_SIZE_SGI = 0x80DF,
  eGL_TEXTURE_COLOR_TABLE_SGI = 0x80BC,
  eGL_PROXY_TEXTURE_COLOR_TABLE_SGI = 0x80BD,
  eGL_UNPACK_CONSTANT_DATA_SUNX = 0x81D5,
  eGL_TEXTURE_CONSTANT_DATA_SUNX = 0x81D6,
  eGL_WRAP_BORDER_SUN = 0x81D4,
  eGL_GLOBAL_ALPHA_SUN = 0x81D9,
  eGL_GLOBAL_ALPHA_FACTOR_SUN = 0x81DA,
  eGL_QUAD_MESH_SUN = 0x8614,
  eGL_TRIANGLE_MESH_SUN = 0x8615,
  eGL_SLICE_ACCUM_SUN = 0x85CC,
  eGL_RESTART_SUN = 0x0001,
  eGL_REPLACE_MIDDLE_SUN = 0x0002,
  eGL_REPLACE_OLDEST_SUN = 0x0003,
  eGL_TRIANGLE_LIST_SUN = 0x81D7,
  eGL_REPLACEMENT_CODE_SUN = 0x81D8,
  eGL_REPLACEMENT_CODE_ARRAY_SUN = 0x85C0,
  eGL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = 0x85C1,
  eGL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = 0x85C2,
  eGL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = 0x85C3,
  eGL_R1UI_V3F_SUN = 0x85C4,
  eGL_R1UI_C4UB_V3F_SUN = 0x85C5,
  eGL_R1UI_C3F_V3F_SUN = 0x85C6,
  eGL_R1UI_N3F_V3F_SUN = 0x85C7,
  eGL_R1UI_C4F_N3F_V3F_SUN = 0x85C8,
  eGL_R1UI_T2F_V3F_SUN = 0x85C9,
  eGL_R1UI_T2F_N3F_V3F_SUN = 0x85CA,
  eGL_R1UI_T2F_C4F_N3F_V3F_SUN = 0x85CB,
  eGL_PHONG_WIN = 0x80EA,
  eGL_PHONG_HINT_WIN = 0x80EB,
  eGL_FOG_SPECULAR_TEXTURE_WIN = 0x80EC,
  eGLX_WINDOW_BIT = 0x00000001,
  eGLX_PIXMAP_BIT = 0x00000002,
  eGLX_PBUFFER_BIT = 0x00000004,
  eGLX_RGBA_BIT = 0x00000001,
  eGLX_COLOR_INDEX_BIT = 0x00000002,
  eGLX_PBUFFER_CLOBBER_MASK = 0x08000000,
  eGLX_FRONT_LEFT_BUFFER_BIT = 0x00000001,
  eGLX_FRONT_RIGHT_BUFFER_BIT = 0x00000002,
  eGLX_BACK_LEFT_BUFFER_BIT = 0x00000004,
  eGLX_BACK_RIGHT_BUFFER_BIT = 0x00000008,
  eGLX_AUX_BUFFERS_BIT = 0x00000010,
  eGLX_DEPTH_BUFFER_BIT = 0x00000020,
  eGLX_STENCIL_BUFFER_BIT = 0x00000040,
  eGLX_ACCUM_BUFFER_BIT = 0x00000080,
  eGLX_DONT_CARE = 0xFFFFFFFF,
  eGLX_NONE = 0x8000,
  eGLX_SLOW_CONFIG = 0x8001,
  eGLX_TRUE_COLOR = 0x8002,
  eGLX_DIRECT_COLOR = 0x8003,
  eGLX_PSEUDO_COLOR = 0x8004,
  eGLX_STATIC_COLOR = 0x8005,
  eGLX_GRAY_SCALE = 0x8006,
  eGLX_STATIC_GRAY = 0x8007,
  eGLX_TRANSPARENT_RGB = 0x8008,
  eGLX_TRANSPARENT_INDEX = 0x8009,
  eGLX_VISUAL_ID = 0x800B,
  eGLX_SCREEN = 0x800C,
  eGLX_NON_CONFORMANT_CONFIG = 0x800D,
  eGLX_DRAWABLE_TYPE = 0x8010,
  eGLX_RENDER_TYPE = 0x8011,
  eGLX_X_RENDERABLE = 0x8012,
  eGLX_FBCONFIG_ID = 0x8013,
  eGLX_RGBA_TYPE = 0x8014,
  eGLX_COLOR_INDEX_TYPE = 0x8015,
  eGLX_MAX_PBUFFER_WIDTH = 0x8016,
  eGLX_MAX_PBUFFER_HEIGHT = 0x8017,
  eGLX_MAX_PBUFFER_PIXELS = 0x8018,
  eGLX_PRESERVED_CONTENTS = 0x801B,
  eGLX_LARGEST_PBUFFER = 0x801C,
  eGLX_WIDTH = 0x801D,
  eGLX_HEIGHT = 0x801E,
  eGLX_EVENT_MASK = 0x801F,
  eGLX_DAMAGED = 0x8020,
  eGLX_SAVED = 0x8021,
  eGLX_WINDOW = 0x8022,
  eGLX_PBUFFER = 0x8023,
  eGLX_PBUFFER_HEIGHT = 0x8040,
  eGLX_PBUFFER_WIDTH = 0x8041,
  eGLX_CONTEXT_RELEASE_BEHAVIOR_ARB = 0x2097,
  eGLX_CONTEXT_RELEASE_BEHAVIOR_FLUSH_ARB = 0x2098,
  eGLX_CONTEXT_DEBUG_BIT_ARB = 0x00000001,
  eGLX_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 0x00000002,
  eGLX_CONTEXT_MAJOR_VERSION_ARB = 0x2091,
  eGLX_CONTEXT_MINOR_VERSION_ARB = 0x2092,
  eGLX_CONTEXT_FLAGS_ARB = 0x2094,
  eGLX_CONTEXT_OPENGL_NO_ERROR_ARB = 0x31B3,
  eGLX_CONTEXT_CORE_PROFILE_BIT_ARB = 0x00000001,
  eGLX_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB = 0x00000002,
  eGLX_CONTEXT_PROFILE_MASK_ARB = 0x9126,
  eGLX_CONTEXT_ROBUST_ACCESS_BIT_ARB = 0x00000004,
  eGLX_LOSE_CONTEXT_ON_RESET_ARB = 0x8252,
  eGLX_CONTEXT_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256,
  eGLX_NO_RESET_NOTIFICATION_ARB = 0x8261,
  eGLX_RGBA_FLOAT_TYPE_ARB = 0x20B9,
  eGLX_RGBA_FLOAT_BIT_ARB = 0x00000004,
  eGLX_FRAMEBUFFER_SRGB_CAPABLE_ARB = 0x20B2,
  eGLX_CONTEXT_RESET_ISOLATION_BIT_ARB = 0x00000008,
  eGLX_CONTEXT_ALLOW_BUFFER_BYTE_ORDER_MISMATCH_ARB = 0x2095,
  eGLX_SAMPLE_BUFFERS_3DFX = 0x8050,
  eGLX_SAMPLES_3DFX = 0x8051,
  eGLX_GPU_VENDOR_AMD = 0x1F00,
  eGLX_GPU_RENDERER_STRING_AMD = 0x1F01,
  eGLX_GPU_OPENGL_VERSION_STRING_AMD = 0x1F02,
  eGLX_GPU_FASTEST_TARGET_GPUS_AMD = 0x21A2,
  eGLX_GPU_RAM_AMD = 0x21A3,
  eGLX_GPU_CLOCK_AMD = 0x21A4,
  eGLX_GPU_NUM_PIPES_AMD = 0x21A5,
  eGLX_GPU_NUM_SIMD_AMD = 0x21A6,
  eGLX_GPU_NUM_RB_AMD = 0x21A7,
  eGLX_GPU_NUM_SPI_AMD = 0x21A8,
  eGLX_BACK_BUFFER_AGE_EXT = 0x20F4,
  eGLX_CONTEXT_ES2_PROFILE_BIT_EXT = 0x00000004,
  eGLX_CONTEXT_ES_PROFILE_BIT_EXT = 0x00000004,
  eGLX_RGBA_UNSIGNED_FLOAT_TYPE_EXT = 0x20B1,
  eGLX_RGBA_UNSIGNED_FLOAT_BIT_EXT = 0x00000008,
  eGLX_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x20B2,
  eGLX_SHARE_CONTEXT_EXT = 0x800A,
  eGLX_VISUAL_ID_EXT = 0x800B,
  eGLX_SCREEN_EXT = 0x800C,
  eGLX_VENDOR_NAMES_EXT = 0x20F6,
  eGLX_STEREO_TREE_EXT = 0x20F5,
  eGLX_STEREO_NOTIFY_MASK_EXT = 0x00000001,
  eGLX_STEREO_NOTIFY_EXT = 0x00000000,
  eGLX_SWAP_INTERVAL_EXT = 0x20F1,
  eGLX_MAX_SWAP_INTERVAL_EXT = 0x20F2,
  eGLX_LATE_SWAPS_TEAR_EXT = 0x20F3,
  eGLX_TEXTURE_1D_BIT_EXT = 0x00000001,
  eGLX_TEXTURE_2D_BIT_EXT = 0x00000002,
  eGLX_TEXTURE_RECTANGLE_BIT_EXT = 0x00000004,
  eGLX_BIND_TO_TEXTURE_RGB_EXT = 0x20D0,
  eGLX_BIND_TO_TEXTURE_RGBA_EXT = 0x20D1,
  eGLX_BIND_TO_MIPMAP_TEXTURE_EXT = 0x20D2,
  eGLX_BIND_TO_TEXTURE_TARGETS_EXT = 0x20D3,
  eGLX_Y_INVERTED_EXT = 0x20D4,
  eGLX_TEXTURE_FORMAT_EXT = 0x20D5,
  eGLX_TEXTURE_TARGET_EXT = 0x20D6,
  eGLX_MIPMAP_TEXTURE_EXT = 0x20D7,
  eGLX_TEXTURE_FORMAT_NONE_EXT = 0x20D8,
  eGLX_TEXTURE_FORMAT_RGB_EXT = 0x20D9,
  eGLX_TEXTURE_FORMAT_RGBA_EXT = 0x20DA,
  eGLX_TEXTURE_1D_EXT = 0x20DB,
  eGLX_TEXTURE_2D_EXT = 0x20DC,
  eGLX_TEXTURE_RECTANGLE_EXT = 0x20DD,
  eGLX_FRONT_LEFT_EXT = 0x20DE,
  eGLX_FRONT_RIGHT_EXT = 0x20DF,
  eGLX_BACK_LEFT_EXT = 0x20E0,
  eGLX_BACK_RIGHT_EXT = 0x20E1,
  eGLX_FRONT_EXT = 0x20DE,
  eGLX_BACK_EXT = 0x20E0,
  eGLX_AUX0_EXT = 0x20E2,
  eGLX_AUX1_EXT = 0x20E3,
  eGLX_AUX2_EXT = 0x20E4,
  eGLX_AUX3_EXT = 0x20E5,
  eGLX_AUX4_EXT = 0x20E6,
  eGLX_AUX5_EXT = 0x20E7,
  eGLX_AUX6_EXT = 0x20E8,
  eGLX_AUX7_EXT = 0x20E9,
  eGLX_AUX8_EXT = 0x20EA,
  eGLX_AUX9_EXT = 0x20EB,
  eGLX_NONE_EXT = 0x8000,
  eGLX_TRUE_COLOR_EXT = 0x8002,
  eGLX_DIRECT_COLOR_EXT = 0x8003,
  eGLX_PSEUDO_COLOR_EXT = 0x8004,
  eGLX_STATIC_COLOR_EXT = 0x8005,
  eGLX_GRAY_SCALE_EXT = 0x8006,
  eGLX_STATIC_GRAY_EXT = 0x8007,
  eGLX_TRANSPARENT_RGB_EXT = 0x8008,
  eGLX_TRANSPARENT_INDEX_EXT = 0x8009,
  eGLX_SLOW_VISUAL_EXT = 0x8001,
  eGLX_NON_CONFORMANT_VISUAL_EXT = 0x800D,
  eGLX_BUFFER_SWAP_COMPLETE_INTEL_MASK = 0x04000000,
  eGLX_EXCHANGE_COMPLETE_INTEL = 0x8180,
  eGLX_COPY_COMPLETE_INTEL = 0x8181,
  eGLX_FLIP_COMPLETE_INTEL = 0x8182,
  eGLX_RENDERER_VENDOR_ID_MESA = 0x8183,
  eGLX_RENDERER_DEVICE_ID_MESA = 0x8184,
  eGLX_RENDERER_VERSION_MESA = 0x8185,
  eGLX_RENDERER_ACCELERATED_MESA = 0x8186,
  eGLX_RENDERER_VIDEO_MEMORY_MESA = 0x8187,
  eGLX_RENDERER_UNIFIED_MEMORY_ARCHITECTURE_MESA = 0x8188,
  eGLX_RENDERER_PREFERRED_PROFILE_MESA = 0x8189,
  eGLX_RENDERER_OPENGL_CORE_PROFILE_VERSION_MESA = 0x818A,
  eGLX_RENDERER_OPENGL_COMPATIBILITY_PROFILE_VERSION_MESA = 0x818B,
  eGLX_RENDERER_OPENGL_ES_PROFILE_VERSION_MESA = 0x818C,
  eGLX_RENDERER_OPENGL_ES2_PROFILE_VERSION_MESA = 0x818D,
  eGLX_RENDERER_ID_MESA = 0x818E,
  eGLX_FLOAT_COMPONENTS_NV = 0x20B0,
  eGLX_COLOR_SAMPLES_NV = 0x20B3,
  eGLX_NUM_VIDEO_SLOTS_NV = 0x20F0,
  eGLX_GENERATE_RESET_ON_VIDEO_MEMORY_PURGE_NV = 0x20F7,
  eGLX_DEVICE_ID_NV = 0x20CD,
  eGLX_UNIQUE_ID_NV = 0x20CE,
  eGLX_NUM_VIDEO_CAPTURE_SLOTS_NV = 0x20CF,
  eGLX_VIDEO_OUT_COLOR_NV = 0x20C3,
  eGLX_VIDEO_OUT_ALPHA_NV = 0x20C4,
  eGLX_VIDEO_OUT_DEPTH_NV = 0x20C5,
  eGLX_VIDEO_OUT_COLOR_AND_ALPHA_NV = 0x20C6,
  eGLX_VIDEO_OUT_COLOR_AND_DEPTH_NV = 0x20C7,
  eGLX_VIDEO_OUT_FRAME_NV = 0x20C8,
  eGLX_VIDEO_OUT_FIELD_1_NV = 0x20C9,
  eGLX_VIDEO_OUT_FIELD_2_NV = 0x20CA,
  eGLX_VIDEO_OUT_STACKED_FIELDS_1_2_NV = 0x20CB,
  eGLX_VIDEO_OUT_STACKED_FIELDS_2_1_NV = 0x20CC,
  eGLX_SWAP_METHOD_OML = 0x8060,
  eGLX_SWAP_EXCHANGE_OML = 0x8061,
  eGLX_SWAP_COPY_OML = 0x8062,
  eGLX_SWAP_UNDEFINED_OML = 0x8063,
  eGLX_BLENDED_RGBA_SGIS = 0x8025,
  eGLX_MULTISAMPLE_SUB_RECT_WIDTH_SGIS = 0x8026,
  eGLX_MULTISAMPLE_SUB_RECT_HEIGHT_SGIS = 0x8027,
  eGLX_DIGITAL_MEDIA_PBUFFER_SGIX = 0x8024,
  eGLX_WINDOW_BIT_SGIX = 0x00000001,
  eGLX_PIXMAP_BIT_SGIX = 0x00000002,
  eGLX_RGBA_BIT_SGIX = 0x00000001,
  eGLX_COLOR_INDEX_BIT_SGIX = 0x00000002,
  eGLX_DRAWABLE_TYPE_SGIX = 0x8010,
  eGLX_RENDER_TYPE_SGIX = 0x8011,
  eGLX_X_RENDERABLE_SGIX = 0x8012,
  eGLX_FBCONFIG_ID_SGIX = 0x8013,
  eGLX_RGBA_TYPE_SGIX = 0x8014,
  eGLX_COLOR_INDEX_TYPE_SGIX = 0x8015,
  eGLX_HYPERPIPE_DISPLAY_PIPE_SGIX = 0x00000001,
  eGLX_HYPERPIPE_RENDER_PIPE_SGIX = 0x00000002,
  eGLX_PIPE_RECT_SGIX = 0x00000001,
  eGLX_PIPE_RECT_LIMITS_SGIX = 0x00000002,
  eGLX_HYPERPIPE_STEREO_SGIX = 0x00000003,
  eGLX_HYPERPIPE_PIXEL_AVERAGE_SGIX = 0x00000004,
  eGLX_HYPERPIPE_ID_SGIX = 0x8030,
  eGLX_PBUFFER_BIT_SGIX = 0x00000004,
  eGLX_BUFFER_CLOBBER_MASK_SGIX = 0x08000000,
  eGLX_FRONT_LEFT_BUFFER_BIT_SGIX = 0x00000001,
  eGLX_FRONT_RIGHT_BUFFER_BIT_SGIX = 0x00000002,
  eGLX_BACK_LEFT_BUFFER_BIT_SGIX = 0x00000004,
  eGLX_BACK_RIGHT_BUFFER_BIT_SGIX = 0x00000008,
  eGLX_AUX_BUFFERS_BIT_SGIX = 0x00000010,
  eGLX_DEPTH_BUFFER_BIT_SGIX = 0x00000020,
  eGLX_STENCIL_BUFFER_BIT_SGIX = 0x00000040,
  eGLX_ACCUM_BUFFER_BIT_SGIX = 0x00000080,
  eGLX_SAMPLE_BUFFERS_BIT_SGIX = 0x00000100,
  eGLX_MAX_PBUFFER_WIDTH_SGIX = 0x8016,
  eGLX_MAX_PBUFFER_HEIGHT_SGIX = 0x8017,
  eGLX_MAX_PBUFFER_PIXELS_SGIX = 0x8018,
  eGLX_OPTIMAL_PBUFFER_WIDTH_SGIX = 0x8019,
  eGLX_OPTIMAL_PBUFFER_HEIGHT_SGIX = 0x801A,
  eGLX_PRESERVED_CONTENTS_SGIX = 0x801B,
  eGLX_LARGEST_PBUFFER_SGIX = 0x801C,
  eGLX_WIDTH_SGIX = 0x801D,
  eGLX_HEIGHT_SGIX = 0x801E,
  eGLX_EVENT_MASK_SGIX = 0x801F,
  eGLX_DAMAGED_SGIX = 0x8020,
  eGLX_SAVED_SGIX = 0x8021,
  eGLX_WINDOW_SGIX = 0x8022,
  eGLX_PBUFFER_SGIX = 0x8023,
  eGLX_SYNC_FRAME_SGIX = 0x00000000,
  eGLX_SYNC_SWAP_SGIX = 0x00000001,
  eGLX_VISUAL_SELECT_GROUP_SGIX = 0x8028,
  eWGL_FRONT_COLOR_BUFFER_BIT_ARB = 0x00000001,
  eWGL_BACK_COLOR_BUFFER_BIT_ARB = 0x00000002,
  eWGL_DEPTH_BUFFER_BIT_ARB = 0x00000004,
  eWGL_STENCIL_BUFFER_BIT_ARB = 0x00000008,
  eWGL_CONTEXT_RELEASE_BEHAVIOR_ARB = 0x2097,
  eWGL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_ARB = 0x2098,
  eWGL_CONTEXT_DEBUG_BIT_ARB = 0x00000001,
  eWGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 0x00000002,
  eWGL_CONTEXT_MAJOR_VERSION_ARB = 0x2091,
  eWGL_CONTEXT_MINOR_VERSION_ARB = 0x2092,
  eWGL_CONTEXT_LAYER_PLANE_ARB = 0x2093,
  eWGL_CONTEXT_FLAGS_ARB = 0x2094,
  eERROR_INVALID_VERSION_ARB = 0x2095,
  eWGL_CONTEXT_OPENGL_NO_ERROR_ARB = 0x31B3,
  eWGL_CONTEXT_PROFILE_MASK_ARB = 0x9126,
  eWGL_CONTEXT_CORE_PROFILE_BIT_ARB = 0x00000001,
  eWGL_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB = 0x00000002,
  eERROR_INVALID_PROFILE_ARB = 0x2096,
  eWGL_CONTEXT_ROBUST_ACCESS_BIT_ARB = 0x00000004,
  eWGL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252,
  eWGL_CONTEXT_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256,
  eWGL_NO_RESET_NOTIFICATION_ARB = 0x8261,
  eWGL_FRAMEBUFFER_SRGB_CAPABLE_ARB = 0x20A9,
  eERROR_INVALID_PIXEL_TYPE_ARB = 0x2043,
  eERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB = 0x2054,
  eWGL_SAMPLE_BUFFERS_ARB = 0x2041,
  eWGL_SAMPLES_ARB = 0x2042,
  eWGL_DRAW_TO_PBUFFER_ARB = 0x202D,
  eWGL_MAX_PBUFFER_PIXELS_ARB = 0x202E,
  eWGL_MAX_PBUFFER_WIDTH_ARB = 0x202F,
  eWGL_MAX_PBUFFER_HEIGHT_ARB = 0x2030,
  eWGL_PBUFFER_LARGEST_ARB = 0x2033,
  eWGL_PBUFFER_WIDTH_ARB = 0x2034,
  eWGL_PBUFFER_HEIGHT_ARB = 0x2035,
  eWGL_PBUFFER_LOST_ARB = 0x2036,
  eWGL_NUMBER_PIXEL_FORMATS_ARB = 0x2000,
  eWGL_DRAW_TO_WINDOW_ARB = 0x2001,
  eWGL_DRAW_TO_BITMAP_ARB = 0x2002,
  eWGL_ACCELERATION_ARB = 0x2003,
  eWGL_NEED_PALETTE_ARB = 0x2004,
  eWGL_NEED_SYSTEM_PALETTE_ARB = 0x2005,
  eWGL_SWAP_LAYER_BUFFERS_ARB = 0x2006,
  eWGL_SWAP_METHOD_ARB = 0x2007,
  eWGL_NUMBER_OVERLAYS_ARB = 0x2008,
  eWGL_NUMBER_UNDERLAYS_ARB = 0x2009,
  eWGL_TRANSPARENT_ARB = 0x200A,
  eWGL_TRANSPARENT_RED_VALUE_ARB = 0x2037,
  eWGL_TRANSPARENT_GREEN_VALUE_ARB = 0x2038,
  eWGL_TRANSPARENT_BLUE_VALUE_ARB = 0x2039,
  eWGL_TRANSPARENT_ALPHA_VALUE_ARB = 0x203A,
  eWGL_TRANSPARENT_INDEX_VALUE_ARB = 0x203B,
  eWGL_SHARE_DEPTH_ARB = 0x200C,
  eWGL_SHARE_STENCIL_ARB = 0x200D,
  eWGL_SHARE_ACCUM_ARB = 0x200E,
  eWGL_SUPPORT_GDI_ARB = 0x200F,
  eWGL_SUPPORT_OPENGL_ARB = 0x2010,
  eWGL_DOUBLE_BUFFER_ARB = 0x2011,
  eWGL_STEREO_ARB = 0x2012,
  eWGL_PIXEL_TYPE_ARB = 0x2013,
  eWGL_COLOR_BITS_ARB = 0x2014,
  eWGL_RED_BITS_ARB = 0x2015,
  eWGL_RED_SHIFT_ARB = 0x2016,
  eWGL_GREEN_BITS_ARB = 0x2017,
  eWGL_GREEN_SHIFT_ARB = 0x2018,
  eWGL_BLUE_BITS_ARB = 0x2019,
  eWGL_BLUE_SHIFT_ARB = 0x201A,
  eWGL_ALPHA_BITS_ARB = 0x201B,
  eWGL_ALPHA_SHIFT_ARB = 0x201C,
  eWGL_ACCUM_BITS_ARB = 0x201D,
  eWGL_ACCUM_RED_BITS_ARB = 0x201E,
  eWGL_ACCUM_GREEN_BITS_ARB = 0x201F,
  eWGL_ACCUM_BLUE_BITS_ARB = 0x2020,
  eWGL_ACCUM_ALPHA_BITS_ARB = 0x2021,
  eWGL_DEPTH_BITS_ARB = 0x2022,
  eWGL_STENCIL_BITS_ARB = 0x2023,
  eWGL_AUX_BUFFERS_ARB = 0x2024,
  eWGL_NO_ACCELERATION_ARB = 0x2025,
  eWGL_GENERIC_ACCELERATION_ARB = 0x2026,
  eWGL_FULL_ACCELERATION_ARB = 0x2027,
  eWGL_SWAP_EXCHANGE_ARB = 0x2028,
  eWGL_SWAP_COPY_ARB = 0x2029,
  eWGL_SWAP_UNDEFINED_ARB = 0x202A,
  eWGL_TYPE_RGBA_ARB = 0x202B,
  eWGL_TYPE_COLORINDEX_ARB = 0x202C,
  eWGL_TYPE_RGBA_FLOAT_ARB = 0x21A0,
  eWGL_BIND_TO_TEXTURE_RGB_ARB = 0x2070,
  eWGL_BIND_TO_TEXTURE_RGBA_ARB = 0x2071,
  eWGL_TEXTURE_FORMAT_ARB = 0x2072,
  eWGL_TEXTURE_TARGET_ARB = 0x2073,
  eWGL_MIPMAP_TEXTURE_ARB = 0x2074,
  eWGL_TEXTURE_RGB_ARB = 0x2075,
  eWGL_TEXTURE_RGBA_ARB = 0x2076,
  eWGL_NO_TEXTURE_ARB = 0x2077,
  eWGL_TEXTURE_CUBE_MAP_ARB = 0x2078,
  eWGL_TEXTURE_1D_ARB = 0x2079,
  eWGL_TEXTURE_2D_ARB = 0x207A,
  eWGL_MIPMAP_LEVEL_ARB = 0x207B,
  eWGL_CUBE_MAP_FACE_ARB = 0x207C,
  eWGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x207D,
  eWGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x207E,
  eWGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x207F,
  eWGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x2080,
  eWGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x2081,
  eWGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x2082,
  eWGL_FRONT_LEFT_ARB = 0x2083,
  eWGL_FRONT_RIGHT_ARB = 0x2084,
  eWGL_BACK_LEFT_ARB = 0x2085,
  eWGL_BACK_RIGHT_ARB = 0x2086,
  eWGL_AUX0_ARB = 0x2087,
  eWGL_AUX1_ARB = 0x2088,
  eWGL_AUX2_ARB = 0x2089,
  eWGL_AUX3_ARB = 0x208A,
  eWGL_AUX4_ARB = 0x208B,
  eWGL_AUX5_ARB = 0x208C,
  eWGL_AUX6_ARB = 0x208D,
  eWGL_AUX7_ARB = 0x208E,
  eWGL_AUX8_ARB = 0x208F,
  eWGL_AUX9_ARB = 0x2090,
  eWGL_CONTEXT_RESET_ISOLATION_BIT_ARB = 0x00000008,
  eWGL_SAMPLE_BUFFERS_3DFX = 0x2060,
  eWGL_SAMPLES_3DFX = 0x2061,
  eWGL_STEREO_EMITTER_ENABLE_3DL = 0x2055,
  eWGL_STEREO_EMITTER_DISABLE_3DL = 0x2056,
  eWGL_STEREO_POLARITY_NORMAL_3DL = 0x2057,
  eWGL_STEREO_POLARITY_INVERT_3DL = 0x2058,
  eWGL_GPU_VENDOR_AMD = 0x1F00,
  eWGL_GPU_RENDERER_STRING_AMD = 0x1F01,
  eWGL_GPU_OPENGL_VERSION_STRING_AMD = 0x1F02,
  eWGL_GPU_FASTEST_TARGET_GPUS_AMD = 0x21A2,
  eWGL_GPU_RAM_AMD = 0x21A3,
  eWGL_GPU_CLOCK_AMD = 0x21A4,
  eWGL_GPU_NUM_PIPES_AMD = 0x21A5,
  eWGL_GPU_NUM_SIMD_AMD = 0x21A6,
  eWGL_GPU_NUM_RB_AMD = 0x21A7,
  eWGL_GPU_NUM_SPI_AMD = 0x21A8,
  eWGL_TYPE_RGBA_FLOAT_ATI = 0x21A0,
  eWGL_COLORSPACE_EXT = 0x3087,
  eWGL_COLORSPACE_SRGB_EXT = 0x3089,
  eWGL_COLORSPACE_LINEAR_EXT = 0x308A,
  eWGL_CONTEXT_ES2_PROFILE_BIT_EXT = 0x00000004,
  eWGL_CONTEXT_ES_PROFILE_BIT_EXT = 0x00000004,
  eWGL_DEPTH_FLOAT_EXT = 0x2040,
  eWGL_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x20A9,
  eERROR_INVALID_PIXEL_TYPE_EXT = 0x2043,
  eWGL_SAMPLE_BUFFERS_EXT = 0x2041,
  eWGL_SAMPLES_EXT = 0x2042,
  eWGL_DRAW_TO_PBUFFER_EXT = 0x202D,
  eWGL_MAX_PBUFFER_PIXELS_EXT = 0x202E,
  eWGL_MAX_PBUFFER_WIDTH_EXT = 0x202F,
  eWGL_MAX_PBUFFER_HEIGHT_EXT = 0x2030,
  eWGL_OPTIMAL_PBUFFER_WIDTH_EXT = 0x2031,
  eWGL_OPTIMAL_PBUFFER_HEIGHT_EXT = 0x2032,
  eWGL_PBUFFER_LARGEST_EXT = 0x2033,
  eWGL_PBUFFER_WIDTH_EXT = 0x2034,
  eWGL_PBUFFER_HEIGHT_EXT = 0x2035,
  eWGL_NUMBER_PIXEL_FORMATS_EXT = 0x2000,
  eWGL_DRAW_TO_WINDOW_EXT = 0x2001,
  eWGL_DRAW_TO_BITMAP_EXT = 0x2002,
  eWGL_ACCELERATION_EXT = 0x2003,
  eWGL_NEED_PALETTE_EXT = 0x2004,
  eWGL_NEED_SYSTEM_PALETTE_EXT = 0x2005,
  eWGL_SWAP_LAYER_BUFFERS_EXT = 0x2006,
  eWGL_SWAP_METHOD_EXT = 0x2007,
  eWGL_NUMBER_OVERLAYS_EXT = 0x2008,
  eWGL_NUMBER_UNDERLAYS_EXT = 0x2009,
  eWGL_TRANSPARENT_EXT = 0x200A,
  eWGL_TRANSPARENT_VALUE_EXT = 0x200B,
  eWGL_SHARE_DEPTH_EXT = 0x200C,
  eWGL_SHARE_STENCIL_EXT = 0x200D,
  eWGL_SHARE_ACCUM_EXT = 0x200E,
  eWGL_SUPPORT_GDI_EXT = 0x200F,
  eWGL_SUPPORT_OPENGL_EXT = 0x2010,
  eWGL_DOUBLE_BUFFER_EXT = 0x2011,
  eWGL_STEREO_EXT = 0x2012,
  eWGL_PIXEL_TYPE_EXT = 0x2013,
  eWGL_COLOR_BITS_EXT = 0x2014,
  eWGL_RED_BITS_EXT = 0x2015,
  eWGL_RED_SHIFT_EXT = 0x2016,
  eWGL_GREEN_BITS_EXT = 0x2017,
  eWGL_GREEN_SHIFT_EXT = 0x2018,
  eWGL_BLUE_BITS_EXT = 0x2019,
  eWGL_BLUE_SHIFT_EXT = 0x201A,
  eWGL_ALPHA_BITS_EXT = 0x201B,
  eWGL_ALPHA_SHIFT_EXT = 0x201C,
  eWGL_ACCUM_BITS_EXT = 0x201D,
  eWGL_ACCUM_RED_BITS_EXT = 0x201E,
  eWGL_ACCUM_GREEN_BITS_EXT = 0x201F,
  eWGL_ACCUM_BLUE_BITS_EXT = 0x2020,
  eWGL_ACCUM_ALPHA_BITS_EXT = 0x2021,
  eWGL_DEPTH_BITS_EXT = 0x2022,
  eWGL_STENCIL_BITS_EXT = 0x2023,
  eWGL_AUX_BUFFERS_EXT = 0x2024,
  eWGL_NO_ACCELERATION_EXT = 0x2025,
  eWGL_GENERIC_ACCELERATION_EXT = 0x2026,
  eWGL_FULL_ACCELERATION_EXT = 0x2027,
  eWGL_SWAP_EXCHANGE_EXT = 0x2028,
  eWGL_SWAP_COPY_EXT = 0x2029,
  eWGL_SWAP_UNDEFINED_EXT = 0x202A,
  eWGL_TYPE_RGBA_EXT = 0x202B,
  eWGL_TYPE_COLORINDEX_EXT = 0x202C,
  eWGL_TYPE_RGBA_UNSIGNED_FLOAT_EXT = 0x20A8,
  eWGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D = 0x2050,
  eWGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D = 0x2051,
  eWGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D = 0x2052,
  eWGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D = 0x2053,
  eWGL_GAMMA_TABLE_SIZE_I3D = 0x204E,
  eWGL_GAMMA_EXCLUDE_DESKTOP_I3D = 0x204F,
  eWGL_GENLOCK_SOURCE_MULTIVIEW_I3D = 0x2044,
  eWGL_GENLOCK_SOURCE_EXTERNAL_SYNC_I3D = 0x2045,
  eWGL_GENLOCK_SOURCE_EXTERNAL_FIELD_I3D = 0x2046,
  eWGL_GENLOCK_SOURCE_EXTERNAL_TTL_I3D = 0x2047,
  eWGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D = 0x2048,
  eWGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D = 0x2049,
  eWGL_GENLOCK_SOURCE_EDGE_FALLING_I3D = 0x204A,
  eWGL_GENLOCK_SOURCE_EDGE_RISING_I3D = 0x204B,
  eWGL_GENLOCK_SOURCE_EDGE_BOTH_I3D = 0x204C,
  eWGL_IMAGE_BUFFER_MIN_ACCESS_I3D = 0x00000001,
  eWGL_IMAGE_BUFFER_LOCK_I3D = 0x00000002,
  eWGL_ACCESS_READ_ONLY_NV = 0x00000000,
  eWGL_ACCESS_READ_WRITE_NV = 0x00000001,
  eWGL_ACCESS_WRITE_DISCARD_NV = 0x00000002,
  eWGL_FLOAT_COMPONENTS_NV = 0x20B0,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV = 0x20B1,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV = 0x20B2,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV = 0x20B3,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV = 0x20B4,
  eWGL_TEXTURE_FLOAT_R_NV = 0x20B5,
  eWGL_TEXTURE_FLOAT_RG_NV = 0x20B6,
  eWGL_TEXTURE_FLOAT_RGB_NV = 0x20B7,
  eWGL_TEXTURE_FLOAT_RGBA_NV = 0x20B8,
  eERROR_INCOMPATIBLE_AFFINITY_MASKS_NV = 0x20D0,
  eERROR_MISSING_AFFINITY_MASK_NV = 0x20D1,
  eWGL_COVERAGE_SAMPLES_NV = 0x2042,
  eWGL_COLOR_SAMPLES_NV = 0x20B9,
  eWGL_NUM_VIDEO_SLOTS_NV = 0x20F0,
  eWGL_BIND_TO_TEXTURE_DEPTH_NV = 0x20A3,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_DEPTH_NV = 0x20A4,
  eWGL_DEPTH_TEXTURE_FORMAT_NV = 0x20A5,
  eWGL_TEXTURE_DEPTH_COMPONENT_NV = 0x20A6,
  eWGL_DEPTH_COMPONENT_NV = 0x20A7,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_RGB_NV = 0x20A0,
  eWGL_BIND_TO_TEXTURE_RECTANGLE_RGBA_NV = 0x20A1,
  eWGL_TEXTURE_RECTANGLE_NV = 0x20A2,
  eWGL_UNIQUE_ID_NV = 0x20CE,
  eWGL_NUM_VIDEO_CAPTURE_SLOTS_NV = 0x20CF,
  eWGL_BIND_TO_VIDEO_RGB_NV = 0x20C0,
  eWGL_BIND_TO_VIDEO_RGBA_NV = 0x20C1,
  eWGL_BIND_TO_VIDEO_RGB_AND_DEPTH_NV = 0x20C2,
  eWGL_VIDEO_OUT_COLOR_NV = 0x20C3,
  eWGL_VIDEO_OUT_ALPHA_NV = 0x20C4,
  eWGL_VIDEO_OUT_DEPTH_NV = 0x20C5,
  eWGL_VIDEO_OUT_COLOR_AND_ALPHA_NV = 0x20C6,
  eWGL_VIDEO_OUT_COLOR_AND_DEPTH_NV = 0x20C7,
  eWGL_VIDEO_OUT_FRAME = 0x20C8,
  eWGL_VIDEO_OUT_FIELD_1 = 0x20C9,
  eWGL_VIDEO_OUT_FIELD_2 = 0x20CA,
  eWGL_VIDEO_OUT_STACKED_FIELDS_1_2 = 0x20CB,
  eWGL_VIDEO_OUT_STACKED_FIELDS_2_1 = 0x20CC,
  eGL_CONTEXT_RELEASE_BEHAVIOR_KHR = 0x82FB,
  eGL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = 0x82FC,
  eGL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 0x8242,
  eGL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 0x8243,
  eGL_DEBUG_CALLBACK_FUNCTION_KHR = 0x8244,
  eGL_DEBUG_CALLBACK_USER_PARAM_KHR = 0x8245,
  eGL_DEBUG_SOURCE_API_KHR = 0x8246,
  eGL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 0x8247,
  eGL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 0x8248,
  eGL_DEBUG_SOURCE_THIRD_PARTY_KHR = 0x8249,
  eGL_DEBUG_SOURCE_APPLICATION_KHR = 0x824A,
  eGL_DEBUG_SOURCE_OTHER_KHR = 0x824B,
  eGL_DEBUG_TYPE_ERROR_KHR = 0x824C,
  eGL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 0x824D,
  eGL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 0x824E,
  eGL_DEBUG_TYPE_PORTABILITY_KHR = 0x824F,
  eGL_DEBUG_TYPE_PERFORMANCE_KHR = 0x8250,
  eGL_DEBUG_TYPE_OTHER_KHR = 0x8251,
  eGL_DEBUG_TYPE_MARKER_KHR = 0x8268,
  eGL_DEBUG_TYPE_PUSH_GROUP_KHR = 0x8269,
  eGL_DEBUG_TYPE_POP_GROUP_KHR = 0x826A,
  eGL_DEBUG_SEVERITY_NOTIFICATION_KHR = 0x826B,
  eGL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826C,
  eGL_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826D,
  eGL_BUFFER_KHR = 0x82E0,
  eGL_SHADER_KHR = 0x82E1,
  eGL_PROGRAM_KHR = 0x82E2,
  eGL_VERTEX_ARRAY_KHR = 0x8074,
  eGL_QUERY_KHR = 0x82E3,
  eGL_PROGRAM_PIPELINE_KHR = 0x82E4,
  eGL_SAMPLER_KHR = 0x82E6,
  eGL_MAX_LABEL_LENGTH_KHR = 0x82E8,
  eGL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 0x9143,
  eGL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 0x9144,
  eGL_DEBUG_LOGGED_MESSAGES_KHR = 0x9145,
  eGL_DEBUG_SEVERITY_HIGH_KHR = 0x9146,
  eGL_DEBUG_SEVERITY_MEDIUM_KHR = 0x9147,
  eGL_DEBUG_SEVERITY_LOW_KHR = 0x9148,
  eGL_DEBUG_OUTPUT_KHR = 0x92E0,
  eGL_CONTEXT_FLAG_DEBUG_BIT_KHR = 0x00000002,
  eGL_STACK_OVERFLOW_KHR = 0x0503,
  eGL_STACK_UNDERFLOW_KHR = 0x0504,
  eGL_CONTEXT_ROBUST_ACCESS_KHR = 0x90F3,
  eGL_LOSE_CONTEXT_ON_RESET_KHR = 0x8252,
  eGL_GUILTY_CONTEXT_RESET_KHR = 0x8253,
  eGL_INNOCENT_CONTEXT_RESET_KHR = 0x8254,
  eGL_UNKNOWN_CONTEXT_RESET_KHR = 0x8255,
  eGL_RESET_NOTIFICATION_STRATEGY_KHR = 0x8256,
  eGL_NO_RESET_NOTIFICATION_KHR = 0x8261,
  eGL_CONTEXT_LOST_KHR = 0x0507,
  eGL_TEXTURE_EXTERNAL_OES = 0x8D65,
  eGL_TEXTURE_BINDING_EXTERNAL_OES = 0x8D67,
  eGL_REQUIRED_TEXTURE_IMAGE_UNITS_OES = 0x8D68,
  eGL_SAMPLER_EXTERNAL_OES = 0x8D66,
  eGL_ETC1_RGB8_OES = 0x8D64,
  eGL_DEPTH_COMPONENT24_OES = 0x81A6,
  eGL_DEPTH_COMPONENT32_OES = 0x81A7,
  eGL_GEOMETRY_SHADER_OES = 0x8DD9,
  eGL_GEOMETRY_SHADER_BIT_OES = 0x00000004,
  eGL_GEOMETRY_LINKED_VERTICES_OUT_OES = 0x8916,
  eGL_GEOMETRY_LINKED_INPUT_TYPE_OES = 0x8917,
  eGL_GEOMETRY_LINKED_OUTPUT_TYPE_OES = 0x8918,
  eGL_GEOMETRY_SHADER_INVOCATIONS_OES = 0x887F,
  eGL_LAYER_PROVOKING_VERTEX_OES = 0x825E,
  eGL_LINES_ADJACENCY_OES = 0x000A,
  eGL_LINE_STRIP_ADJACENCY_OES = 0x000B,
  eGL_TRIANGLES_ADJACENCY_OES = 0x000C,
  eGL_TRIANGLE_STRIP_ADJACENCY_OES = 0x000D,
  eGL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8DDF,
  eGL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES = 0x8A2C,
  eGL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES = 0x8A32,
  eGL_MAX_GEOMETRY_INPUT_COMPONENTS_OES = 0x9123,
  eGL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES = 0x9124,
  eGL_MAX_GEOMETRY_OUTPUT_VERTICES_OES = 0x8DE0,
  eGL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES = 0x8DE1,
  eGL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES = 0x8E5A,
  eGL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES = 0x8C29,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES = 0x92CF,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES = 0x92D5,
  eGL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES = 0x90CD,
  eGL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES = 0x90D7,
  eGL_FIRST_VERTEX_CONVENTION_OES = 0x8E4D,
  eGL_LAST_VERTEX_CONVENTION_OES = 0x8E4E,
  eGL_UNDEFINED_VERTEX_OES = 0x8260,
  eGL_PRIMITIVES_GENERATED_OES = 0x8C87,
  eGL_FRAMEBUFFER_DEFAULT_LAYERS_OES = 0x9312,
  eGL_MAX_FRAMEBUFFER_LAYERS_OES = 0x9317,
  eGL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES = 0x8DA8,
  eGL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES = 0x8DA7,
  eGL_REFERENCED_BY_GEOMETRY_SHADER_OES = 0x9309,
  eGL_PROGRAM_BINARY_LENGTH_OES = 0x8741,
  eGL_NUM_PROGRAM_BINARY_FORMATS_OES = 0x87FE,
  eGL_PROGRAM_BINARY_FORMATS_OES = 0x87FF,
  eGL_WRITE_ONLY_OES = 0x88B9,
  eGL_BUFFER_ACCESS_OES = 0x88BB,
  eGL_BUFFER_MAPPED_OES = 0x88BC,
  eGL_BUFFER_MAP_POINTER_OES = 0x88BD,
  eGL_DEPTH_STENCIL_OES = 0x84F9,
  eGL_UNSIGNED_INT_24_8_OES = 0x84FA,
  eGL_DEPTH24_STENCIL8_OES = 0x88F0,
  eGL_PRIMITIVE_BOUNDING_BOX_OES = 0x92BE,
  eGL_ALPHA8_OES = 0x803C,
  eGL_DEPTH_COMPONENT16_OES = 0x81A5,
  eGL_LUMINANCE4_ALPHA4_OES = 0x8043,
  eGL_LUMINANCE8_ALPHA8_OES = 0x8045,
  eGL_LUMINANCE8_OES = 0x8040,
  eGL_RGBA4_OES = 0x8056,
  eGL_RGB5_A1_OES = 0x8057,
  eGL_RGB565_OES = 0x8D62,
  eGL_RGB8_OES = 0x8051,
  eGL_RGBA8_OES = 0x8058,
  eGL_SAMPLE_SHADING_OES = 0x8C36,
  eGL_MIN_SAMPLE_SHADING_VALUE_OES = 0x8C37,
  eGL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5B,
  eGL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES = 0x8E5C,
  eGL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES = 0x8E5D,
  eGL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = 0x8B8B,
  eGL_STENCIL_INDEX1_OES = 0x8D46,
  eGL_STENCIL_INDEX4_OES = 0x8D47,
  eGL_FRAMEBUFFER_UNDEFINED_OES = 0x8219,
  eGL_PATCHES_OES = 0x000E,
  eGL_PATCH_VERTICES_OES = 0x8E72,
  eGL_TESS_CONTROL_OUTPUT_VERTICES_OES = 0x8E75,
  eGL_TESS_GEN_MODE_OES = 0x8E76,
  eGL_TESS_GEN_SPACING_OES = 0x8E77,
  eGL_TESS_GEN_VERTEX_ORDER_OES = 0x8E78,
  eGL_TESS_GEN_POINT_MODE_OES = 0x8E79,
  eGL_ISOLINES_OES = 0x8E7A,
  eGL_QUADS_OES = 0x0007,
  eGL_FRACTIONAL_ODD_OES = 0x8E7B,
  eGL_FRACTIONAL_EVEN_OES = 0x8E7C,
  eGL_MAX_PATCH_VERTICES_OES = 0x8E7D,
  eGL_MAX_TESS_GEN_LEVEL_OES = 0x8E7E,
  eGL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E7F,
  eGL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E80,
  eGL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES = 0x8E81,
  eGL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES = 0x8E82,
  eGL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES = 0x8E83,
  eGL_MAX_TESS_PATCH_COMPONENTS_OES = 0x8E84,
  eGL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES = 0x8E85,
  eGL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES = 0x8E86,
  eGL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES = 0x8E89,
  eGL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES = 0x8E8A,
  eGL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES = 0x886C,
  eGL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES = 0x886D,
  eGL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES = 0x8E1E,
  eGL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = 0x8E1F,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES = 0x92CD,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES = 0x92CE,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES = 0x92D3,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES = 0x92D4,
  eGL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES = 0x90CB,
  eGL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES = 0x90CC,
  eGL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES = 0x90D8,
  eGL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES = 0x90D9,
  eGL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES = 0x8221,
  eGL_IS_PER_PATCH_OES = 0x92E7,
  eGL_REFERENCED_BY_TESS_CONTROL_SHADER_OES = 0x9307,
  eGL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES = 0x9308,
  eGL_TESS_CONTROL_SHADER_OES = 0x8E88,
  eGL_TESS_EVALUATION_SHADER_OES = 0x8E87,
  eGL_TESS_CONTROL_SHADER_BIT_OES = 0x00000008,
  eGL_TESS_EVALUATION_SHADER_BIT_OES = 0x00000010,
  eGL_TEXTURE_WRAP_R_OES = 0x8072,
  eGL_TEXTURE_3D_OES = 0x806F,
  eGL_TEXTURE_BINDING_3D_OES = 0x806A,
  eGL_MAX_3D_TEXTURE_SIZE_OES = 0x8073,
  eGL_SAMPLER_3D_OES = 0x8B5F,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = 0x8CD4,
  eGL_TEXTURE_BORDER_COLOR_OES = 0x1004,
  eGL_CLAMP_TO_BORDER_OES = 0x812D,
  eGL_TEXTURE_BUFFER_OES = 0x8C2A,
  eGL_TEXTURE_BUFFER_BINDING_OES = 0x8C2A,
  eGL_MAX_TEXTURE_BUFFER_SIZE_OES = 0x8C2B,
  eGL_TEXTURE_BINDING_BUFFER_OES = 0x8C2C,
  eGL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES = 0x8C2D,
  eGL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES = 0x919F,
  eGL_SAMPLER_BUFFER_OES = 0x8DC2,
  eGL_INT_SAMPLER_BUFFER_OES = 0x8DD0,
  eGL_UNSIGNED_INT_SAMPLER_BUFFER_OES = 0x8DD8,
  eGL_IMAGE_BUFFER_OES = 0x9051,
  eGL_INT_IMAGE_BUFFER_OES = 0x905C,
  eGL_UNSIGNED_INT_IMAGE_BUFFER_OES = 0x9067,
  eGL_TEXTURE_BUFFER_OFFSET_OES = 0x919D,
  eGL_TEXTURE_BUFFER_SIZE_OES = 0x919E,
  eGL_COMPRESSED_RGBA_ASTC_3x3x3_OES = 0x93C0,
  eGL_COMPRESSED_RGBA_ASTC_4x3x3_OES = 0x93C1,
  eGL_COMPRESSED_RGBA_ASTC_4x4x3_OES = 0x93C2,
  eGL_COMPRESSED_RGBA_ASTC_4x4x4_OES = 0x93C3,
  eGL_COMPRESSED_RGBA_ASTC_5x4x4_OES = 0x93C4,
  eGL_COMPRESSED_RGBA_ASTC_5x5x4_OES = 0x93C5,
  eGL_COMPRESSED_RGBA_ASTC_5x5x5_OES = 0x93C6,
  eGL_COMPRESSED_RGBA_ASTC_6x5x5_OES = 0x93C7,
  eGL_COMPRESSED_RGBA_ASTC_6x6x5_OES = 0x93C8,
  eGL_COMPRESSED_RGBA_ASTC_6x6x6_OES = 0x93C9,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES = 0x93E0,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES = 0x93E1,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES = 0x93E2,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES = 0x93E3,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES = 0x93E4,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES = 0x93E5,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES = 0x93E6,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES = 0x93E7,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES = 0x93E8,
  eGL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES = 0x93E9,
  eGL_TEXTURE_CUBE_MAP_ARRAY_OES = 0x9009,
  eGL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES = 0x900A,
  eGL_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900C,
  eGL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES = 0x900D,
  eGL_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900E,
  eGL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES = 0x900F,
  eGL_IMAGE_CUBE_MAP_ARRAY_OES = 0x9054,
  eGL_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x905F,
  eGL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES = 0x906A,
  eGL_HALF_FLOAT_OES = 0x8D61,
  eGL_STENCIL_INDEX_OES = 0x1901,
  eGL_STENCIL_INDEX8_OES = 0x8D48,
  eGL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES = 0x9102,
  eGL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES = 0x9105,
  eGL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910B,
  eGL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910C,
  eGL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = 0x910D,
  eGL_TEXTURE_VIEW_MIN_LEVEL_OES = 0x82DB,
  eGL_TEXTURE_VIEW_NUM_LEVELS_OES = 0x82DC,
  eGL_TEXTURE_VIEW_MIN_LAYER_OES = 0x82DD,
  eGL_TEXTURE_VIEW_NUM_LAYERS_OES = 0x82DE,
  eGL_VERTEX_ARRAY_BINDING_OES = 0x85B5,
  eGL_UNSIGNED_INT_10_10_10_2_OES = 0x8DF6,
  eGL_INT_10_10_10_2_OES = 0x8DF7,
  eGL_MAX_VIEWPORTS_OES = 0x825B,
  eGL_VIEWPORT_SUBPIXEL_BITS_OES = 0x825C,
  eGL_VIEWPORT_BOUNDS_RANGE_OES = 0x825D,
  eGL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = 0x825F,
  eGL_3DC_X_AMD = 0x87F9,
  eGL_3DC_XY_AMD = 0x87FA,
  eGL_ATC_RGB_AMD = 0x8C92,
  eGL_ATC_RGBA_EXPLICIT_ALPHA_AMD = 0x8C93,
  eGL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = 0x87EE,
  eGL_Z400_BINARY_AMD = 0x8740,
  eGL_READ_FRAMEBUFFER_ANGLE = 0x8CA8,
  eGL_DRAW_FRAMEBUFFER_ANGLE = 0x8CA9,
  eGL_DRAW_FRAMEBUFFER_BINDING_ANGLE = 0x8CA6,
  eGL_READ_FRAMEBUFFER_BINDING_ANGLE = 0x8CAA,
  eGL_RENDERBUFFER_SAMPLES_ANGLE = 0x8CAB,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE = 0x8D56,
  eGL_MAX_SAMPLES_ANGLE = 0x8D57,
  eGL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = 0x88FE,
  eGL_PACK_REVERSE_ROW_ORDER_ANGLE = 0x93A4,
  eGL_PROGRAM_BINARY_ANGLE = 0x93A6,
  eGL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE = 0x83F2,
  eGL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE = 0x83F3,
  eGL_TEXTURE_USAGE_ANGLE = 0x93A2,
  eGL_FRAMEBUFFER_ATTACHMENT_ANGLE = 0x93A3,
  eGL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = 0x93A0,
  eGL_MAX_CLIP_DISTANCES_APPLE = 0x0D32,
  eGL_CLIP_DISTANCE0_APPLE = 0x3000,
  eGL_CLIP_DISTANCE1_APPLE = 0x3001,
  eGL_CLIP_DISTANCE2_APPLE = 0x3002,
  eGL_CLIP_DISTANCE3_APPLE = 0x3003,
  eGL_CLIP_DISTANCE4_APPLE = 0x3004,
  eGL_CLIP_DISTANCE5_APPLE = 0x3005,
  eGL_CLIP_DISTANCE6_APPLE = 0x3006,
  eGL_CLIP_DISTANCE7_APPLE = 0x3007,
  eGL_RENDERBUFFER_SAMPLES_APPLE = 0x8CAB,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE = 0x8D56,
  eGL_MAX_SAMPLES_APPLE = 0x8D57,
  eGL_READ_FRAMEBUFFER_APPLE = 0x8CA8,
  eGL_DRAW_FRAMEBUFFER_APPLE = 0x8CA9,
  eGL_DRAW_FRAMEBUFFER_BINDING_APPLE = 0x8CA6,
  eGL_READ_FRAMEBUFFER_BINDING_APPLE = 0x8CAA,
  eGL_SYNC_OBJECT_APPLE = 0x8A53,
  eGL_MAX_SERVER_WAIT_TIMEOUT_APPLE = 0x9111,
  eGL_OBJECT_TYPE_APPLE = 0x9112,
  eGL_SYNC_CONDITION_APPLE = 0x9113,
  eGL_SYNC_STATUS_APPLE = 0x9114,
  eGL_SYNC_FLAGS_APPLE = 0x9115,
  eGL_SYNC_FENCE_APPLE = 0x9116,
  eGL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = 0x9117,
  eGL_UNSIGNALED_APPLE = 0x9118,
  eGL_SIGNALED_APPLE = 0x9119,
  eGL_ALREADY_SIGNALED_APPLE = 0x911A,
  eGL_TIMEOUT_EXPIRED_APPLE = 0x911B,
  eGL_CONDITION_SATISFIED_APPLE = 0x911C,
  eGL_WAIT_FAILED_APPLE = 0x911D,
  eGL_SYNC_FLUSH_COMMANDS_BIT_APPLE = 0x00000001,
  eGL_BGRA8_EXT = 0x93A1,
  eGL_TEXTURE_MAX_LEVEL_APPLE = 0x813D,
  eGL_UNSIGNED_INT_10F_11F_11F_REV_APPLE = 0x8C3B,
  eGL_UNSIGNED_INT_5_9_9_9_REV_APPLE = 0x8C3E,
  eGL_R11F_G11F_B10F_APPLE = 0x8C3A,
  eGL_RGB9_E5_APPLE = 0x8C3D,
  eGL_MALI_PROGRAM_BINARY_ARM = 0x8F61,
  eGL_MALI_SHADER_BINARY_ARM = 0x8F60,
  eGL_FETCH_PER_SAMPLE_ARM = 0x8F65,
  eGL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM = 0x8F66,
  eGL_SMAPHS30_PROGRAM_BINARY_DMP = 0x9251,
  eGL_SMAPHS_PROGRAM_BINARY_DMP = 0x9252,
  eGL_DMP_PROGRAM_BINARY_DMP = 0x9253,
  eGL_SHADER_BINARY_DMP = 0x9250,
  eGL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = 0x8BE7,
  eGL_SRC1_COLOR_EXT = 0x88F9,
  eGL_SRC1_ALPHA_EXT = 0x8589,
  eGL_ONE_MINUS_SRC1_COLOR_EXT = 0x88FA,
  eGL_ONE_MINUS_SRC1_ALPHA_EXT = 0x88FB,
  eGL_SRC_ALPHA_SATURATE_EXT = 0x0308,
  eGL_LOCATION_INDEX_EXT = 0x930F,
  eGL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = 0x88FC,
  eGL_MAP_PERSISTENT_BIT_EXT = 0x0040,
  eGL_MAP_COHERENT_BIT_EXT = 0x0080,
  eGL_DYNAMIC_STORAGE_BIT_EXT = 0x0100,
  eGL_CLIENT_STORAGE_BIT_EXT = 0x0200,
  eGL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = 0x00004000,
  eGL_BUFFER_IMMUTABLE_STORAGE_EXT = 0x821F,
  eGL_BUFFER_STORAGE_FLAGS_EXT = 0x8220,
  eGL_LOWER_LEFT_EXT = 0x8CA1,
  eGL_UPPER_LEFT_EXT = 0x8CA2,
  eGL_NEGATIVE_ONE_TO_ONE_EXT = 0x935E,
  eGL_ZERO_TO_ONE_EXT = 0x935F,
  eGL_CLIP_ORIGIN_EXT = 0x935C,
  eGL_CLIP_DEPTH_MODE_EXT = 0x935D,
  eGL_MAX_CLIP_DISTANCES_EXT = 0x0D32,
  eGL_MAX_CULL_DISTANCES_EXT = 0x82F9,
  eGL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT = 0x82FA,
  eGL_CLIP_DISTANCE0_EXT = 0x3000,
  eGL_CLIP_DISTANCE1_EXT = 0x3001,
  eGL_CLIP_DISTANCE2_EXT = 0x3002,
  eGL_CLIP_DISTANCE3_EXT = 0x3003,
  eGL_CLIP_DISTANCE4_EXT = 0x3004,
  eGL_CLIP_DISTANCE5_EXT = 0x3005,
  eGL_CLIP_DISTANCE6_EXT = 0x3006,
  eGL_CLIP_DISTANCE7_EXT = 0x3007,
  eGL_RGBA16F_EXT = 0x881A,
  eGL_RGB16F_EXT = 0x881B,
  eGL_RG16F_EXT = 0x822F,
  eGL_R16F_EXT = 0x822D,
  eGL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT = 0x8211,
  eGL_UNSIGNED_NORMALIZED_EXT = 0x8C17,
  eGL_COLOR_EXT = 0x1800,
  eGL_DEPTH_EXT = 0x1801,
  eGL_STENCIL_EXT = 0x1802,
  eGL_QUERY_COUNTER_BITS_EXT = 0x8864,
  eGL_CURRENT_QUERY_EXT = 0x8865,
  eGL_QUERY_RESULT_EXT = 0x8866,
  eGL_QUERY_RESULT_AVAILABLE_EXT = 0x8867,
  eGL_TIMESTAMP_EXT = 0x8E28,
  eGL_GPU_DISJOINT_EXT = 0x8FBB,
  eGL_MAX_DRAW_BUFFERS_EXT = 0x8824,
  eGL_DRAW_BUFFER0_EXT = 0x8825,
  eGL_DRAW_BUFFER1_EXT = 0x8826,
  eGL_DRAW_BUFFER2_EXT = 0x8827,
  eGL_DRAW_BUFFER3_EXT = 0x8828,
  eGL_DRAW_BUFFER4_EXT = 0x8829,
  eGL_DRAW_BUFFER5_EXT = 0x882A,
  eGL_DRAW_BUFFER6_EXT = 0x882B,
  eGL_DRAW_BUFFER7_EXT = 0x882C,
  eGL_DRAW_BUFFER8_EXT = 0x882D,
  eGL_DRAW_BUFFER9_EXT = 0x882E,
  eGL_DRAW_BUFFER10_EXT = 0x882F,
  eGL_DRAW_BUFFER11_EXT = 0x8830,
  eGL_DRAW_BUFFER12_EXT = 0x8831,
  eGL_DRAW_BUFFER13_EXT = 0x8832,
  eGL_DRAW_BUFFER14_EXT = 0x8833,
  eGL_DRAW_BUFFER15_EXT = 0x8834,
  eGL_GEOMETRY_SHADER_BIT_EXT = 0x00000004,
  eGL_GEOMETRY_LINKED_VERTICES_OUT_EXT = 0x8916,
  eGL_GEOMETRY_LINKED_INPUT_TYPE_EXT = 0x8917,
  eGL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT = 0x8918,
  eGL_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x887F,
  eGL_LAYER_PROVOKING_VERTEX_EXT = 0x825E,
  eGL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT = 0x8A2C,
  eGL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8A32,
  eGL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT = 0x9123,
  eGL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT = 0x9124,
  eGL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT = 0x8E5A,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CF,
  eGL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT = 0x92D5,
  eGL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT = 0x90CD,
  eGL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT = 0x90D7,
  eGL_UNDEFINED_VERTEX_EXT = 0x8260,
  eGL_FRAMEBUFFER_DEFAULT_LAYERS_EXT = 0x9312,
  eGL_MAX_FRAMEBUFFER_LAYERS_EXT = 0x9317,
  eGL_REFERENCED_BY_GEOMETRY_SHADER_EXT = 0x9309,
  eGL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = 0x88FE,
  eGL_MAP_READ_BIT_EXT = 0x0001,
  eGL_MAP_WRITE_BIT_EXT = 0x0002,
  eGL_MAP_INVALIDATE_RANGE_BIT_EXT = 0x0004,
  eGL_MAP_INVALIDATE_BUFFER_BIT_EXT = 0x0008,
  eGL_MAP_FLUSH_EXPLICIT_BIT_EXT = 0x0010,
  eGL_MAP_UNSYNCHRONIZED_BIT_EXT = 0x0020,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT = 0x8D6C,
  eGL_COLOR_ATTACHMENT_EXT = 0x90F0,
  eGL_MULTIVIEW_EXT = 0x90F1,
  eGL_DRAW_BUFFER_EXT = 0x0C01,
  eGL_READ_BUFFER_EXT = 0x0C02,
  eGL_MAX_MULTIVIEW_BUFFERS_EXT = 0x90F2,
  eGL_ANY_SAMPLES_PASSED_EXT = 0x8C2F,
  eGL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = 0x8D6A,
  eGL_PRIMITIVE_BOUNDING_BOX_EXT = 0x92BE,
  eGL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT = 0x00000010,
  eGL_TEXTURE_PROTECTED_EXT = 0x8BFA,
  eGL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT = 0x8A54,
  eGL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT = 0x8A55,
  eGL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT = 0x8A56,
  eGL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT = 0x8A57,
  eGL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG = 0x93F0,
  eGL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG = 0x93F1,
  eGL_UNSIGNED_SHORT_4_4_4_4_REV_EXT = 0x8365,
  eGL_UNSIGNED_SHORT_1_5_5_5_REV_EXT = 0x8366,
  eGL_R16_SNORM_EXT = 0x8F98,
  eGL_RG16_SNORM_EXT = 0x8F99,
  eGL_RGBA16_SNORM_EXT = 0x8F9B,
  eGL_GUILTY_CONTEXT_RESET_EXT = 0x8253,
  eGL_INNOCENT_CONTEXT_RESET_EXT = 0x8254,
  eGL_UNKNOWN_CONTEXT_RESET_EXT = 0x8255,
  eGL_CONTEXT_ROBUST_ACCESS_EXT = 0x90F3,
  eGL_RESET_NOTIFICATION_STRATEGY_EXT = 0x8256,
  eGL_LOSE_CONTEXT_ON_RESET_EXT = 0x8252,
  eGL_NO_RESET_NOTIFICATION_EXT = 0x8261,
  eGL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT = 0x8210,
  eGL_ACTIVE_PROGRAM_EXT = 0x8259,
  eGL_VERTEX_SHADER_BIT_EXT = 0x00000001,
  eGL_FRAGMENT_SHADER_BIT_EXT = 0x00000002,
  eGL_ALL_SHADER_BITS_EXT = 0xFFFFFFFF,
  eGL_PROGRAM_SEPARABLE_EXT = 0x8258,
  eGL_PROGRAM_PIPELINE_BINDING_EXT = 0x825A,
  eGL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = 0x8A52,
  eGL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT = 0x8F63,
  eGL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT = 0x8F67,
  eGL_SHADER_PIXEL_LOCAL_STORAGE_EXT = 0x8F64,
  eGL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT = 0x9650,
  eGL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT = 0x9651,
  eGL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT = 0x9652,
  eGL_TEXTURE_COMPARE_MODE_EXT = 0x884C,
  eGL_TEXTURE_COMPARE_FUNC_EXT = 0x884D,
  eGL_COMPARE_REF_TO_TEXTURE_EXT = 0x884E,
  eGL_SAMPLER_2D_SHADOW_EXT = 0x8B62,
  eGL_TEXTURE_SPARSE_EXT = 0x91A6,
  eGL_VIRTUAL_PAGE_SIZE_INDEX_EXT = 0x91A7,
  eGL_NUM_SPARSE_LEVELS_EXT = 0x91AA,
  eGL_NUM_VIRTUAL_PAGE_SIZES_EXT = 0x91A8,
  eGL_VIRTUAL_PAGE_SIZE_X_EXT = 0x9195,
  eGL_VIRTUAL_PAGE_SIZE_Y_EXT = 0x9196,
  eGL_VIRTUAL_PAGE_SIZE_Z_EXT = 0x9197,
  eGL_MAX_SPARSE_TEXTURE_SIZE_EXT = 0x9198,
  eGL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT = 0x9199,
  eGL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT = 0x919A,
  eGL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT = 0x91A9,
  eGL_PATCHES_EXT = 0x000E,
  eGL_PATCH_VERTICES_EXT = 0x8E72,
  eGL_TESS_CONTROL_OUTPUT_VERTICES_EXT = 0x8E75,
  eGL_TESS_GEN_MODE_EXT = 0x8E76,
  eGL_TESS_GEN_SPACING_EXT = 0x8E77,
  eGL_TESS_GEN_VERTEX_ORDER_EXT = 0x8E78,
  eGL_TESS_GEN_POINT_MODE_EXT = 0x8E79,
  eGL_ISOLINES_EXT = 0x8E7A,
  eGL_QUADS_EXT = 0x0007,
  eGL_FRACTIONAL_ODD_EXT = 0x8E7B,
  eGL_FRACTIONAL_EVEN_EXT = 0x8E7C,
  eGL_MAX_PATCH_VERTICES_EXT = 0x8E7D,
  eGL_MAX_TESS_GEN_LEVEL_EXT = 0x8E7E,
  eGL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E7F,
  eGL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E80,
  eGL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT = 0x8E81,
  eGL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT = 0x8E82,
  eGL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT = 0x8E83,
  eGL_MAX_TESS_PATCH_COMPONENTS_EXT = 0x8E84,
  eGL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8E85,
  eGL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT = 0x8E86,
  eGL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT = 0x8E89,
  eGL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT = 0x8E8A,
  eGL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT = 0x886C,
  eGL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT = 0x886D,
  eGL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = 0x8E1E,
  eGL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = 0x8E1F,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CD,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT = 0x92CE,
  eGL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT = 0x92D3,
  eGL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT = 0x92D4,
  eGL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT = 0x90CB,
  eGL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT = 0x90CC,
  eGL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT = 0x90D8,
  eGL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT = 0x90D9,
  eGL_IS_PER_PATCH_EXT = 0x92E7,
  eGL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT = 0x9307,
  eGL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT = 0x9308,
  eGL_TESS_CONTROL_SHADER_EXT = 0x8E88,
  eGL_TESS_EVALUATION_SHADER_EXT = 0x8E87,
  eGL_TESS_CONTROL_SHADER_BIT_EXT = 0x00000008,
  eGL_TESS_EVALUATION_SHADER_BIT_EXT = 0x00000010,
  eGL_TEXTURE_BORDER_COLOR_EXT = 0x1004,
  eGL_CLAMP_TO_BORDER_EXT = 0x812D,
  eGL_TEXTURE_BUFFER_BINDING_EXT = 0x8C2A,
  eGL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT = 0x919F,
  eGL_TEXTURE_BUFFER_OFFSET_EXT = 0x919D,
  eGL_TEXTURE_BUFFER_SIZE_EXT = 0x919E,
  eGL_TEXTURE_ASTC_DECODE_PRECISION_EXT = 0x8F69,
  eGL_COMPRESSED_RGBA_BPTC_UNORM_EXT = 0x8E8C,
  eGL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT = 0x8E8D,
  eGL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT = 0x8E8E,
  eGL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT = 0x8E8F,
  eGL_TEXTURE_CUBE_MAP_ARRAY_EXT = 0x9009,
  eGL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT = 0x900A,
  eGL_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900C,
  eGL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT = 0x900D,
  eGL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900E,
  eGL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = 0x900F,
  eGL_R16_EXT = 0x822A,
  eGL_RG16_EXT = 0x822C,
  eGL_RGB16_SNORM_EXT = 0x8F9A,
  eGL_RED_EXT = 0x1903,
  eGL_RG_EXT = 0x8227,
  eGL_R8_EXT = 0x8229,
  eGL_RG8_EXT = 0x822B,
  eGL_SR8_EXT = 0x8FBD,
  eGL_SRG8_EXT = 0x8FBE,
  eGL_TEXTURE_IMMUTABLE_FORMAT_EXT = 0x912F,
  eGL_RGBA32F_EXT = 0x8814,
  eGL_RGB32F_EXT = 0x8815,
  eGL_ALPHA32F_EXT = 0x8816,
  eGL_LUMINANCE32F_EXT = 0x8818,
  eGL_LUMINANCE_ALPHA32F_EXT = 0x8819,
  eGL_ALPHA16F_EXT = 0x881C,
  eGL_LUMINANCE16F_EXT = 0x881E,
  eGL_LUMINANCE_ALPHA16F_EXT = 0x881F,
  eGL_R32F_EXT = 0x822E,
  eGL_RG32F_EXT = 0x8230,
  eGL_UNSIGNED_INT_2_10_10_10_REV_EXT = 0x8368,
  eGL_TEXTURE_VIEW_MIN_LEVEL_EXT = 0x82DB,
  eGL_TEXTURE_VIEW_NUM_LEVELS_EXT = 0x82DC,
  eGL_TEXTURE_VIEW_MIN_LAYER_EXT = 0x82DD,
  eGL_TEXTURE_VIEW_NUM_LAYERS_EXT = 0x82DE,
  eGL_UNPACK_ROW_LENGTH_EXT = 0x0CF2,
  eGL_UNPACK_SKIP_ROWS_EXT = 0x0CF3,
  eGL_UNPACK_SKIP_PIXELS_EXT = 0x0CF4,
  eGL_GCCSO_SHADER_BINARY_FJ = 0x9260,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG = 0x913C,
  eGL_NUM_DOWNSAMPLE_SCALES_IMG = 0x913D,
  eGL_DOWNSAMPLE_SCALES_IMG = 0x913E,
  eGL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG = 0x913F,
  eGL_RENDERBUFFER_SAMPLES_IMG = 0x9133,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG = 0x9134,
  eGL_MAX_SAMPLES_IMG = 0x9135,
  eGL_TEXTURE_SAMPLES_IMG = 0x9136,
  eGL_SGX_PROGRAM_BINARY_IMG = 0x9130,
  eGL_BGRA_IMG = 0x80E1,
  eGL_UNSIGNED_SHORT_4_4_4_4_REV_IMG = 0x8365,
  eGL_SGX_BINARY_IMG = 0x8C0A,
  eGL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00,
  eGL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01,
  eGL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02,
  eGL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03,
  eGL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG = 0x9137,
  eGL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG = 0x9138,
  eGL_CUBIC_IMG = 0x9139,
  eGL_CUBIC_MIPMAP_NEAREST_IMG = 0x913A,
  eGL_CUBIC_MIPMAP_LINEAR_IMG = 0x913B,
  eGL_COPY_READ_BUFFER_NV = 0x8F36,
  eGL_COPY_WRITE_BUFFER_NV = 0x8F37,
  eGL_COVERAGE_COMPONENT_NV = 0x8ED0,
  eGL_COVERAGE_COMPONENT4_NV = 0x8ED1,
  eGL_COVERAGE_ATTACHMENT_NV = 0x8ED2,
  eGL_COVERAGE_BUFFERS_NV = 0x8ED3,
  eGL_COVERAGE_SAMPLES_NV = 0x8ED4,
  eGL_COVERAGE_ALL_FRAGMENTS_NV = 0x8ED5,
  eGL_COVERAGE_EDGE_FRAGMENTS_NV = 0x8ED6,
  eGL_COVERAGE_AUTOMATIC_NV = 0x8ED7,
  eGL_COVERAGE_BUFFER_BIT_NV = 0x00008000,
  eGL_DEPTH_COMPONENT16_NONLINEAR_NV = 0x8E2C,
  eGL_MAX_DRAW_BUFFERS_NV = 0x8824,
  eGL_DRAW_BUFFER0_NV = 0x8825,
  eGL_DRAW_BUFFER1_NV = 0x8826,
  eGL_DRAW_BUFFER2_NV = 0x8827,
  eGL_DRAW_BUFFER3_NV = 0x8828,
  eGL_DRAW_BUFFER4_NV = 0x8829,
  eGL_DRAW_BUFFER5_NV = 0x882A,
  eGL_DRAW_BUFFER6_NV = 0x882B,
  eGL_DRAW_BUFFER7_NV = 0x882C,
  eGL_DRAW_BUFFER8_NV = 0x882D,
  eGL_DRAW_BUFFER9_NV = 0x882E,
  eGL_DRAW_BUFFER10_NV = 0x882F,
  eGL_DRAW_BUFFER11_NV = 0x8830,
  eGL_DRAW_BUFFER12_NV = 0x8831,
  eGL_DRAW_BUFFER13_NV = 0x8832,
  eGL_DRAW_BUFFER14_NV = 0x8833,
  eGL_DRAW_BUFFER15_NV = 0x8834,
  eGL_COLOR_ATTACHMENT0_NV = 0x8CE0,
  eGL_COLOR_ATTACHMENT1_NV = 0x8CE1,
  eGL_COLOR_ATTACHMENT2_NV = 0x8CE2,
  eGL_COLOR_ATTACHMENT3_NV = 0x8CE3,
  eGL_COLOR_ATTACHMENT4_NV = 0x8CE4,
  eGL_COLOR_ATTACHMENT5_NV = 0x8CE5,
  eGL_COLOR_ATTACHMENT6_NV = 0x8CE6,
  eGL_COLOR_ATTACHMENT7_NV = 0x8CE7,
  eGL_COLOR_ATTACHMENT8_NV = 0x8CE8,
  eGL_COLOR_ATTACHMENT9_NV = 0x8CE9,
  eGL_COLOR_ATTACHMENT10_NV = 0x8CEA,
  eGL_COLOR_ATTACHMENT11_NV = 0x8CEB,
  eGL_COLOR_ATTACHMENT12_NV = 0x8CEC,
  eGL_COLOR_ATTACHMENT13_NV = 0x8CED,
  eGL_COLOR_ATTACHMENT14_NV = 0x8CEE,
  eGL_COLOR_ATTACHMENT15_NV = 0x8CEF,
  eGL_MAX_COLOR_ATTACHMENTS_NV = 0x8CDF,
  eGL_READ_FRAMEBUFFER_NV = 0x8CA8,
  eGL_DRAW_FRAMEBUFFER_NV = 0x8CA9,
  eGL_DRAW_FRAMEBUFFER_BINDING_NV = 0x8CA6,
  eGL_READ_FRAMEBUFFER_BINDING_NV = 0x8CAA,
  eGL_RENDERBUFFER_SAMPLES_NV = 0x8CAB,
  eGL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV = 0x8D56,
  eGL_MAX_SAMPLES_NV = 0x8D57,
  eGL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV = 0x88FE,
  eGL_FLOAT_MAT2x3_NV = 0x8B65,
  eGL_FLOAT_MAT2x4_NV = 0x8B66,
  eGL_FLOAT_MAT3x2_NV = 0x8B67,
  eGL_FLOAT_MAT3x4_NV = 0x8B68,
  eGL_FLOAT_MAT4x2_NV = 0x8B69,
  eGL_FLOAT_MAT4x3_NV = 0x8B6A,
  eGL_PIXEL_PACK_BUFFER_NV = 0x88EB,
  eGL_PIXEL_UNPACK_BUFFER_NV = 0x88EC,
  eGL_PIXEL_PACK_BUFFER_BINDING_NV = 0x88ED,
  eGL_PIXEL_UNPACK_BUFFER_BINDING_NV = 0x88EF,
  eGL_POLYGON_MODE_NV = 0x0B40,
  eGL_POLYGON_OFFSET_POINT_NV = 0x2A01,
  eGL_POLYGON_OFFSET_LINE_NV = 0x2A02,
  eGL_POINT_NV = 0x1B00,
  eGL_LINE_NV = 0x1B01,
  eGL_FILL_NV = 0x1B02,
  eGL_READ_BUFFER_NV = 0x0C02,
  eGL_SLUMINANCE_NV = 0x8C46,
  eGL_SLUMINANCE_ALPHA_NV = 0x8C44,
  eGL_SRGB8_NV = 0x8C41,
  eGL_SLUMINANCE8_NV = 0x8C47,
  eGL_SLUMINANCE8_ALPHA8_NV = 0x8C45,
  eGL_COMPRESSED_SRGB_S3TC_DXT1_NV = 0x8C4C,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV = 0x8C4D,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV = 0x8C4E,
  eGL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV = 0x8C4F,
  eGL_ETC1_SRGB8_NV = 0x88EE,
  eGL_SAMPLER_2D_ARRAY_SHADOW_NV = 0x8DC4,
  eGL_SAMPLER_CUBE_SHADOW_NV = 0x8DC5,
  eGL_TEXTURE_BORDER_COLOR_NV = 0x1004,
  eGL_CLAMP_TO_BORDER_NV = 0x812D,
  eGL_MAX_VIEWPORTS_NV = 0x825B,
  eGL_VIEWPORT_SUBPIXEL_BITS_NV = 0x825C,
  eGL_VIEWPORT_BOUNDS_RANGE_NV = 0x825D,
  eGL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 0x825F,
  eGL_ALPHA_TEST_QCOM = 0x0BC0,
  eGL_ALPHA_TEST_FUNC_QCOM = 0x0BC1,
  eGL_ALPHA_TEST_REF_QCOM = 0x0BC2,
  eGL_BINNING_CONTROL_HINT_QCOM = 0x8FB0,
  eGL_CPU_OPTIMIZED_QCOM = 0x8FB1,
  eGL_GPU_OPTIMIZED_QCOM = 0x8FB2,
  eGL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM = 0x8FB3,
  eGL_TEXTURE_WIDTH_QCOM = 0x8BD2,
  eGL_TEXTURE_HEIGHT_QCOM = 0x8BD3,
  eGL_TEXTURE_DEPTH_QCOM = 0x8BD4,
  eGL_TEXTURE_INTERNAL_FORMAT_QCOM = 0x8BD5,
  eGL_TEXTURE_FORMAT_QCOM = 0x8BD6,
  eGL_TEXTURE_TYPE_QCOM = 0x8BD7,
  eGL_TEXTURE_IMAGE_VALID_QCOM = 0x8BD8,
  eGL_TEXTURE_NUM_LEVELS_QCOM = 0x8BD9,
  eGL_TEXTURE_TARGET_QCOM = 0x8BDA,
  eGL_TEXTURE_OBJECT_VALID_QCOM = 0x8BDB,
  eGL_STATE_RESTORE = 0x8BDC,
  eGL_FOVEATION_ENABLE_BIT_QCOM = 0x00000001,
  eGL_FOVEATION_SCALED_BIN_METHOD_BIT_QCOM = 0x00000002,
  eGL_PERFMON_GLOBAL_MODE_QCOM = 0x8FA0,
  eGL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM = 0x96A2,
  eGL_TEXTURE_FOVEATED_FEATURE_BITS_QCOM = 0x8BFB,
  eGL_TEXTURE_FOVEATED_MIN_PIXEL_DENSITY_QCOM = 0x8BFC,
  eGL_TEXTURE_FOVEATED_FEATURE_QUERY_QCOM = 0x8BFD,
  eGL_TEXTURE_FOVEATED_NUM_FOCAL_POINTS_QUERY_QCOM = 0x8BFE,
  eGL_FRAMEBUFFER_INCOMPLETE_FOVEATION_QCOM = 0x8BFF,
  eGL_COLOR_BUFFER_BIT0_QCOM = 0x00000001,
  eGL_COLOR_BUFFER_BIT1_QCOM = 0x00000002,
  eGL_COLOR_BUFFER_BIT2_QCOM = 0x00000004,
  eGL_COLOR_BUFFER_BIT3_QCOM = 0x00000008,
  eGL_COLOR_BUFFER_BIT4_QCOM = 0x00000010,
  eGL_COLOR_BUFFER_BIT5_QCOM = 0x00000020,
  eGL_COLOR_BUFFER_BIT6_QCOM = 0x00000040,
  eGL_COLOR_BUFFER_BIT7_QCOM = 0x00000080,
  eGL_DEPTH_BUFFER_BIT0_QCOM = 0x00000100,
  eGL_DEPTH_BUFFER_BIT1_QCOM = 0x00000200,
  eGL_DEPTH_BUFFER_BIT2_QCOM = 0x00000400,
  eGL_DEPTH_BUFFER_BIT3_QCOM = 0x00000800,
  eGL_DEPTH_BUFFER_BIT4_QCOM = 0x00001000,
  eGL_DEPTH_BUFFER_BIT5_QCOM = 0x00002000,
  eGL_DEPTH_BUFFER_BIT6_QCOM = 0x00004000,
  eGL_DEPTH_BUFFER_BIT7_QCOM = 0x00008000,
  eGL_STENCIL_BUFFER_BIT0_QCOM = 0x00010000,
  eGL_STENCIL_BUFFER_BIT1_QCOM = 0x00020000,
  eGL_STENCIL_BUFFER_BIT2_QCOM = 0x00040000,
  eGL_STENCIL_BUFFER_BIT3_QCOM = 0x00080000,
  eGL_STENCIL_BUFFER_BIT4_QCOM = 0x00100000,
  eGL_STENCIL_BUFFER_BIT5_QCOM = 0x00200000,
  eGL_STENCIL_BUFFER_BIT6_QCOM = 0x00400000,
  eGL_STENCIL_BUFFER_BIT7_QCOM = 0x00800000,
  eGL_MULTISAMPLE_BUFFER_BIT0_QCOM = 0x01000000,
  eGL_MULTISAMPLE_BUFFER_BIT1_QCOM = 0x02000000,
  eGL_MULTISAMPLE_BUFFER_BIT2_QCOM = 0x04000000,
  eGL_MULTISAMPLE_BUFFER_BIT3_QCOM = 0x08000000,
  eGL_MULTISAMPLE_BUFFER_BIT4_QCOM = 0x10000000,
  eGL_MULTISAMPLE_BUFFER_BIT5_QCOM = 0x20000000,
  eGL_MULTISAMPLE_BUFFER_BIT6_QCOM = 0x40000000,
  eGL_MULTISAMPLE_BUFFER_BIT7_QCOM = 0x80000000,
  eGL_WRITEONLY_RENDERING_QCOM = 0x8823,
  eGL_SHADER_BINARY_VIV = 0x8FC4,
  eEGL_ALPHA_SIZE = 0x3021,
  eEGL_BAD_ACCESS = 0x3002,
  eEGL_BAD_ALLOC = 0x3003,
  eEGL_BAD_ATTRIBUTE = 0x3004,
  eEGL_BAD_CONFIG = 0x3005,
  eEGL_BAD_CONTEXT = 0x3006,
  eEGL_BAD_CURRENT_SURFACE = 0x3007,
  eEGL_BAD_DISPLAY = 0x3008,
  eEGL_BAD_MATCH = 0x3009,
  eEGL_BAD_NATIVE_PIXMAP = 0x300A,
  eEGL_BAD_NATIVE_WINDOW = 0x300B,
  eEGL_BAD_PARAMETER = 0x300C,
  eEGL_BAD_SURFACE = 0x300D,
  eEGL_BLUE_SIZE = 0x3022,
  eEGL_BUFFER_SIZE = 0x3020,
  eEGL_CONFIG_CAVEAT = 0x3027,
  eEGL_CONFIG_ID = 0x3028,
  eEGL_CORE_NATIVE_ENGINE = 0x305B,
  eEGL_DEPTH_SIZE = 0x3025,
  eEGL_DRAW = 0x3059,
  eEGL_EXTENSIONS = 0x3055,
  eEGL_GREEN_SIZE = 0x3023,
  eEGL_HEIGHT = 0x3056,
  eEGL_LARGEST_PBUFFER = 0x3058,
  eEGL_LEVEL = 0x3029,
  eEGL_MAX_PBUFFER_HEIGHT = 0x302A,
  eEGL_MAX_PBUFFER_PIXELS = 0x302B,
  eEGL_MAX_PBUFFER_WIDTH = 0x302C,
  eEGL_NATIVE_RENDERABLE = 0x302D,
  eEGL_NATIVE_VISUAL_ID = 0x302E,
  eEGL_NATIVE_VISUAL_TYPE = 0x302F,
  eEGL_NONE = 0x3038,
  eEGL_NON_CONFORMANT_CONFIG = 0x3051,
  eEGL_NOT_INITIALIZED = 0x3001,
  eEGL_PBUFFER_BIT = 0x0001,
  eEGL_PIXMAP_BIT = 0x0002,
  eEGL_READ = 0x305A,
  eEGL_RED_SIZE = 0x3024,
  eEGL_SAMPLES = 0x3031,
  eEGL_SAMPLE_BUFFERS = 0x3032,
  eEGL_SLOW_CONFIG = 0x3050,
  eEGL_STENCIL_SIZE = 0x3026,
  eEGL_SUCCESS = 0x3000,
  eEGL_SURFACE_TYPE = 0x3033,
  eEGL_TRANSPARENT_BLUE_VALUE = 0x3035,
  eEGL_TRANSPARENT_GREEN_VALUE = 0x3036,
  eEGL_TRANSPARENT_RED_VALUE = 0x3037,
  eEGL_TRANSPARENT_RGB = 0x3052,
  eEGL_TRANSPARENT_TYPE = 0x3034,
  eEGL_VENDOR = 0x3053,
  eEGL_VERSION = 0x3054,
  eEGL_WIDTH = 0x3057,
  eEGL_WINDOW_BIT = 0x0004,
  eEGL_BACK_BUFFER = 0x3084,
  eEGL_BIND_TO_TEXTURE_RGB = 0x3039,
  eEGL_BIND_TO_TEXTURE_RGBA = 0x303A,
  eEGL_CONTEXT_LOST = 0x300E,
  eEGL_MIN_SWAP_INTERVAL = 0x303B,
  eEGL_MAX_SWAP_INTERVAL = 0x303C,
  eEGL_MIPMAP_TEXTURE = 0x3082,
  eEGL_MIPMAP_LEVEL = 0x3083,
  eEGL_NO_TEXTURE = 0x305C,
  eEGL_TEXTURE_2D = 0x305F,
  eEGL_TEXTURE_FORMAT = 0x3080,
  eEGL_TEXTURE_RGB = 0x305D,
  eEGL_TEXTURE_RGBA = 0x305E,
  eEGL_TEXTURE_TARGET = 0x3081,
  eEGL_ALPHA_FORMAT = 0x3088,
  eEGL_ALPHA_FORMAT_NONPRE = 0x308B,
  eEGL_ALPHA_FORMAT_PRE = 0x308C,
  eEGL_ALPHA_MASK_SIZE = 0x303E,
  eEGL_BUFFER_PRESERVED = 0x3094,
  eEGL_BUFFER_DESTROYED = 0x3095,
  eEGL_CLIENT_APIS = 0x308D,
  eEGL_COLORSPACE = 0x3087,
  eEGL_COLORSPACE_sRGB = 0x3089,
  eEGL_COLORSPACE_LINEAR = 0x308A,
  eEGL_COLOR_BUFFER_TYPE = 0x303F,
  eEGL_CONTEXT_CLIENT_TYPE = 0x3097,
  eEGL_HORIZONTAL_RESOLUTION = 0x3090,
  eEGL_LUMINANCE_BUFFER = 0x308F,
  eEGL_LUMINANCE_SIZE = 0x303D,
  eEGL_OPENGL_ES_BIT = 0x0001,
  eEGL_OPENVG_BIT = 0x0002,
  eEGL_OPENGL_ES_API = 0x30A0,
  eEGL_OPENVG_API = 0x30A1,
  eEGL_OPENVG_IMAGE = 0x3096,
  eEGL_PIXEL_ASPECT_RATIO = 0x3092,
  eEGL_RENDERABLE_TYPE = 0x3040,
  eEGL_RENDER_BUFFER = 0x3086,
  eEGL_RGB_BUFFER = 0x308E,
  eEGL_SINGLE_BUFFER = 0x3085,
  eEGL_SWAP_BEHAVIOR = 0x3093,
  eEGL_VERTICAL_RESOLUTION = 0x3091,
  eEGL_CONFORMANT = 0x3042,
  eEGL_CONTEXT_CLIENT_VERSION = 0x3098,
  eEGL_MATCH_NATIVE_PIXMAP = 0x3041,
  eEGL_OPENGL_ES2_BIT = 0x0004,
  eEGL_VG_ALPHA_FORMAT = 0x3088,
  eEGL_VG_ALPHA_FORMAT_NONPRE = 0x308B,
  eEGL_VG_ALPHA_FORMAT_PRE = 0x308C,
  eEGL_VG_ALPHA_FORMAT_PRE_BIT = 0x0040,
  eEGL_VG_COLORSPACE = 0x3087,
  eEGL_VG_COLORSPACE_sRGB = 0x3089,
  eEGL_VG_COLORSPACE_LINEAR = 0x308A,
  eEGL_VG_COLORSPACE_LINEAR_BIT = 0x0020,
  eEGL_MULTISAMPLE_RESOLVE_BOX_BIT = 0x0200,
  eEGL_MULTISAMPLE_RESOLVE = 0x3099,
  eEGL_MULTISAMPLE_RESOLVE_DEFAULT = 0x309A,
  eEGL_MULTISAMPLE_RESOLVE_BOX = 0x309B,
  eEGL_OPENGL_API = 0x30A2,
  eEGL_OPENGL_BIT = 0x0008,
  eEGL_SWAP_BEHAVIOR_PRESERVED_BIT = 0x0400,
  eEGL_CONTEXT_MAJOR_VERSION = 0x3098,
  eEGL_CONTEXT_MINOR_VERSION = 0x30FB,
  eEGL_CONTEXT_OPENGL_PROFILE_MASK = 0x30FD,
  eEGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY = 0x31BD,
  eEGL_NO_RESET_NOTIFICATION = 0x31BE,
  eEGL_LOSE_CONTEXT_ON_RESET = 0x31BF,
  eEGL_CONTEXT_OPENGL_CORE_PROFILE_BIT = 0x00000001,
  eEGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT = 0x00000002,
  eEGL_CONTEXT_OPENGL_DEBUG = 0x31B0,
  eEGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE = 0x31B1,
  eEGL_CONTEXT_OPENGL_ROBUST_ACCESS = 0x31B2,
  eEGL_OPENGL_ES3_BIT = 0x00000040,
  eEGL_CL_EVENT_HANDLE = 0x309C,
  eEGL_SYNC_CL_EVENT = 0x30FE,
  eEGL_SYNC_CL_EVENT_COMPLETE = 0x30FF,
  eEGL_SYNC_PRIOR_COMMANDS_COMPLETE = 0x30F0,
  eEGL_SYNC_TYPE = 0x30F7,
  eEGL_SYNC_STATUS = 0x30F1,
  eEGL_SYNC_CONDITION = 0x30F8,
  eEGL_SIGNALED = 0x30F2,
  eEGL_UNSIGNALED = 0x30F3,
  eEGL_SYNC_FLUSH_COMMANDS_BIT = 0x0001,
  eEGL_TIMEOUT_EXPIRED = 0x30F5,
  eEGL_CONDITION_SATISFIED = 0x30F6,
  eEGL_SYNC_FENCE = 0x30F9,
  eEGL_GL_COLORSPACE = 0x309D,
  eEGL_GL_COLORSPACE_SRGB = 0x3089,
  eEGL_GL_COLORSPACE_LINEAR = 0x308A,
  eEGL_GL_RENDERBUFFER = 0x30B9,
  eEGL_GL_TEXTURE_2D = 0x30B1,
  eEGL_GL_TEXTURE_LEVEL = 0x30BC,
  eEGL_GL_TEXTURE_3D = 0x30B2,
  eEGL_GL_TEXTURE_ZOFFSET = 0x30BD,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x30B3,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x30B4,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x30B5,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x30B6,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x30B7,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x30B8,
  eEGL_IMAGE_PRESERVED = 0x30D2,
  eEGL_CL_EVENT_HANDLE_KHR = 0x309C,
  eEGL_SYNC_CL_EVENT_KHR = 0x30FE,
  eEGL_SYNC_CL_EVENT_COMPLETE_KHR = 0x30FF,
  eEGL_CONFORMANT_KHR = 0x3042,
  eEGL_VG_COLORSPACE_LINEAR_BIT_KHR = 0x0020,
  eEGL_VG_ALPHA_FORMAT_PRE_BIT_KHR = 0x0040,
  eEGL_CONTEXT_RELEASE_BEHAVIOR_KHR = 0x2097,
  eEGL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = 0x2098,
  eEGL_CONTEXT_MAJOR_VERSION_KHR = 0x3098,
  eEGL_CONTEXT_MINOR_VERSION_KHR = 0x30FB,
  eEGL_CONTEXT_FLAGS_KHR = 0x30FC,
  eEGL_CONTEXT_OPENGL_PROFILE_MASK_KHR = 0x30FD,
  eEGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY_KHR = 0x31BD,
  eEGL_NO_RESET_NOTIFICATION_KHR = 0x31BE,
  eEGL_LOSE_CONTEXT_ON_RESET_KHR = 0x31BF,
  eEGL_CONTEXT_OPENGL_DEBUG_BIT_KHR = 0x00000001,
  eEGL_CONTEXT_OPENGL_FORWARD_COMPATIBLE_BIT_KHR = 0x00000002,
  eEGL_CONTEXT_OPENGL_ROBUST_ACCESS_BIT_KHR = 0x00000004,
  eEGL_CONTEXT_OPENGL_CORE_PROFILE_BIT_KHR = 0x00000001,
  eEGL_CONTEXT_OPENGL_COMPATIBILITY_PROFILE_BIT_KHR = 0x00000002,
  eEGL_OPENGL_ES3_BIT_KHR = 0x00000040,
  eEGL_CONTEXT_OPENGL_NO_ERROR_KHR = 0x31B3,
  eEGL_OBJECT_THREAD_KHR = 0x33B0,
  eEGL_OBJECT_DISPLAY_KHR = 0x33B1,
  eEGL_OBJECT_CONTEXT_KHR = 0x33B2,
  eEGL_OBJECT_SURFACE_KHR = 0x33B3,
  eEGL_OBJECT_IMAGE_KHR = 0x33B4,
  eEGL_OBJECT_SYNC_KHR = 0x33B5,
  eEGL_OBJECT_STREAM_KHR = 0x33B6,
  eEGL_DEBUG_MSG_CRITICAL_KHR = 0x33B9,
  eEGL_DEBUG_MSG_ERROR_KHR = 0x33BA,
  eEGL_DEBUG_MSG_WARN_KHR = 0x33BB,
  eEGL_DEBUG_MSG_INFO_KHR = 0x33BC,
  eEGL_DEBUG_CALLBACK_KHR = 0x33B8,
  eEGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR = 0x30F0,
  eEGL_SYNC_CONDITION_KHR = 0x30F8,
  eEGL_SYNC_FENCE_KHR = 0x30F9,
  eEGL_GL_COLORSPACE_KHR = 0x309D,
  eEGL_GL_COLORSPACE_SRGB_KHR = 0x3089,
  eEGL_GL_COLORSPACE_LINEAR_KHR = 0x308A,
  eEGL_GL_RENDERBUFFER_KHR = 0x30B9,
  eEGL_GL_TEXTURE_2D_KHR = 0x30B1,
  eEGL_GL_TEXTURE_LEVEL_KHR = 0x30BC,
  eEGL_GL_TEXTURE_3D_KHR = 0x30B2,
  eEGL_GL_TEXTURE_ZOFFSET_KHR = 0x30BD,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR = 0x30B3,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR = 0x30B4,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR = 0x30B5,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR = 0x30B6,
  eEGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR = 0x30B7,
  eEGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR = 0x30B8,
  eEGL_NATIVE_PIXMAP_KHR = 0x30B0,
  eEGL_IMAGE_PRESERVED_KHR = 0x30D2,
  eEGL_READ_SURFACE_BIT_KHR = 0x0001,
  eEGL_WRITE_SURFACE_BIT_KHR = 0x0002,
  eEGL_LOCK_SURFACE_BIT_KHR = 0x0080,
  eEGL_OPTIMAL_FORMAT_BIT_KHR = 0x0100,
  eEGL_MATCH_FORMAT_KHR = 0x3043,
  eEGL_FORMAT_RGB_565_EXACT_KHR = 0x30C0,
  eEGL_FORMAT_RGB_565_KHR = 0x30C1,
  eEGL_FORMAT_RGBA_8888_EXACT_KHR = 0x30C2,
  eEGL_FORMAT_RGBA_8888_KHR = 0x30C3,
  eEGL_MAP_PRESERVE_PIXELS_KHR = 0x30C4,
  eEGL_LOCK_USAGE_HINT_KHR = 0x30C5,
  eEGL_BITMAP_POINTER_KHR = 0x30C6,
  eEGL_BITMAP_PITCH_KHR = 0x30C7,
  eEGL_BITMAP_ORIGIN_KHR = 0x30C8,
  eEGL_BITMAP_PIXEL_RED_OFFSET_KHR = 0x30C9,
  eEGL_BITMAP_PIXEL_GREEN_OFFSET_KHR = 0x30CA,
  eEGL_BITMAP_PIXEL_BLUE_OFFSET_KHR = 0x30CB,
  eEGL_BITMAP_PIXEL_ALPHA_OFFSET_KHR = 0x30CC,
  eEGL_BITMAP_PIXEL_LUMINANCE_OFFSET_KHR = 0x30CD,
  eEGL_LOWER_LEFT_KHR = 0x30CE,
  eEGL_UPPER_LEFT_KHR = 0x30CF,
  eEGL_BITMAP_PIXEL_SIZE_KHR = 0x3110,
  eEGL_MUTABLE_RENDER_BUFFER_BIT_KHR = 0x1000,
  eEGL_BUFFER_AGE_KHR = 0x313D,
  eEGL_PLATFORM_ANDROID_KHR = 0x3141,
  eEGL_PLATFORM_GBM_KHR = 0x31D7,
  eEGL_PLATFORM_WAYLAND_KHR = 0x31D8,
  eEGL_PLATFORM_X11_KHR = 0x31D5,
  eEGL_PLATFORM_X11_SCREEN_KHR = 0x31D6,
  eEGL_SYNC_STATUS_KHR = 0x30F1,
  eEGL_SIGNALED_KHR = 0x30F2,
  eEGL_UNSIGNALED_KHR = 0x30F3,
  eEGL_TIMEOUT_EXPIRED_KHR = 0x30F5,
  eEGL_CONDITION_SATISFIED_KHR = 0x30F6,
  eEGL_SYNC_TYPE_KHR = 0x30F7,
  eEGL_SYNC_REUSABLE_KHR = 0x30FA,
  eEGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 0x0001,
  eEGL_CONSUMER_LATENCY_USEC_KHR = 0x3210,
  eEGL_PRODUCER_FRAME_KHR = 0x3212,
  eEGL_CONSUMER_FRAME_KHR = 0x3213,
  eEGL_STREAM_STATE_KHR = 0x3214,
  eEGL_STREAM_STATE_CREATED_KHR = 0x3215,
  eEGL_STREAM_STATE_CONNECTING_KHR = 0x3216,
  eEGL_STREAM_STATE_EMPTY_KHR = 0x3217,
  eEGL_STREAM_STATE_NEW_FRAME_AVAILABLE_KHR = 0x3218,
  eEGL_STREAM_STATE_OLD_FRAME_AVAILABLE_KHR = 0x3219,
  eEGL_STREAM_STATE_DISCONNECTED_KHR = 0x321A,
  eEGL_BAD_STREAM_KHR = 0x321B,
  eEGL_BAD_STATE_KHR = 0x321C,
  eEGL_CONSUMER_ACQUIRE_TIMEOUT_USEC_KHR = 0x321E,
  eEGL_STREAM_FIFO_LENGTH_KHR = 0x31FC,
  eEGL_STREAM_TIME_NOW_KHR = 0x31FD,
  eEGL_STREAM_TIME_CONSUMER_KHR = 0x31FE,
  eEGL_STREAM_TIME_PRODUCER_KHR = 0x31FF,
  eEGL_STREAM_BIT_KHR = 0x0800,
  eEGL_VG_PARENT_IMAGE_KHR = 0x30BA,
  eEGL_NATIVE_BUFFER_USAGE_ANDROID = 0x3143,
  eEGL_NATIVE_BUFFER_USAGE_PROTECTED_BIT_ANDROID = 0x00000001,
  eEGL_NATIVE_BUFFER_USAGE_RENDERBUFFER_BIT_ANDROID = 0x00000002,
  eEGL_NATIVE_BUFFER_USAGE_TEXTURE_BIT_ANDROID = 0x00000004,
  eEGL_FRAMEBUFFER_TARGET_ANDROID = 0x3147,
  eEGL_FRONT_BUFFER_AUTO_REFRESH_ANDROID = 0x314C,
  eEGL_NATIVE_BUFFER_ANDROID = 0x3140,
  eEGL_SYNC_NATIVE_FENCE_ANDROID = 0x3144,
  eEGL_SYNC_NATIVE_FENCE_FD_ANDROID = 0x3145,
  eEGL_SYNC_NATIVE_FENCE_SIGNALED_ANDROID = 0x3146,
  eEGL_RECORDABLE_ANDROID = 0x3142,
  eEGL_D3D_TEXTURE_2D_SHARE_HANDLE_ANGLE = 0x3200,
  eEGL_D3D9_DEVICE_ANGLE = 0x33A0,
  eEGL_D3D11_DEVICE_ANGLE = 0x33A1,
  eEGL_FIXED_SIZE_ANGLE = 0x3201,
  eEGL_SYNC_PRIOR_COMMANDS_IMPLICIT_EXTERNAL_ARM = 0x328A,
  eEGL_DISCARD_SAMPLES_ARM = 0x3286,
  eEGL_BUFFER_AGE_EXT = 0x313D,
  eEGL_PRIMARY_COMPOSITOR_CONTEXT_EXT = 0x3460,
  eEGL_EXTERNAL_REF_ID_EXT = 0x3461,
  eEGL_COMPOSITOR_DROP_NEWEST_FRAME_EXT = 0x3462,
  eEGL_COMPOSITOR_KEEP_NEWEST_FRAME_EXT = 0x3463,
  eEGL_CONTEXT_OPENGL_ROBUST_ACCESS_EXT = 0x30BF,
  eEGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY_EXT = 0x3138,
  eEGL_NO_RESET_NOTIFICATION_EXT = 0x31BE,
  eEGL_LOSE_CONTEXT_ON_RESET_EXT = 0x31BF,
  eEGL_BAD_DEVICE_EXT = 0x322B,
  eEGL_DEVICE_EXT = 0x322C,
  eEGL_DRM_DEVICE_FILE_EXT = 0x3233,
  eEGL_OPENWF_DEVICE_ID_EXT = 0x3237,
  eEGL_GL_COLORSPACE_BT2020_LINEAR_EXT = 0x333F,
  eEGL_GL_COLORSPACE_BT2020_PQ_EXT = 0x3340,
  eEGL_GL_COLORSPACE_SCRGB_LINEAR_EXT = 0x3350,
  eEGL_LINUX_DMA_BUF_EXT = 0x3270,
  eEGL_LINUX_DRM_FOURCC_EXT = 0x3271,
  eEGL_DMA_BUF_PLANE0_FD_EXT = 0x3272,
  eEGL_DMA_BUF_PLANE0_OFFSET_EXT = 0x3273,
  eEGL_DMA_BUF_PLANE0_PITCH_EXT = 0x3274,
  eEGL_DMA_BUF_PLANE1_FD_EXT = 0x3275,
  eEGL_DMA_BUF_PLANE1_OFFSET_EXT = 0x3276,
  eEGL_DMA_BUF_PLANE1_PITCH_EXT = 0x3277,
  eEGL_DMA_BUF_PLANE2_FD_EXT = 0x3278,
  eEGL_DMA_BUF_PLANE2_OFFSET_EXT = 0x3279,
  eEGL_DMA_BUF_PLANE2_PITCH_EXT = 0x327A,
  eEGL_YUV_COLOR_SPACE_HINT_EXT = 0x327B,
  eEGL_SAMPLE_RANGE_HINT_EXT = 0x327C,
  eEGL_YUV_CHROMA_HORIZONTAL_SITING_HINT_EXT = 0x327D,
  eEGL_YUV_CHROMA_VERTICAL_SITING_HINT_EXT = 0x327E,
  eEGL_ITU_REC601_EXT = 0x327F,
  eEGL_ITU_REC709_EXT = 0x3280,
  eEGL_ITU_REC2020_EXT = 0x3281,
  eEGL_YUV_FULL_RANGE_EXT = 0x3282,
  eEGL_YUV_NARROW_RANGE_EXT = 0x3283,
  eEGL_YUV_CHROMA_SITING_0_EXT = 0x3284,
  eEGL_YUV_CHROMA_SITING_0_5_EXT = 0x3285,
  eEGL_DMA_BUF_PLANE3_FD_EXT = 0x3440,
  eEGL_DMA_BUF_PLANE3_OFFSET_EXT = 0x3441,
  eEGL_DMA_BUF_PLANE3_PITCH_EXT = 0x3442,
  eEGL_DMA_BUF_PLANE0_MODIFIER_LO_EXT = 0x3443,
  eEGL_DMA_BUF_PLANE0_MODIFIER_HI_EXT = 0x3444,
  eEGL_DMA_BUF_PLANE1_MODIFIER_LO_EXT = 0x3445,
  eEGL_DMA_BUF_PLANE1_MODIFIER_HI_EXT = 0x3446,
  eEGL_DMA_BUF_PLANE2_MODIFIER_LO_EXT = 0x3447,
  eEGL_DMA_BUF_PLANE2_MODIFIER_HI_EXT = 0x3448,
  eEGL_DMA_BUF_PLANE3_MODIFIER_LO_EXT = 0x3449,
  eEGL_DMA_BUF_PLANE3_MODIFIER_HI_EXT = 0x344A,
  eEGL_MULTIVIEW_VIEW_COUNT_EXT = 0x3134,
  eEGL_BAD_OUTPUT_LAYER_EXT = 0x322D,
  eEGL_BAD_OUTPUT_PORT_EXT = 0x322E,
  eEGL_SWAP_INTERVAL_EXT = 0x322F,
  eEGL_DRM_CRTC_EXT = 0x3234,
  eEGL_DRM_PLANE_EXT = 0x3235,
  eEGL_DRM_CONNECTOR_EXT = 0x3236,
  eEGL_OPENWF_PIPELINE_ID_EXT = 0x3238,
  eEGL_OPENWF_PORT_ID_EXT = 0x3239,
  eEGL_COLOR_COMPONENT_TYPE_EXT = 0x3339,
  eEGL_COLOR_COMPONENT_TYPE_FIXED_EXT = 0x333A,
  eEGL_COLOR_COMPONENT_TYPE_FLOAT_EXT = 0x333B,
  eEGL_PLATFORM_DEVICE_EXT = 0x313F,
  eEGL_PLATFORM_WAYLAND_EXT = 0x31D8,
  eEGL_PLATFORM_X11_EXT = 0x31D5,
  eEGL_PLATFORM_X11_SCREEN_EXT = 0x31D6,
  eEGL_PROTECTED_CONTENT_EXT = 0x32C0,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_RX_EXT = 0x3341,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_RY_EXT = 0x3342,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_GX_EXT = 0x3343,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_GY_EXT = 0x3344,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_BX_EXT = 0x3345,
  eEGL_SMPTE2086_DISPLAY_PRIMARY_BY_EXT = 0x3346,
  eEGL_SMPTE2086_WHITE_POINT_X_EXT = 0x3347,
  eEGL_SMPTE2086_WHITE_POINT_Y_EXT = 0x3348,
  eEGL_SMPTE2086_MAX_LUMINANCE_EXT = 0x3349,
  eEGL_SMPTE2086_MIN_LUMINANCE_EXT = 0x334A,
  eEGL_YUV_ORDER_EXT = 0x3301,
  eEGL_YUV_NUMBER_OF_PLANES_EXT = 0x3311,
  eEGL_YUV_SUBSAMPLE_EXT = 0x3312,
  eEGL_YUV_DEPTH_RANGE_EXT = 0x3317,
  eEGL_YUV_CSC_STANDARD_EXT = 0x330A,
  eEGL_YUV_PLANE_BPP_EXT = 0x331A,
  eEGL_YUV_BUFFER_EXT = 0x3300,
  eEGL_YUV_ORDER_YUV_EXT = 0x3302,
  eEGL_YUV_ORDER_YVU_EXT = 0x3303,
  eEGL_YUV_ORDER_YUYV_EXT = 0x3304,
  eEGL_YUV_ORDER_UYVY_EXT = 0x3305,
  eEGL_YUV_ORDER_YVYU_EXT = 0x3306,
  eEGL_YUV_ORDER_VYUY_EXT = 0x3307,
  eEGL_YUV_ORDER_AYUV_EXT = 0x3308,
  eEGL_YUV_SUBSAMPLE_4_2_0_EXT = 0x3313,
  eEGL_YUV_SUBSAMPLE_4_2_2_EXT = 0x3314,
  eEGL_YUV_SUBSAMPLE_4_4_4_EXT = 0x3315,
  eEGL_YUV_DEPTH_RANGE_LIMITED_EXT = 0x3318,
  eEGL_YUV_DEPTH_RANGE_FULL_EXT = 0x3319,
  eEGL_YUV_CSC_STANDARD_601_EXT = 0x330B,
  eEGL_YUV_CSC_STANDARD_709_EXT = 0x330C,
  eEGL_YUV_CSC_STANDARD_2020_EXT = 0x330D,
  eEGL_YUV_PLANE_BPP_0_EXT = 0x331B,
  eEGL_YUV_PLANE_BPP_8_EXT = 0x331C,
  eEGL_YUV_PLANE_BPP_10_EXT = 0x331D,
  eEGL_CLIENT_PIXMAP_POINTER_HI = 0x8F74,
  eEGL_COLOR_FORMAT_HI = 0x8F70,
  eEGL_COLOR_RGB_HI = 0x8F71,
  eEGL_COLOR_RGBA_HI = 0x8F72,
  eEGL_COLOR_ARGB_HI = 0x8F73,
  eEGL_CONTEXT_PRIORITY_LEVEL_IMG = 0x3100,
  eEGL_CONTEXT_PRIORITY_HIGH_IMG = 0x3101,
  eEGL_CONTEXT_PRIORITY_MEDIUM_IMG = 0x3102,
  eEGL_CONTEXT_PRIORITY_LOW_IMG = 0x3103,
  eEGL_NATIVE_BUFFER_MULTIPLANE_SEPARATE_IMG = 0x3105,
  eEGL_NATIVE_BUFFER_PLANE_OFFSET_IMG = 0x3106,
  eEGL_DRM_BUFFER_FORMAT_MESA = 0x31D0,
  eEGL_DRM_BUFFER_USE_MESA = 0x31D1,
  eEGL_DRM_BUFFER_FORMAT_ARGB32_MESA = 0x31D2,
  eEGL_DRM_BUFFER_MESA = 0x31D3,
  eEGL_DRM_BUFFER_STRIDE_MESA = 0x31D4,
  eEGL_DRM_BUFFER_USE_SCANOUT_MESA = 0x00000001,
  eEGL_DRM_BUFFER_USE_SHARE_MESA = 0x00000002,
  eEGL_PLATFORM_GBM_MESA = 0x31D7,
  eEGL_PLATFORM_SURFACELESS_MESA = 0x31DD,
  eEGL_Y_INVERTED_NOK = 0x307F,
  eEGL_AUTO_STEREO_NV = 0x3136,
  eEGL_COVERAGE_BUFFERS_NV = 0x30E0,
  eEGL_COVERAGE_SAMPLES_NV = 0x30E1,
  eEGL_COVERAGE_SAMPLE_RESOLVE_NV = 0x3131,
  eEGL_COVERAGE_SAMPLE_RESOLVE_DEFAULT_NV = 0x3132,
  eEGL_COVERAGE_SAMPLE_RESOLVE_NONE_NV = 0x3133,
  eEGL_CUDA_EVENT_HANDLE_NV = 0x323B,
  eEGL_SYNC_CUDA_EVENT_NV = 0x323C,
  eEGL_SYNC_CUDA_EVENT_COMPLETE_NV = 0x323D,
  eEGL_DEPTH_ENCODING_NV = 0x30E2,
  eEGL_DEPTH_ENCODING_NONLINEAR_NV = 0x30E3,
  eEGL_CUDA_DEVICE_NV = 0x323A,
  eEGL_POST_SUB_BUFFER_SUPPORTED_NV = 0x30BE,
  eEGL_GENERATE_RESET_ON_VIDEO_MEMORY_PURGE_NV = 0x334C,
  eEGL_YUV_PLANE0_TEXTURE_UNIT_NV = 0x332C,
  eEGL_YUV_PLANE1_TEXTURE_UNIT_NV = 0x332D,
  eEGL_YUV_PLANE2_TEXTURE_UNIT_NV = 0x332E,
  eEGL_STREAM_CROSS_DISPLAY_NV = 0x334E,
  eEGL_STREAM_CROSS_OBJECT_NV = 0x334D,
  eEGL_STREAM_CROSS_PARTITION_NV = 0x323F,
  eEGL_STREAM_CROSS_PROCESS_NV = 0x3245,
  eEGL_STREAM_CROSS_SYSTEM_NV = 0x334F,
  eEGL_PENDING_FRAME_NV = 0x3329,
  eEGL_STREAM_TIME_PENDING_NV = 0x332A,
  eEGL_STREAM_FIFO_SYNCHRONOUS_NV = 0x3336,
  eEGL_PRODUCER_MAX_FRAME_HINT_NV = 0x3337,
  eEGL_CONSUMER_MAX_FRAME_HINT_NV = 0x3338,
  eEGL_MAX_STREAM_METADATA_BLOCKS_NV = 0x3250,
  eEGL_MAX_STREAM_METADATA_BLOCK_SIZE_NV = 0x3251,
  eEGL_MAX_STREAM_METADATA_TOTAL_SIZE_NV = 0x3252,
  eEGL_PRODUCER_METADATA_NV = 0x3253,
  eEGL_CONSUMER_METADATA_NV = 0x3254,
  eEGL_PENDING_METADATA_NV = 0x3328,
  eEGL_METADATA0_SIZE_NV = 0x3255,
  eEGL_METADATA1_SIZE_NV = 0x3256,
  eEGL_METADATA2_SIZE_NV = 0x3257,
  eEGL_METADATA3_SIZE_NV = 0x3258,
  eEGL_METADATA0_TYPE_NV = 0x3259,
  eEGL_METADATA1_TYPE_NV = 0x325A,
  eEGL_METADATA2_TYPE_NV = 0x325B,
  eEGL_METADATA3_TYPE_NV = 0x325C,
  eEGL_STREAM_STATE_INITIALIZING_NV = 0x3240,
  eEGL_STREAM_TYPE_NV = 0x3241,
  eEGL_STREAM_PROTOCOL_NV = 0x3242,
  eEGL_STREAM_ENDPOINT_NV = 0x3243,
  eEGL_STREAM_LOCAL_NV = 0x3244,
  eEGL_STREAM_PRODUCER_NV = 0x3247,
  eEGL_STREAM_CONSUMER_NV = 0x3248,
  eEGL_STREAM_PROTOCOL_FD_NV = 0x3246,
  eEGL_SUPPORT_RESET_NV = 0x3334,
  eEGL_SUPPORT_REUSE_NV = 0x3335,
  eEGL_STREAM_PROTOCOL_SOCKET_NV = 0x324B,
  eEGL_SOCKET_HANDLE_NV = 0x324C,
  eEGL_SOCKET_TYPE_NV = 0x324D,
  eEGL_SOCKET_TYPE_INET_NV = 0x324F,
  eEGL_SOCKET_TYPE_UNIX_NV = 0x324E,
  eEGL_SYNC_NEW_FRAME_NV = 0x321F,
  eEGL_SYNC_PRIOR_COMMANDS_COMPLETE_NV = 0x30E6,
  eEGL_SYNC_STATUS_NV = 0x30E7,
  eEGL_SIGNALED_NV = 0x30E8,
  eEGL_UNSIGNALED_NV = 0x30E9,
  eEGL_SYNC_FLUSH_COMMANDS_BIT_NV = 0x0001,
  eEGL_ALREADY_SIGNALED_NV = 0x30EA,
  eEGL_TIMEOUT_EXPIRED_NV = 0x30EB,
  eEGL_CONDITION_SATISFIED_NV = 0x30EC,
  eEGL_SYNC_TYPE_NV = 0x30ED,
  eEGL_SYNC_CONDITION_NV = 0x30EE,
  eEGL_SYNC_FENCE_NV = 0x30EF,
  eEGL_NATIVE_BUFFER_TIZEN = 0x32A0,
  eEGL_NATIVE_SURFACE_TIZEN = 0x32A1,
  eKHRONOS_MAX_ENUM = 0x7FFFFFFF,
};
