/*
remotefs file system
See the file AUTHORS for copyright information.
	
This program can be distributed under the terms of the GNU GPL.
See the file LICENSE.
*/

#ifndef CACHE_H
#define CACHE_H

/** attributes cache. used with rfs_getattr() and rfs_readdir() */

#include <sys/stat.h>
#include <time.h>

#if defined (__cplusplus) || defined (c_plusplus)
extern "C" {
#endif

struct rfs_instance;

/** tree_item is data type stored in cache 
which is balanced tree with filename as key */
struct tree_item
{
	char *path;
	time_t time;
	struct stat data;
};

/** add file to cache */
void* cache_file(struct rfs_instance *instance, const char *path, struct stat *stbuf);

/** delete file from cache */
void delete_from_cache(struct rfs_instance *instance, const char *path);

/** get cached value for file */
const struct tree_item* get_cache(struct rfs_instance *instance, const char *path);

/** delete all cached data */
void destroy_cache(struct rfs_instance *instance);

/** check if cache is outdated
@return not 0 if cache is old 
*/
unsigned char cache_is_old(struct rfs_instance *instance);

/** delete outdated files from cache */
void clear_cache(struct rfs_instance *instance);

#ifdef RFS_DEBUG
/** print hits/misses */
void dump_attr_stats(struct rfs_instance *instance);
#endif

#if defined (__cplusplus) || defined (c_plusplus)
}
#endif

#endif /* CACHE_H */
