#  help.py: -*- Python -*-  DESCRIPTIVE TEXT.

from qt import *
import xpm
import os
import sys
from helpBA import HelpBA


def getAppPath():
    fullpath = os.path.abspath(sys.argv[0])
    path = os.path.dirname(fullpath)
    return path


def findFile(filename):
    dirs = [getAppPath(),
            os.path.join("/", "usr", "share", "releaseforge"),
            os.path.join("/", "usr", "local", "releaseforge")]

    for d in dirs:
        path = os.path.join(d, filename)
        if os.access(path, os.R_OK): return path


    
                

class Help(HelpBA):
    def __init__(self, parent, filename):
        HelpBA.__init__(self, None)
        self.setGeometry(100, 50, 800, 600)
        self.setIcon(QPixmap(xpm.helpIcon))

        absPath = self.getHelpFile(filename)

        self.helpTextBrowser.setSource(absPath)
        self.show()


    def back_slot(self):
        self.helpTextBrowser.backward()

    def home_slot(self):
        self.helpTextBrowser.home()

    def forward_slot(self):
        self.helpTextBrowser.forward()
    
    def getHelpFile(self, filename):
        f = findFile(os.path.join("help", filename))
        return f
    

        
