from qt import QMessageBox
from fmregex import *
from FMProjectVO import FMProjectVO
from constants import FM_XMLRPC
import logging
from messageQueue import mainMessageQueue, freshmeatMessageQueue
import os, sys
import time
from xmlrpclib import Server, Fault

debug = logging.getLogger("fmcomm").debug
error = logging.getLogger("fmcomm").error

try:
    set = set
except:
    from sets import Set
    set = Set

ERR_SESSION_INVALID = 21
ERR_DUPLICATE_VERSION_STRING = 51



class FMComm:
    def __init__(self, username=None, password=None, verbose=0):
        self.verbose = 0
        self.session = None
        self.sid = None
        self.username = username
        self.password = password
        # connect to Freshmeat via xml-rpc
        self.session = Server(FM_XMLRPC,
                              verbose=self.verbose)

    def set_username(self, username):
        self.username = username

    def set_password(self, password):
        self.password = password

    def set_credentials(self, username, password):
        self.username = username
        self.password = password                      

    def __login(self, data=None):
        # Freshmeat login
        response = self.session.login({"username": self.username,
                                       "password": self.password})
        self.sid = response['SID']
        self.lifetime = response['Lifetime']

        if self.verbose:
            debug("sid: %s - lifetime: %s", self.sid, self.lifetime)

        if data:
            data['SID'] = self.sid
        

    def __rpc(self, func, data):
        # invoke the xml-rpc call specified by func.  If it fails
        # because the session is invalid, attempt to login again
        # and re-run the xml-rpc call with the new sid.
        if data.get('SID') is None:
            debug("freshmeat sid is none... attempting to login")
            self.__login(data)
                
        try:
            response = func(data)
        except Fault, f:
            if f.faultCode == ERR_SESSION_INVALID:
                debug("xml-rpc session is invalid... attempting to login again")
                self.__login(data)
                response = func(data)
            else:
                raise f
        return response


    def get_projects(self):
        try:
            projects = set()
            project_list = self.__rpc(self.session.fetch_project_list,
                                      {'SID': self.sid})
            for p in project_list:
                projects.add(FMProjectVO(p['projectname_full'],
                                         p['projectname_short']))
            return projects
        except Fault, fault:
            return None

            
    def get_branches(self, project_name):
        branch_list = self.__rpc(self.session.fetch_branch_list,
                                 {'SID': self.sid,
                                  'project_name': project_name})
        return branch_list


    def publish_release(self, data):
        "Add a new release to the current project."
        # returns a tuple of (success boolean, message string) 
        data['SID'] = self.sid
        status = ""
        ok = True
        try:
            response = self.__rpc(self.session.publish_release,
                                  data)
            status = response['OK']
        except Fault, fault:
            status = 'Error: %d - %s' % (fault.faultCode, fault.faultString)
            error(status)
            ok = False
        return ok, status

        
    def logout(self):
        ok = False
        try:
            ok = self.session.logout({"SID": self.sid})
        except Fault, fault:
            if fault.getCode == ERR_SESSION_INVALID: ok = True            
            error("Error: %d - %s", fault.faultCode, fault.faultString)
        debug("ok: %s", ok)
        self.sid = None
        return ok
            
        

if __name__ == '__main__':
    pass

    
    
