/***************************************************************************
    file	         : tk_helpwindow.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_HELPWINDOW_H
#define	__TK_HELPWINDOW_H

#include	<qcache.h>
#include	<qstring.h>
#include	<qdialog.h>
#include	<qwidget.h>
#include	<qtabwidget.h>
#include	<qcheckbox.h>
#include	<qlabel.h>
#include	<qspinbox.h>
#include	<qpushbutton.h>
#include	<qlayout.h>
#include	<qsocket.h>


class	TKHelpPage	;
class	TKHelpWindow	;
class	TKHelpDialog	;


/*  TKHelpPage							*/
/*  ----------							*/
/*  Class for an individual help page. Basically a wrapper	*/
/*  round the QTextBrowser class, which keeps track of the page	*/
/*  being displayed, and passes link requests to the main help	*/
/*  window.							*/

class	TKHelpPage : public QTextBrowser
{
	TKHelpWindow	*m_helpWin	;
	QString		m_page		;

public	:


	TKHelpPage	(QWidget *, TKHelpWindow *) ;
	~TKHelpPage	() ;

	virtual	void	setSource	(const QString &) ;

	inline	void	setPage
		(	const QString	&page
		)
	{
		m_page	= page	;
	}

	inline	const QString	&page		()
	{
		return	m_page	;
	}
}	;


/*  TKHelpWindow						*/
/*  ------------						*/
/*  This is the main window for the help display program. It	*/
/*  shows as a (modeless) dialog (so that buttons are nicely	*/
/*  sized) and contains the tab widget in which individual	*/
/*  help pages are displayed. Requests to display pages are	*/
/*  passed via stdin.						*/

class	TKHelpWindow : public QDialog
{
	Q_OBJECT

	QString		m_helpDir	;
	QCache<TKHelpPage>
			m_pCache	;

	QTabWidget	m_tabber	;
	QPushButton	m_bConfig	;
	QPushButton	m_bDismiss	;
	QPushButton	m_bClose	;

	QVBoxLayout	*m_layMain	;
	QHBoxLayout	*m_layControls	;

	QSocket		m_socket	;

	bool		m_linkToNew	;
	uint		m_maxPages	;


	void		bringToTop	()	;
	void		loadHelpText	(const QString &, QString &, QString &) ;

protected slots :

	void		slotConfig	()	;
	void		slotClose	()	;
	void		slotDismiss	()	;
	void		slotReadyRead	()	;
	void		slotLinkClosed	()	;
	void		lruLimitChanged	(int)	;

public	:

	TKHelpWindow	(const QString &)	;
	~TKHelpWindow	()			;

	void		showHelpText	(const QString &) ;
	void		showHelpText	(TKHelpPage *, const QString &) ;
}	;


class	TKHelpDialog : public QDialog
{
	Q_OBJECT

	QCheckBox	m_linkCheck		;
	QSpinBox	m_maxSpin		;
	QLabel		m_linkLabel		;
	QLabel		m_maxLabel		;
	QPushButton	m_bOK			;
	QPushButton	m_bCancel		;
	QGridLayout	m_layout		;

	bool		&m_linkToNew		;
	uint		&m_maxPages		;

protected slots :

	void		clickOK		()	;
	void		clickCancel	()	;

public	:

	TKHelpDialog (QWidget *, bool &, uint &) ;
}	;

#endif	// __TK_HELPWINDOW_H
