/***************************************************************************
    file	         : kb_tableform.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qstring.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_attrdict.h"


extern	bool	splitLookup (const QString &, QString &, QString &, QString &) ;

static	PSet	blkPSet[] =
{
	{	"h",		"350"			},
	{	"dx",		"0"			},
	{	"dy",		"20"			},
	{	"rowcount",	"0"			},
	{	"autosync",	"Yes"			},
	{	"showbar",	"Yes"			},
	{	"stretch",	"Yes"			},
	{	"sloppy",	"Yes"			},
	{	"language",	"py"			},
	{	"onload",	"#Load"			},
	{	"onunload",	"#Unload"		},
	{	"name",		"TableData"		},
	{	0,		0			}
}	;

static	PSet	scrPSet[] =
{
	{	"module",	"//script/py/TableData"	},
	{	0,		0			}
}	;

static	PSet	grdPSet[] =
{
	{	"x",		"40"			},
	{	"y",		"0"			},
	{	"h",		"20"			},
	{	"name",		"$$grid$$"		},
	{	0,		0			}
}	;

static	PSet	rowPSet[] =
{
	{	"x",		"0"			},
	{	"y",		"20"			},
	{	"w",		"40"			},
	{	"h",		"20"			},
	{	"showrow",	"Yes"			},
	{	0,		0			}
}	;

static	PSet	fldPSet[] =
{
	{	"y",		"20"			},
	{	"h",		"20"			},
	{	"morph",	"Yes"			},
	{	0,		0			}
}	;



/*  KBOpenTable	: Generate and open form for specified table		*/
/*  location	: KBLocation &	  : Form location			*/
/*  typeMap	: QDict<KBType> & : Return column type map		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: KBForm *	  : Table-specific form			*/

KBForm	*KBOpenTable
	(	KBLocation	&location,
		QDict<KBType>	&typeMap,
		KBError		&pError
	)
{

	KBDBLink 		dbLink	;

	QString			text	;
	QString			ctrls	;
	int			width	= 0 ;

	if (!dbLink.connect (location.dbInfo, location.docLocn))
	{	pError	= dbLink.lastError () ;
		return	0 ;
	}

	KBTableInfo	*tabInfo = location.dbInfo->findTableInfo
				   (	location.docLocn,
					location.docName
				   )	;

	KBTableSpec	tabSpec (location.docName) ;
	if (!dbLink.listFields (tabSpec))
	{	pError	= dbLink.lastError () ;
		return	0 ;
	}


	for (uint idx = 0 ; idx < tabSpec.m_fldList.count() ; idx += 1)
	{
		KBFieldSpec	*fSpec	 = tabSpec.m_fldList.at(idx) ;
		const QString	&colName = fSpec->m_name ;
		KBAttrDict	fldAList (fldPSet) ;

		bool	nn	 = (fSpec->m_flags & KBFieldSpec::NotNull) != 0 ;
		bool	ai	 = (fSpec->m_flags & KBFieldSpec::Serial ) != 0 ;


		typeMap .insert   (fSpec->m_name, new KBType("TD", fSpec->m_typeIntl, fSpec->m_length, fSpec->m_prec, !nn)) ;

		fldAList.addValue ("x",	 	idx * 100 + 45) ;
		fldAList.addValue ("taborder",	idx + 1	      ) ;
		fldAList.addValue ("expr", 	fSpec->m_name ) ;
		fldAList.addValue ("master", 	fSpec->m_name ) ;
		fldAList.addValue ("name", 	fSpec->m_name ) ;

		fldAList.addValue ("nullok",	nn && !ai? "No" : "Yes") ;
		fldAList.addValue ("emptynull", nn ? "No" : "Yes") ;

		if (tabInfo != 0)
		{
			int	w	= tabInfo->designValue(colName, TI_WIDTH).toInt () ;
			QString	eValid	= tabInfo->designValue(colName, TI_EVALID) ;
			QString	format	= tabInfo->designValue(colName, TI_FORMAT) ;

			if	(w <=  0) w = 100 ;
			else if (w <  20) w = 20  ;

			fldAList.addValue ("evalid", eValid) ;
			fldAList.addValue ("format", format) ;
			fldAList.addValue ("w",	     w) ;
			if (!format.isEmpty()) 
				fldAList.addValue ("deformat", "Yes") ;

			width	+= w	;

			QString	vTable	;
			QString	vField	;
			QString	vShow	;

			if (splitLookup (tabInfo->designValue(colName, TI_LINK), vTable, vField, vShow))
			{
				fldAList.addValue ("child",  vField) ;
				fldAList.addValue ("show",   vShow ) ;
				if (vTable == location.docName)
					fldAList.addValue ("dynamic", "Yes") ;

				ctrls	+= fldAList.print ("KBLink") ;

				KBAttrDict	qryAList ;
				qryAList.addValue ("server", location.docLocn) ;
				qryAList.addValue ("table",  vTable) ;
				ctrls	+= qryAList.print ("KBQryTable", true) ;

				ctrls	+= "</KBLink>" ;
				continue ;
			}
		}
		else
		{	fldAList.addValue ("w",	100) ;
			width	+= 100 ;
		}

		ctrls	+= fldAList.print ("KBField", true) ;
	}

	KBAttrDict blkAList (blkPSet) ;
	blkAList.addValue ("w", width + 70) ;
	text	+= blkAList.print ("KBForm") ;

	KBAttrDict scrAList (scrPSet) ;
	text	+= scrAList.print ("KBScript", true) ;

	KBAttrDict qryAList (0)	;
	qryAList.addValue ("server", location.docLocn) ;
	qryAList.addValue ("table",  location.docName ) ;
	if (tabSpec.m_prefKey >= 0)
		qryAList.addValue ("primary",  tabSpec.m_fldList.at(tabSpec.m_prefKey)->m_name) ;
	text	+= qryAList.print ("KBQryTable", true) ;

	KBAttrDict grdAList (grdPSet)	;
	grdAList.addValue ("w", width)  ;
	text	+= grdAList.print ("KBGrid",    true) ;

	KBAttrDict rowAList (rowPSet)	;
	text	+= rowAList.print ("KBRowMark", true) ;

	text	+= ctrls ;

	text	+= "</KBForm>" ;

	fprintf	(stderr, "%s\n", (cchar *)text) ;

	QByteArray f ;
	f.duplicate (text, strlen(text)) ;
	return	KBOpenFormText (location, f, pError) ;
}
