/***************************************************************************
    file	         : kb_lookup.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qcombobox.h>

#ifndef _WIN32
#include	"kb_lookup.moc"
#else
#include "kb_lookup.h"
#endif

bool	splitLookup
	(	const	QString	&value,
		QString		&vTable,
		QString		&vField,
		QString		&vShow
	)
{
	int	p1	;
	int	p2	;

	if ( ((p1 = value.find (":"	   )) >= 0) &&
	     ((p2 = value.find (":", p1 + 1)) >= 0) )
	{
		vTable	= value.left(p1) ;
		vField	= value.mid (p1 + 1, p2 - p1 - 1) ;
		vShow	= value.mid (p2 + 1) ;
		return	true ;
	}

	return	false	;
}
		
/*  KBLookupHelper							*/
/*  KBLookupHelper: Constructor for lookup field helper			*/
/*  parent	  : QWidget *		: Parent widget			*/
/*  location	  : const KBLocation &	: Embedding document location	*/
/*  (returns)	  : KBLookupHelper	:				*/

KBLookupHelper::KBLookupHelper
	(	QWidget			*parent,
		const KBLocation	&location
	)
	:
	QWidget		(parent),
	KBHelperBase	(this),
	vLayout		(this),
	lTable		(this),
	lField		(this),
	lShow		(this),
	cTable		(this),
	cField		(this),
	eShow		(this),
	location	(location)
{
	vLayout.setMargin (10)	    ;
	vLayout.setSpacing( 5)	    ;

	vLayout.addWidget (&lTable, 0, 0) ;
	vLayout.addWidget (&lField, 1, 0) ;
	vLayout.addWidget (&lShow,  2, 0) ;

	vLayout.addWidget (&cTable, 0, 1) ;
	vLayout.addWidget (&cField, 1, 1) ;
	vLayout.addWidget (&eShow,  2, 1) ;

	lTable .setText	  ("Linked table"	) ;
	lField .setText	  ("Linked field"	) ;
	lShow  .setText	  ("Display expression"	) ;

	connect	(&cTable, SIGNAL(activated(int)), this, SLOT(pickTable(int))) ;
	connect	(&cField, SIGNAL(activated(int)), this, SLOT(pickField(int))) ;

	eShow	.setEditable (true) ;
}

/*  KBLookupHelper							*/
/*  ~KBLookupHelper: Destructor for lookup field helper			*/
/*  (returns)	   :		:					*/

KBLookupHelper::~KBLookupHelper ()
{
}

/*  KBLookupHelper							*/
/*  setFields	: Set fields in field combo box				*/
/*  curval	: QString	: Current value				*/
/*  (returns)	: void		:					*/

void	KBLookupHelper::setFields
	(	QString		curval
	)
{
	KBTableSpec	tabSpec	(cTable.currentText()) ;
	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	int	at = -1 ;
	cField.clear () ;

	LITER
	(	KBFieldSpec,
		tabSpec.m_fldList,
		fSpec,

		cField.insertItem (fSpec->m_name) ;
		if (fSpec->m_name == curval) at = cField.count() - 1 ;
	)

	if (at <  0) at = tabSpec.m_prefKey ;
	if (at >= 0) cField.setCurrentItem (at)	;
}

/*  KBLookupHelper							*/
/*  setExpr	: Set expression in expression combo box		*/
/*  curval	: QString	: Current value				*/
/*  (returns)	: void		:					*/

void	KBLookupHelper::setExpr
	(	QString		curval
	)
{
	KBTableSpec	tabSpec	(cTable.currentText()) ;
	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	eShow.clear  () ;

	LITER
	(	KBFieldSpec,
		tabSpec.m_fldList,
		fSpec,
		eShow.insertItem (fSpec->m_name) ;
	)

	eShow.setEditText (curval) ;
}

/*  KBLookupHelper							*/
/*  setValue	: Set current value					*/
/*  value	: const QString & : Current value			*/
/*  (returns)	: void		  :					*/

void	KBLookupHelper::setValue
	(	const QString	&value
	)
{
	/* Connect to the server (this being as good a time as any	*/
	/* and retrieve the list of tables, which will be displayed in	*/
	/* the tables combo box.					*/
	if (!dbLink.connect (location.dbInfo, location.docLocn))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	KBTableDetailsList tabList ;

	if (!dbLink.listTables (tabList))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	/* Now see if we have a valid initial value. This should have	*/
	/* have the format <table>:<field>:<expr>. If it is duff then	*/
	/* we will ignore it in toto.					*/
	QString	vTable	;
	QString	vField	;
	QString	vShow	;
	splitLookup (value, vTable, vField, vShow) ;

	/* Load the tables combo, setting the current table if any as	*/
	/* current.							*/
	int at	= -1 ;

	for (uint idx = 0 ; idx < tabList.count() ; idx += 1)
	{
		const QString &tabName = tabList[idx].m_name ;

		cTable.insertItem (tabName) ;
		if (vTable == tabName) at = cTable.count() - 1 ;
	}

	if (at < 0) at = 0 ;
	cTable.setCurrentItem (at) ;

	/* Now load the fields and set the display expression.		*/
	setFields (vField) ;
	setExpr	  (vShow ) ;
}

/*  KBLookupHelper							*/
/*  getValue	: Get current value					*/
/*  (returns)	: QString	: Value					*/

QString	KBLookupHelper::getValue ()
{
	return	QString("%1:%2:%3")
		.arg(cTable.currentText())
		.arg(cField.currentText())
		.arg(eShow .currentText()) ;
}

/*  KBLookupHelper							*/
/*  pickTable	: Handle change in table selection			*/
/*  index	: int		: Newly selected index			*/
/*  (returns)	: void		:					*/

void	KBLookupHelper::pickTable
	(	int	
	)
{
	setFields ("") ;
	setExpr	  ("") ; 
}

/*  KBLookupHelper							*/
/*  pickField	: Handle change in table selection			*/
/*  index	: int		: Newly selected index			*/
/*  (returns)	: void		:					*/

void	KBLookupHelper::pickField
	(	int	
	)
{
	setExpr	  ("") ; 

}

static	KBHelperBase	*makeLookupHelper
	(	QWidget			*parent,
		const KBLocation	&location
	)
{
	return	new	KBLookupHelper (parent, location) ;
}


static	KBHelperReg	_mkLookupHelper ("_tableLookup", &makeLookupHelper) ;
