/***************************************************************************
    file	         : kb_wizreport.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		__KB_WIZREPORT_H
#define		__KB_WIZREPORT_H

#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_wizard.h"
#include	"kb_wizsource.h"
#include	"kb_wizfields.h"


/*  KBWizardReportFrame							*/
/*  -----------------							*/
/*  This class exists simply so that we can provide a size hint. Should	*/
/*  really be done by the KBDispScroller class ...			*/

class	KBWizardReportFrame : public QWidget
{
	QSize		m_size	;

public	:

	KBWizardReportFrame	(QWidget *) ;

	void		setWidget	(QWidget *, const QSize &) ;
	virtual	QSize	sizeHint	() const	;
}	;


/*  KBWizardReportPreview							*/
/*  -------------------							*/
/*  Class used to preview a wizard defined report, gives the user a	*/
/*  chance to have a look and make changes before saving the report.	*/

class	KBWizardReportPreview : public _KBDialog
{
	KBWizardReportFrame	m_frame		;
	QPushButton		m_bOK		;
	KBReport		*m_report	;
	QWidget			*m_top		;
	QWidget			*m_display	;

	virtual	bool	eventFilter	(QObject *, QEvent *) ;

protected :

	virtual	bool	focusNextPrevChild (bool) ;

public	:

	KBWizardReportPreview	(const QString &, bool &ok) ;
	~KBWizardReportPreview	() ;
}	;


/*  KBWizardReport							*/
/*  ------------							*/
/*  Wizard class for creation of reports.					*/

class	KBWizardReport : public KBWizard
{
	KBLocation	&m_location	;

public	:

	KBWizardReport	(KBLocation &, const QString &) ;

	int		exec	() ;
	QString		create	(QString &, KB::ShowAs &, bool = false) ;

	inline	KBWizardCtrlDataSource::Type sourceType	()
	{
		return	(KBWizardCtrlDataSource::Type)ctrlAttribute	("source", "object", "type"  ).toInt	   () ;
	}

	inline	QString		sourceName	() { return ctrlValue		("source", "object"  ) ; }
	inline	QStringList	fields		() { return ctrlAttribute 	("fields", "fields", "fields").toStringList() ; }
	inline	QStringList	order		() { return ctrlAttribute	("order",  "order",  "order" ).toStringList() ; }
	inline	int		layout		() { return ctrlAttribute 	("layout", "layout", "index" ).toInt	   () ; }
	inline	int		pageThrow	() { return ctrlAttribute	("layout", "throw",  "index" ).toInt	   () ; }
	inline	int		mode		() { return ctrlAttribute	("final",  "mode",   "index" ).toInt	   () ; }
	inline	QString		caption		() { return ctrlValue		("names",  "caption" ) ; }
	inline	QString		name		() { return ctrlValue		("names",  "name"    ) ; }
	inline	QString		fontCaption	() { return ctrlValue		("font",   "caption" ) ; }
	inline	QString		fontPage	() { return ctrlValue		("font",   "page"    ) ; }

	inline	void	fieldList
		(	QList<KBFieldSpec>	&fieldList
		)
	{
		((KBWizardCtrlFields *)findCtrl("fields", "fields"))->fields (fieldList) ;
	}
}	;


#endif		// __KB_WIZREPORT_H
