/***************************************************************************
    file	         : kb_tablealias.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_TABLEALIAS_H
#define	__KB_TABLEALIAS_H

#include	<qlistview.h>
#include	<qlistbox.h>
#include	<qlabel.h>
#include	<qlayout.h>


class	KBTableListBox	;
class	KBTableAlias	;
class	KBQueryDlg	;
class	KBTable		;

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_node.h"
#include	"kb_table.h"
#include	"kb_dialog.h"


/*  KBTableListBoxItem							*/
/*  ------------------							*/
/*  The list of fields is displayed with a marker for the preferred	*/
/*  key. This class is used to handle this.				*/

class KBTableListBoxItem : public QListBoxText
{
	bool	m_pKey	;

protected :

	virtual	void	paint	(QPainter *) ;

public	:

	inline	KBTableListBoxItem
		(	QListBox	*lbox,
			const QString	&text,
			bool		pKey
		)
		:
		QListBoxText	(lbox, text),
		m_pKey		(pKey)
	{
	}

	inline	bool	isPkey	()
	{
		return	m_pKey	;
	}
	inline	void	setPKey
		(	bool	pKey
		)
	{
		m_pKey	= pKey	;
	}
}	;

/*  KBTableAlias							*/
/*  ------------							*/
/*  This class is used for the items in the tables list. Basically it	*/
/*  is a list box with various extra information.			*/

class	KBTableAlias : public QWidget
{
	Q_OBJECT

	QListBox	m_fieldList	;
	KBQueryDlg	*m_qryDlg	;
	KBTable		*m_table	;
	QString		m_keyField	;

#if	__KB_EMBEDDED
	QLabel		*m_legend	;
#endif
	QVBoxLayout	*m_layout	;

	void		setLegend	() ;

#if	__KB_EMBEDDED

protected :

	virtual	bool	eventFilter	(QObject *, QEvent *) ;
#endif

protected slots :

	void	fieldButtonPressed	(int, QListBoxItem *, const QPoint &) ;

public	:

	KBTableAlias (KBQueryDlg *, KBTable *) ;

	virtual	void	reparent	(QWidget  *, WFlags, const QPoint &, bool) ;

	QRect		geometry	() ;
	void		setAlias	(const QString &) ;
	void		setPrimary	(const QString &, KBTable::UniqueType) ;

	QPoint		getPosition	(const QString &, bool, bool &) ;
	bool		hit		(QPoint, QString &)	;

	inline	KBTable *getTable 	()
	{
		return	m_table		;
	}
	inline	const QString	&getKeyField ()
	{
		return	m_keyField	;
	}
}	;


#define	C_TABLE		0
#define	C_ALIAS		1
#define	C_PRIMARY	2
#define	C_FIELD		3
#define	C_FIELD2	4

#endif	// __KB_TABLEALIAS_H
