/***************************************************************************
    file	         : kb_wizform.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapplication.h>
#include	<time.h>

#include	"kb_dbinfo.h"
#include	"kb_serverinfo.h"
#include	"kb_location.h"
#include	"kb_wizform.h"
#include	"kb_wizfields.h"
#include	"kb_display.h"
#include	"kb_form.h"

#include	"kb_locator.h"


KBWizardFormFrame::KBWizardFormFrame
	(	QWidget		*parent
	)
	:
	QWidget	(parent)
{
}

void	KBWizardFormFrame::setWidget
	(	QWidget		*widget,
		const QSize	&size
	)
{
	QVBoxLayout *lay = new QVBoxLayout(this) ;
	lay->addWidget (widget) ;
	m_size	= size	;
}

QSize	KBWizardFormFrame::sizeHint () const
{
	return	m_size	;
}

/*  ------------------------------------------------------------------  */

/*  KBWizardFormPreview							*/
/*  KBWizardFormPreview							*/
/*		: Constructor for wizard form previewer			*/
/*  text	: const QString &	: Form definition		*/
/*  ok		: bool &		: Return success		*/
/*  (returns)	: KBWizardFormPreview	:				*/

KBWizardFormPreview::KBWizardFormPreview
	(	const QString	&text,
		bool		&ok
	)
	:
	_KBDialog	("Form Preview", true),
	m_frame		(this),
	m_bOK		(this, "ok")
{
	extern	KBForm	*KBOpenFormText (KBLocation &, QByteArray &, KBError &) ;

	/* Convert the form from text into an object tree. If there is	*/
	/* an error then report it, and clear the "ok" flag so that	*/
	/* the user knows not to execute the dialog.			*/
	KBLocation	locn	;
	KBError		error	;
	QByteArray	data	;
	QSize		size	;

	cchar		*raw	= (cchar *)text ;
	data.duplicate	(raw, strlen(raw)) ;

	if ((m_form = KBOpenFormText (locn, data, error)) == 0)
	{
		error.DISPLAY()	;
		ok	= false	;
		return	;
	}

	m_form->showPreview (&m_frame, size) ;
	size	+= QSize (24,24) ;

	m_top	  = m_form->getDisplay()->getTopWidget    () ;
	m_top->resize(size) ;
	m_top->show  ()	;

	m_display = m_form->getDisplay()->getDisplayWidget() ;
	
	m_frame.setWidget (m_top, size) ;

	
	QVBoxLayout	*layMain= new QVBoxLayout (this) ;
	layMain->addWidget (&m_frame)	;
	QHBoxLayout	*layButt= new QHBoxLayout (layMain) ;
	layButt->addStretch()		;
	layButt->addWidget (&m_bOK)	;


	m_bOK.setDefault (true) ;

	qApp->installEventFilter(this) ;

	ok	= true	;
}

/*  KBWizardFormPreview							*/
/*  ~KBWizardFormPreview						*/
/*		: Destructor for wizard form previewer			*/
/*  (returns)	:		:					*/

KBWizardFormPreview::~KBWizardFormPreview ()
{
	if (m_form != 0) delete m_form ;
}

/*  KBWizardFormPreview							*/
/*  focusNextPrevChild							*/
/*		: Handle focus movement					*/
/*  (returns)	: bool		: Next focused widget found		*/

bool	KBWizardFormPreview::focusNextPrevChild
	(	bool
	)
{
	/* Override this as the dialog only has a single button as we	*/
	/* want to keep focus out of the preview			*/
	return	true	;
}

/*  KBWizardFormPreview							*/
/*  eventFilter	: Event filtering					*/
/*  o		: QObject *	: Object receiving event8		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: Event consumed			*/

bool	KBWizardFormPreview::eventFilter
	(	QObject		*o,
		QEvent		*e
	)
{
	/* This exists to stop the user actually doing anything with	*/
	/* the "form" ...						*/
	if (o->isWidgetType()) 
		for (QWidget *w = (QWidget *)o ; w != 0 ; w = w->parentWidget())
			if (w == m_display)
				switch (e->type())
				{
					case QEvent::MouseButtonPress    :
					case QEvent::MouseButtonRelease  :
					case QEvent::MouseButtonDblClick :
					case QEvent::ContextMenu	 :
					case QEvent::KeyPress		 :
					case QEvent::KeyRelease		 :
					case QEvent::Wheel		 :
					case QEvent::FocusIn		 :
					case QEvent::FocusOut		 :
						return	true	;

					default	:
						return	false	;
				}

	return	false	;
}


/*  ------------------------------------------------------------------  */

/*  KBWizardForm							*/
/*  KBWizardForm: Constructor for form wizard				*/
/*  location	: KBLocation &	  : Dummy location			*/
/*  server	: const QString & : Server name				*/
/*  (returns)	: KBWizardForm	  :					*/

KBWizardForm::KBWizardForm
	(	KBLocation	&location,
		const QString	&server
	)
	:
	KBWizard   (location.dbInfo, server),
	m_location (location)
{
}

/*  KBWizardForm							*/
/*  exec	: Execute wizard					*/
/*  (returns)	: int		: DIalog exit code			*/

int	KBWizardForm::exec ()
{
	/* Locate the wizard definition and initialise the wizard,	*/
	/* checking for errors, not that there should be any thus far.	*/
	QString	wizXML	= wizForLocale ("Form") ;
	if (wizXML.isNull())
	{
		KBError::EError
		(	QString(TR("Cannot locate wizard specification")),
			"wizForm.wiz",
			__ERRLOCN
		)	;
		return	0 ;
	}

	if (!init (wizXML))
	{	lastError().DISPLAY() ;
		return	0 ;
	}

	/* The loop below keeps running the wizard so long as the user	*/
	/* finishes with the "preview" option. This allows the user to	*/
	/* preview and return to update the wizard settings.		*/
	bool	first	= true	;
	int	rc	;

	while ((rc = KBWizard::exec (first)) != 0)
	{
		if (ctrlAttribute ("final", "mode", "index" ).toInt() != 2)
			return	rc ;

		first	= false	;

		/* Preview the form. Note that we generate it with	*/
		/* a null query since we don't seem to be able to stop	*/
		/* focus events getting through ....			*/
		KB::ShowAs		showAs	;
		QString			name	;
		bool			ok	;

		KBWizardFormPreview	preview	(create (name, showAs, true), ok) ;
		if (ok) preview.exec	()	;
	}

	return	0 ;
}

QString	KBWizardForm::create
	(	QString		&formName,
		KB::ShowAs	&showAs,
		bool		preview
	)
{
	fprintf
	(	stderr,
		"KBWizardForm::create:\n"
		"	sourceName	: %s\n"
		"	sourceType	: %d\n"
		"	fields		: %s\n"
		"	layout		: %d\n"
		"	stretch		: %d\n"
		"	move/update	: %d/%d\n"
		"	scroll		: %d\n"
		"	caption		: %s\n"
		"	name		: %s\n"
		"	mode		: %d\n",
		(cchar *)sourceName(),
		(int	)sourceType(),
		(cchar *)fields().join(", "),
		layout (),
		stretch(),
		move   (),
		update (),
		scroll (),
		(cchar *)caption(),
		(cchar *)name   (),
		mode   ()
	)	;

	extern	QString	kbFormBuilder (KBLocation &, bool, KBWizardForm	&) ;
	QString	form  = kbFormBuilder (m_location, preview, *this) ;

	fprintf
	(	stderr,
		"KBWizardForm::create[[\n%s\n]]\n",
		(cchar *)form
	)	;

	showAs	 = mode() ? KB::ShowAsDesign : KB::ShowAsData ;
	formName = name() ;
	return	 form	  ;
}

		
