/***************************************************************************
    file	         : kb_editorbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_EDITORBASE_H
#define	__KB_EDITORBASE_H

#include	"kb_libloader.h"
#include	"kb_objbase.h"
#include	"kb_editor.h"

class	KBEditorBase : public KBObjBase
{
	Q_OBJECT

	KBEditor	*m_editor	;
	bool		m_create	;

private slots :

	void	widgetClosing () ;

public	:

	KBEditorBase	(QObject *)	 ;
	virtual		~KBEditorBase () ;

	virtual	bool		build
		(		KBLocation &,
				bool,
				KBError &
		) ;

	virtual	KB::ShowRC	show
		(		KB::ShowAs		,
				const QDict<QString> 	&,
				QWidget 		*,
				KBError 		&,
				const KBValue		& = KBValue(),
				QDict<QString>		* = 0
		) ;

	virtual	QString		def	() ;
}	;

#ifndef _WIN32
KBPARTFACTORY(KBEditorFactory,"editor")
#else
class KBEditorFactory : public KBPartFactory
{
public:
	
	inline	KBEditorFactory() : KBPartFactory ()
	{
	}
	virtual	QObject	*create(QObject* = 0, const char* = 0, const char* = 0, 
		const QStringList &	= QStringList());
	virtual	const char *ident	() ;
};
#endif

#endif	// __KB_EDITORBASE_H
