/***************************************************************************
    file	         : kb_copywidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYWIDGET_H
#define	__KB_COPYWIDGET_H

#include	<qtabwidget.h>
#include	<qtabbar.h>

#include 	"kb_dom.h"
#include	"kb_location.h"

class	KBTableWidget	;
class	KBFileWidget	;
class	KBXMLWidget	;
class	KBSQLWidget	;
class	KBQueryWidget	;
class	KBCopyBase	;

/*  KBCopyWidget							*/
/*  ------------							*/
/*  This class is the outmost widget for a copy part source or		*/
/*  destination component. It is derived from QTabWidget, and has a tab	*/
/*  for each source (or destination).					*/

class	KBCopyWidget : public QTabWidget
{
	Q_OBJECT

	bool			srce		;
	KBLocation		location	;
	KBTableWidget		*cpTable	;
	KBFileWidget		*cpFile		;
	KBXMLWidget		*cpXML		;
	KBSQLWidget		*cpSQL		;
	KBQueryWidget		*cpQuery	;
	QList<KBCopyBase>	copiers		;

public	:

	KBCopyWidget	(QWidget *, QObject *, bool, KBLocation &) ;
       ~KBCopyWidget	() ;

	inline	int	tabHeight ()
	{
		return	tabBar()->sizeHint().height() ;
	}

	bool		valid	  (KBError     &) ;
	void		def	  (QDomElement &) ;
	bool		set	  (QDomElement &, KBError &) ;

	KBCopyBase	*getCopier()	;
}	;

#endif	// __KB_COPYWIDGET_H
