/***************************************************************************
    file	         : kb_wizformat.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_wizformat.h"
#include	"kb_formatdlg.h"
#include	"tk_config.h"


static	aFormat	fFloat[] =
{
{	"",			"192.76",			"%.2f"			},
{	"",			"192.76416",			"%f"			},
{	"",			"1.92764E+02",			"%E"			},
{	"",			"35%",				"%f.0%%"		},
{	"",			"35.2%",			"%f.1%%"		},
{	0,			0,				0			}
}	;


/*  KBWizardCtrlFormat							*/
/*  KBWizardCtrlFormat							*/
/*		: Wizard control to select formatting			*/
/*  page	: KBWizardPage *	: Parent page			*/
/*  elem	: const QDomElement &	: Specification element		*/
/*  (returns)	: KBWizardCtrlFormat	:				*/

KBWizardCtrlFormat::KBWizardCtrlFormat
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardComboBox
	(	page,
		elem.attribute	("name"),
		QStringList	(),
		QString::null,
		false
	),
	m_type	(elem.attribute ("type"))
{

	/* For date, time and date/time we use the format options from	*/
	/* the standard control format dialog. For floating values use	*/
	/* our own list, which is more useful where the user cannot	*/
	/* (immediately) edit the format string.			*/
	if	(m_type == "date"    ) m_format = getDateFormat	    () ;
	else if	(m_type == "time"    ) m_format = getTimeFormat	    () ;
	else if	(m_type == "datetime") m_format = getDateTimeFormat () ;
	else if (m_type == "float"   ) m_format = fFloat ;
	else			       m_format = 0	 ;

	if (m_format != 0)
	{
		comboBox()->insertItem("") ;

		for (struct aFormat *ap = m_format ; ap->descr != 0 ; ap += 1)
			comboBox()->insertItem (ap->example) ;

		TKConfig *config = TKConfig::getConfig() ;
		config->setGroup ("Wizard Format")	 ;
		comboBox()->setCurrentItem(config->readNumEntry(m_type)) ;
	}
}

KBWizardCtrlFormat::~KBWizardCtrlFormat	()
{
}


void	KBWizardCtrlFormat::setValue
	(	const QString	&
	)
{
}

/*  KBWizardCtrlFormat							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlFormat::value ()
{
	if ((m_format != 0) && (comboBox()->currentItem() > 0))
		return	m_format[comboBox()->currentItem() - 1].format ;

	return	QString::null ;
}

void	KBWizardCtrlFormat::save
	(	int
	)
{
	TKConfig *config = TKConfig::getConfig() ;
	config->setGroup   ("Wizard Format")     ;
	config->writeEntry (m_type, comboBox()->currentItem()) ;
}

WIZARDCTRLREG(Format)
